/*
 */

#ifndef CHANNEL_H_DEF
#define CHANNEL_H_DEF

#ifdef linux
#include <sys/soundcard.h>
#elif defined(__FreeBSD__)
#include <machine/soundcard.h>
#endif

#define MAX_MIDI_CHANNELS	32

typedef struct _ChannelStat {
	int bank, defbank;	/* bank, default bank */
	int preset, defpreset;	/* preset */

	/* parameters */
	int pitchsense;	/* usually 0x100 (= 2 semitones) */
	int pitchbend;	/* 0 - 0x3fff (0x2000 = no bend) */
	int chan_press;	/* channel pressure */
	char controls[127];

	/* tuning */
	int finetune, coarsetune;

	int volscale; 	/* volume sensitivity */
	int bankmode;	/* XG bank mode; bank MSB */
} ChannelStat;

#ifndef CTL_REVERB_DEPTH
#define CTL_REVERB_DEPTH CTL_EXT_EFF_DEPTH
#endif

extern int channel_drums;	/* drum flag bits */
extern ChannelStat channels[MAX_MIDI_CHANNELS];
#define CHAN_ISDRUM(ch)	(channel_drums & DRUMBIT(ch))

#endif	/* CHANNEL_H_DEF */
