
#include "audio.h"

#include <StringList.h>
#include <unistd.h>

int old_freq = -1;
int old_stereo = -1;
int old_sign = -1;
int old_big = -1;
int old_sixteen = -1;
int old_bit = 0;
int volume = 80;
int vol_l = 100;
int vol_r = 100;

int GetVolume(int *left, int *right)
{
   int vol;

   EDBUG(4, "GetVolume");
   vol = audioGetVolume(left, right);
   if (vol < 0)
      EDBUG_RETURN(-1);
   if ((*left == *right) && (*left != volume))
      volume = *left;
   if (vol) {
      *left = (*left / vol) * 100;
      *right = (*right / vol) * 100;
   }
   else {
      *left = 0;
      *right = 0;
   }
   if (*left == *right)
      *left = *right = 100;
   vol_l = *left;
   vol_r = *right;
   EDBUG_RETURN(volume);
}

void ChangeMasterVolume(int new_volume)
{
   EDBUG(4, "ChangeMasterVolume");
   if (new_volume > 100)
      volume = 100;
   else if (new_volume < 0)
      volume = 0;
   if (volume == new_volume)
      EDBUG_RETURN_;
   volume = new_volume;
   vol_l = ((float) vol_l / 100) * volume;
   vol_r = ((float) vol_r / 100) * volume;
   audioSetVolume(vol_l, vol_r);
   EDBUG_RETURN_;
}

void ChangeBalance(int left, int right)
{
   int l, r;

   EDBUG(4, "ChangeBalance");
   if (left < 0)
      left = 0;
   else if (left > 100)
      left = 100;
   if (right < 0)
      right = 0;
   else if (right > 100)
      right = 100;
   l = ((float) left / 100) * volume;
   r = ((float) right / 100) * volume;
   if ((l != vol_l) || (r != vol_r)) {
      vol_l = l;
      vol_r = r;
      audioSetVolume(vol_l, vol_r);
   }
   EDBUG_RETURN_;
}

void set_bitrate(int bit)
{
   EDBUG(8, "set_bitrate");
   old_bit = bit;
   EDBUG_RETURN_;
}

void GetAudioStats(int *stereo, int *mono, int *bit, int *sample)
{
   EDBUG(4, "GetAudioStats");
   if (playing || paused) {
      *stereo = old_stereo;
      if (old_stereo == 0)
	 *mono = 1;
      else
	 *mono = 0;
      *sample = (old_freq / 1000);
      *bit = old_bit;
      EDBUG_RETURN_;
   }
   *stereo = 0;
   *mono = 0;
   *bit = 0;
   *sample = 0;
   EDBUG_RETURN_;
}

int setup_audio(int frequency, int stereo, int sign, int big, int sixteen)
{
   EDBUG(2, "setup_audio");
   if (AUDIO_BUFFER_SIZE == 0)
      audioOpen(frequency, stereo, sign, big, sixteen);
   else {
      if ((old_freq != frequency) || (old_stereo != stereo) ||
	  (old_sign != sign) || (old_big != big) || (old_sixteen != sixteen) ||
	  (!buffer_running)) {
	 if (buffer_running) {
	    inputFinished = TRUE;
	    while (buffer_running)
	       usleep(100);
	    inputFinished = FALSE;
	 }
	 audioBufferOpen(frequency, stereo, sign, big, sixteen);
	 old_freq = frequency;
	 old_stereo = stereo;
	 old_sign = sign;
	 old_big = big;
	 old_sixteen = sixteen;
      }
   }
   EDBUG_RETURN(0);
}

void close_audio(void)
{
   EDBUG(2, "close_audio");
   if (AUDIO_BUFFER_SIZE != 0)
      audioBufferClose();
   else
      audioClose();
   EDBUG_RETURN_;
}
