#include "emusic.h"

void setcurposition(PlayList * plist, int pos)
{
   struct playlist_item *cur;

   EDBUG(4, "setcurposition");
   if (!plist || !plist->first) {
      cur_item = NULL;
      EDBUG_RETURN_;
   }
   if (pos <= (plist->last->pos / 2)) {
      cur = plist->first;
      while (cur) {
	 if (cur->pos == pos) {
	    cur_item = cur;
	    num_seconds = cur_item->length;
	    EDBUG_RETURN_;
	 }
	 cur = cur->next;
      }
   }
   else {
      cur = plist->last;
      while (cur) {
	 if (cur->pos == pos) {
	    cur_item = cur;
	    num_seconds = cur_item->length;
	    EDBUG_RETURN_;
	 }
	 cur = cur->prev;
      }
   }
   EDBUG_RETURN_;
}

void copylist(PlayList * source, PlayList * dest)
{
   struct playlist_item *cur, *dcur;

   EDBUG(4, "copylist");
   if (!source || !source->first)
      EDBUG_RETURN_;
   if (!dest)
      dest = Emalloc(sizeof(PlayList));
   else
      clearplaylist(dest);
   dest->length = source->length;
   cur = source->first;
   dest->first = Emalloc(sizeof(struct playlist_item));

   dcur = dest->first;
   dcur->prev = NULL;
   while (cur) {
      if (cur->name)
	 dcur->name = duplicate(cur->name);
      else
	 dcur->name = NULL;
      if (cur->path)
	 dcur->path = duplicate(cur->path);
      else
	 dcur->path = NULL;
      dcur->length = cur->length;
      dcur->pos = cur->pos;
      dcur->player = cur->player;
      dcur->next = Emalloc(sizeof(struct playlist_item));

      dcur->next->prev = dcur;
      cur = cur->next;
      dcur = dcur->next;
   }
   dcur = dcur->prev;
   if (dcur->next)
      Efree(dcur->next);
   dcur->next = NULL;
   dest->last = dcur;
   renumber_list(dest, 1);
   EDBUG_RETURN_;
}

void printlist(PlayList * plist)
{
   struct playlist_item *cur;

   EDBUG(4, "printlist");
   if (!plist || !plist->first)
      EDBUG_RETURN_;
   cur = plist->first;
   fprintf(stderr, "printing playlist %p\n", plist);
   while (cur) {
      fprintf(stderr, "%s %s\n", cur->name, cur->path);
      cur = cur->next;
   }
   EDBUG_RETURN_;
}

void makelistofnums(PlayList * plist, int numbers)
{
   struct playlist_item *cur;
   int x;

   EDBUG(4, "makelistofnums");
   if (!plist)
      plist = Emalloc(sizeof(PlayList));
   else
      clearplaylist(plist);
   if (!numbers) {
      plist->first = plist->last = NULL;
      EDBUG_RETURN_;
   }
   plist->first = Emalloc(sizeof(struct playlist_item));

   cur = plist->first;
   cur->prev = NULL;
   for (x = 1; x <= numbers; x++) {
      cur->path = Emalloc(8);
      sprintf(cur->path, "/%d.cda", x);
      cur->name = NULL;
      cur->player = ReturnPlayerPlugin("cd");
      get_info(cur);
      cur->next = Emalloc(sizeof(struct playlist_item));

      cur->next->prev = cur;
      cur = cur->next;
   }
   cur = cur->prev;
   if (cur->next)
      Efree(cur->next);
   cur->next = NULL;
   plist->last = cur;
   renumber_list(plist, 1);
   EDBUG_RETURN_;
}

void clearplaylist(PlayList * plist)
{
   struct playlist_item *cur;

   EDBUG(4, "clearplaylist");
   if (!plist || !plist->first)
      EDBUG_RETURN_;
   if (plist->last && plist->first) {
      cur = plist->last->prev;
      if (plist->last != plist->first) {
	 while (cur) {
	    if (cur->next) {
	       if (cur->next->name)
		  Efree(cur->next->name);
	       if (cur->next->path)
		  Efree(cur->next->path);
	       Efree(cur->next);
	    }
	    cur->next = NULL;
	    cur = cur->prev;
	    plist->last = cur;
	 }
	 Efree(plist->first);
      }
      else
	 Efree(plist->first);
   }
   plist->last = NULL;
   plist->first = NULL;
   EDBUG_RETURN_;
}

void renumber_list(PlayList * plist, int prefix)
{
   struct playlist_item *cur;
   char *temp;
   int i = 1;
   int j = 0;

   EDBUG(4, "renumber_list");
   cur = plist->first;
   while (cur) {
      cur->pos = i;
      if (prefix) {
	 if (cur->name) {
	    temp = Emalloc(strlen(cur->name) + 1);
	    if (!sscanf(cur->name, "(%d) - %[^\n]", &j, temp))
	       strcpy(temp, cur->name);
	    if (j != cur->pos) {
	       Efree(cur->name);
	       cur->name = Emalloc(strlen(temp) + 15);
	       sprintf(cur->name, "(%d) - %s", i, temp);
	    }
	    Efree(temp);
	 }
      }
      i++;
      cur = cur->next;
   }
   EDBUG_RETURN_;
}

void sort_list(PlayList * plist, int strip)
{
   struct playlist_item *cur, *next;
   int max;
   int notdone;
   char *name;

   EDBUG(4, "sort_list");
   if (!plist->first || !plist->first->next)
      EDBUG_RETURN_;
   max = plist->last->pos;
   if (strip) {
      cur = plist->first;
      while (cur) {
	 name = strrchr(cur->path, '/') + 1;
	 Efree(cur->name);
	 cur->name = duplicate(name);
	 cur = cur->next;
      }
   }
   cur = plist->first;
   next = cur->next;
   do {
      notdone = 0;
      while (next) {
	 if (strcmp(next->name, cur->name) < 0) {
	    if (cur == plist->first)
	       plist->first = next;
	    if (next == plist->last)
	       plist->last = cur;
	    cur->next = next->next;
	    if (cur->next)
	       cur->next->prev = cur;
	    next->prev = cur->prev;
	    if (next->prev)
	       next->prev->next = next;
	    cur->prev = next;
	    next->next = cur;
	    notdone = 1;
	 }
	 cur = next;
	 next = cur->next;
	 if (!next)
	    break;
      }
      cur = plist->first;
      next = cur->next;
   }
   while (notdone);
   if (strip)
      renumber_list(plist, 1);
   EDBUG_RETURN_;
}

void delete_one(int number)
{
   struct playlist_item *cur;

   EDBUG(4, "delete_one");
   if (!playlist->first)
      EDBUG_RETURN_;
   if (number <= (playlist->last->pos / 2)) {
      cur = playlist->first;
      while (cur && (cur->pos != number))
	 cur = cur->next;
   }
   else {
      cur = playlist->last;
      while (cur && (cur->pos != number))
	 cur = cur->prev;
   }
   if (!cur)
      EDBUG_RETURN_;
   if (cur->pos == number) {
      if (cur->next && cur->prev) {
	 cur->prev->next = cur->next;
	 cur->next->prev = cur->prev;
	 if (cur_item == cur)
	    cur_item = cur->next;
      }
      else if (cur->prev) {
	 cur->prev->next = NULL;
	 playlist->last = cur->prev;
	 if (cur_item == cur)
	    cur_item = cur->prev;
      }
      else if (cur->next) {
	 cur->next->prev = NULL;
	 playlist->first = cur->next;
	 if (cur_item == cur)
	    cur_item = cur->next;
      }
      else {
	 playlist->first = NULL;
	 playlist->last = NULL;
	 cur_item = NULL;
      }
      Efree(cur->name);
      Efree(cur->path);
      Efree(cur);
      renumber_list(playlist, 1);
   }
   EDBUG_RETURN_;
}

void add_one(int number, struct playlist_item *add)
{
   struct playlist_item *cur;

   EDBUG(4, "add_one");
   if (!add->name)
      get_info(add);
   if (!playlist) {
      playlist = Emalloc(sizeof(PlayList));
      playlist->first = NULL;
   }
   if (!playlist->first) {
      playlist->first = playlist->last = add;
      add->prev = NULL;
      add->next = NULL;
      renumber_list(playlist, 1);
      EDBUG_RETURN_;
   }
   cur = playlist->first;
   while (cur && (cur->pos != number))
      cur = cur->next;
   if (cur) {
      if (cur->prev) {
	 cur->prev->next = add;
	 add->prev = cur->prev;
      }
      else {
	 playlist->first = add;
	 add->prev = NULL;
      }
      cur->prev = add;
      add->next = cur;
      renumber_list(playlist, 1);
   }
   else {
      char *temp;

      add->prev = playlist->last;
      playlist->last->next = add;
      add->next = NULL;
      playlist->last = add;
      add->pos = playlist->last->pos + 1;
      temp = Emalloc(strlen(add->name) + 20);
      sprintf(temp, "(%d) - ", add->pos);
      strcat(temp, add->name);
      Efree(add->name);
      add->name = temp;
   }
   EDBUG_RETURN_;
}

void move_one(int number, int direction)
{
   struct playlist_item *cur, *temp;
   int change_current = FALSE;

   EDBUG(4, "move_one");
   if (!playlist->first)
      EDBUG_RETURN_;
   if (direction && (number == playlist->last->pos))
      EDBUG_RETURN_;
   if (!direction && (number == 1))
      EDBUG_RETURN_;
   temp = Emalloc(sizeof(struct playlist_item));

   if (number <= (playlist->last->pos / 2)) {
      cur = playlist->first;
      while (cur && (cur->pos != number))
	 cur = cur->next;
   }
   else {
      cur = playlist->last;
      while (cur && (cur->pos != number))
	 cur = cur->prev;
   }
   if (!cur)
      EDBUG_RETURN_;
   if (cur_item == cur)
      change_current = TRUE;
   temp->name = duplicate(cur->name);
   temp->path = duplicate(cur->path);
   temp->length = cur->length;
   temp->pos = cur->pos;
   temp->player = cur->player;
   delete_one(number);
   if (direction)
      add_one(number + 1, temp);
   else
      add_one(number - 1, temp);
   if (change_current)
      cur_item = temp;
   if (cur_item)
      num_seconds = cur_item->length;
   EDBUG_RETURN_;
}

PlayList *shuffle_list(PlayList * plist)
{
   time_t currentTime;
   PlayList *shuffled;
   struct playlist_item *cur = NULL, *shuf;
   int i, num;
   int used = 1;
   int max;

   EDBUG(4, "shuffle_list");
   if (!plist->first)
      EDBUG_RETURN(plist);
   max = plist->last->pos;
   currentTime = time(NULL);
   srand(currentTime);
   shuffled = Emalloc(sizeof(PlayList));
   shuffled->last = NULL;
   shuffled->first = Emalloc(sizeof(struct playlist_item));

   shuf = shuffled->first;
   shuf->prev = NULL;
   for (i = 1; i <= max; i++) {
      while (used) {
	 num = (float) rand() / (RAND_MAX + 1.0) * max + 1;
	 cur = plist->first;
	 while ((used) && (cur->next)) {
	    if (cur->pos == num)
	       used = 0;
	    else if (cur->next)
	       cur = cur->next;
	 }
	 if (cur->pos == num)
	    used = 0;
      }
      if (cur->name)
	 shuf->name = duplicate(cur->name);
      else
	 shuf->name = NULL;
      if (cur->path)
	 shuf->path = duplicate(cur->path);
      else
	 shuf->path = NULL;
      shuf->length = cur->length;
      shuf->pos = i;
      shuf->player = cur->player;
      cur->pos = 0;
      shuf->next = Emalloc(sizeof(struct playlist_item));

      shuf->next->prev = shuf;
      shuf = shuf->next;
      used = 1;
   }
   shuf = shuf->prev;
   if (shuf->next)
      Efree(shuf->next);
   shuffled->last = shuf;
   shuf->next = NULL;
   clearplaylist(plist);
   Efree(plist);
   plist = shuffled;
   EDBUG_RETURN(shuffled);
}

int loadplaylist(char *file)
{
   int temp = 1;

   EDBUG(4, "loadplaylist");
   if (!file)
      EDBUG_RETURN(0);
   if (!exists(file))
      EDBUG_RETURN(0);
   clearplaylist(playlist);
   if (listbox) {
      temp = listbox->current_selection;
      listbox->current_selection = 1;
   }
   addplaylist(file);
   cur_item = playlist->first;
   if (cur_item)
      num_seconds = cur_item->length;
   if (listbox)
      listbox->current_selection = temp;
   EDBUG_RETURN(1);
}

void addplaylist(char *path)
{
   FILE *list;
   char *buffer, *temp;
   struct playlist_item *cur;

   EDBUG(4, "addplaylist");
   if (!path)
      EDBUG_RETURN_;
   if (!(list = fopen(path, "r"))) {
      EDBUG_RETURN_;
   }
   buffer = Emalloc(FILEPATH_LEN_MAX);
   if ((temp = strrchr(path, '/')))
      temp = '\0';
   cd(path);
   memset(buffer, 0, FILEPATH_LEN_MAX);
   while (GetNextLine(buffer, list)) {
      cur = Emalloc(sizeof(struct playlist_item));

      cur->path = duplicate(buffer);
      cur->name = NULL;
      if (!LoadCacheItem(cur) || !cur->player)
	 cur->player = getfiletype(cur->path);
      cur->next = NULL;
      cur->prev = NULL;
      if (listbox) {
	 add_one(listbox->current_selection, cur);
	 listbox->current_selection++;
      }
      else if (playlist->last)
	 add_one(playlist->last->pos + 1, cur);
      else
	 add_one(1, cur);
   }
   fclose(list);
   renumber_list(playlist, 1);
   Efree(buffer);
   if (!cur_item)
      cur_item = playlist->first;
   EDBUG_RETURN_;
}

void setplugsplaylist(PlayList * plist)
{
   struct playlist_item *cur;

   EDBUG(4, "setplugsplaylist");
   if (!plist || !plist->first)
      EDBUG_RETURN_;
   cur = plist->first;
   while (cur) {
      cur->player = getfiletype(cur->path);
      cur = cur->next;
   }
   renumber_list(plist, 1);
   EDBUG_RETURN_;
}

int saveplaylist(PlayList * plist, char *file)
{
   FILE *list;
   struct playlist_item *cur;

   EDBUG(4, "saveplaylist");
   if (!(list = fopen(file, "w"))) {
      fprintf(stderr, "Couldn't write playlist\n");
      EDBUG_RETURN(0);
   }
   if (plist->first) {
      cur = plist->first;
      while (cur) {
	 fprintf(list, "%s\n", cur->path);
	 SaveItemCache(cur);
	 cur = cur->next;
      }
   }
   fclose(list);
   EDBUG_RETURN(1);
}
