#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <pthread.h>
#include "common.h"
#include "../common.h"
#include "tplay.h"

struct info_struct info;

extern int end_song;
extern int stop_song;
extern pthread_t player_thread;
extern pthread_mutex_t player_lock;
extern int AUSIZ;

static void swap_block(byte * buffer, int blocksize)
{
   register int i;
   byte c, *p;

   p = buffer;
   for (i = 0; i < (blocksize / 2); i++) {
      c = *p;
      *p = *(p + 1);
      *++p = c;
      p++;
   }
}

static void read_header(void)
{
   int bytesread, count;
   byte *p, *bufferp;

   info.firstblock = (byte *) Emalloc(info.blocksize * sizeof(byte));
   bufferp = info.firstblock;
   if (!info.forceraw) {
      bytesread = 0;
      count = 0;
      p = bufferp;
      while ((bytesread < info.blocksize) && (count != -1) &&
	 ((count = read(info.file_fd, p, info.blocksize - bytesread)) != 0)) {
	 p += count;
	 bytesread += count;
      }

      if (bytesread < SUN_HDRSIZE)
	 warning("Sample size is too small");

      if (read_au(info.firstblock) && read_wav(info.firstblock)) {
	 if (info.verbose)
	    printf("Playing raw data: %d samples/s, %d bits, %d channels.\n",
		   info.speed, info.bits, info.channels);
      }

      if (info.swap)
	 swap_block(bufferp, bytesread);

      if (bytesread < info.blocksize) {
	 info.alldone = TRUE;
	 info.bytes_on_last_block = bytesread;
	 return;
      }

      if (info.headerskip) {
	 count = 0;
	 bytesread = info.blocksize - info.headerskip;
	 p = info.firstblock + (info.blocksize - info.headerskip);
	 while ((bytesread < info.blocksize) && (count != -1) &&
		((count = read(info.file_fd, p,
			       info.blocksize - bytesread)) != 0)) {
	    p += count;
	    bytesread += count;
	 }
      }

      info.writeblock++;
      info.writecount++;
   }
   else {
      if (info.verbose)
	 printf("Playing raw data: %d samples/s, %d bits, %d channels\n",
		info.speed, info.bits, info.channels);
   }
}


void tplay_seek_to_frame(int second)
{
   int bytes_per_second;
   int seconds;

   bytes_per_second = info.speed * info.channels * (info.bits / 8);
   seconds = bytes_per_second * second;
   lseek(info.file_fd, seconds, SEEK_SET);
   flush_audio();
}

void *tplay_thread(void *foo)
{
   int bytesread, count, bits, stereo;
   byte *p, *bufferp;
   int start = 0;

/*   if (foo)
   start = *(int*)foo; */
   if (info.channels == 1)
      stereo = FALSE;
   else
      stereo = TRUE;
   if (info.bits == 16)
      bits = TRUE;
   else
      bits = FALSE;
   setup_audio(info.speed, stereo, 1, 0, bits);
   if (start)
      tplay_seek_to_frame(start);
   pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
   pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, NULL);
   info.buffer = (byte *) Emalloc(info.buffer_size * sizeof(byte));
   info.number_of_blocks = 0;
   bufferp = info.buffer;
   while (1) {
      pthread_mutex_lock(&player_lock);
      bytesread = 0;
      count = 0;
      p = bufferp;
      while ((bytesread < info.blocksize) && (count != -1) &&
	 ((count = read(info.file_fd, p, info.blocksize - bytesread)) != 0)) {
	 p += count;
	 bytesread += count;
      }

      if (info.swap)
	 swap_block(bufferp, bytesread);

      if (bytesread != -1)
	 audio_play((char *) bufferp, bytesread);

      if (bytesread < info.blocksize) {
	 info.alldone = TRUE;
	 end_song = TRUE;
	 pthread_mutex_unlock(&player_lock);
	 while (1) {
	    pthread_testcancel();
	    usleep(100);
	 }
      }
      pthread_mutex_unlock(&player_lock);
      pthread_testcancel();
   }
}

int tplay_play(int start, char *path)
{
   open_file(path);
   read_header();
   if (info.alldone)
      return FALSE;
   pthread_create(&player_thread, NULL, tplay_thread, &start);
   return 1;
}

void tplay_pause_it(void)
{
}

void tplay_stop(int playing)
{
   pthread_cancel(player_thread);
   pthread_join(player_thread, NULL);
   Efree(info.buffer);
   info.buffer = NULL;
}

int tplay_is_file(char *path)
{
   char *temp;

   if (!path)
      return 0;
   if ((temp = strrchr(path, '.')) && (temp + 1)) {
      if (!strcasecmp((temp + 1), "wav"))
	 return 1;
      if (!strcasecmp((temp + 1), "au"))
	 return 1;
   }
   return 0;
}

void tplay_version_info(char *id, char *version, char *copyright)
{
   strcpy(id, "tplay");
   sprintf(version, "%d.%d.%d", MAJOR_VERSION, MINOR_VERSION, PATCHLEVEL);
   sprintf(copyright, "1997-1998 Ilkka Karvinen");
}

void tplay_init(void)
{
   info.progname = duplicate("eMusic");
   info.loop = FALSE;
   info.in_seconds = FALSE;
   info.speed = DEFAULT_SPEED;
   info.bits = DEFAULT_BITS;
   info.channels = DEFAULT_CHANNELS;
   info.buffer_size = BUFFER_SIZE;
   info.show_usage = FALSE;
   info.swap = FALSE;
   info.forceraw = FALSE;
   info.force = FALSE;
   info.device = NULL;
   info.verbose = FALSE;
   info.optind = 0;
   info.buffer = NULL;
   info.firstblock = NULL;
   info.number_of_blocks = 0;
   info.readblock = 0;
   info.writeblock = 0;
   info.readcount = 0;
   info.writecount = 0;
   info.alldone = FALSE;
   info.overflow = FALSE;
   info.underflow = FALSE;
   info.audioset = FALSE;
   info.headerskip = 0;
   info.audio_fd = -1;
   info.file_fd = -1;
   info.blocksize = AUSIZ;
   info.bytes_on_last_block = 0;
}

void tplay_get_info(struct playlist_item *song)
{
   char *temp;

   temp = strrchr(song->path, '/');
   if (temp + 1) {
      temp++;
      song->name = duplicate(temp);
   }
   song->length = 0;
}

void tplay_config(char *left, char *right)
{
}

struct player_plugin *setup_plugin(void)
{
   struct player_plugin *temp = Emalloc(sizeof(struct player_plugin));

   temp->init = tplay_init;
   temp->config = tplay_config;
   temp->seek_to_frame = tplay_seek_to_frame;
   temp->play = tplay_play;
   temp->stop = tplay_stop;
   temp->pause_it = tplay_pause_it;
   temp->is_file = tplay_is_file;
   temp->get_info = tplay_get_info;
   temp->version_info = tplay_version_info;
   return temp;
}
