/* interface.c
 * Contains detection routines for the kernel and direct interfaces to the
 * card.
 */

/* (c) 1998 by Keith Wesolowski (wesolows@cs.unr.edu) 

 * Portions of the direct i/o routines are (c)1996 Thomas Lehmann,
 * Gideon LaGrange, and/or Franz Brinkman. 

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include "gradio.h"
#include <fcntl.h>
#include <unistd.h>
#include <sys/perm.h>

extern radio_status gr_stat;

void gradio_get_interface (void)
{

    /* First determine whether we can use the kernel interface */
#ifndef NO_KERNEL

    int fd = open (DEV_NAME, O_RDONLY);
    if (fd > 0) {
	close (fd);
	gr_stat.interface = GR_IF_KERNEL;
	return;
    } else
#endif /* NO_KERNEL */
	gradio_use_direct ();
}

void gradio_use_direct (void)
{
    /* The kernel interface isn't available for one reason or another,
     * so we'll try to use the direct interface. This requires root
     * privileges, so we'll try to pick them up. Then we attempt
     * to autodetect the card's address. Failing that, ask for it.
     */
    
    int x,user_port;
    
    if (ioperm (0x20c, 4, 0xffff) < 0) { /* Can't get permissions */
	gr_stat.interface = GR_IF_NONE;
	return;
    }
    if (ioperm (0x30c, 4, 0xffff) < 0) { /* This shouldn't happen */
	gr_stat.interface = GR_IF_NONE;
	return;
    }
    
    if (gr_stat.port == 0x20c || gr_stat.port == 0x30c) {
	gr_stat.interface = GR_IF_DIRECT;
	return;
    }
    
    /* This is based on Frans Brinkman's code */
    gradio_write_card(0x20c, 0xf8);
    usleep(200000);              /* any faster and it won't work? */
    
    x = gradio_read_card(0x20c);
    usleep(25000);               
    
    gradio_write_card(0x20c,0x00);
  
    /* if x == ff not tuned, if x == fd then tuned
     * something else means wrong port */
    /* Note that ff is returned for wrong port as well; it's useless */
    
    if (x==0xfd) {
	gr_stat.port = 0x20c;
		seteuid (getuid ()); 
	gr_stat.interface = GR_IF_DIRECT;
	return;
    }
    
    gradio_write_card (0x30c, 0xf8);
    usleep (200000);              /* any faster and it won't work? */
	
    x = gradio_read_card (0x30c);
    usleep (25000);               
    
    gradio_write_card (0x30c,0x00);    

    /* if x == fd then tuned, ff conveys no information. */
    
    if (x==0xfd) {
	gr_stat.port = 0x30c;
	/* Give up unnecessary permissions */
		seteuid (getuid ()); 
	gr_stat.interface = GR_IF_DIRECT;
	return;
    }

    gradio_get_port (&user_port);
    gtk_main ();
    
    gr_stat.port = user_port;
    gr_stat.interface = (gr_stat.port == 0x00) ? GR_IF_NONE : GR_IF_DIRECT;
    return;
}
