/*
 *  @(#) obuffer_hp.h 1.2, last edit: 21 Nov 1994 13:27:33
 *  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
 *  @(#) Berlin University of Technology
 *
 *  Many thanks to:
 *  -> John Brezak <brezak@apollo.hp.com>
 *     for his first HP implementation using the audio server
 *     (the current version does not use the audio server to keep
 *      ethernets on low traffic for playing DOOM :-)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *  New in maplay 1.3
 */

#ifndef OBUFFER_HPUX_H
#define OBUFFER_HPUX_H

const uint32	TXBUFSIZE = 256 * 1024;
		  // size of audio device internal buffer

// a class for direct sound output on Hewlett-Packard series 700 workstations
// (the audio server is not used, instead /dev/audio is used directly)
class HpuxObuffer : public Obuffer
{
private:
  static uint32		ringbuffersize;		// size of ringbuffer (in bytes)
  static int16		*buffer;		// ringbuffer
  static int16		*tail[2];		// position for next sample per channel
  static uint32		channels;		// number of channels (1 or 2)
  static char		*head;			// next byte for the audio device
  static boil		buffer_empty;		// buffer empty?
  static boil		handler_activated;	// signal_handler() is activated and
						// can receive signals, if True
  static boil		drain_buffer;		// drain ringbuffer completely, if True
  static int		audio_fd;		// filedescriptor for /dev/audio
  static itimerval	timerval;		// timer value for setitimer()

  static int		open_audio_device (void);

  static void		signal_handler (void);
			  // works as a SIGALRM handler if USE_TIMER is defined,
			  // else as SIGIO handler

public:
		HpuxObuffer (uint32 number_of_channels, Header *, boil use_speaker,
			     boil use_headphone, boil use_line_out, float volume);
	       ~HpuxObuffer (void);

  void		append (uint32 channel, int16 value);

  void		write_buffer (int) { cerr << "don't call me!\n"; }
		  // This function is obsolete, because signal_handler() does the output now.

  static boil	class_suitable (void);
		  // returnvalue == False: no 16-bit audio output possible (class unsuitable)
};

#endif
