;; $Id: dbl1fr.dsl 1.3 1998/07/19 16:10:53 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, norm@berkshire.net

;; Thanks to Rainer Feuerstein, fire@informatik.uni-wuerzburg.de and
;; Christian Leutloff, leutloff@sundancer.oche.de for many of these
;; translations.

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x and #x
;; keywords.
;;

(define (gentext-fr-xref-strings giname)
  (case giname
    (("APPENDIX") (if %chapter-autolabel%
		      "Appendice %n"
		      "L'appendice dont le nom est %t"))
    (("ARTICLE") "\U-201C;%t\U-201D;")
    (("BOOK") "%t")
    (("CHAPTER") (if %chapter-autolabel%
		     "Chapitre%n"
		     "Le chapitre dont le nom est %t"))
    (("EQUATION") "Equation%n")
    (("EXAMPLE") "Exemple %n")
    (("FIGURE") "Illustration %n")
    (("INFORMALTABLE") "%kg %kn")
    (("PART") "Partie %n")
    (("PREFACE") "%t")
    (("PROCEDURE") "Proc\latin-small-letter-e-with-acute;dure %n, %t")
    (("SECT1") (if %section-autolabel% 
		   "Section %n" 
		   "La section dont le nom est %t#c"))
    (("SECT2") (if %section-autolabel% 
		   "Section %n" 
		   "La section dont le nom est %t#c"))
    (("SECT3") (if %section-autolabel% 
		   "Section %n" 
		   "La section dont le nom est %t#c"))
    (("SECT4") (if %section-autolabel% 
		   "Section %n" 
		   "La section dont le nom est %t#c"))
    (("SECT5") (if %section-autolabel% 
		   "Section %n" 
		   "La section dont le nom est %t#c"))
    (("STEP") "Op\latin-small-letter-e-with-acute;ration %n#k")
    (("TABLE") "Tableau %n")
    (("TITLE") "%kg %kn")
    (else (string-append "[xref auf " 
			 (if giname 
			     giname
			     "Cet \latin-small-letter-e-with-acute;l\latin-small-letter-e-with-acute;ment n'existe pas")
			 " Non-reconnu par le syst\latin-small-letter-e-with-grave;me"))))

;; Indirection in the generated text for cross references.  The first
;; element of the list is used for cross references across element
;; boundries, the second element is used for cross references within
;; the same element
;;
(define (gentext-fr-xref-strings-indirect key)
  (case key
    (("b") '("" ""))
    (("c") '(" in %cg %cn" ""))
    (("d") '("" ""))
    (("k") '(" in %kg %kn" ""))
    (("s") '("" ""))))

;; Should the TOC come first or last?
;;
(define %generate-fr-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define (gentext-fr-element-name giname)
  (case giname
    (("CHAPTER") "Chapitre")
    (("COPYRIGHT") "Copyright")
    (("DEDICATION") "D\latin-small-letter-e-with-acute;dicace")
    (("EQUATION") "Equation")
    (("EXAMPLE") "Exemple")
    (("FIGURE") "Illustration")
    (("GLOSSARY") "Glossaire")
    (("GLOSSSEE") "Voir")
    (("GLOSSSEEALSO") "Voir aussi")
    (("IMPORTANT") "IMPORTANT")
    (("INDEX") "Index")
    (("LEGALNOTICE") "")
    (("MSGAUD") "Public cible")
    (("MSGLEVEL") "Niveau")
    (("MSGORIG") "Origine")
    (("NOTE") "NOTE")
    (("PART") "Partie")
    (("PREFACE") "Pr\latin-small-letter-e-with-acute;face")
    (("PROCEDURE") "Proc\latin-small-letter-e-with-acute;dure")
    (("REFERENCE") "R\latin-small-letter-e-with-acute;f\latin-small-letter-e-with-acute;rence")
    (("REFNAME") "Nom")
    (("REVHISTORY") "Histoire des r\latin-small-letter-e-with-acute;visions")
    (("REVISION") "R\latin-small-letter-e-with-acute;vision")
    (("SECT1") "Section")
    (("SECT2") "Section")
    (("SECT3") "Section")
    (("SECT4") "Section")
    (("SECT5") "Section")
    (("SIDEBAR") "")
    (("STEP") "Op\latin-small-letter-e-with-acute;ration")
    (("TABLE") "Tableau")
    (("TIP") "TUYAU")
    (("TOC") "Table des mati\latin-small-letter-e-with-grave;res")
    (("WARNING") "AVERTISSEMENT")
    (else (string-append "UNEXPECTED-ELEMENT-NAME: " giname))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-fr-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;
(define (gentext-fr-intra-label-sep giname)
  (case giname
    (("EQUATION") "-")
    (("EXAMPLE") "-")
    (("FIGURE") "-")
    (("PROCEDURE") ".")
    (("REFENTRY") ".")
    (("REFERENCE") ".")
    (("REFNAME") ", ")
    (("REFSECT1") ".")
    (("REFSECT2") ".")
    (("REFSECT3") ".")
    (("SECT1") ".")
    (("SECT2") ".")
    (("SECT3") ".")
    (("SECT4") ".")
    (("SECT5") ".")
    (("STEP") ".")
    (("TABLE") "-")
    (("_PAGENUMBER") "-")  ;; page number psuedo element
    (else "")))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;
(define (gentext-fr-label-title-sep giname)
  (case giname
    (("ABSTRACT") ": ")
    (("APPENDIX") ". ")
    (("CAUTION") "")
    (("CHAPTER") ". ")
    (("EQUATION") ". ")
    (("EXAMPLE") ". ")
    (("FIGURE") ". ")
    (("FOOTNOTE") ". ")
    (("GLOSSSEE") ": ")
    (("GLOSSSEEALSO") ": ")
    (("IMPORTANT") ": ")
    (("NOTE") ": ")
    (("ORDEREDLIST") ". ")
    (("PART") ". ")
    (("PROCEDURE") ". ")
    (("PREFIX") ". ")
    (("REFENTRY") "")
    (("REFERENCE") ". ")
    (("REFSECT1") ". ")
    (("REFSECT2") ". ")
    (("REFSECT3") ". ")
    (("SECT1") ". ")
    (("SECT2") ". ")
    (("SECT3") ". ")
    (("SECT4") ". ")
    (("SECT5") ". ")
    (("STEP") ". ")
    (("TABLE") ". ")
    (("TIP") ": ")
    (("WARNING") "")
    (else "")))

(define ($lot-title-fr$ lotgi)
  (cond ((string=? "TABLE"   lotgi) "Liste des tableaux")
	((string=? "EXAMPLE" lotgi) "Exemple")
	((string=? "FIGURE"  lotgi) "Liste des illustrations")
	((string=? "EQUATION" lotgi) "Equation")
	(else "Liste des ???")))

(define %gentext-fr-start-quote%  (dingbat "ldquo"))

(define %gentext-fr-end-quote%  (dingbat "rdquo"))

(define %gentext-fr-by% "par") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-fr-edited-by% "Publi\latin-small-letter-e-with-acute; par")
                           ;; "Edited by" Jane Doe

(define %gentext-fr-page% "")

(define %gentext-fr-and% "et")

(define %gentext-fr-bibl-pages% "Pages")

(define %gentext-fr-endnotes% "Notes")

(define %gentext-fr-table-endnotes% "Remarques:")

(define %gentext-fr-index-see% "See")

(define %gentext-fr-index-seealso% "See Also")
