;;; redefs.scm
;;; Copyright Henry S. Thompson 1996, 1997
;;; Version 1.0

;;; Produced at HCRC, Edinburgh with support for the UK Economic and Social
;;;  Research Council and SunSoft

;;; Redefinitions to/from DSSSL/R4RS
;;; Last edited: Fri Jan  3 23:31:24 1997

;; core, as per 8.6.1
(define d!quote quote)
(define d!if if)
(define d!and and)
(define d!or or)
(define d!define define)
(define d!not not)
(define d!boolean? boolean?)
(define d!null? null?)
(define d!list? list?)
(define d!list list)
(define d!length length)
(define d!append append)
(define d!reverse reverse)
(define d!list-tail list-tail)
(define d!list-ref list-ref)
(define d!symbol? symbol?)
(define d!symbol->string symbol->string) ; temporary
(define d!string->symbol string->symbol) ; temporary
(define d!number? number?)
(define d!real? real?)
(define d!integer? integer?)
(define d!remainder remainder)
(define d!quotient quotient)
(define d!modulo modulo)
(define d!char? char?)			; temporary
(define d!char=? char=?)		; temporary
(define d!string? string?)		; temporary
(define d!string string)		; temporary
(define d!string-length string-length)	; temporary
(define d!string-ref string-ref)	; temporary
(define d!string=? string=?)		; temporary
(define d!substring substring)		; temporary
(define d!string-append string-append)	; temporary
(define d!procedure? procedure?)
(define d!apply apply)

;; optional
(define d!lambda lambda)
(define d!let let)
(define d!let* let*)
(define d!letrec letrec)
(define d!quasiquote quasiquote)
(define d!cons cons)
(define d!pair? pair?)

(define-macro (def-cognates . syms)
  `(begin ,@(map (lambda (sym)
		   `(define ,(dssslize (symbol->string sym)) ,sym))
		 syms)))

(def-cognates car cdr
  caar cadr cdar cddr
  caaar caadr cadar caddr cdaar cdadr cddar cdddr caaar
  caaaar caaadr caadar caaddr cadaar cadadr caddar cadddr cdaaar
  cdaadr cdadar cdaddr cddaar cddadr cdddar cddddr)

(define d!odd? odd?)
(define d!even? even?)
