#!@SHELL@

error()
{
    echo $@ 1>&2
    exit 1
}    

if [ $# -ne 2 ] ; then
    error "Usage: makemacrodoc MACRODOC-FILE DOC-FILENAME"
    exit 2
fi

if [ ! -f $1 ] ; then
    error "cannot find input file $1!"
fi

awk 'BEGIN {
        active = 0;                         # inactive at startup
    }
    {
        if ($1 == "@startdoc")              # docpart starts
            active = 1;
        else if ($1 == "@enddoc")           # docpart ends
        {
            active = 0;
            printf ("\n");
        }
        else                                # normal text
            if (active)
                print;
    }' $1 > $2
