# Module: ftape-contents.tcl
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

# module contents
global moduleList
global autoLoadList
set moduleList(ftape-contents.tcl) { VFrame.frame8 AddVolume AcceptVolume CloseContentsFrame ContentsButtonsState ContentsWidgetsUpdate ContentsSelection ContentsCmdHandler DeleteVolume MakeContentsFrame RunContentsCmd SetContentsView SetContentsWidgetsStatus TapeContents UpdateVolumeLists VolnoCallback VolumeUpdate WriteContents}
set autoLoadList(ftape-contents.tcl) {1}

# procedures to show toplevel windows


# User defined procedures


# Procedure: VFrame.frame8
proc VFrame.frame8 { insertWidgetPath args} {

  set xfCounter 0
  set xfLength [llength $args]
  while {$xfCounter < $xfLength} {
    set xfElement [lindex $args $xfCounter]
    if {"$xfElement" == "-startupSrc" ||
        "$xfElement" == "-middleSrc" ||
        "$xfElement" == "-endSrc"} {
      if {$xfLength > [expr $xfCounter+1]} {
        incr xfCounter
        set xfSource($xfElement) [lindex $args $xfCounter]
      }
    } {
      if {[string match -* $xfElement]} {
        if {$xfLength > [expr $xfCounter+1]} {
          incr xfCounter
          set xfGenResource($xfElement) [lindex $args $xfCounter]
        }
      } {
        if {[string match $insertWidgetPath* $xfElement]} {
          if {$xfLength > [expr $xfCounter+2]} {
            incr xfCounter
            set xfSpecResource($xfElement) [lindex $args $xfCounter]
            incr xfCounter
            lappend xfSpecResource($xfElement) [lindex $args $xfCounter]
          }
        }
      }
    }
    incr xfCounter
  }

  if {"[info commands $insertWidgetPath]" == ""} {
  if {[info exists xfSource(-startupSrc)]} {
    if {[catch "$xfSource(-startupSrc) $insertWidgetPath" xfResult]} {
      puts stderr $xfResult
    }
  }
  set widgetCode {

  # build widget $insertWidgetPath.frame8
  frame $insertWidgetPath.frame8  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame8.frame0
  frame $insertWidgetPath.frame8.frame0  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame8.frame0.button1
  button $insertWidgetPath.frame8.frame0.button1  -command {CloseContentsFrame}  -foreground {Blue}  -padx {9}  -pady {3}  -text {Cancel}  -width {20}

  # build widget $insertWidgetPath.frame8.frame0.button2
  button $insertWidgetPath.frame8.frame0.button2  -command {WriteContents}  -foreground {Red}  -padx {9}  -pady {3}  -text {Write Volume Table}  -width {20}

  # build widget $insertWidgetPath.frame8.frame0.button3
  button $insertWidgetPath.frame8.frame0.button3  -command {RunContentsCmd [SN ContentsErrorList] "vtblc -f $Options(RawNoRewindDevice)"}  -foreground {DarkGreen}  -padx {9}  -pady {3}  -text {Read Volume Table}  -width {20}

  # build widget $insertWidgetPath.frame8.frame
  frame $insertWidgetPath.frame8.frame

  # build widget $insertWidgetPath.frame8.frame.scrollbar2
  scrollbar $insertWidgetPath.frame8.frame.scrollbar2  -command {UpdateVolumeLists}

  # build widget $insertWidgetPath.frame8.frame.listbox1
  listbox $insertWidgetPath.frame8.frame.listbox1  -width {4}  -yscrollcommand {$insertWidgetPath.frame8.frame.scrollbar2 set}
  bind $insertWidgetPath.frame8.frame.listbox1 <Button-1> {ContentsSelection %W %y}
  bind $insertWidgetPath.frame8.frame.listbox1 <ButtonRelease-1> {ContentsSelection %W %y}

  # build widget $insertWidgetPath.frame8.frame.listbox2
  listbox $insertWidgetPath.frame8.frame.listbox2  -width {8}  -yscrollcommand {$insertWidgetPath.frame8.frame.scrollbar2 set}
  bind $insertWidgetPath.frame8.frame.listbox2 <Button-1> {ContentsSelection %W %y}
  bind $insertWidgetPath.frame8.frame.listbox2 <ButtonRelease-1> {ContentsSelection %W %y}

  # build widget $insertWidgetPath.frame8.frame.listbox3
  listbox $insertWidgetPath.frame8.frame.listbox3 -yscrollcommand {$insertWidgetPath.frame8.frame.scrollbar2 set}
  bind $insertWidgetPath.frame8.frame.listbox3 <Button-1> {ContentsSelection %W %y}
  bind $insertWidgetPath.frame8.frame.listbox3 <ButtonRelease-1> {ContentsSelection %W %y}

  # build widget $insertWidgetPath.frame8.frame.listbox4
  listbox $insertWidgetPath.frame8.frame.listbox4  -width {23}  -yscrollcommand {$insertWidgetPath.frame8.frame.scrollbar2 set}
  bind $insertWidgetPath.frame8.frame.listbox4 <Button-1> {ContentsSelection %W %y}
  bind $insertWidgetPath.frame8.frame.listbox4 <ButtonRelease-1> {ContentsSelection %W %y}

  # build widget $insertWidgetPath.frame8.frame.listbox5
  listbox $insertWidgetPath.frame8.frame.listbox5  -width {10}  -yscrollcommand {$insertWidgetPath.frame8.frame.scrollbar2 set}
  bind $insertWidgetPath.frame8.frame.listbox5 <Button-1> {ContentsSelection %W %y}
  bind $insertWidgetPath.frame8.frame.listbox5 <ButtonRelease-1> {ContentsSelection %W %y}

  # build widget $insertWidgetPath.frame8.frame.listbox6
  listbox $insertWidgetPath.frame8.frame.listbox6  -width {10}  -yscrollcommand {$insertWidgetPath.frame8.frame.scrollbar2 set}
  # bindings
  bind $insertWidgetPath.frame8.frame.listbox6 <Button-1> {ContentsSelection %W %y}
  bind $insertWidgetPath.frame8.frame.listbox6 <ButtonRelease-1> {ContentsSelection %W %y}

  # build widget $insertWidgetPath.frame8.frame6
  frame $insertWidgetPath.frame8.frame6  -height {30}  -width {30}

  # build widget $insertWidgetPath.frame8.frame6.frame1
  frame $insertWidgetPath.frame8.frame6.frame1  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4
  frame $insertWidgetPath.frame8.frame6.frame1.frame4  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.label32
  label $insertWidgetPath.frame8.frame6.frame1.frame4.label32  -relief {sunken}  -text {1}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.entry33
  entry $insertWidgetPath.frame8.frame6.frame1.frame4.entry33  -width {0}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.entry34
  entry $insertWidgetPath.frame8.frame6.frame1.frame4.entry34  -width {15}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.entry35
  entry $insertWidgetPath.frame8.frame6.frame1.frame4.entry35  -width {0}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.entry36
  entry $insertWidgetPath.frame8.frame6.frame1.frame4.entry36  -width {0}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.entry37
  entry $insertWidgetPath.frame8.frame6.frame1.frame4.entry37  -width {0}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.label38
  label $insertWidgetPath.frame8.frame6.frame1.frame4.label38  -foreground {Blue}  -relief {sunken}  -text {Vol}  -width {4}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.label19
  label $insertWidgetPath.frame8.frame6.frame1.frame4.label19  -foreground {Blue}  -padx {2}  -relief {sunken}  -text {Description}  -width {20}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.label21
  label $insertWidgetPath.frame8.frame6.frame1.frame4.label21  -foreground {Blue}  -padx {0}  -relief {sunken}  -text {Start}  -width {11}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.label22
  label $insertWidgetPath.frame8.frame6.frame1.frame4.label22  -foreground {Blue}  -padx {0}  -relief {sunken}  -text {End}  -width {11}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.label23
  label $insertWidgetPath.frame8.frame6.frame1.frame4.label23  -foreground {Blue}  -relief {sunken}  -text {Date}  -width {24}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame4.label24
  label $insertWidgetPath.frame8.frame6.frame1.frame4.label24  -foreground {Blue}  -padx {3}  -relief {sunken}  -text {Signature}  -width {8}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14
  frame $insertWidgetPath.frame8.frame6.frame1.frame14  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.label32
  label $insertWidgetPath.frame8.frame6.frame1.frame14.label32  -relief {sunken}  -text {1}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.entry33
  entry $insertWidgetPath.frame8.frame6.frame1.frame14.entry33  -width {0}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.entry34
  entry $insertWidgetPath.frame8.frame6.frame1.frame14.entry34  -width {15}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.entry35
  entry $insertWidgetPath.frame8.frame6.frame1.frame14.entry35  -width {0}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.entry36
  entry $insertWidgetPath.frame8.frame6.frame1.frame14.entry36  -width {0}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.entry37
  entry $insertWidgetPath.frame8.frame6.frame1.frame14.entry37  -width {0}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame44
  frame $insertWidgetPath.frame8.frame6.frame1.frame14.frame44

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.value
  entry $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.value  -textvariable {SIGNATUREVar}  -width {5}  -xscrollcommand {global VolumeNumber
global SIGNATUREVar
global VolumeCount
if {"$VolumeCount" != "0"} {
    [SN UndoVolumeButton] configure -state normal
}
VolumeUpdate SIGNATURE $VolumeNumber $SIGNATUREVar}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2
  menubutton $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2  -menu {$insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2.m}  -padx {5}  -pady {2}  -relief {groove}  -text {v}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2.m
  menu $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2.m  -tearoff {0}
  $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2.m add command  -command {OptionButtonSet [SN SignatureFrame]}  -label {VTBL}
  $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2.m add command  -command {OptionButtonSet [SN SignatureFrame]}  -label {XTBL}
  $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2.m add command  -command {OptionButtonSet [SN SignatureFrame]}  -label {UTID}
  $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2.m add command  -command {OptionButtonSet [SN SignatureFrame]}  -label {EXVT}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame0
  frame $insertWidgetPath.frame8.frame6.frame1.frame14.frame0

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.menubutton2
  menubutton $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.menubutton2  -menu {$insertWidgetPath.frame8.frame6.frame1.frame14.frame0.menubutton2.m}  -padx {5}  -pady {3}  -relief {groove}  -takefocus {1}  -text {v}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.menubutton2.m
  menu $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.menubutton2.m  -tearoff {0}
  $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.menubutton2.m add command  -command {OptionButtonSet [SN DateFrame]}  -label {Today}
  $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.menubutton2.m add command  -command {OptionButtonSet [SN DateFrame]}  -label {Yesterday}
  $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.menubutton2.m add command  -command {OptionButtonSet [SN DateFrame]}  -label {Tomorrow}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.value
  entry $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.value  -textvariable {DATEVar}  -xscrollcommand {global VolumeNumber
global DATEVar
global VolumeCount
if {"$VolumeCount" != "0"} {
    VolumeUpdate DATE $VolumeNumber $DATEVar
    [SN UndoVolumeButton] configure -state normal
}
[SN DATEScrollbar] set}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.scrollbar8
  scrollbar $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.scrollbar8  -command {[SN DATEEntry] xview}  -orient {horizontal}  -width {10}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame9
  frame $insertWidgetPath.frame8.frame6.frame1.frame14.frame9

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame9.entry40
  entry $insertWidgetPath.frame8.frame6.frame1.frame14.frame9.entry40  -textvariable {DESCRIPTIONVar}  -xscrollcommand {global VolumeNumber
global DESCRIPTIONVar
global VolumeCount
if {"$VolumeCount" != "0"} {
    VolumeUpdate DESCRIPTION $VolumeNumber $DESCRIPTIONVar
    [SN UndoVolumeButton] configure -state normal
}
[SN DESCRIPTIONScrollbar] set}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.frame9.scrollbar11
  scrollbar $insertWidgetPath.frame8.frame6.frame1.frame14.frame9.scrollbar11  -activerelief {sunken}  -command {[SN DESCRIPTIONEntry] xview}  -orient {horizontal}  -width {10}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.scale17
  scale $insertWidgetPath.frame8.frame6.frame1.frame14.scale17  -command {global VolumeNumber
global STARTVar
global ENDVar
global VolumeCount
if {"$VolumeCount" != "0"} {
    if {$STARTVar > $ENDVar} {
	    VolumeUpdate END $VolumeNumber $STARTVar
    }
    [SN UndoVolumeButton] configure -state normal
}
VolumeUpdate START $VolumeNumber}  -from {3.0}  -length {73}  -orient {horizontal}  -relief {sunken}  -to {200000.0}  -variable {STARTVar}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.scale18
  scale $insertWidgetPath.frame8.frame6.frame1.frame14.scale18  -command {global VolumeNumber
global STARTVar
global ENDVar
global VolumeCount
if {"$VolumeCount" != "0"} {
    if {$STARTVar > $ENDVar} {
	    VolumeUpdate START $VolumeNumber $ENDVar
    }
    [SN UndoVolumeButton] configure -state normal
}
VolumeUpdate END $VolumeNumber}  -from {3.0}  -length {73}  -orient {horizontal}  -relief {sunken}  -to {200000.0}  -variable {ENDVar}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame14.scale19
  scale $insertWidgetPath.frame8.frame6.frame1.frame14.scale19  -command {VolnoCallback}  -length {26}  -orient {horizontal}  -relief {sunken}  -sliderlength {10}  -to {0.0}  -variable {VOLNOVar}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame5
  frame $insertWidgetPath.frame8.frame6.frame1.frame5  -height {30}  -width {30}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame5.frame0
  frame $insertWidgetPath.frame8.frame6.frame1.frame5.frame0  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame5.frame0.button1
  button $insertWidgetPath.frame8.frame6.frame1.frame5.frame0.button1  -command {global VolumeNumber
AcceptVolume $VolumeNumber}  -foreground {Red}  -padx {9}  -pady {3}  -text {Accept}  -width {20}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame5.frame0.button2
  button $insertWidgetPath.frame8.frame6.frame1.frame5.frame0.button2  -command {global VolumeNumber
ContentsWidgetsUpdate $VolumeNumber}  -foreground {DarkGreen}  -padx {9}  -pady {3}  -text {Undo Last Edit}  -width {20}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame5.frame1
  frame $insertWidgetPath.frame8.frame6.frame1.frame5.frame1  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame5.frame1.button0
  button $insertWidgetPath.frame8.frame6.frame1.frame5.frame1.button0  -command {AddVolume}  -foreground {Blue}  -padx {9}  -pady {3}  -text {Add New Entry}  -width {20}

  # build widget $insertWidgetPath.frame8.frame6.frame1.frame5.frame1.button3
  button $insertWidgetPath.frame8.frame6.frame1.frame5.frame1.button3  -command {DeleteVolume}  -foreground {Red}  -padx {9}  -pady {3}  -text {Delete Last Entry}  -width {20}

  # build widget $insertWidgetPath.frame8.frame6.frame7
  frame $insertWidgetPath.frame8.frame6.frame7  -height {30}  -width {23}

  # build widget $insertWidgetPath.frame8.frame6.frame7.button0
  button $insertWidgetPath.frame8.frame6.frame7.button0  -padx {9}  -pady {3}

  # build widget $insertWidgetPath.frame8.squeezer
  frame $insertWidgetPath.frame8.squeezer  -borderwidth {4}  -relief {ridge}

  # build widget $insertWidgetPath.frame8.squeezer.frame4
  frame $insertWidgetPath.frame8.squeezer.frame4

  # build widget $insertWidgetPath.frame8.squeezer.frame4.listbox5
  listbox $insertWidgetPath.frame8.squeezer.frame4.listbox5  -height {6}  -width {1}  -xscrollcommand {$insertWidgetPath.frame8.squeezer.frame4.scrollbar7 set}  -yscrollcommand {$insertWidgetPath.frame8.squeezer.frame4.scrollbar6 set}

  # build widget $insertWidgetPath.frame8.squeezer.frame4.scrollbar6
  scrollbar $insertWidgetPath.frame8.squeezer.frame4.scrollbar6  -command {$insertWidgetPath.frame8.squeezer.frame4.listbox5 yview}

  # build widget $insertWidgetPath.frame8.squeezer.frame4.scrollbar7
  scrollbar $insertWidgetPath.frame8.squeezer.frame4.scrollbar7  -command {$insertWidgetPath.frame8.squeezer.frame4.listbox5 xview}  -orient {horizontal}

  # build widget $insertWidgetPath.frame8.squeezer.frame5
  frame $insertWidgetPath.frame8.squeezer.frame5  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame8.squeezer.frame5.checkbutton8
  checkbutton $insertWidgetPath.frame8.squeezer.frame5.checkbutton8  -anchor {w}  -command {if {$squeeze(.squeezer.checkbutton8)} {
  pack configure $insertWidgetPath.frame8.squeezer.frame4 -side bottom -fill both -expand true
} {
  pack forget $insertWidgetPath.frame8.squeezer.frame4
} }  -text {Messages}  -variable {squeeze(.squeezer.checkbutton8)}

  # build widget $insertWidgetPath.frame8.squeezer.frame5.label9
  label $insertWidgetPath.frame8.squeezer.frame5.label9  -text {Elapsed Time}

  # build widget $insertWidgetPath.frame8.squeezer.frame5.message8
  message $insertWidgetPath.frame8.squeezer.frame5.message8  -aspect {1500}  -foreground {Blue}  -justify {right}  -padx {5}  -pady {2}  -relief {ridge}  -text {00:00:00}  -textvariable {TimeString}

  # pack master $insertWidgetPath.frame8.frame0
  pack configure $insertWidgetPath.frame8.frame0.button2  -expand 1  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame0.button3  -expand 1  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame0.button1  -expand 1  -fill x  -side left

  # pack master $insertWidgetPath.frame8.frame
  pack configure $insertWidgetPath.frame8.frame.scrollbar2  -fill y  -padx 2  -side right
  pack configure $insertWidgetPath.frame8.frame.listbox1  -fill y  -side left
  pack configure $insertWidgetPath.frame8.frame.listbox2  -fill y  -side left
  pack configure $insertWidgetPath.frame8.frame.listbox3  -expand 1  -fill both  -side left
  pack configure $insertWidgetPath.frame8.frame.listbox4  -fill y  -ipadx 1  -side left
  pack configure $insertWidgetPath.frame8.frame.listbox5  -fill y  -ipadx 1  -side left
  pack configure $insertWidgetPath.frame8.frame.listbox6  -fill y  -ipadx 2  -side left

  # pack master $insertWidgetPath.frame8.frame6
  pack configure $insertWidgetPath.frame8.frame6.frame1  -expand 1  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame7  -fill y  -side right

  # pack master $insertWidgetPath.frame8.frame6.frame1
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame5  -expand 1  -fill x
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14  -fill x
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame4  -fill x

  # pack master $insertWidgetPath.frame8.frame6.frame1.frame4
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame4.label38  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame4.label24  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame4.label19  -expand 1  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame4.label23  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame4.label21  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame4.label22  -fill x  -side left

  # pack master $insertWidgetPath.frame8.frame6.frame1.frame14
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.scale19  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame44  -fill y  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame9  -expand 1  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame0  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.scale17  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.scale18  -side left

  # pack master $insertWidgetPath.frame8.frame6.frame1.frame14.frame44
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.menubutton2  -expand 1  -fill y  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame44.value  -expand 1  -fill y  -side right

  # pack master $insertWidgetPath.frame8.frame6.frame1.frame14.frame0
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.menubutton2  -fill y  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.value
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame0.scrollbar8  -anchor s  -fill x  -side bottom

  # pack master $insertWidgetPath.frame8.frame6.frame1.frame14.frame9
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame9.entry40  -expand 1  -fill x
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame14.frame9.scrollbar11  -fill x  -side bottom

  # pack master $insertWidgetPath.frame8.frame6.frame1.frame5
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame5.frame1  -expand 1  -fill x  -side left
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame5.frame0  -expand 1  -fill x  -side left

  # pack master $insertWidgetPath.frame8.frame6.frame1.frame5.frame0
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame5.frame0.button1  -expand 1  -fill x
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame5.frame0.button2  -expand 1  -fill x

  # pack master $insertWidgetPath.frame8.frame6.frame1.frame5.frame1
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame5.frame1.button0  -expand 1  -fill x
  pack configure $insertWidgetPath.frame8.frame6.frame1.frame5.frame1.button3  -expand 1  -fill x

  # pack master $insertWidgetPath.frame8.frame6.frame7
  pack configure $insertWidgetPath.frame8.frame6.frame7.button0  -fill y  -side left

  # pack master $insertWidgetPath.frame8.squeezer
  pack configure $insertWidgetPath.frame8.squeezer.frame5  -fill x

  # pack master $insertWidgetPath.frame8.squeezer.frame4
  pack configure $insertWidgetPath.frame8.squeezer.frame4.scrollbar6  -fill y  -side right
  pack configure $insertWidgetPath.frame8.squeezer.frame4.listbox5  -expand 1  -fill both
  pack configure $insertWidgetPath.frame8.squeezer.frame4.scrollbar7  -fill x  -side bottom

  # pack master $insertWidgetPath.frame8.squeezer.frame5
  pack configure $insertWidgetPath.frame8.squeezer.frame5.checkbutton8  -anchor w  -side left
  pack configure $insertWidgetPath.frame8.squeezer.frame5.message8  -side right
  pack configure $insertWidgetPath.frame8.squeezer.frame5.label9  -side right
  }
  set subst ""
  append subst \\ [string trim { $insertWidgetPath.frame8 }]
  regsub -all $subst $widgetCode $insertWidgetPath widgetCode
  regsub -all {%ThisTopWidget} $widgetCode $insertWidgetPath widgetCode
  eval $widgetCode

  if {[info exists xfSource(-middleSrc)]} {
    if {[catch "$xfSource(-middleSrc) $insertWidgetPath" xfResult]} {
      puts stderr $xfResult
    }
  }
  set geometryCode {

  # pack master $insertWidgetPath.frame8
  pack configure $insertWidgetPath.frame8.frame6  -fill x
  pack configure $insertWidgetPath.frame8.frame  -fill both
  pack configure $insertWidgetPath.frame8.squeezer  -fill x
  pack configure $insertWidgetPath.frame8.frame0  -fill x

  # pack slave $insertWidgetPath.frame8
  pack configure $insertWidgetPath.frame8  -fill both

  $insertWidgetPath.frame8.frame.listbox1 insert end {0}
  $insertWidgetPath.frame8.frame.listbox2 insert end {VTBL}
  $insertWidgetPath.frame8.frame.listbox3 insert end {zftape volume 000}
  $insertWidgetPath.frame8.frame.listbox4 insert end {00:00:00 01/01/70}
  $insertWidgetPath.frame8.frame.listbox5 insert end {3}
  $insertWidgetPath.frame8.frame.listbox6 insert end {692}
  $insertWidgetPath.frame8.frame6.frame1.frame4.entry33 insert end {}
  $insertWidgetPath.frame8.frame6.frame1.frame4.entry34 insert end {}
  $insertWidgetPath.frame8.frame6.frame1.frame4.entry35 insert end {}
  $insertWidgetPath.frame8.frame6.frame1.frame4.entry36 insert end {}
  $insertWidgetPath.frame8.frame6.frame1.frame4.entry37 insert end {}
  $insertWidgetPath.frame8.frame6.frame1.frame14.entry33 insert end {}
  $insertWidgetPath.frame8.frame6.frame1.frame14.entry34 insert end {}
  $insertWidgetPath.frame8.frame6.frame1.frame14.entry35 insert end {}
  $insertWidgetPath.frame8.frame6.frame1.frame14.entry36 insert end {}
  $insertWidgetPath.frame8.frame6.frame1.frame14.entry37 insert end {}
  $insertWidgetPath.frame8.squeezer.frame4.listbox5 insert end {Warnung: die Kasette ist schreibgeschtzt!}
  $insertWidgetPath.frame8.squeezer.frame4.listbox5 insert end {Ioctl Fehler beim Schreiben des Inhaltsverzeichnisses: Permission denied}
  $insertWidgetPath.frame8.squeezer.frame4.listbox5 insert end {}


  }
  set subst ""
  append subst \\ [string trim { $insertWidgetPath.frame8 }]
  regsub -all $subst $geometryCode $insertWidgetPath geometryCode
  regsub -all {\$insertWidgetPath} $geometryCode [winfo parent $insertWidgetPath] geometryCode
  eval $geometryCode

  if {[info exists xfSource(-endSrc)]} {
    if {[catch "$xfSource(-endSrc) $insertWidgetPath" xfResult]} {
      puts stderr $xfResult
    }
  }
  }

  if {[info exists xfGenResource]} {
    set xfWidgetList ""
    set xfTmpWidgetList $insertWidgetPath
    while {1} {
      if {[llength $xfTmpWidgetList] == 0} {
        break
      }
      set xfFirstWidget [lindex $xfTmpWidgetList 0]
      lappend xfWidgetList $xfFirstWidget
      set xfTmpWidgetList [lreplace $xfTmpWidgetList 0 0]
      if {"[winfo children $xfFirstWidget]" != ""} {
        eval lappend xfTmpWidgetList [winfo children $xfFirstWidget]
      }
    }
    foreach xfCounter $xfWidgetList {
      if {[info exists xfGenResource]} {
        foreach xfResource [array names xfGenResource] {
          catch "$xfCounter config $xfResource [set xfGenResource($xfResource)]"
        }
      }
    }
  }
  if {[info exists xfSpecResource]} {
    foreach xfCounter [array names xfSpecResource] {
      if {"[info commands $xfCounter]" != ""} {
        catch "$xfCounter config [lindex $xfSpecResource($xfCounter) 0] [lindex $xfSpecResource($xfCounter) 1]"
      }
    }
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree $insertWidgetPath"
    after 2 "catch {XFEditSetShowWindows}"
  }
  return $insertWidgetPath
}


# Procedure: AddVolume
proc AddVolume {} {
    global Volumes
    global VolumeCount

    set Volumes($VolumeCount,VOLNO) $VolumeCount
    set Volumes($VolumeCount,SIGNATURE) "VTBL"
    set Volumes($VolumeCount,DESCRIPTION) "Funny Dummy Volume"
    set Volumes($VolumeCount,DATE) "Tomorrow"
    if {$VolumeCount == 0} {
	set Volumes($VolumeCount,START) $Volumes(-1,START)
	set Volumes($VolumeCount,END) $Volumes(-1,START)
    } {
	set Volumes($VolumeCount,START) [expr $Volumes([expr $VolumeCount - 1],END) + 1]
	set Volumes($VolumeCount,END) [expr $Volumes([expr $VolumeCount - 1],END) + 1]
    }
#    puts "Start: $Volumes(-1,START)"

    set oldcount $VolumeCount
    set VolumeCount [expr $VolumeCount + 1]
    foreach tag {
	SIGNATURE
	START
	END
	DESCRIPTION
	DATE
	VOLNO} {			
	VolumeUpdate $tag $oldcount $Volumes($oldcount,$tag)
#	puts "tag: $tag, value: $Volumes($oldcount,$tag)"
    }
    AcceptVolume $oldcount
    ContentsWidgetsUpdate $oldcount

    update idletasks
    SetContentsView
    [SN UndoVolumeButton] configure -state disabled
}


# Procedure: AcceptVolume
proc AcceptVolume { {index ""}} {
    global Volumes
    global DATEVar

    if {$index == {}} {
	puts "AcceptVolume: no update, cause index not set\n"
	return
    }

    SetContentsWidgetsStatus "disabled"
    switch $DATEVar {
	today {
	    set tapetime [clock seconds]
	}
	yesterday {
	    set tapetime [clock seconds]
	    set tapetime [expr $tapetime - 86400]
	}
	tomorrow {
	    set tapetime [clock seconds]
	    set tapetime [expr $tapetime - 86400]
	}
	default {
	    if {[catch {clock scan $DATEVar} tapetime]} {
#		puts "AcceptVolume: $tapetime\n"
		SetContentsWidgetsStatus "normal"
		return
	    }
	}
    }	    
    set DATEVar [clock format $tapetime -format {%T %D}]
    foreach tag {
	SIGNATURE
	START
	END
	DESCRIPTION
	DATE
	VOLNO} {
	upvar \#0 ${tag}Var Var

	set Volumes($index,$tag) $Var
    }
    SetContentsWidgetsStatus "normal"
    update
    [SN UndoVolumeButton] configure -state disabled
}


# Procedure: CloseContentsFrame
proc CloseContentsFrame {} {
    global outputframe

    CloseFD CmdPipeFD 1
    if {[lindex [[SN ContentsWriteButton] config -state] 4] == "disabled"} {
	[SN ContentsWriteButton] configure -state normal
	[SN ContentsReadButton] configure -state normal
    } else {
	UpdateTapeButtons Contents "stop"
	catch {destroy $outputframe}
	set outputframe [SN logoframe]
	VFrame[SN logoframe] [SN logoframe]
    }
}


# Procedure: ContentsButtonsState
proc ContentsButtonsState { {state "normal"}} {
    global VolumeCount

    foreach but {
	ContentsWrite
	ContentsRead
	AddVolume
	DeleteVolume
	AcceptVolume} {
	if {"$VolumeCount" == "0" && $but != {AddVolume}} {
	    [SN ${but}Button] configure -state "disabled"
	} {
	    [SN ${but}Button] configure -state $state
	}
    }
    [SN UndoVolumeButton] configure -state "disabled"
    update
}


# Procedure: ContentsWidgetsUpdate
proc ContentsWidgetsUpdate { index} {
    global Volumes
    global VolumeNumber
    global VolumeCount
    global VOLNOVar

    SetContentsWidgetsStatus "disabled"
    ContentsButtonsState "disabled"
    if {$VolumeCount == 0} {
	ContentsButtonsState "normal"
	return
    }

#    puts "ContentsWidgetsUpdate: Index: $index\n"

    [SN VOLNOScale] configure -from 0 -to [expr $VolumeCount - 1]
    [SN STARTScale] configure -from $Volumes(-1,START) -to $Volumes(-1,END)
    [SN ENDScale] configure -from $Volumes(-1,START) -to $Volumes(-1,END)
#    puts "ContentsWidgetsUpdate: VOLNOVar: $VOLNOVar\n"
    if {$VolumeNumber != {}} {
	foreach tag {
	    SIGNATURE
	    START
	    END
	    DESCRIPTION
	    DATE} {
	    global ${tag}Var
	    upvar \#0 ${tag}Var foo
	    
	    VolumeUpdate $tag $VolumeNumber $Volumes($VolumeNumber,$tag)
#	    puts "${tag}Var (should): $Volumes($VolumeNumber,$tag)\n"
	}
    }
    set VolumeNumber $index
    set VOLNOVar     $index
    foreach tag {
	SIGNATURE
	START
	END
	DESCRIPTION
	DATE} {
	global ${tag}Var
	upvar \#0 ${tag}Var foo

	VolumeUpdate $tag $index $Volumes($index,$tag)
#	puts "${tag}Var (should): $Volumes($index,$tag)\n"
    }
    SetContentsWidgetsStatus "normal"
    ContentsButtonsState "normal"
    update
    [SN UndoVolumeButton] configure -state disabled
}


# Procedure: ContentsSelection
proc ContentsSelection { w ypos} {
    global VOLNOVar
    global VolumeNumber
    
#    SetContentsWidgetsStatus "disabled"

    set line [$w nearest $ypos]

#    puts "ContentsSelection: line $line\n"

    [SN UndoVolumeButton] configure -state disabled

    set VOLNOVar [[SN VOLNOList] get $line]
    set VolumeNumber $VOLNOVar

    foreach tag {
	VOLNO
	SIGNATURE
	DESCRIPTION
	DATE
	START
	END } {
	global ${tag}Var

	[SN ${tag}List] select clear 0 end
	[SN ${tag}List] activate $line
	set ${tag}Var [[SN ${tag}List] get $line]
#	puts "ContentsSelection: tag$: [[SN ${tag}List] get $line]\n"
    }
#    SetContentsWidgetsStatus "normal"
    update idletasks
    [SN UndoVolumeButton] configure -state disabled
#     foreach tag {
# 	SIGNATURE
# 	DESCRIPTION
# 	DATE} {
# 	[SN ${tag}Entry] delete 0 end
# 	[SN ${tag}Entry] insert 0 [[SN ${tag}List] get $line]
#     }
#     foreach tag {
# 	VOLNO
# 	START
# 	END} {
# 	set ${tag}Var [[SN ${tag}List] get $line]
#     }
}


# Procedure: ContentsCmdHandler
proc ContentsCmdHandler { listWidget fd} {
    global CmdPipeFD
    global Volumes
    global VolumeNumber
    global VolumeCount

#    puts "$Opts(qic-standard)\n"
    set oldscript [fileevent $CmdPipeFD readable]
    fileevent $CmdPipeFD readable ""
    set contentsline {}
    if {[catch {gets $CmdPipeFD contentsline} error]} {
	after cancel UpdateTime
	exec sync
	FileInList $listWidget "/tmp/ftape-tool.[pid]"
	$listWidget insert end "Error Reading $CmdPipeFD:\n"
	$listWidget insert end "$error\n"
	CloseFD CmdPipeFD 1
	ContentsButtonsState "normal"
	SetContentsWidgetsStatus "normal"
	return
    }
#    puts stdout "$contentsline"
    if {[eof $fd]} {
	after cancel UpdateTime
	$listWidget insert end "Normal completion reading $CmdPipeFD.\n"
	CloseFD CmdPipeFD 0
	FileInList $listWidget "/tmp/ftape-tool.[pid]"
	update
	ContentsButtonsState "normal"
	SetContentsWidgetsStatus "normal"
	return
    }

    if {[regexp -- ^VTBL.* $contentsline]} {
	if {[regexp -- ^VTBL\ +START\ +(\[0-9\]+)\ +(\[0-9\]+) $contentsline tmp Volumes(-1,START) Volumes(-1,END)]} {
	    incr Volumes(-1,START)
#	    puts "First data segment: $Volumes(-1,START)"
#	    puts "Last data segment: $Volumes(-1,END)"
	    set VolumeCount 0
	} else {
	    if {![regexp -- ^VTBL\ +END $contentsline]} {
		puts "Corrupt entry $contentsline\n"
		set VolumeCount 0
	    }
	}
#	puts "VolumeCount: $VolumeCount\n"
	fileevent $CmdPipeFD readable $oldscript
	return
    }
    if {$Volumes(-1,START) == -1} {
	fileevent $CmdPipeFD readable $oldscript
	return
    }
#    puts "$contentsline"
    if {[regexp -- ^ENTRY.* $contentsline]} {
	if {[regexp -- ^ENTRY\ +(\[0-9\]+) $contentsline tmp VolumeNumber]} {
	    set Volumes($VolumeNumber,SIGNATURE) ""
	    set Volumes($VolumeNumber,START) ""
	    set Volumes($VolumeNumber,END) ""
	    set Volumes($VolumeNumber,DESCRIPTION) ""
	    set Volumes($VolumeNumber,DATE) ""
	    set Volumes($VolumeNumber,VOLNO) $VolumeNumber
	    set VolumeCount [expr $VolumeNumber + 1]
#	    puts "VolumeCount: $VolumeCount\n"
#	    puts "Zapping volume variables (vol $VolumeNumber)\n"
	} else {
	    if {[regexp -- ^ENTRY\ *END $contentsline]} {
#		puts "Ending volume (vol $VolumeNumber)\n"
		foreach tag {
		    SIGNATURE
		    START
		    END
		    DESCRIPTION
		    DATE
		    VOLNO} {			
		    VolumeUpdate $tag $VolumeNumber $Volumes($VolumeNumber,$tag)
		}
		ContentsWidgetsUpdate [expr $VolumeCount - 1]
		update
	    }
	} else {
	    puts "Corrupt entry $contentsline\n"
	}
	[SN UndoVolumeButton] configure -state disabled
	fileevent $CmdPipeFD readable $oldscript
	return
    }
    foreach tag {
	SIGNATURE
	START
	END
	DESCRIPTION
	DATE} {
#	puts "Trying $tag\n"
	if {[regexp -- ^$tag.* $contentsline]} {
	    if {![regexp -- ^$tag\ +\"?(\[^\"\]*)\"? $contentsline tmp Volumes($VolumeNumber,$tag)]} {
		puts "Corrupt entry $contentsline\n"
	    }
#	    puts "Found $tag, value $Volumes($VolumeNumber,$tag)\n"
	    fileevent $CmdPipeFD readable $oldscript
	    return
	}
    }
    fileevent $CmdPipeFD readable $oldscript
}


# Procedure: DeleteVolume
proc DeleteVolume {} {
    global VolumeNumber
    global Volumes
    global VolumeCount

    if {$VolumeCount == 0} {
	return
    }
    set VolumeCount [expr $VolumeCount - 1]

    ContentsWidgetsUpdate [expr $VolumeCount - 1]

    unset Volumes($VolumeCount,VOLNO)
    unset Volumes($VolumeCount,SIGNATURE)
    unset Volumes($VolumeCount,DESCRIPTION)
    unset Volumes($VolumeCount,DATE)
    unset Volumes($VolumeCount,START)
    unset Volumes($VolumeCount,END)

    foreach tag {
	SIGNATURE
	START
	END
	DESCRIPTION
	DATE
	VOLNO} {			
	[SN ${tag}List] delete end
    }
    update
}


# Procedure: MakeContentsFrame
proc MakeContentsFrame {} {
    global outputframe
    global Options
    global CmdPipeFD
    global Volumes
    global VolumeNumber

    if {[lindex [[SN ContentsButton] config -text] 4] == "Cancel"} {
	if {$CmdPipeFD != ""} {
	    CloseFD CmdPipeFD 1
	}
	UpdateTapeButtons Contents "stop"
	catch {destroy $outputframe}
	set outputframe [SN logoframe]
	VFrame[SN logoframe] [SN logoframe]
	return
    }
    unset Volumes
    set VolumeNumber 0
    set {Volumes(-1,END)} {2}
    set {Volumes(-1,START)} {-1}
    foreach tag {
	SIGNATURE
	START
	END
	DESCRIPTION
	DATE
	VOLNO} {
	set Volumes(0,$tag) 0
    }
    
    UpdateTapeButtons Contents "start"   

    catch {destroy $outputframe}
    set outputframe [SN TapeContentsFrame]
    VFrame[SN TapeContentsFrame] [SN TapeContentsFrame]
    RunContentsCmd [SN ContentsErrorList] "vtblc -f $Options(RawNoRewindDevice)"
    [SN UndoVolumeButton] configure -state disabled
}


# Procedure: RunContentsCmd
proc RunContentsCmd { listWidget {cmd "vtblc -f /dev/nrawft0"} {input ""}} {
    global starttime
    global CmdPipeFD
    global cmdstatus
    
    SetContentsWidgetsStatus "disabled"
    ContentsButtonsState "disabled"

    CloseFD CmdPipeFD 1
    set cmdstatus $cmd
    ClearList $listWidget
    foreach tag {
	SIGNATURE
	START
	END
	DESCRIPTION
	DATE
	VOLNO} {
	[SN ${tag}List] delete 0 end	
    }
    if {$input == ""} {
	set mode RDONLY
    } else {
	set mode RDWR
    }
    if {[catch {open "|$cmd --print=parsable 2> /tmp/ftape-tool.[pid]" $mode} CmdPipeFD]} {
 	foreach fileLine [split $CmdPipeFD "\n"] {
 	    $listWidget insert end $fileLine
 	}
 	set CmdPipeFD ""
	ContentsButtonsState "normal"
	SetContentsWidgetsStatus "normal"
 	return
    }
    catch {
	if {$input == ""} {
	    fconfigure $CmdPipeFD -blocking 0 -translation binary
	} else {
	    fconfigure $CmdPipeFD -blocking 0 -translation {binary binary}
	}
    }
    if {[catch {clock seconds} starttime] == 0} {
	after 1000 UpdateTime
    }
    set Volumes(-1,START) -1
    set VolumeCount 0
    fileevent $CmdPipeFD readable [list ContentsCmdHandler $listWidget $CmdPipeFD]
    if {$input != ""} {
	puts "Trying to write to $CmdPipeFD\n"
	if {[catch {puts -nonewline $CmdPipeFD $input} error]} {
	    puts "Error: $error\n"
	    $listWidget insert end "Error writing to $CmdPipeFD:\n"
	    $listWidget insert end "$error\n"
	}
	puts "Trying to flush $CmdPipeFD\n"
	if {[catch {flush $CmdPipeFD} error]} {
	    puts "Error: $error\n"
	    $listWidget insert end "Error flushing $CmdPipeFD:\n"
	    $listWidget insert end "$error\n"
	}
    }
    [SN UndoVolumeButton] configure -state disabled
}


# Procedure: SetContentsView
proc SetContentsView { {index "end"}} {
    foreach tag {
	VOLNO
	SIGNATURE
	START
	END
	DESCRIPTION
	DATE} {
#	puts "AddVolume: size\($tag\): [[SN ${tag}List] size]\n"
	[SN ${tag}List] see $index
    }
}


# Procedure: SetContentsWidgetsStatus
proc SetContentsWidgetsStatus { {state "normal"}} {
    global ContentsWidgetsStatus
    global VolumeCount

    if {$VolumeCount == 0} {
	set state "disabled"
    }
    switch $state {
	case "normal" {
	    set $ContentsWidgetsStatus [expr $ContentsWidgetsStatus - 1]
	    if {$ContentsWidgetsStatus > 0} {
		return
	    }
	}
	case "disabled" {
	    set $ContentsWidgetsStatus [expr $ContentsWidgetsStatus + 1]
	    if {$ContentsWidgetsStatus > 1} {
		return
	    }
	}
    }
#    puts "SetContentsWidgetsStatus: $state\n"
    foreach wid {
	VOLNO
	START
	END} {
	[SN ${wid}Scale] configure -state $state
    }
    foreach wid {
	SIGNATURE
	DESCRIPTION
	DATE} {
	[SN ${wid}Entry] configure -state $state
    }
#     foreach wid {
# 	DESCRIPTION
# 	DATE} {
# 	[SN ${wid}Scrollbar] configure -state $state
#     }
    foreach wid {
	DATE
	SIGNATURE} {
	[SN ${wid}Menu] configure -state $state
    }
    [SN UndoVolumeButton] configure -state disabled
}


# Procedure: TapeContents
proc TapeContents { {tapedev "/dev/nqft0"} FDName} {
    global outputframe
    upvar \#0 $FDName fd

    if {[lindex [[SN ContentsButton] config -text] 4] == "Cancel"} {
	if {$fd != ""} {
	    CloseFD $FDName 1
	}
	UpdateTapeButtons Contents "stop"
	return
    }
    UpdateTapeButtons Contents "start"   

    catch "destroy $outputframe"
    VFrame.frame5 .frame5
    set outputframe [SN cmdframe]
    VFrame[SN cmdframe] [SN cmdframe]
    ClearList [SN cmdframe].frame.listbox1
    CmdInList [SN cmdframe].frame.listbox1 "vtblc -f $tapedev --print=parsable"  Contents $FDName
}


# Procedure: UpdateVolumeLists
proc UpdateVolumeLists { {arg1 ""} {arg2 ""} {arg3 ""}} {
    
#    puts "UpdateVolumeLists: $arg1 $arg2 $arg3\n"
    if {$arg1 == "moveto"} {
	foreach List {
	    VOLNO
	    SIGNATURE
	    DESCRIPTION
	    DATE
	    START
	    END } {
	    [SN ${List}List] yview moveto $arg2
	}
	return
    }
    foreach List {
	VOLNO
	SIGNATURE
	DESCRIPTION
	DATE
	START
	END } {
	[SN ${List}List] yview scroll $arg2 $arg3
    }
}


# Procedure: VolnoCallback
proc VolnoCallback { index} {
    global Volumes
    global VolumeNumber
    global VolumeCount
    global VOLNOVar

    if {$VolumeCount == 0} {
	return
    }
    if {$index != $VolumeNumber} {
	[SN UndoVolumeButton] configure -state disabled
	foreach tag {
	    SIGNATURE
	    START
	    END
	    DESCRIPTION
	    DATE} {
	    global ${tag}Var
	    upvar \#0 ${tag}Var foo
	    
	    VolumeUpdate $tag $VolumeNumber $Volumes($VolumeNumber,$tag)
	}
	set VolumeNumber $index
	foreach tag {
	    SIGNATURE
	    START
	    END
	    DESCRIPTION
	    DATE} {
	    global ${tag}Var
	    upvar \#0 ${tag}Var foo
	    
	    VolumeUpdate $tag $index $Volumes($index,$tag)
	}
	[SN UndoVolumeButton] configure -state disabled
    }
    if {$index != $VOLNOVar} {
	VolnoCallback $VOLNOVar
    }
    SetContentsView $VOLNOVar
    update
    [SN UndoVolumeButton] configure -state disabled
}


# Procedure: VolumeUpdate
proc VolumeUpdate { tag index value {dummy0 ""} {dummy1 ""}} {
    global Volumes
    global VolumeCount
    global ${tag}Var
    global VOLNOVar
    
    if {"$VolumeCount" == "0"} {
	return
    }
#    puts "VolumeCount: $VolumeCount\n"
    if {$index == {}} {
	puts "VolumeUpdate: index == $index\n"
	return
    }
#    [SN UndoVolumeButton] configure -state normal

#	set $Volumes($index,$tag) $value
#    puts "VolumeUpdate: VOLNOVar: $VOLNOVar\n"
#    puts "Index: $index\n"
#    puts "Size: [[SN ${tag}List] size]\n"
    
#    puts "VolumeUpdate: $tag\($index\): $value\n"

    set ${tag}Var $value
    if {[expr [[SN ${tag}List] size] - 1] >= $index} {
	[SN ${tag}List] delete $index 
	[SN ${tag}List] insert $index $value
    } else {
	[SN ${tag}List] insert end $value
    }
}


# Procedure: WriteContents
proc WriteContents {} {
    global Volumes
    global VolumeNumber
    global VolumeCount
    global Options

    SetContentsWidgetsStatus "disabled"
    ContentsButtonsState "disabled"

    set VolumeString "VTBL START\n"
    for {set cnt 0} {$cnt < $VolumeCount} {incr cnt} {
	set VolumeString "${VolumeString}ENTRY $cnt\n"
	foreach tag {
	    SIGNATURE
	    DESCRIPTION
	    DATE
	    START
	    END} {
	    set VolumeString "${VolumeString}$tag $Volumes($cnt,$tag)\n"
	}
	set VolumeString "${VolumeString}ENTRY END\n"
    }
    set VolumeString "${VolumeString}VTBL END\n"
    ContentsButtonsState "normal"
    SetContentsWidgetsStatus "normal"

    puts "Created:\n$VolumeString\n"

    RunContentsCmd [SN ContentsErrorList] "vtblc -f $Options(RawNoRewindDevice)  --truncate=$VolumeCount --modify=tagged" $VolumeString
}


# Internal procedures

# eof
#

