/*
 *      Copyright (C) 1997 Claus-Justus Heine

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 * $Source: /homes/cvs/ftape/ftape-tools/src/ftformat/ftformat.h,v $
 * $Revision: 1.2 $
 * $Date: 1998/08/13 21:46:58 $
 *
 *      This file contains the definitions for the user level floppy
 *      tape formatting stuff for the QIC-40/80/3010/3020 floppy-tape
 *      driver "ftape" for Linux.
 */

#ifndef NR_FTAPE_BUFFERS
#define NR_FTAPE_BUFFERS 3
#endif

#define NR_ITEMS(x)     (int)(sizeof(x)/ sizeof(*x))

/* Each sector in a segment needs these four bytes to be send via dma.
 * As the fdc doesn't know about the sequential ordering of data on a tape,
 * one needs to translate the segment id and sector number of a TAPE segment
 * into something the fdc understands. In turn, the tape drive hardware knows
 * what to do with the data it gets from the fdc.
 *
 * cyl  gives the floppy track the sector belongs to
 * head gives the floppy r/w head this sector belongs to
 * sect gives the sector relative to the start of the floppy track
 * size is equal to 3.
 */

typedef struct {
    u_int8_t cyl; u_int8_t head; u_int8_t sect; u_int8_t size;
} format_sector __attribute__ ((packed));

typedef struct {
	format_sector sectors[FT_SECTORS_PER_SEGMENT];
} format_segment __attribute__ ((packed));

#define MAX_FLOPPY_SECTOR 128        /* number of sectors per track */
#define SEGMENTS_PER_FLOPPY_TRACK (MAX_FLOPPY_SECTOR/FT_SECTORS_PER_SEGMENT)
/* segments per floppy head. ftm == floppy track max. */
#define SPFH(ftm) (SEGMENTS_PER_FLOPPY_TRACK * ((ftm) + 1))

/*  Unaligned access.
 */
#define PUT2(ptr, off, val) \
{ u_int16_t _val = val; memcpy((u_int8_t *)ptr + off, &_val, 2); }
#define PUT4(ptr, off, val) \
{ u_int32_t _val = val; memcpy((u_int8_t *)ptr + off, &_val, 4); }
#define PUT8(ptr, off, val) \
{ u_int64_t _val = val; memcpy((u_int8_t *)ptr + off, &_val, 8); }
#define GET2(ptr, off) \
({ u_int16_t _res; memcpy(&_res, (u_int8_t *)ptr + off, 2); _res; })
#define GET4(ptr, off) \
({ u_int32_t _res; memcpy(&_res, (u_int8_t *)ptr + off, 4); _res; })
#define GET8(ptr, off) \
({ u_int64_t _res; memcpy(&_res, (u_int8_t *)ptr + off, 8); _res; })

/* count the number of bits set in mask
 */
static inline int count_ones(unsigned long mask)
{
	int bits;

	for (bits = 0; mask != 0; mask >>= 1) {
		if (mask & 1) {
			++bits;
		}
	}
	return bits;
}

extern int
getsubopt (char **optionp, const char *const *tokens, char **valuep);

/*
 * Local variables:
 *  version-control: t
 *  kept-new-versions: 5
 *  c-basic-offset: 4
 *  tab-width: 4
 * End:
 */
