/*
  Truncates the column data to make them fit into the
  field width specification.

  Author: Carlo Strozzi <carlos@linux.it>
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define EMPTY			""

void show_help( char *my_name)
{
    printf("
        NoSQL operator: %s

Usage:  %s [options]

Options:
    -h    Print this help info.
    -b    Strips extra blanks from field edges.
    -n    Strips table header from output.

Truncates any data column wider than the length specified by the column
definition header line.

This operator reads an rdbtable from STDIN and prints the output rdbtable
to STDOUT.


'$Id: nsq-trunc.c,v 1.1 1998/05/29 20:43:01 carlos Exp $'

            ----------------------
NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.
This program comes with ABSOLUTELY NO WARRANTY; for details
refer to the GNU General Public License.

You should have received a copy of the GNU General Public License
along with this program;  if not, write to the Free Software
Foundation, Inc., 59 Temple Place Suite 330, Boston, MA 02111-1307
USA.
            ----------------------\n",my_name,my_name,"\\");
}

int main( int  argc, char *argv[] ) {
  
  /* For getopt() */
  extern char* optarg;
  extern int optind;

  /* for the rest of the program. */
  register int
	a_loop;
  char
	*my_name=argv[0],
	cmd_buf[MAX_COMMAND_LENGTH];

  int no_hdr=0, debug=0, strip_blanks=0;

  while ((a_loop = getopt(argc, argv, "xhnb")) != EOF) {
    switch (a_loop) {
      case 'h':
        show_help(my_name);
        exit(0);
        break;
      case 'x': 
        debug=1;
        break;
      case 'n': 
        no_hdr=1;
        break;
      case 'b': 
        strip_blanks=1;
        break;
      default:
        show_help(my_name);
        exit(1);
    }
  }

  snprintf(cmd_buf,MAX_COMMAND_LENGTH,"#
#
BEGIN { NULL=\"\"; FS=\"\\t\"; OFS=FS; }
# Table comments.
r == 0 && $0 ~ /^ *#/ { if(!%d) print; next; }
# Column names.
r == 0 { if(!%d) print; r++; next; }
# Column definitions.
r == 1 {
  split( $0, c_len )
  while( c_len[++c] != NULL ) {
	c_len[c] = substr( c_len[c], 1, index( c_len[c], \" \" ))
	gsub( /[^0-9]+/, NULL, c_len[c] )
  }
  if(!%d) print; r++; next;
}
{
  c=1
  if(%d) {
	sub( /^ */, NULL, $1 )
	sub( / *$/, NULL, $1 )
  }
  out_rec = substr( $1, 1, c_len[c] )
  while( ++c <= NF ) {
	if(%d) {
	  sub( /^ */, NULL, $c )
	  sub( / *$/, NULL, $c )
	}
	out_rec = out_rec OFS substr( $c, 1, c_len[c] )
  }
  print out_rec
}",no_hdr, no_hdr, strip_blanks, strip_blanks);

  if( debug )
	fprintf (stderr, "Generated AWK program:
	  ----------\n%s\n----------\n",cmd_buf);

  execlp(AWK,"awk",cmd_buf,NULL);
  exit(0);
}

