/***************************************************************************
 *
 * $Header: /home/werner/ytree/RCS/view.c,v 1.15 1998/07/26 21:21:13 werner Rel $
 *
 * View-Kommando-Bearbeitung
 *
 ***************************************************************************/


#include "ytree.h"



static int ViewFile(char *file_path);
static int ViewArchiveFile(char *file_path);


int View(char *file_path)
{
  switch( mode )
  {
    case DISK_MODE :     return( ViewFile( file_path ) );
    case TAPE_MODE:
    case RPM_FILE_MODE:
    case TAR_FILE_MODE : 
    case ZOO_FILE_MODE :
    case ZIP_FILE_MODE :
    case LHA_FILE_MODE :
    case ARC_FILE_MODE : return( ViewArchiveFile( file_path ) );
    default:             beep(); return( -1 );
  }
}




static int ViewFile(char *file_path)
{
  char *command_line, *aux;
  int  compress_method;
  int  result = -1;
  int  l;
  char *file_p_aux;
  BOOL notice_mapped = FALSE;
  
  command_line = file_p_aux = NULL;

  if( ( file_p_aux = (char *) malloc( COMMAND_LINE_LENGTH + 1 ) ) == NULL )
  {
    ERROR_MSG( "Malloc failed*ABORT" );
    exit( 1 );
  }
  StrCp(file_p_aux, file_path);

  if( access( file_path, R_OK ) )
  {
    (void) sprintf( message, 
		    "View not possible!*\"%s\"*%s", 
		    file_path, 
		    sys_errlist[errno] 
		  );
    MESSAGE( message );
    ESCAPE;
  }

  if( ( command_line = malloc( COMMAND_LINE_LENGTH + 1 ) ) == NULL )
  {
    ERROR_MSG( "Malloc failed*ABORT" );
    exit( 1 );
  }
  
  if (( aux = GetExtViewer(file_path))!= NULL) 
  {
     if (strstr(aux,"%s") != NULL) 
     {
        (void) sprintf(command_line, aux, file_p_aux);
     } 
     else 
          (void) sprintf(command_line, "%s %s", aux, file_p_aux);
  } 
  else 
  {
    compress_method = GetFileMethod( file_path );
    l = strlen( file_path );
    if( compress_method == FREEZE_COMPRESS )
    {
      (void) sprintf( command_line, 
		      "%s < %s %s | %s", 
		      MELT, 
		      file_p_aux, 
		      ERR_TO_STDOUT,
		      PAGER 
		    );
  }
  else if( compress_method == COMPRESS_COMPRESS )
  {
    (void) sprintf( command_line, 
		    "%s < %s %s | %s", 
		    UNCOMPRESS, 
		    file_p_aux, 
		    ERR_TO_STDOUT,
		    PAGER 
		  );
  }
  else if( compress_method == GZIP_COMPRESS )
  {
    (void) sprintf( command_line, 
                    "%s < %s %s | %s", 
		    GNUUNZIP, 
		    file_p_aux, 
		    ERR_TO_STDOUT,
		    PAGER 
		  );
  }
  else if( compress_method == BZIP_COMPRESS )
  {
    (void) sprintf( command_line, 
                    "%s < %s %s | %s", 
		    BUNZIP, 
		    file_p_aux, 
		    ERR_TO_STDOUT,
		    PAGER 
		  );
  }
  else
  {
    (void) sprintf( command_line, 
		    "%s %s", 
		    PAGER,
		    file_p_aux
		  );
  }
  }

  if((result = SystemCall( command_line )))
  {
    (void) sprintf( message, "can't execute*%s", command_line );
    MESSAGE( message );
  }

  if( notice_mapped ) 
  {
    UnmapNoticeWindow();
  }

FNC_XIT:

  if(file_p_aux)
    free(file_p_aux);
  if(command_line)
    free(command_line);

  return( result );
}



static int ViewArchiveFile(char *file_path)
{
  char *command_line, *aux;
  char buffer[100];
  char *archive;
  int  l;
  int  result = -1;

  if( ( command_line = malloc( COMMAND_LINE_LENGTH + 1 ) ) == NULL )
  {
    ERROR_MSG( "Malloc failed*ABORT" );
    exit( 1 );
  }

  l = strlen( file_path );
  
  if (( aux = GetExtViewer(file_path)) != NULL) {
     if (strstr(aux,"%s") != NULL) {
  	(void) sprintf( buffer, "| %s", PAGER );
     } else {
  	(void) sprintf( buffer, "| %s", aux ); /* maybe pipe-able */
     }
  } else {
    (void) sprintf( buffer, "| %s", PAGER );
  }

  archive = (mode == TAPE_MODE) ? statistic.tape_name : statistic.login_path;

  MakeExtractCommandLine( command_line, 
			  archive,
			  file_path, 
			  buffer
			);
  if((result = SystemCall( command_line )))
  {
    (void) sprintf( message, "can't execute*%s", command_line );
    MESSAGE( message );
  }

  free( command_line );

  return( result );
}


