.TH asfsm 1.0pre13 "11 January 1998" asfsm
.UC
.SH NAME
\fBasfsm\fP \- the AfterStep file system monitor
.SH SYNOPSIS
.B asfsm [-bg] [-fg] [-bp] [-z] [-pbg] [-pfg] [-pbp] [-i]
.SH DESCRIPTION
The \fBasfsm\fP application is a file system monitor for the AfterStep window
manager.  It displays "raised" horizontal bars representing the percent used 
of each mounted filesystem. Filesystems of zero initial block size are 
represented as "lowered" horizontal bars that span the entire window if the 
-showzero option is used, otherwise they are not shown at all.
\fBasfsm\fP checks the filesystem usage on an interval.  Filesystems mounted 
between intervals will appear after the next scan.  Left clicking the mouse 
in a bar pops up a window displaying detailed information about the filesystem 
that the bar represents.  
Left clicking the mouse in the border or anywhere not occupied by a bar pops up
a window which displays the filesystem names and mount directories for each
filesystem available for mount (excluding NFS filesystems on sun machines).  
An icon surrounded by a colored rectangle displays the filesystem type and
status.  A red rectangle denotes an unmounted filesystem, a green denotes a
mounted filesystem and a yellow rectangle denotes a filesystem which users do
not have permission to mount or unmount.  A zip disk image is displayed for all
filesystems whose device name contain "zip",  a Compact Disc is displayed for
all filesystems whose type is "RCKRDG", "ISO9660", "iso9660", or "hsfs",  
a floppy image is displayed for all filesystems whose device name contains "fd",
a dos floppy image is displayed for all floppies whose device type is "DOS"
or "msdos", a dos hard disk image is displayed for all non-floppies whose device
type is "DOS" or "msdod", a networking image is displayed for all nfs 
filesystems (whose filesystem names have a":" in them) and an image of a hard 
drive platter with a devil on it is displayed for everything else.  Left 
clicking inside the colored rectangle toggles the mount status of the 
filesystem.
.SH CONFIGURATION OPTIONS
.IP "-showzero"
.RS
Shows zero sized filesystems such as /proc.
.RE
.IP "-bg"
.RS
Changes background color of the main window.
.RE
.IP "-fg"
.RS
Changes foreground color of the main window.
.RE
.IP "-bp"
.RS
Changes background pixmap of the main window. Can also be None which lets the 
background color show through.
.RE
.IP "-z"
.RS
Changes foreground color for filesystems of zero initial block size.
.RE
.IP "-pbg"
.RS
Changes background color of the popup window.
.RE
.IP "-pfg"
.RS
Changes foreground color of the popup window.
.RE
.IP "-pbd"
.RS
Changes border color of the popup window.
.RE
.IP "-pbp"
.RS
Changes background pixmap of the popup window. Can also be None which lets 
the background color show through, Transparent which makes it transparent, or 
Translucent which makes it translucent.
.RE
.IP "-i"
.RS
Changes the interval of scan in seconds. The default is every 5 seconds.
.RE
.SH INVOCATION
\fBasfsm\fP can be called from one of many ways.  The most common invocation
is the command line:
.nf

	[user@host] ~% asfsm -b green -f blue -i 3 -pbp Translucent&

.fi
Another way to call \fBasfsm\fP is from the window manager:
.nf

	*Wharf - - MaxSwallow "asfsm"	asfsm -b green -f blue -i 3 -pbp Translucent&

.fi


This line, when placed in the \fIwharf\fP file in ~/GNUstep/Library/AfterStep
will cause \fBasfsm\fP a
button on the \fBWharf (1)\fP button bar under the \fBafterstep (1)\fP
window manager.
.SH COPYRIGHTS
GNU GPL v2
.SH AUTHORS
David Muse <dmuse@engr.latech.edu> -- application and man page.
