/*
 *--------------------------------*-C-*---------------------------------
 * File:        xiterm.h
 *
 * Copyright (c) 1995,1996 Mj Olesen <olesen@me.QueensU.CA>
 * Copyright (c) 1997 Guylhem Aznar <guylhem@danmark.linux.eu.org>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License version
 *  2 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------
 */

/* Look & feel */

#define BORDERWIDTH     1	/* borderWidth [pixels] */
#define SAVELINES       64	/* saveLines [lines] */

#define KS_BIGFONT      XK_greater
#define KS_SMALLFONT    XK_less
#define KS_PAGEUP       XK_Prior
#define KS_PAGEDOWN     XK_Next
#define KS_PASTE        XK_Insert
#define KS_PRINTSCREEN  XK_Print

/* #define OLD_SELECTION_CLICK */
#define NO_DOUBLECLICK_EXTEND

/* character class of separating chars for multiple-click selection */
#define CUTCHARS        "\t \"&'()*,;<=>?@[\\]^`{|}~"

/* color scheme */
/*
 * If it must be an integer (DEFAULT_CURSORCOLOR, DEFAULT_SCROLLBAR* ...), use:
 *
 * 0: black             (#000000)
 * 1: red               (#CD0000)
 * 2: green             (#00CD00)
 * 3: yellow            (#CDCD00)
 * 4: blue              (#0000CD)
 * 5: magenta           (#CD00CD)
 * 6: cyan              (#00CDCD)
 * 7: white             (#FAEBD7)
 * 8: bright black      (#404040)
 * 1/9: bright red      (#FF0000)
 * 2/10: bright green   (#00FF00)
 * 3/11: bright yellow  (#FFFF00)
 * 4/12: bright blue    (#0000FF)
 * 5/13: bright magenta (#FF00FF)
 * 6/14: bright cyan    (#00FFFF)
 * 7/15: bright white   (#FFFFFF)
 */

#define DEFAULT_CURSORCOLOR	3
#define DEFAULT_FOREGROUNDCOLOR "White"
#define DEFAULT_BACKGROUNDCOLOR "Black"
#define DEFAULT_SCROLLBAR_FOREGROUND "#B2B2B2"	/*scrollColor:match Netscape */
#define DEFAULT_SCROLLBAR_BACKGROUND 10		/* This one has a problem ! */

/*----------------------------------------------------------------------*
 * #define NDEBUG
 *	to disable whichever assert() macros are used in the code
 *
 * #define DEBUG_SCREEN
 *	to do self-check for internal screen corruption
 *
 * #define DEBUG_MALLOC
 *	to do self-check on out-of-bound memory usage
 *
 * #define DEBUG_CMD
 *	to output some data structures of command.c
 *	(key-buffer contents, command line, tty permissions)
 *
 * #define DEBUG_TTY
 *	to output tty settings
 *
 * #define DEBUG_COLORS
 *	to print out current color/renditions as they change
 *
 * #define DEBUG_SELECTION
 *	to use XK_Print to dump information about the current selection
 *
 * #define DEBUG_DEPTH	1
 *  to set the X color depth, for debugging lower depth modes
 *----------------------------------------------------------------------*/
/* #define NDEBUG */
#ifndef NDEBUG
/* #define DEBUG_SCREEN */
/* #define DEBUG_MALLOC */
/* #define DEBUG_CMD */
/* #define DEBUG_TTY */
/* #define DEBUG_COLORS */
/* #define DEBUG_SELECTION */
/* #define DEBUG_DEPTH 1 */
#endif

/*----------------------------------------------------------------------*
 * #define XPM_BACKGROUND
 *	to add sexy-looking background pixmaps.  Needs libxpm
 *
 * #define XPM_SCALING
 *	to allow pixmaps to be dynamically scaled
 *
 * #define PATH_ENV "XITERM_PATH"
 *	to define the name of the environment variable to be used in
 *	addition to the "PATH" environment and the `path' resource
 *
 * #define XPM_BUFFERING
 *	to use xpm buffers for the screen update
 *	(bigger & faster? ... but does it work correctly?)
 *
 * #define NO_CURSORCOLOR
 *	to avoid enabling a color cursor (-cr, cursorColor, cursorColor2)
 *
 * #define NO_BRIGHTCOLOR
 *	to suppress use of BOLD and BLINK attributes for setting
 *	bright foreground and background, respectively.
 *	Simulate BOLD using colorBD, boldFont or overstrike characters.
 *
 * #define NO_BOLDUNDERLINE
 *	to disable separate colors for bold/underline
 *
 * #define NO_BOLDOVERSTRIKE
 *	to disable using simulated bold using overstrike
 *
 * #define NO_BOLDFONT
 *	to compile without support for real bold fonts
 *
 * #define NO_SECONDARY_SCREEN
 *	to disable the secondary screen ("\E[?47h" / "\E[?47l")
 *
 * #define REFRESH_PERIOD <num>
 *	to limit the number of screenfulls between screen refreshes
 *	during hard & fast scrolling [default: 1]
 *
 * #define USE_XCOPYAREA
 *	to use XCopyArea (in place of re-draws) to speed up xiterm.
 *	- I've been told this helps with some graphics adapters like the
 *	  PC's et4000. OK, it's good on monochrome Sun-3's that I've tried
 *	  too. /RN
 *	- sometimes looks worse and slower /mjo
 *
 * #define PRINTPIPE  "lpr"
 *	to define a printer pipe which will be used for emulation of an
 *	attached vt100 printer
 *
 * #define OLD_COLOR_MODEL
 *	to use the old color model whereby erasing is done with the
 *	default rendition rather than the current rendition
 *	NB: this make break some applications and should used with caution
 *----------------------------------------------------------------------*/

/* #define XPM_BACKGROUND */
/* #define XPM_SCALING */
/* #define XPM_BUFFERING */
#define PATH_ENV	"PATH"
/* #define NO_CURSORCOLOR */
/* #define NO_BRIGHTCOLOR */
/* #define NO_BOLDUNDERLINE */
/* #define NO_BOLDOVERSTRIKE */
/* #define NO_BOLDFONT */
#define NO_SECONDARY_SCREEN
/* #define REFRESH_PERIOD       1 */
/* #define USE_XCOPYAREA */
#define PRINTPIPE    "lpr"
/* #define OLD_COLOR_MODEL */

/*----------------------------------------------------------------------*
 * #define NO_RESOURCES
 *	to blow off the Xdefaults altogether
 *
 * #define USE_XGETDEFAULT
 *	to use XGetDefault() instead of the default, which is to use a
 *	substitute for using XGetDefaults() that saves 60-150kB memory
 *
 *	The default is best if all you want to do is put xiterm defaults
 *	in ~/.Xdefaults file,
 *
 * #define XAPPLOADDIR	"/usr/X11R6/lib/X11/app-defaults"
 *	to define where to find installed application defaults for xiterm
 *	Only if USE_XGETDEFAULT is not defined.
 *
 * #define OFFIX_DND
 *	to add support for the Offix DND (Drag 'n' Drop) protocol
 *
 * #define STATIC_TITLE
 *	to avoid having the title set from program name
 *	Overridden by xdefaults.
 *----------------------------------------------------------------------*/
/* #define NO_RESOURCES */
#define USE_XGETDEFAULT
#ifndef XAPPLOADDIR
#define XAPPLOADDIR	"/usr/X11R6/lib/X11/app-defaults"
#endif
#define OFFIX_DND
/* #define STATIC_TITLE */

/*----------------------------------------------------------------------*
 * #define NO_DELETE_KEY
 *	to use the unadulterated X server value for the Delete key
 *
 * #define DONT_GUESS_BACKSPACE
 *	to use ^H for the Backspace key and avoid using the current stty
 *	setting of erase to guess a Backspace value of either ^H or ^?
 *
 * #define HOTKEY_CTRL
 * #define HOTKEY_META
 *	choose one of these values to be the `hotkey' for changing font.
 *	-- obsolete
 *
 * #define LINUX_KEYS
 *	to use
 *		Home = "\E[1~", End = "\E[4~"
 *	instead of
 *		Home = "\E[7~", End = "\E[8~"	[default]
 *
 * #define KEYSYM_RESOURCE
 *	to enable the keysym resource which allows you to define
 *	strings associated with various KeySyms (0xFF00 - 0xFFFF).
 *	Only works with the default hand-rolled resources.
 *
 * #define NO_XLOCALE
 *	to disable X11R6 support for European languages
 *	- possibly still beta
 *----------------------------------------------------------------------*/
#if defined (__sun__) || defined (__svr4__)
#define NO_DELETE_KEY		/* favoured settings for these systems */
#endif
/* #define NO_DELETE_KEY */
/* #define DONT_GUESS_BACKSPACE */

/* #define HOTKEY_CTRL */
/* #define HOTKEY_META */

#define LINUX_KEYS
#define KEYSYM_RESOURCE
/* #define NO_XLOCALE */

/*----------------------------------------------------------------------*
 * #define NO_SCROLLBAR_REPORT
 *	to disable sending escape sequences (up, down, page up/down)
 *	from the scrollbar when XTerm mouse reporting is enabled
 *
 * #define CUTCHAR_RESOURCE
 *	to add run-time support for changing the default cutchars
 *	for double click selection
 *
 * #define MOUSE_REPORT_DOUBLECLICK
 *	to have mouse reporting include double-click info for button1
 *
 * #define MULTICLICK_TIME <num>
 *	to set delay between multiple click events [default: 500]
 *----------------------------------------------------------------------*/
/* #define NO_SCROLLBAR_REPORT */
#define CUTCHAR_RESOURCE
#define MOUSE_REPORT_DOUBLECLICK
/* #define MULTICLICK_TIME 500 */

/*----------------------------------------------------------------------*
 * #define NO_MAPALERT
 *	to disable automatic de-iconify when a bell is received
 *
 * #define MAPALERT_OPTION
 *	to have mapAlert behaviour selectable with mapAlert resource
 *----------------------------------------------------------------------*/
/* #define NO_MAPALERT */
#define MAPALERT_OPTION

/*----------------------------------------------------------------------*
 * #define XTERM_SCROLLBAR
 *	to only use the XTerm-style scrollbar - no arrows, bitmapped
 *	instead of the regular scrollbar (with arrows)
 *
 * ---------------------------------------------------------------------*
 * #define SCROLLBAR_RIGHT
 *	to have the scrollbar on the right-hand side
 *
 * #define SB_WIDTH	<width>
 *	to choose the scrollbar width - should be an even number [default: 10]
 *	for XTERM_SCROLLBAR it is *always* 14.
 *----------------------------------------------------------------------*/
/* #define XTERM_SCROLLBAR */
/* #define SCROLLBAR_RIGHT */
#define SB_WIDTH 16

/*----------------------------------------------------------------------*
 * #define META8_OPTION
 *	to allow run-time selection of Meta (Alt) to set the 8th bit on
 *
 * You must choose between this two options :
 *
 * #define GREEK_SUPPORT
 *	to include support for the Greek Elot-928 & IBM-437 keyboard
 *	see doc/README.greek
 *
 * #define KANJI
 *	to compile with Kanji support
 *	after compilation, rename executable as `kxvt'
 *----------------------------------------------------------------------*/
/* #define META8_OPTION */
/* #define GREEK_SUPPORT */
/* #define KANJI */

/*----------------------------------------------------------------------*
 * #define DISPLAY_IS_IP
 *	to have DISPLAY environment variable and "\E[7n" transmit
 *	display with an IP number
 *
 * #define ENABLE_DISPLAY_ANSWER
 *	to have "\E[7n" transmit the display name.
 *	This has been cited as a potential security hole.
 *
 * #define ESCZ_ANSWER	"\033[?1;2C"
 *	to change what ESC Z transmits instead of the default "\E[?1;2c"
 *
 * #define SMART_WINDOW_TITLE
 *	to check the current value of the window-time/icon-name and
 *	avoid re-setting it to the same value -- avoids unnecessary window
 *	refreshes
 *
 * #define XTERM_COLOR_CHANGE
 *	to allow foreground/background color to be changed with an
 *	xterm escape sequence "\E]39;color^G" -- still experimental
 *
 * #define DEFINE_XTERM_COLOR
 *	to define TERM="xterm-color" instead of just TERM="xterm", which
 *	is a useful addition to COLORTERM for distinguishing color
 *	characteristics since it will be exported across rlogin/rsh
 *
 * #define DEFINE_TERMISLINUX
 *	to define TERM="linux", works better than xterm-color for many linux
 *	machines, thanks to <vischne@ibm.net> for the tip !
 *----------------------------------------------------------------------*/
/* #define DISPLAY_IS_IP */
/* #define ENABLE_DISPLAY_ANSWER */
/* #define ESCZ_ANSWER  "\033[?1;2C" */
#define SMART_WINDOW_TITLE
#define XTERM_COLOR_CHANGE
#define DEFINE_XTERM_COLOR
/* #define DEFINE_TERMISLINUX */

/*----------------------------------------------------------------------*
 * #define UTMP_SUPPORT
 *	for utmp support to update `/etc/utmp' to show xiterm logins
 *
 * For this to work,
 *	- make xiterm setuid root, a potential security hole but is
 *	  reportedly okay - do at your own risk
 *		su
 *		chown root.root xiterm
 *		chmod a+s xiterm
 *	- make xiterm setuid/setgid to match user/group that owns `/etc/utmp'
 *
 * #define UTMP_FILENAME "/var/run/utmp"	(Linux, FreeBSD, NetBSD 0.9)
 * #define UTMP_FILENAME "/var/adm/utmp"        (Irix, dec alpha)
 *
 *	to define where the utmp file is located if it isn't /etc/utmp
 *	and isn't defined by one of the myriad names in utmp.c
 *
 * #define TTYTAB_FILENAME "/etc/ttys"		(FreeBSD, NetBSD 0.9)
 *	for BSD-type systems, to define where the tty table is located
 *	if it isn't /etc/ttytab
 *----------------------------------------------------------------------*/
/* #define UTMP_SUPPORT */
#ifdef UTMP_SUPPORT
#ifndef UTMP_FILENAME
/* #define UTMP_FILENAME      "/var/run/utmp" */
/* #define UTMP_FILENAME      "/var/adm/utmp" */
#endif
#ifndef TTYTAB_FILENAME
#define TTYTAB_FILENAME "/etc/ttys"
#endif
#endif

/* Consistent defines - please report on the necessity
 * @ Unixware: defines (__svr4__)
 */
#if defined (SVR4) && !defined (__svr4__)
#define __svr4__
#endif
#if defined (sun) && !defined (__sun__)
#define __sun__
#endif

/*
 * sun <sys/ioctl.h> isn't properly protected?
 * anyway, it causes problems when <termios.h> is also included
 */
#if defined (__sun__)
#undef HAVE_SYS_IOCTL_H
#endif

/*----------------------------------------------------------------------*
 * Fonts used
 *----------------------------------------------------------------------*/
#ifdef KANJI
/* fonts used */
#define KFONT0  "k14"
#define KFONT1  "jiskan16"
#define KFONT2  "jiskan18"
#define KFONT3  "jiskan24"
#define KFONT4  "jiskan26"
/* sizes matched to kanji fonts */
#define FONT0   "7x14"
#define FONT1   "8x16"
#define FONT2   "9x18"
#define FONT3   "12x24"
#define FONT4   "13x26"

#else /* KANJI */
#define FONT0   "7x14"
#define FONT1   "6x13"
#define FONT2   "8x13"
#define FONT3   "9x15"
#define FONT4   "10x20"

/*----------------------------------------------------------------------*
 * end of user configuration section
 *----------------------------------------------------------------------*/

/* the logical position of font0 in the list */
#define FONT0_IDX 2
#undef GREEK_SUPPORT		/* Kanji/Greek together is too weird */
#undef XTERM_FONT_CHANGE	/* can't ensure font sizes will match */
#endif

#ifdef XPM_BUFFERING
#ifndef XPM_SCALING
#define XPM_SCALING
#endif
#endif

/* Define if you have the Xpm library (-lXpm).
* #ifndef HAVE_LIBXPM
* #undef XPM_BACKGROUND
* #endif
* disable what can't be used
*/

#ifndef XPM_BACKGROUND
#undef XPM_BUFFERING
#undef XPM_SCALING
#undef XTERM_PIXMAP_CHANGE
#endif

#define APL_CLASS	"XTerm"		/* class name */
#define APL_SUBCLASS	"XIterm"	/* also check resources for this name */
#define APL_NAME	"Xiterm"	/* normal name */

/* COLORTERM, TERM environment variables */

#define COLORTERMENV	"xiterm"

#ifdef DEFINE_TERMISLINUX
#undef DEFINE_XTERM_COLOR
#define TERMENV	"linux"
#endif

#ifndef DEFINE_TERMISLINUX
#define TERMENV "xterm"
#endif

#ifdef KANJI
#undef DEFINE_TERMISLINUX
#define TERMENV "kterm"
#endif

#if defined (NO_RESOURCES) || defined (USE_XGETDEFAULT)
#undef KEYSYM_RESOURCE
#endif
#ifdef NO_RESOURCES
#undef USE_XGETDEFAULT
#endif

/*----------------------- end-of-file (C header) -----------------------*/
