/*
** Chameleon by ff, 1998.
** Release 1.0
**
** chameleon --help for usage information 
**
**
** Thanks to _QZ, smitten and printf1 for their
** time beta testing, recommending improvements
** and reporting bugs.
*/

#include <ctype.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>

#include "chameleon.h"


/* Callback handler for the "Set Color" button. */

void set_color(GtkWidget *widget, gpointer *colorsel)
{
	gdouble data[3];
	int red, green, blue;
	char buf[16];

	gtk_color_selection_get_color(GTK_COLOR_SELECTION(colorsel),
		(gdouble *)&data);

/* This is quite crude... please dont kill me. 
 * This converts GTK's 0-1 float format of RGB colors
 * to the X-friendly 0-65535 int format... */

	sprintf(buf, "%.0f", data[0]*65535.0);
	red = atoi(buf);
	sprintf(buf, "%.0f", data[1]*65535.0);
	green = atoi(buf);
	sprintf(buf, "%.0f", data[2]*65535.0);
	blue = atoi(buf);

/* Set the background color given the RGB values... */
	
	set_rgb(red, green, blue);
}


void delete_event (GtkWidget *widget, GdkEvent *event, gpointer *data)
{
	gtk_main_quit();
}

/* This limitation is a bit lame, and will likely
 * be fixed in a later version. */

	char path[MAXPATH];


/* This function is called upon selection of an image
 * file to be tiled. */
	
void tile_ok_sel(GtkWidget *w, GtkFileSelection *fs)
{
	char *name;

	name = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));

/* Make sure a file was actually selected from a dialog. */

	if(strlen(name) > 0 && name[strlen(name)-1]!='/') {
		strncpy(path, name, MAXPATH-1);
		set_file(name, 0);
	}
	
/* If no file was selected, pretend the whole thing never
 * happened and just kill the dialog. */
	
	gtk_widget_destroy(GTK_WIDGET(fs));
}


/* This function is called upon selection of an image
 * file to be stretched in the background. */

void stretch_ok_sel(GtkWidget *w, GtkFileSelection *fs)
{
	char *name;

	name = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));

/* Make sure something was actually selected... */

	if(strlen(name) > 0 && name[strlen(name)-1]!='/') {
		strncpy(path, name, MAXPATH-1);
		set_file(name, 1);
	}
	gtk_widget_destroy(GTK_WIDGET(fs));
}


/* The code for the "Select Image to be Tiled" dialog box */

void seltile (GtkWidget *widget, gpointer *data)
{
	GtkWidget *fs;

	fs = gtk_file_selection_new("Select the image to tile");

	if(path[0] != 0)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs),
			(char *)path);

	gtk_signal_connect (GTK_OBJECT (fs), "destroy",
		(GtkSignalFunc)delete_event, &fs);

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		"clicked", (GtkSignalFunc) tile_ok_sel, fs);

	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
		"clicked", (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(fs));

	gtk_widget_show(fs);
	gtk_main();
	
	return;
}


/* The code for the "Select Image to be Stretched" dialog */

void selstretch (GtkWidget *widget, gpointer *data)
{
	GtkWidget *fs;

	fs = gtk_file_selection_new("Select the image to stretch");

	if(path[0] != 0)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs),
			(char *)path);

	gtk_signal_connect (GTK_OBJECT (fs), "destroy",
		(GtkSignalFunc)delete_event, &fs);

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		"clicked", (GtkSignalFunc) stretch_ok_sel, fs);

	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
		"clicked", (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(fs));

	gtk_widget_show(fs);
	gtk_main();
	
	return;
}


/* Check for existence of a file...
 * If it exists, return 1, if not, 0. */

int exist(char *file)
{
	int fd;

	if((fd = open(file, O_RDONLY)) < 0)
		return 0;

	close(fd);
	return 1;
}


/* Chameleon's main routine. */

int main (int argc, char **argv)
{
	char conf[MAXPATH];

	int red, green, blue, temp;

	GtkWidget *window, *button, *set, *box, *tile, *stretch,
		*info, *colorsel, *separator, *quitbox;


	gtk_init (&argc, &argv);

	/* Process arguments if there are any */
	if(argc > 1) {

		/* The argument is an RGB specification */
		if(argv[1][0]=='#') {
			printf("Looks like a color spec...\n");
			temp = strtol(argv[1]+1, NULL, 16);
			
			red = temp / 65536;
			green = (temp % 65536) / 256;
			blue = temp % 256;

			printf("Setting color: Red: %d   Green: %d   Blue: %d\n", red, green, blue);
			set_rgb(red*256, green*256, blue*256);
			printf("Done.\n");
			
			return 0;
		} 

		/* The argument is a filename */
		else if(strstr(argv[1], ".")!=NULL || strstr(argv[1], "/")!=NULL) {
			if(argv[2]!=NULL && strcmp(argv[2], "-t")==0)
				temp = 0;
			else temp = 1;

			printf("Looks like a filename... ");
			if(exist(argv[1]))
				printf("yup, found it.\n");
			else {
				printf("nope, doesn't exist.\n");
				return 1;
			}

			if(set_file(argv[1], temp)!=0) {
				return 1;
			}
			else return 0;		
		}

		/* The argument is a color name */
		else if(isalpha(argv[1][0])) {
			printf("Looks like a color name...\nSetting color...\n");

			if(set_name(argv[1])!=0) {
				fprintf(stderr, "Failed: Invalid color.\n");
				return 1;
			}
			else {
				printf("Done.\n");
				return 0;
			}
		}

		else {
			fprintf(stderr, "%s%s", VERSION, USAGE);
			return 1;
		}
	}

	/* No arguments, go into visual mode */

	/* First, parse the configuration file */
	strncpy(conf, getenv("HOME"), MAXPATH-strlen(CONFFILE)-2);
	strcat(conf, "/");
	strcat(conf, CONFFILE);

	gtk_rc_parse(conf);


/* Now, set up all the widgets and associate them with callbacks. */

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW(window), VERSION);

	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		GTK_SIGNAL_FUNC (delete_event), NULL);
	gtk_container_border_width (GTK_CONTAINER (window), 10);

	box = gtk_vbox_new (FALSE, 0);
         
 	colorsel = gtk_color_selection_new();
	gtk_box_pack_start (GTK_BOX (box), colorsel, FALSE, FALSE, 0);
	gtk_widget_show (colorsel);

	separator = gtk_hseparator_new ();

	gtk_box_pack_start (GTK_BOX (box), separator, FALSE, TRUE, 5);
	gtk_widget_show (separator);

	quitbox = gtk_hbox_new (FALSE, 0);

	info = gtk_button_new_with_label ("  Color Info  ");
	gtk_signal_connect (GTK_OBJECT (info), "clicked",
		GTK_SIGNAL_FUNC (color_info), (gpointer)colorsel);

	set = gtk_button_new_with_label ("  Set Color  ");
	gtk_signal_connect (GTK_OBJECT (set), "clicked",
		GTK_SIGNAL_FUNC (set_color), (gpointer)colorsel);

	tile = gtk_button_new_with_label ("  Tile Picture  ");
	gtk_signal_connect (GTK_OBJECT (tile), "clicked",
		GTK_SIGNAL_FUNC (seltile), NULL);

	stretch = gtk_button_new_with_label ("  Stretch Picture  ");
	gtk_signal_connect (GTK_OBJECT (stretch), "clicked",
		GTK_SIGNAL_FUNC (selstretch), NULL);

	gtk_box_pack_start (GTK_BOX (quitbox), info, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (quitbox), set, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (quitbox), tile, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (quitbox), stretch, TRUE, FALSE, 0);

	button = gtk_button_new_with_label ("   Done   ");

	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (delete_event), NULL);

	gtk_box_pack_start (GTK_BOX (quitbox), button, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), quitbox, FALSE, FALSE, 0);

	gtk_container_add (GTK_CONTAINER (window), box);

/* Actually display all the widgets now... */

	gtk_widget_show (info);
	gtk_widget_show (set);
	gtk_widget_show (tile);
	gtk_widget_show (stretch);
	gtk_widget_show (button);
	gtk_widget_show (quitbox);

	gtk_widget_show (box);
	gtk_widget_show (window);

	gtk_main ();

	return 0;
}
