#include "E.h"

ActionClass        *
CreateAclass(char *name)
{
   ActionClass        *a;

   EDBUG(5, "CreateAclass");
   a = Emalloc(sizeof(ActionClass));
   a->name = duplicate(name);
   a->num = 0;
   a->list = NULL;
   EDBUG_RETURN(a);
}

Action             *
CreateAction(char event, char anymod, int mod, int anybut, int but,
	     char anykey, char *key)
{
   Action             *act;

   EDBUG(5, "CreateAction");
   act = Emalloc(sizeof(Action));
   act->action = NULL;
   act->event = event;
   act->anymodifier = anymod;
   act->modifiers = mod;
   act->anybutton = anybut;
   act->button = but;
   act->anykey = anykey;
   if (!key)
      act->key = 0;
   else
      act->key = XKeysymToKeycode(disp, XStringToKeysym(key));
   EDBUG_RETURN(act);
}

void
AddToAction(Action * act, int id, void *params)
{
   ActionType         *pptr, *ptr, *at;

   EDBUG(5, "AddToAction");
   at = Emalloc(sizeof(ActionType));
   at->Next = NULL;
   at->Type = id;
   at->params = params;
   if (!act->action)
     {
	act->action = at;
     }
   else
     {
	ptr = act->action;
	while (ptr)
	  {
	     pptr = ptr;
	     ptr = ptr->Next;
	  }
	pptr->Next = at;
     }
   EDBUG_RETURN_;
}

void
AddAction(ActionClass * a, Action * act)
{
   EDBUG(5, "AddAction");
   a->num++;
   a->list = Erealloc(a->list, a->num * sizeof(Action *));
   a->list[a->num - 1] = act;
   EDBUG_RETURN_;
}

void
EventAclass(XEvent * ev, ActionClass * a)
{
   KeyCode             key;
   int                 i, type, button, modifiers, ok, mouse;
   Action             *act;
   char                reset_ewin;

   EDBUG(5, "EventAclass");
   reset_ewin = key = type = button = modifiers = mouse = 0;
   if (!mode.ewin)
     {
	mode.ewin = mode.focuswin;
	if (!mode.ewin)
	   mode.ewin = mode.mouse_over_win;
	reset_ewin = 1;
     }
   {
      EWin               *ewin;

      ewin = GetEwin();
      if ((mode.movemode == 0) && (ewin) && (mode.mode == MODE_MOVE))
	{
	   char                dofloat = 0;

	   if ((ewin->desktop != 0) && (!ewin->floating) && (!ewin->sticky))
	     {
		if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x,
		      desks.desk[ewin->desktop].y + ewin->y) != ewin->desktop)
		   dofloat = 1;
		else if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x + ewin->w,
		      desks.desk[ewin->desktop].y + ewin->y) != ewin->desktop)
		   dofloat = 1;
		else if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x + ewin->w,
				   desks.desk[ewin->desktop].y + ewin->y + ewin->h) != ewin->desktop)
		   dofloat = 1;
		else if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x,
				   desks.desk[ewin->desktop].y + ewin->y + ewin->h) != ewin->desktop)
		   dofloat = 1;
		if (dofloat)
		   FloatEwinAt(ewin, ewin->x + desks.desk[ewin->desktop].x,
			       ewin->y + desks.desk[ewin->desktop].y);
	     }
	}
   }
   switch (ev->type)
     {
     case KeyPress:
	type = EVENT_KEY_DOWN;
	key = ev->xkey.keycode;
	modifiers = ev->xbutton.state & (ShiftMask | ControlMask | Mod1Mask |
				   Mod2Mask | Mod3Mask | Mod4Mask | Mod5Mask);
	mouse = 0;
	break;
     case KeyRelease:
	type = EVENT_KEY_UP;
	key = ev->xkey.keycode;
	modifiers = ev->xbutton.state & (ShiftMask | ControlMask | Mod1Mask |
				   Mod2Mask | Mod3Mask | Mod4Mask | Mod5Mask);
	mouse = 0;
	break;
     case ButtonPress:
	type = EVENT_MOUSE_DOWN;
	button = ev->xbutton.button;
	modifiers = ev->xbutton.state & (ShiftMask | ControlMask | Mod1Mask |
				   Mod2Mask | Mod3Mask | Mod4Mask | Mod5Mask);
	mouse = 1;
	break;
     case ButtonRelease:
	type = EVENT_MOUSE_UP;
	button = ev->xbutton.button;
	modifiers = ev->xbutton.state & (ShiftMask | ControlMask | Mod1Mask |
				   Mod2Mask | Mod3Mask | Mod4Mask | Mod5Mask);
	mouse = 1;
	break;
     case EnterNotify:
	type = EVENT_MOUSE_ENTER;
	button = -1;
	modifiers = ev->xcrossing.state & (ShiftMask | ControlMask | Mod1Mask |
				   Mod2Mask | Mod3Mask | Mod4Mask | Mod5Mask);
	mouse = 1;
	break;
     case LeaveNotify:
	type = EVENT_MOUSE_LEAVE;
	button = -1;
	modifiers = ev->xcrossing.state & (ShiftMask | ControlMask | Mod1Mask |
				   Mod2Mask | Mod3Mask | Mod4Mask | Mod5Mask);
	mouse = 1;
	break;
     default:
	break;
     }
   for (i = 0; i < a->num; i++)
     {
	act = a->list[i];
	ok = 0;
	if ((act->event == type) && (act->action))
	  {
	     if (mouse)
	       {
		  if (button < 0)
		    {
		       if (act->anymodifier)
			  ok = 1;
		       else if (act->modifiers == modifiers)
			  ok = 1;
		    }
		  else
		    {
		       if (act->anymodifier)
			 {
			    if (act->anybutton)
			       ok = 1;
			    else if (act->button == button)
			       ok = 1;
			 }
		       else if (act->modifiers == modifiers)
			 {
			    if (act->anybutton)
			       ok = 1;
			    else if (act->button == button)
			       ok = 1;
			 }
		    }
	       }
	     else
	       {
		  if (act->anymodifier)
		    {
		       if (act->anykey)
			  ok = 1;
		       else if (act->key == key)
			  ok = 1;
		    }
		  else if (act->modifiers == modifiers)
		    {
		       if (act->anykey)
			  ok = 1;
		       else if (act->key == key)
			  ok = 1;
		    }
	       }
	     if (ok)
		handleAction(act->action);
	  }
     }
   if (reset_ewin)
      mode.ewin = NULL;
   EDBUG_RETURN_;
}

int
handleAction(ActionType * Action)
{

   /* This function will handle any type of action that is passed into
    * it.  ALL internal events should be passed through this function.
    * No exceptions.  --Mandrake (02/26/98)
    */

   int                 error;

   EDBUG(5, "handleAction");
   error = (*(ActionFunctions[Action->Type])) (Action->params);
   /* If there is another action in this series, perform it */
   if (!error)
      if (Action->Next)
	 error = handleAction(Action->Next);
   EDBUG_RETURN(error);
}

int
spawnMenu(void *params)
{
   EDBUG(6, "spawnMenu");
   EDBUG_RETURN(0);
}

int
hideMenu(void *params)
{
   EDBUG(6, "hideMenu");
   EDBUG_RETURN(0);
}

int
doNothing(void *params)
{
   EDBUG(6, "doNothing");
   EDBUG_RETURN(0);
}

int
execApplication(void *params)
{
   char               *sh;
   char               *path;
   char                exe[10240];

   EDBUG(6, "execApplication");
   if (!params)
      EDBUG_RETURN(0);
   if (fork())
      EDBUG_RETURN(0);
   setsid();
   sh = usershell(getuid());
   exe[0] = 0;
   sscanf(params, "%10240s", exe);
   if (exe[0])
     {
	path = pathtoexec(exe);
	if (path)
	  {
	     Efree(path);
	     execl(sh, sh, "-c", (char *)params, NULL);
	     exit(0);
	  }
	path = pathtofile(exe);
	if (!path)
	  {
	     /* absolute path */
	     if (((char *)exe)[0] == '/')
		Alert("There was an error running the program:\n"
		      "%s\n"
		      "This program could not be executed.\n"
		      "This is because the file does not exist.\n",
		      (char *)exe);
	     /* realtive path */
	     else
		Alert("There was an error running the program:\n"
		      "%s\n"
		      "This program could not be executed.\n"
		  "This is most probably because this program is not in the\n"
		      "path for your shell which is %s. I suggest you read the manual\n"
		      "page for that shell and read up how to change or add to your\n"
		      "execution path.\n",
		      (char *)exe, sh);
	  }
	else
	   /* it is a node on the filing sys */
	  {
	     /* it's a file */
	     if (isfile((char *)path))
	       {
		  /* can execute it */
		  if (canexec((char *)path))
		     Alert("There was an error running the program:\n"
			   "%s\n"
			   "This program could not be executed.\n"
			   "I am unsure as to why you could not do this. The file exists,\n"
			   "is a file, and you are allowed to execute it. I suggest you look\n"
			   "into this.\n",
			   (char *)path);
		  /* not executable file */
		  else
		     Alert("There was an error running the program:\n"
			   "%s\n"
			   "This program could not be executed.\n"
			   "This is because the file exists, is a file, but you are unable\n"
			   "to execute it because you do not have execute access to this file.\n",
			   (char *)path);
	       }
	     /* it's not a file */
	     else
	       {
		  /* its a dir */
		  if (isdir((char *)path))
		     Alert("There was an error running the program:\n"
			   "%s\n"
			   "This program could not be executed.\n"
			   "This is because the file is infact a directory.\n",
			   (char *)path);
		  /* its not a file or a dir */
		  else
		     Alert("There was an error running the program:\n"
			   "%s\n"
			   "This program could not be executed.\n"
			   "This is because the file is not a regular file.\n",
			   (char *)path);
	       }
	     Efree(path);
	  }
	exit(100);
     }
   execl(sh, sh, "-c", (char *)params, NULL);
   exit(0);
   EDBUG_RETURN(0);
}

int
alert(void *params)
{
   char               *pp;
   int                 i;

   EDBUG(6, "alert");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   pp = duplicate((char *)params);
   i = 1;
   if (!pp)
      EDBUG_RETURN(1);
   if (strlen(pp) <= 0)
      EDBUG_RETURN(1);
   while (pp[i])
     {
	if ((pp[i - 1] == '\\') && (((char *)params)[i] == 'n'))
	  {
	     pp[i - 1] = ' ';
	     pp[i] = '\n';
	  }
	i++;
     }
   Alert(pp);
   Efree(pp);
   EDBUG_RETURN(0);
}

int
doExit(void *params)
{
   char                s[1024];

   EDBUG(6, "doExit");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   if (params)
     {
	setsid();
	UngrabX();
	UnGrabTheButtons();
	XCloseDisplay(disp);
	if (mode.autosave)
	   SaveUserControlConfig();
	else
	   DeleteUserControlConfig();
	sscanf(params, "%1000s", s);
	if (mustdel)
	  {
	     char                sss[FILEPATH_LEN_MAX];

	     Esnprintf(sss, sizeof(sss), "/bin/rm -rf %s", themepath);
	     system(sss);
	  }
	if (!strcmp(s, "restart"))
	  {
	     SoundExit();
	     if (themepath[0] != 0)
	       {
		  execl("/bin/sh", "/bin/sh", "-c", command,
			"-restart", "-theme", themepath, NULL);
	       }
	     else
	       {
		  execl("/bin/sh", "/bin/sh", "-c", command,
			"-restart", NULL);
	       }
	  }
	else if (!strcmp(s, "restart_theme"))
	  {
	     SoundExit();
	     sscanf(params, "%*s %1000s", s);
	     execl("/bin/sh", "/bin/sh", "-c", command,
		   "-restart", "-theme", s, NULL);
	  }
	else if (!strcmp(s, "restart_wm"))
	  {
	     SoundExit();
	     if (atword(params, 1))
		strncpy(s, atword(params, 1), 1000);
	     execl("/bin/sh", "/bin/sh", "-c", s,
		   NULL);
	  }
     }
   ApplySclass(FindItem("SOUND_EXIT", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   EExit(0);
   EDBUG_RETURN(0);
}

int
doResize(void *params)
{
   EWin               *ewin;
   int                 x, y, w, h;

   EDBUG(6, "doResize");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   ewin = mode.ewin = GetEwin();
   if (!ewin)
      EDBUG_RETURN(0);
   if (mode.resizemode > 0)
      GrabX();
   mode.mode = MODE_RESIZE;
   x = mode.x - ewin->x;
   y = mode.y - ewin->y;
   w = ewin->w >> 1;
   h = ewin->h >> 1;
   if ((x < w) && (y < h))
      mode.resize_detail = 0;
   if ((x >= w) && (y < h))
      mode.resize_detail = 1;
   if ((x < w) && (y >= h))
      mode.resize_detail = 2;
   if ((x >= w) && (y >= h))
      mode.resize_detail = 3;
   mode.start_x = mode.x;
   mode.start_y = mode.y;
   mode.win_x = ewin->x;
   mode.win_y = ewin->y;
   mode.win_w = ewin->client.w;
   mode.win_h = ewin->client.h;
   mode.firstlast = 0;
   DrawEwinShape(ewin, mode.resizemode, ewin->x, ewin->y, ewin->client.w, ewin->client.h, mode.firstlast);
   mode.firstlast = 1;
   EDBUG_RETURN(0);
}

int
doResizeH(void *params)
{
   EWin               *ewin;
   int                 x, w;

   EDBUG(6, "doResizeH");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   ewin = mode.ewin = GetEwin();
   if (!ewin)
      EDBUG_RETURN(0);
   if (mode.resizemode > 0)
      GrabX();
   mode.mode = MODE_RESIZE_H;
   x = mode.x - ewin->x;
   w = ewin->w >> 1;
   if (x < w)
      mode.resize_detail = 0;
   else
      mode.resize_detail = 1;
   mode.start_x = mode.x;
   mode.start_y = mode.y;
   mode.win_x = ewin->x;
   mode.win_y = ewin->y;
   mode.win_w = ewin->client.w;
   mode.win_h = ewin->client.h;
   mode.firstlast = 0;
   DrawEwinShape(ewin, mode.resizemode, ewin->x, ewin->y, ewin->client.w, ewin->client.h, mode.firstlast);
   mode.firstlast = 1;
   EDBUG_RETURN(0);
}

int
doResizeV(void *params)
{
   EWin               *ewin;
   int                 y, h;

   EDBUG(6, "doResizeV");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   ewin = mode.ewin = GetEwin();
   if (!ewin)
      EDBUG_RETURN(0);
   if (mode.resizemode > 0)
      GrabX();
   mode.mode = MODE_RESIZE_V;
   y = mode.y - ewin->y;
   h = ewin->h >> 1;
   if (y < h)
      mode.resize_detail = 0;
   else
      mode.resize_detail = 1;
   mode.start_x = mode.x;
   mode.start_y = mode.y;
   mode.win_x = ewin->x;
   mode.win_y = ewin->y;
   mode.win_w = ewin->client.w;
   mode.win_h = ewin->client.h;
   mode.firstlast = 0;
   DrawEwinShape(ewin, mode.resizemode, ewin->x, ewin->y, ewin->client.w, ewin->client.h, mode.firstlast);
   mode.firstlast = 1;
   EDBUG_RETURN(0);
}

int
doResizeEnd(void *params)
{
   EWin               *ewin;

   EDBUG(0, "doResizeEnd");
   ewin = GetEwin();
   if (!ewin)
     {
	if (mode.resizemode > 0)
	   UngrabX();
	EDBUG_RETURN(0);
     }
   mode.mode = MODE_NONE;
   if (mode.noewin)
      mode.ewin = NULL;
   mode.noewin = 0;
   mode.firstlast = 2;
   DrawEwinShape(ewin, mode.resizemode, ewin->x, ewin->y, ewin->client.w, ewin->client.h, mode.firstlast);
   ICCCM_Configure(ewin);
   XSync(disp, False);
   if (mode.resizemode > 0)
      UngrabX();
   mode.firstlast = 0;
   EDBUG_RETURN(0);
}

int
doMove(void *params)
{
   EWin               *ewin;
   int                 xo, yo;

   EDBUG(6, "doMove");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   ewin = mode.ewin = GetEwin();
   if (mode.movemode > 0)
      GrabX();
   GrabThePointer(root.win);
   mode.mode = MODE_MOVE;
   mode.start_x = mode.x;
   mode.start_y = mode.y;
   mode.win_x = ewin->x;
   mode.win_y = ewin->y;
   mode.win_w = ewin->client.w;
   mode.win_h = ewin->client.h;
   mode.firstlast = 0;
   xo = desks.desk[ewin->desktop].x;
   yo = desks.desk[ewin->desktop].y;
   if ((ewin->desktop == 0) || (mode.movemode > 0))
     {
	FloatEwinAt(ewin, ewin->x + xo, ewin->y + yo);
     }
   DrawEwinShape(ewin, mode.movemode, ewin->x, ewin->y, ewin->client.w, ewin->client.h, mode.firstlast);
   mode.firstlast = 1;
   EDBUG_RETURN(0);
}

int
doMoveEnd(void *params)
{
   EWin               *ewin;
   int                 d;

   EDBUG(6, "doMoveEnd");
   ewin = GetEwin();
   UnGrabTheButtons();
   if (!ewin)
     {
	if (mode.movemode > 0)
	   UngrabX();
	EDBUG_RETURN(0);
     }
   mode.mode = MODE_NONE;
   if (mode.noewin)
      mode.ewin = NULL;
   mode.noewin = 0;
   mode.firstlast = 2;
   if (ewin->sticky)
     {
	ewin->floating = 0;
	DesktopRemoveEwin(ewin);
	DrawEwinShape(ewin, mode.movemode, ewin->x, ewin->y, ewin->client.w,
		      ewin->client.h, mode.firstlast);
     }
   else
     {
	d = DekstopAt(mode.x, mode.y);
	DrawEwinShape(ewin, mode.movemode, ewin->x, ewin->y, ewin->client.w,
		      ewin->client.h, mode.firstlast);
	if ((ewin->floating) || (mode.movemode > 0))
	  {
	     ewin->floating = 0;
	     MoveEwinToDesktopAt(ewin, d,
				 ewin->x - desks.desk[d].x,
				 ewin->y - desks.desk[d].y);
	  }
	RaiseEwin(ewin);
	mode.firstlast = 0;
     }
   ICCCM_Configure(ewin);
   XSync(disp, False);
   if (mode.movemode > 0)
      UngrabX();
   EDBUG_RETURN(0);
}

int
doRaise(void *params)
{
   EWin               *ewin;

   EDBUG(6, "doRaise");
   ewin = GetEwin();
   if (!ewin)
      EDBUG_RETURN(0);
   RaiseEwin(ewin);
   EDBUG_RETURN(0);
}

int
doLower(void *params)
{
   EWin               *ewin;

   EDBUG(6, "doLower");
   ewin = GetEwin();
   if (!ewin)
      EDBUG_RETURN(0);
   LowerEwin(ewin);
   EDBUG_RETURN(0);
}

int
doCleanup(void *params)
{
   char               *type;
   int                 method;
   void              **lst;
   int                 i, j, k, num, speed;
   RectBox            *fixed, *ret, *floating;
   char                doslide;
   EWin               *ewin;
   Button            **blst;

   EDBUG(6, "doCleanup");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   type = (char *)params;
   method = ARRANGE_BY_SIZE;
   speed = mode.slidespeedcleanup;
   doslide = mode.cleanupslide;
   if (params)
     {
	if (!strcmp("order", type))
	   method = ARRANGE_VERBATIM;
	else if (!strcmp("place", type))
	   method = ARRANGE_BY_POSITION;
     }
   lst = ListItemType(&num, LIST_TYPE_EWIN);
   if (lst)
     {
	fixed = NULL;
	floating = Emalloc(sizeof(RectBox) * num);
	ret = Emalloc(sizeof(RectBox) * (num));
	j = 0;
	for (i = 0; i < num; i++)
	  {
	     if (((EWin *) lst[i])->desktop == desks.current)
	       {
		  floating[j].data = lst[i];
		  floating[j].x = ((EWin *) lst[i])->x;
		  floating[j].y = ((EWin *) lst[i])->y;
		  floating[j].w = ((EWin *) lst[i])->w;
		  floating[j++].h = ((EWin *) lst[i])->h;
	       }
	  }
	blst = (Button **) ListItemType(&num, LIST_TYPE_BUTTON);
	k = 0;
	if (blst)
	  {
	     fixed = Emalloc(sizeof(RectBox) * (num));
	     ret = Erealloc(ret, sizeof(RectBox) * ((num + j) + 1));
	     for (i = 0; i < num; i++)
	       {
		  if (((blst[i]->desktop == desks.current) ||
		       ((blst[i]->desktop == 0) && (blst[i]->sticky))) &&
		      (blst[i]->visible))
		    {
		       fixed[k].data = NULL;
		       fixed[k].x = blst[i]->x;
		       fixed[k].y = blst[i]->y;
		       fixed[k].w = blst[i]->w;
		       fixed[k++].h = blst[i]->h;
		    }
	       }
	     Efree(blst);
	  }
	ArrangeRects(fixed, k, floating, j, ret, root.w, root.h, method);
	for (i = 0; i < (j + k); i++)
	  {
	     if (ret[i].data)
	       {
		  if (doslide)
		    {
		       ewin = (EWin *) ret[i].data;
		       if (ewin)
			 {
			    if ((ewin->x != ret[i].x) || (ewin->y != ret[i].y))
			      {
				 SlideEwinTo(ewin, ewin->x, ewin->y, ret[i].x, ret[i].y, speed);
				 ICCCM_Configure(ewin);
			      }
			 }
		    }
		  else
		    {
		       ewin = (EWin *) ret[i].data;
		       if (ewin)
			 {
			    if ((ewin->x != ret[i].x) || (ewin->y != ret[i].y))
			      {
				 MoveEwin((EWin *) ret[i].data, ret[i].x, ret[i].y);
				 ICCCM_Configure((EWin *) ret[i].data);
			      }
			 }
		    }
	       }
	  }
	if (fixed)
	   Efree(fixed);
	Efree(ret);
	Efree(floating);
	Efree(lst);
     }
   EDBUG_RETURN(0);
}

int
doKill(void *params)
{
   EWin               *ewin;

   EDBUG(6, "doKill");
   ewin = GetEwin();
   if (!ewin)
      EDBUG_RETURN(0);
   ICCCM_Delete(ewin);
   ApplySclass(FindItem("SOUND_WINDOW_CLOSE", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   EDBUG_RETURN(0);
}

int
doKillNasty(void *params)
{
   EWin               *ewin;

   EDBUG(6, "doKillNasty");
   ewin = GetEwin();
   if (!ewin)
      EDBUG_RETURN(0);
   XDestroyWindow(disp, ewin->client.win);
   ApplySclass(FindItem("SOUND_WINDOW_CLOSE", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   EDBUG_RETURN(0);
}

int
doNextDesktop(void *params)
{
   EDBUG(6, "doNextDesktop");
   GotoDesktop(desks.current + 1);
   ApplySclass(FindItem("SOUND_DESKTOP_SHUT", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   EDBUG_RETURN(0);
}

int
doPrevDesktop(void *params)
{
   EDBUG(6, "doPrevDesktop");
   GotoDesktop(desks.current - 1);
   ApplySclass(FindItem("SOUND_DESKTOP_SHUT", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   EDBUG_RETURN(0);
}

int
doRaiseDesktop(void *params)
{
   int                 d;

   EDBUG(6, "doRaiseDesktop");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   if (!params)
      d = desks.current;
   else
      d = atoi((char *)params);
   RaiseDesktop(d);
   EDBUG_RETURN(0);
}

int
doLowerDesktop(void *params)
{
   int                 d;

   EDBUG(6, "doLowerDesktop");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   if (!params)
      d = desks.current;
   else
      d = atoi((char *)params);
   LowerDesktop(d);
   EDBUG_RETURN(0);
}

int
doDragDesktop(void *params)
{
   int                 d;

   EDBUG(6, "doDragDesktop");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   if (!params)
      d = desks.current;
   else
      d = atoi((char *)params);
   mode.deskdrag = d;
   mode.mode = MODE_DESKDRAG;
   mode.start_x = mode.x;
   mode.start_y = mode.y;
   mode.win_x = desks.desk[d].x;
   mode.win_y = desks.desk[d].y;
   EDBUG_RETURN(0);
}

int
doStick(void *params)
{
   EWin               *ewin;
   int                 xo, yo;
   int                 d;

   EDBUG(6, "doStick");
   ewin = GetEwin();
   if (!ewin)
      EDBUG_RETURN(0);
   if (ewin->sticky)
     {
	ewin->sticky = 0;
	ewin->state &= ~EWIN_STICKY;
	d = DekstopAt(ewin->x, ewin->y);
	xo = desks.desk[d].x;
	yo = desks.desk[d].y;
	MoveEwinToDesktopAt(ewin, d, ewin->x - xo, ewin->y - yo);
	RaiseEwin(ewin);
	DrawEwin(ewin);
	ApplySclass(FindItem("SOUND_WINDOW_UNSTICK", 0,
			     LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
     }
   else
     {
	xo = desks.desk[ewin->desktop].x;
	yo = desks.desk[ewin->desktop].y;
	MoveEwinToDesktopAt(ewin, 0, ewin->x + xo, ewin->y + yo);
	DesktopRemoveEwin(ewin);
	ewin->sticky = 1;
	ewin->state |= EWIN_STICKY;
	RaiseEwin(ewin);
	DrawEwin(ewin);
	DesktopRemoveEwin(ewin);
	ApplySclass(FindItem("SOUND_WINDOW_STICK", 0,
			     LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
     }
   EDBUG_RETURN(0);
}

int
doInplaceDesktop(void *params)
{
   int                 d;

   EDBUG(6, "doInplaceDesktop");
   if (!params)
      d = desks.current;
   else
      d = atoi((char *)params);
   GotoDesktop(d);
   ApplySclass(FindItem("SOUND_DESKTOP_SHUT", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   EDBUG_RETURN(0);
}

int
doDragButtonStart(void *params)
{
   Button             *button;
   int                 xo, yo;

   EDBUG(6, "doDragButtonStart");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   button = mode.button;
   if (button->flags & FLAG_FIXED)
     {
	mode.button = NULL;
	EDBUG_RETURN(0);
     }
   if (!button)
      EDBUG_RETURN(0);
   GrabThePointer(root.win);
   mode.mode = MODE_BUTTONDRAG;
   mode.button_move_pending = 1;
   mode.start_x = mode.x;
   mode.start_y = mode.y;
   mode.win_x = button->x;
   mode.win_y = button->y;
   mode.firstlast = 0;
   xo = desks.desk[button->desktop].x;
   yo = desks.desk[button->desktop].y;
   EDBUG_RETURN(0);
}

int
doDragButtonEnd(void *params)
{
   Button             *button;
   int                 d;

   EDBUG(6, "doDragButtonEnd");
   button = mode.button;
   if (!button)
      EDBUG_RETURN(0);
   mode.mode = MODE_NONE;
   UnGrabTheButtons();
   if (!mode.button_move_pending)
     {
	d = DekstopAt(mode.x, mode.y);
	MoveButtonToDesktop(button, d);
	MovebuttonToCoord(button, button->x - desks.desk[button->desktop].x,
			  button->y - desks.desk[button->desktop].y);
     }
   else
      mode.button_move_pending = 0;
   EDBUG_RETURN(0);
}

int
doFocusModeSet(void *params)
{
   EDBUG(6, "doFocusModeSet");
   if (params)
     {
	if (!strcasecmp("pointer", params))
	   mode.focusmode = FOCUS_POINTER;
	else if (!strcasecmp("sloppy", params))
	   mode.focusmode = FOCUS_SLOPPY;
	else if (!strcasecmp("click", params))
	   mode.focusmode = FOCUS_CLICK;
     }
   else
     {
	if (mode.focusmode == FOCUS_POINTER)
	   mode.focusmode = FOCUS_SLOPPY;
	else if (mode.focusmode == FOCUS_SLOPPY)
	   mode.focusmode = FOCUS_CLICK;
	else if (mode.focusmode == FOCUS_CLICK)
	   mode.focusmode = FOCUS_POINTER;
     }
   EDBUG_RETURN(0);
}

int
doMoveModeSet(void *params)
{
   EDBUG(6, "doMoveModeSet");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   if (params)
     {
	mode.movemode = atoi(params);
     }
   else
     {
	mode.movemode++;
	if (mode.movemode > 1)
	   mode.movemode = 0;
     }
   EDBUG_RETURN(0);
}

int
doResizeModeSet(void *params)
{
   EDBUG(6, "doResizeModeSet");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   if (params)
     {
	mode.resizemode = atoi(params);
     }
   else
     {
	mode.resizemode++;
	if (mode.resizemode > 1)
	   mode.resizemode = 0;
     }
   EDBUG_RETURN(0);
}

int
doSlideModeSet(void *params)
{
   EDBUG(6, "doSlideModeSet");
   if (params)
     {
	mode.slidemode = atoi(params);
     }
   else
     {
	mode.slidemode++;
	if (mode.slidemode > 1)
	   mode.slidemode = 0;
     }
   EDBUG_RETURN(0);
}

int
doCleanupSlideSet(void *params)
{
   EDBUG(6, "doCleanupSlideSet");
   if (params)
     {
	mode.cleanupslide = atoi(params);
     }
   else
     {
	if (mode.cleanupslide)
	   mode.cleanupslide = 0;
	else
	   mode.cleanupslide = 1;
     }
   EDBUG_RETURN(0);
}

int
doMapSlideSet(void *params)
{
   EDBUG(6, "doMapSlideSet");
   if (params)
     {
	mode.mapslide = atoi(params);
     }
   else
     {
	if (mode.mapslide)
	   mode.mapslide = 0;
	else
	   mode.mapslide = 1;
     }
   EDBUG_RETURN(0);
}

int
doSoundSet(void *params)
{
   SoundClass        **lst;
   int                 num, i;
   char                snd;

   EDBUG(6, "doSoundSet");
   snd = mode.sound;
   if (params)
     {
	mode.sound = atoi(params);
     }
   else
     {
	if (mode.sound)
	   mode.sound = 0;
	else
	   mode.sound = 1;
     }
   if (mode.sound != snd)
     {
	if (!mode.sound)
	  {
	     lst = (SoundClass **) ListItemType(&num, LIST_TYPE_SCLASS);
	     if (lst)
	       {
		  for (i = 0; i < num; i++)
		    {
		       if (lst[i]->sample)
			  DestroySample(lst[i]->sample);
		       lst[i]->sample = NULL;
		    }
		  Efree(lst);
	       }
	     close(sound_fd);
	     sound_fd = -1;
	  }
	else
	   SoundInit();
     }
   EDBUG_RETURN(0);
}

int
doButtonMoveResistSet(void *params)
{
   EDBUG(6, "doButtonMoveResistSet");
   if (params)
     {
	mode.button_move_resistance = atoi(params);
     }
   EDBUG_RETURN(0);
}

int
doDesktopBgTimeoutSet(void *params)
{
   EDBUG(6, "doDesktopBgTimeoutSet");
   if (params)
     {
	mode.desktop_bg_timeout = atoi(params);
     }
   EDBUG_RETURN(0);
}

int
doMapSlideSpeedSet(void *params)
{
   EDBUG(6, "doMapSlideSpeedSet");
   if (params)
     {
	mode.slidespeedmap = atoi(params);
     }
   EDBUG_RETURN(0);
}

int
doCleanupSlideSpeedSet(void *params)
{
   EDBUG(6, "doCleanupSlideSpeedSet");
   if (params)
     {
	mode.slidespeedcleanup = atoi(params);
     }
   EDBUG_RETURN(0);
}

int
doDragdirSet(void *params)
{
   char                pd;
   Button             *b;
   int                 i;

   EDBUG(6, "doDragdirSet");
   pd = desks.dragdir;
   if (params)
     {
	desks.dragdir = atoi(params);
     }
   else
     {
	desks.dragdir++;
	if (desks.dragdir > 3)
	   desks.dragdir = 0;
     }
   if (pd != desks.dragdir)
     {
	GotoDesktop(desks.current);
	for (i = 0; i < 32; i++)
	   MoveDesktop(i, 0, 0);
	while ((b = RemoveItem("_DESKTOP_DRAG_CONTROL", 0, LIST_FINDBY_NAME,
			       LIST_TYPE_BUTTON)))
	   DestroyButton(b);
	while ((b = RemoveItem("_DESKTOP_DESKRAY_DRAG_CONTROL", 0, LIST_FINDBY_NAME,
			       LIST_TYPE_BUTTON)))
	   DestroyButton(b);
	InitDesktopControls();
	ShowDesktopControls();
     }
   EDBUG_RETURN(0);
}

int
doDragbarOrderSet(void *params)
{
   char                pd;
   Button             *b;

   EDBUG(6, "doDragbarOrderSet");
   pd = desks.dragbar_ordering;
   if (params)
     {
	desks.dragbar_ordering = atoi(params);
     }
   else
     {
	desks.dragbar_ordering++;
	if (desks.dragbar_ordering > 5)
	   desks.dragbar_ordering = 0;
     }
   if (pd != desks.dragbar_ordering)
     {
	while ((b = RemoveItem("_DESKTOP_DRAG_CONTROL", 0, LIST_FINDBY_NAME,
			       LIST_TYPE_BUTTON)))
	   DestroyButton(b);
	InitDesktopControls();
	ShowDesktopControls();
     }
   EDBUG_RETURN(0);
}

int
doDragbarWidthSet(void *params)
{
   int                 pd;
   Button             *b;

   EDBUG(6, "doDragbarWidthSet");
   pd = desks.dragbar_width;
   if (params)
     {
	desks.dragbar_width = atoi(params);
     }
   if (pd != desks.dragbar_width)
     {
	while ((b = RemoveItem("_DESKTOP_DRAG_CONTROL", 0, LIST_FINDBY_NAME,
			       LIST_TYPE_BUTTON)))
	   DestroyButton(b);
	InitDesktopControls();
	ShowDesktopControls();
     }
   EDBUG_RETURN(0);
}

int
doDragbarLengthSet(void *params)
{
   int                 pd;
   Button             *b;

   EDBUG(6, "doDragbarLengthSet");
   pd = desks.dragbar_length;
   if (params)
     {
	desks.dragbar_length = atoi(params);
     }
   if (pd != desks.dragbar_length)
     {
	while ((b = RemoveItem("_DESKTOP_DRAG_CONTROL", 0, LIST_FINDBY_NAME,
			       LIST_TYPE_BUTTON)))
	   DestroyButton(b);
	InitDesktopControls();
	ShowDesktopControls();
     }
   EDBUG_RETURN(0);
}

int
doDeskSlideSet(void *params)
{
   EDBUG(6, "doDeskSlideSet");
   if (params)
     {
	desks.slidein = atoi(params);
     }
   else
     {
	if (desks.slidein)
	   desks.slidein = 0;
	else
	   desks.slidein = 1;
     }
   EDBUG_RETURN(0);
}

int
doDeskSlideSpeedSet(void *params)
{
   EDBUG(6, "doDeskSlideSpeedSet");
   if (params)
     {
	desks.slidespeed = atoi(params);
     }
   EDBUG_RETURN(0);
}

int
doHiQualityBgSet(void *params)
{
   EDBUG(6, "doHiQualityBgSet");
   if (params)
     {
	desks.hiqualitybg = atoi(params);
     }
   else
     {
	if (desks.hiqualitybg)
	   desks.hiqualitybg = 0;
	else
	   desks.hiqualitybg = 1;
     }
   EDBUG_RETURN(0);
}

int
doPlaySoundClass(void *params)
{
   EDBUG(6, "doPlaySoundClass");
   if (!params)
      EDBUG_RETURN(0);
   ApplySclass(FindItem(params, 0, LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   EDBUG_RETURN(0);
}

int
doGotoDesktop(void *params)
{
   EDBUG(6, "doGotoDesktop");
   if (!params)
      EDBUG_RETURN(0);
   GotoDesktop(atoi(params));
   ApplySclass(FindItem("SOUND_DESKTOP_SHUT", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   EDBUG_RETURN(0);
}

int
doDeskray(void *params)
{
   EDBUG(6, "doDeskray");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   if (params)
     {
	if (!atoi(params))
	  {
	     HideDesktopTabs();
	     mode.deskmode = MODE_NONE;
	  }
	else
	  {
	     mode.deskmode = MODE_DESKRAY;
	     ShowDesktopTabs();
	  }
     }
   else
     {
	if (mode.deskmode == MODE_DESKRAY)
	  {
	     HideDesktopTabs();
	     mode.deskmode = MODE_NONE;
	  }
	else
	  {
	     mode.deskmode = MODE_DESKRAY;
	     ShowDesktopTabs();
	  }
     }
   EDBUG_RETURN(0);
}

int
doAutosaveSet(void *params)
{
   EDBUG(6, "doAutosaveSet");
   if (params)
     {
	mode.autosave = atoi(params);
     }
   else
     {
	if (mode.autosave)
	   mode.autosave = 0;
	else
	   mode.autosave = 1;
     }
   EDBUG_RETURN(0);
}

int
doHideShowButton(void *params)
{
   Button            **lst, *b;
   char                s[1024], *ss;
   int                 num, i;
   static char         lasthide = 0;

   EDBUG(6, "doHideButtons");
   if ((mode.mode == MODE_MOVE) || (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V) || (mode.mode == MODE_RESIZE))
      EDBUG_RETURN(0);
   if (params)
     {
	sscanf(params, "%1000s", s);
	if (!strcmp(s, "button"))
	  {
	     sscanf(params, "%*s %1000s", s);
	     b = (Button *) FindItem(s, 0, LIST_FINDBY_NAME, LIST_TYPE_BUTTON);
	     if (b)
	       {
		  if (b->visible)
		     HideButton(b);
		  else
		     ShowButton(b);
	       }
	  }
	else if (!strcmp(s, "buttons"))
	  {
	     ss = atword(params, 2);
	     if (ss)
	       {
		  lst = (Button **) ListItemType(&num, LIST_TYPE_BUTTON);
		  if (lst)
		    {
		       for (i = 0; i < num; i++)
			 {
			    if (matchregexp(ss, lst[i]->name))
			      {
				 if (strcmp(lst[i]->name, "_DESKTOP_DESKRAY_DRAG_CONTROL"))
				   {
				      if (lasthide)
					 ShowButton(lst[i]);
				      else
					 HideButton(lst[i]);
				   }
			      }
			 }
		       if (!lasthide)
			  lasthide = 1;
		       else
			  lasthide = 0;
		    }
	       }
	  }
	else if (!strcmp(s, "all_buttons_except"))
	  {
	     ss = atword(params, 2);
	     if (ss)
	       {
		  lst = (Button **) ListItemTypeID(&num, LIST_TYPE_BUTTON, 0);
		  if (lst)
		    {
		       for (i = 0; i < num; i++)
			 {
			    if (!matchregexp(ss, lst[i]->name))
			      {
				 if (strcmp(lst[i]->name, "_DESKTOP_DESKRAY_DRAG_CONTROL"))
				   {
				      if (lasthide)
					 ShowButton(lst[i]);
				      else
					 HideButton(lst[i]);
				   }
			      }
			 }
		       if (!lasthide)
			  lasthide = 1;
		       else
			  lasthide = 0;
		    }
	       }
	  }
	else if (!strcmp(s, "all"))
	  {
	     lst = (Button **) ListItemType(&num, LIST_TYPE_BUTTON);
	     if (lst)
	       {
		  for (i = 0; i < num; i++)
		    {
		       if (strcmp(lst[i]->name, "_DESKTOP_DESKRAY_DRAG_CONTROL"))
			 {
			    if (lasthide)
			       ShowButton(lst[i]);
			    else
			       HideButton(lst[i]);
			 }
		    }
		  if (!lasthide)
		     lasthide = 1;
		  else
		     lasthide = 0;
	       }
	  }
     }
   else
     {
	lst = (Button **) ListItemTypeID(&num, LIST_TYPE_BUTTON, 0);
	if (lst)
	  {
	     for (i = 0; i < num; i++)
	       {
		  if (lasthide)
		     ShowButton(lst[i]);
		  else
		     HideButton(lst[i]);
	       }
	     if (!lasthide)
		lasthide = 1;
	     else
		lasthide = 0;
	  }
     }
   EDBUG_RETURN(0);
}

int
initFunctionArray(void)
{
   EDBUG(5, "initFunctionArray");
   ActionFunctions[ACTION_NONE] = (int (*)(void *))(doNothing);
   ActionFunctions[ACTION_EXIT] = (int (*)(void *))(doExit);
   ActionFunctions[ACTION_EXEC] = (int (*)(void *))(execApplication);
   ActionFunctions[ACTION_ALERT] = (int (*)(void *))(Alert);
   ActionFunctions[ACTION_SHOW_MENU] = (int (*)(void *))(spawnMenu);
   ActionFunctions[ACTION_HIDE_MENU] = (int (*)(void *))(hideMenu);
   ActionFunctions[ACTION_MOVE] = (int (*)(void *))(doMove);
   ActionFunctions[ACTION_RESIZE] = (int (*)(void *))(doResize);
   ActionFunctions[ACTION_RAISE] = (int (*)(void *))(doRaise);
   ActionFunctions[ACTION_LOWER] = (int (*)(void *))(doLower);
   ActionFunctions[ACTION_CLEANUP] = (int (*)(void *))(doCleanup);
   ActionFunctions[ACTION_RESIZE_H] = (int (*)(void *))(doResizeH);
   ActionFunctions[ACTION_RESIZE_V] = (int (*)(void *))(doResizeV);
   ActionFunctions[ACTION_KILL] = (int (*)(void *))(doKill);
   ActionFunctions[ACTION_KILL_NASTY] = (int (*)(void *))(doKillNasty);
   ActionFunctions[ACTION_DESKTOP_NEXT] = (int (*)(void *))(doNextDesktop);
   ActionFunctions[ACTION_DESKTOP_PREV] = (int (*)(void *))(doPrevDesktop);
   ActionFunctions[ACTION_DESKTOP_RAISE] = (int (*)(void *))(doRaiseDesktop);
   ActionFunctions[ACTION_DESKTOP_LOWER] = (int (*)(void *))(doLowerDesktop);
   ActionFunctions[ACTION_DESKTOP_DRAG] = (int (*)(void *))(doDragDesktop);
   ActionFunctions[ACTION_STICK] = (int (*)(void *))(doStick);
   ActionFunctions[ACTION_DESKTOP_INPLACE] = (int (*)(void *))(doInplaceDesktop);
   ActionFunctions[ACTION_DRAG_BUTTON] = (int (*)(void *))(doDragButtonStart);
   ActionFunctions[ACTION_FOCUSMODE_SET] = (int (*)(void *))(doFocusModeSet);
   ActionFunctions[ACTION_MOVEMODE_SET] = (int (*)(void *))(doMoveModeSet);
   ActionFunctions[ACTION_RESIZEMODE_SET] = (int (*)(void *))(doResizeModeSet);
   ActionFunctions[ACTION_SLIDEMODE_SET] = (int (*)(void *))(doSlideModeSet);
   ActionFunctions[ACTION_CLEANUPSILDE_SET] = (int (*)(void *))(doCleanupSlideSet);
   ActionFunctions[ACTION_MAPSLIDE_SET] = (int (*)(void *))(doMapSlideSet);
   ActionFunctions[ACTION_SOUND_SET] = (int (*)(void *))(doSoundSet);
   ActionFunctions[ACTION_BUTTONMOVE_RESIST_SET] = (int (*)(void *))(doButtonMoveResistSet);
   ActionFunctions[ACTION_DESKTOPBG_TIMEOUT_SET] = (int (*)(void *))(doDesktopBgTimeoutSet);
   ActionFunctions[ACTION_MAPSLIDE_SPEED_SET] = (int (*)(void *))(doMapSlideSpeedSet);
   ActionFunctions[ACTION_CLEANUPSLIDE_SPEED_SET] = (int (*)(void *))(doCleanupSlideSpeedSet);
   ActionFunctions[ACTION_DRAGDIR_SET] = (int (*)(void *))(doDragdirSet);
   ActionFunctions[ACTION_DRAGBAR_ORDER_SET] = (int (*)(void *))(doDragbarOrderSet);
   ActionFunctions[ACTION_DRAGBAR_WIDTH_SET] = (int (*)(void *))(doDragbarWidthSet);
   ActionFunctions[ACTION_DRAGBAR_LENGTH_SET] = (int (*)(void *))(doDragbarLengthSet);
   ActionFunctions[ACTION_DESKSLIDE_SET] = (int (*)(void *))(doDeskSlideSet);
   ActionFunctions[ACTION_DESKSLIDE_SPEED_SET] = (int (*)(void *))(doDeskSlideSpeedSet);
   ActionFunctions[ACTION_HIQUALITYBG_SET] = (int (*)(void *))(doHiQualityBgSet);
   ActionFunctions[ACTION_PLAYSOUNDCLASS] = (int (*)(void *))(doPlaySoundClass);
   ActionFunctions[ACTION_GOTO_DESK] = (int (*)(void *))(doGotoDesktop);
   ActionFunctions[ACTION_DESKRAY] = (int (*)(void *))(doDeskray);
   ActionFunctions[ACTION_AUTOSAVE_SET] = (int (*)(void *))(doAutosaveSet);
   ActionFunctions[ACTION_HIDESHOW_BUTTON] = (int (*)(void *))(doHideShowButton);
   EDBUG_RETURN(0);
}
