
#include "E.h"

Window
ECreateWindow(Window parent, int x, int y, int w, int h, int saveunder)
{
   Window              win;
   XSetWindowAttributes attr;

   EDBUG(6, "ECreateWindow");
   attr.backing_store = NotUseful;
   attr.override_redirect = False;
   attr.colormap = root.cmap;
   attr.border_pixel = 0;
   attr.background_pixel = 0;
   if (saveunder)
      attr.save_under = True;
   else
      attr.save_under = False;
   win = XCreateWindow(disp, parent, x, y, w, h, 0, root.depth, InputOutput, root.vis,
	      CWOverrideRedirect | CWSaveUnder | CWBackingStore | CWColormap |
		       CWBackPixel | CWBorderPixel, &attr);
   XSetWindowBackground(disp, win, 0);
   EDBUG_RETURN(win);
}

Window
ECreateEventWindow(Window parent, int x, int y, int w, int h)
{
   Window              win;
   XSetWindowAttributes attr;

   EDBUG(6, "ECreateEventWindow");
   attr.backing_store = NotUseful;
   attr.override_redirect = False;
   attr.colormap = root.cmap;
   attr.border_pixel = 0;
   attr.background_pixel = 0;
   attr.save_under = False;
   win = XCreateWindow(disp, parent, x, y, w, h, 0, root.depth, InputOnly, root.vis,
	      CWOverrideRedirect | CWSaveUnder | CWBackingStore | CWColormap |
		       CWBackPixel | CWBorderPixel, &attr);
   XSetWindowBackground(disp, win, 0);
   EDBUG_RETURN(win);
}

void
GrabX()
{
   EDBUG(6, "GrabX");
   if (mode.server_grabbed <= 0)
      XGrabServer(disp);
   mode.server_grabbed++;
   EDBUG_RETURN_;
}

void
UngrabX()
{
   EDBUG(6, "UngrabX");
   if (mode.server_grabbed == 1)
      XUngrabServer(disp);
   mode.server_grabbed--;
   if (mode.server_grabbed < 0)
      mode.server_grabbed = 0;
   EDBUG_RETURN_;
}

void
SetBG(Window win, Pixmap pmap, int color)
{
   Atom                a, aa;

   EDBUG(6, "SetBG");
   a = XInternAtom(disp, "_XROOTPMAP_ID", False);
   aa = XInternAtom(disp, "_XROOTCOLOR_PIXEL", False);
   XChangeProperty(disp, win, a, XA_PIXMAP, 32, PropModeReplace,
		   (unsigned char *)&pmap, 1);
   XChangeProperty(disp, win, aa, XA_CARDINAL, 32, PropModeReplace,
		   (unsigned char *)&color, 1);
   if (pmap)
      XSetWindowBackgroundPixmap(disp, win, pmap);
   else
      XSetWindowBackground(disp, win, color);
   XClearWindow(disp, win);
   EDBUG_RETURN_;
}

void
GetWinXY(Window win, int *x, int *y)
{
   Window              w1;
   unsigned int        w, h, b, d;

   EDBUG(7, "GetWinXY");
   XGetGeometry(disp, win, &w1, x, y, &w, &h, &b, &d);
   EDBUG_RETURN_;
}

void
GetWinWH(Window win, unsigned int *w, unsigned int *h)
{
   Window              w1;
   int                 x, y;
   unsigned int        b, d;

   EDBUG(7, "GetWinWH");
   XGetGeometry(disp, win, &w1, &x, &y, w, h, &b, &d);
   EDBUG_RETURN_;
}

int
WinExists(Window win)
{
   Window              w1;
   int                 x, y;
   unsigned int        w, h;
   unsigned int        b, d;

   EDBUG(7, "WinExists");
   if (XGetGeometry(disp, win, &w1, &x, &y, &w, &h, &b, &d))
      EDBUG_RETURN(1);
   EDBUG_RETURN(0);
}
