#include "icewm.h"

int main(int argc, char *argv[]) {
#ifndef NO_CONFIGURE
    char *configFile = 0;
#endif
#ifdef I18N
    setlocale(LC_ALL, "");
#endif

    YApplication app(&argc, &argv);

#ifndef NO_CONFIGURE_MENUS
    if (menuFile)
        loadMenus(menuFile);
    if (programFile)
        loadMenus(programFile, true);
#else
#endif

    if (openCommand != 0) {
        char *path[2];
        YMenu *sub;
        YMenu::YMenuItem *item;

        path[0] = (char *)"/";
        path[1] = getenv("HOME");

        for (unsigned int i = 0; i < sizeof(path)/sizeof(path[0]); i++) {
            char *p = path[i];

            sub = new YBrowseMenu(p);
            item = new YMenu::YMenuItem(p, 0, 0, cmdOpen, sub, (void *)p);
            rootMenu->add(item);
        }
    }
    //rootMenu->addSubmenu("Navigate", 0, sub;
    //rootMenu->addSubmenu("Bookmarks", 0, 0);
    //rootMenu->addSubmenu("Documents", 0, 0);
#ifdef CONFIG_WINLIST
    rootMenu->addSeparator();
    {
        YMenu::YMenuItem *item =
            new YMenu::YMenuItem("Windows", 0, 0,
                                 cmdWindowList,
                                 windowListMenu, 0);
        rootMenu->add(item);
    }
#endif
    rootMenu->addSeparator();
    //rootMenu->addItem("Find...", 0, "", cmdRun);
    if (runDlgCommand != 0)
        rootMenu->addItem("Run...", 0, "", cmdRun);
    rootMenu->addItem("Refresh", 1, "", cmdRefresh);
    rootMenu->addSeparator();
    YMenu *close = new YMenu();
    close->addItem("All windows", 0, "", cmdCloseSession);
    close->addSeparator();
    close->addItem("Exit Window Manager", 1, "", cmdExit);
    if (addProgram("icewm"EXEEXT, "icewm"EXEEXT, 0) == 1)
        close->addItem("Restart icewm", 0, "", cmdRestart, (void *)(progCount - 1));
    if (addProgram("xterm", "xterm", 0) == 1)
        close->addItem("Restart xterm", 1, "", cmdRestart, (void *)(progCount - 1));
    rootMenu->addSubmenu("Close", 0, close);

    int rc = app.mainLoop();
    return rc;
}
