/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"
#ifdef I18N
#include <X11/Xlocale.h>
#endif
#ifdef GNOME
#include <gnome.h>
#endif

int initializing = 1;

YWMApp *wmapp = 0;
YWindowManager *manager = 0;
XContext frameContext;
XContext clientContext;

Cursor sizeRightPointer;
Cursor sizeTopRightPointer;
Cursor sizeTopPointer;
Cursor sizeTopLeftPointer;
Cursor sizeLeftPointer;
Cursor sizeBottomLeftPointer;
Cursor sizeBottomPointer;
Cursor sizeBottomRightPointer;

YMenu *windowMenu = 0;
YMenu *occupyMenu = 0;
YMenu *moveMenu = 0;
YMenu *layerMenu = 0;
YMenu *windowListMenu = 0;
YMenu *windowListPopup = 0;

MoveSizeStatus *statusMoveSize = 0;
SwitchWindow *switchWindow = 0;
#ifdef CONFIG_TASKBAR
TaskBar *taskBar = 0;
#endif
#ifdef CONFIG_WINLIST
WindowList *windowList = 0;
#endif
CtrlAltDelete *ctrlAltDelete = 0;

PhaseType phase = phaseStartup;

static void initContexts() {
    frameContext = XUniqueContext();
    clientContext = XUniqueContext();
}

static void registerProtocols() {
    Atom win_proto[8];
    unsigned int i = 0;

    win_proto[i++] = _XA_WIN_WORKSPACE;
    win_proto[i++] =  _XA_WIN_WORKSPACE_COUNT;
    win_proto[i++] = _XA_WIN_WORKSPACE_NAMES;
    win_proto[i++] = _XA_WIN_ICONS;
    win_proto[i++] = _XA_WIN_WORKAREA;

    win_proto[i++] = _XA_WIN_STATE;
    win_proto[i++] = _XA_WIN_LAYER;
    win_proto[i++] = __XA_WIN_WORKSPACE_NAMES;

    XChangeProperty(app->display(), manager->handle(),
                    _XA_WIN_PROTOCOLS, XA_ATOM,
                    32, PropModeReplace, (unsigned char *)win_proto, i);
}

static void unregisterProtocols() {
    XDeleteProperty(app->display(),
                    manager->handle(),
                    _XA_WIN_PROTOCOLS);
}
static void initIcons() {
    XIconSize *is;

    is = XAllocIconSize();
    assert(is != 0);
    is->min_width = 16;
    is->min_height = 16;
    is->max_width = 32;
    is->max_height = 32;
    is->width_inc = 16;
    is->height_inc = 16;
    XSetIconSizes(app->display(), manager->handle(), is, 1);
    XFree(is);
}

static void initPointers() {
    sizeRightPointer = XCreateFontCursor(app->display(), XC_right_side);
    sizeTopRightPointer = XCreateFontCursor(app->display(), XC_top_right_corner);
    sizeTopPointer = XCreateFontCursor(app->display(), XC_top_side);
    sizeTopLeftPointer = XCreateFontCursor(app->display(), XC_top_left_corner);
    sizeLeftPointer = XCreateFontCursor(app->display(), XC_left_side);
    sizeBottomLeftPointer = XCreateFontCursor(app->display(), XC_bottom_left_corner);
    sizeBottomPointer = XCreateFontCursor(app->display(), XC_bottom_side);
    sizeBottomRightPointer = XCreateFontCursor(app->display(), XC_bottom_right_corner);
}

static void initGCs() {
    titleFont = new YFont(titleFontName);
#ifdef CONFIG_TASKBAR
    normalTaskBarFont = new YFont(normalTaskBarFontName);
    activeTaskBarFont = new YFont(activeTaskBarFontName);
#endif
    minimizedWindowFont = new YFont(minimizedWindowFontName);

    titleButtonBg = new YColor(clrNormalTitleButton);
    titleButtonFg = new YColor(clrNormalTitleButtonText);

    activeBorderBg = new YColor(clrActiveBorder);
    inactiveBorderBg = new YColor(clrInactiveBorder);

    activeTitleBarBg = new YColor(clrActiveTitleBar);
    activeTitleBarFg = new YColor(clrActiveTitleBarText);

    inactiveTitleBarBg = new YColor(clrInactiveTitleBar);
    inactiveTitleBarFg = new YColor(clrInactiveTitleBarText);

    normalMinimizedWindowBg = new YColor(clrNormalMinimizedWindow);
    normalMinimizedWindowFg = new YColor(clrNormalMinimizedWindowText);

    activeMinimizedWindowBg = new YColor(clrActiveMinimizedWindow);
    activeMinimizedWindowFg = new YColor(clrActiveMinimizedWindowText);

#ifdef CONFIG_TASKBAR
    taskBarBg = new YColor(clrDefaultTaskBar);

    normalTaskBarAppBg = new YColor(clrNormalTaskBarApp);
    normalTaskBarAppFg = new YColor(clrNormalTaskBarAppText);

    activeTaskBarAppBg = new YColor(clrActiveTaskBarApp);
    activeTaskBarAppFg = new YColor(clrActiveTaskBarAppText);

    minimizedTaskBarAppBg = new YColor(clrMinimizedTaskBarApp);
    minimizedTaskBarAppFg = new YColor(clrMinimizedTaskBarAppText);
#endif
}

static void initMenus() {
    windowListMenu = new WindowListMenu();
    windowListMenu->setShared(true);
    
    windowMenu = new YMenu();
    assert(windowMenu != 0);

    occupyMenu = new YMenu();
    assert(occupyMenu != 0);

    occupyMenu->addItem("All", 0, "Alt+F2", cmdOccupyAllOrCurrent);
    //YMenu::YMenuItem *all = new YMenu::YMenuItem("All", 0, "Alt+F2",
    //                                             cmdOccupyAll,
    //                                             0, 0);
    //all->setCheck(1);
    //occupyMenu->add(all);
    occupyMenu->addSeparator();
    CARD32 w;
    for (w = 0; w < workspaceCount; w++) {
        char s[128];
        sprintf(s, "%lu. %s", (unsigned long)(w + 1), workspaceNames[w]);
        occupyMenu->addItem(s, 0, 0, cmdOccupyWorkspace, (void *)w);
    }
    //occupyMenu->addSeparator();
    //occupyMenu->addItem("All/Previous", 0, "", cmdOccupyAll);

    layerMenu = new YMenu();
    assert(layerMenu != 0);

    layerMenu->addItem("Above Dock", 0, 0, cmdSetLayer, (void *)WinLayerAboveDock);
    layerMenu->addItem("Dock", 0, 0, cmdSetLayer, (void *)WinLayerDock);
    layerMenu->addItem("OnTop", 0, 0, cmdSetLayer, (void *)WinLayerOnTop);
    layerMenu->addItem("Normal", 0, 0, cmdSetLayer, (void *)WinLayerNormal);
    layerMenu->addItem("Below", 0, 0, cmdSetLayer, (void *)WinLayerBelow);
    layerMenu->addItem("Desktop", 1, 0, cmdSetLayer, (void *)WinLayerDesktop);

    moveMenu = new YMenu();
    assert(moveMenu != 0);
    moveMenu->setShared(true);
    for (w = 0; w < workspaceCount; w++) {
        char s[128];
        sprintf(s, "%lu. %s", (unsigned long)(w + 1), workspaceNames[w]);
        moveMenu->addItem(s, 0, 0, cmdMoveToWorkspace, (void *)w);
    }

    windowMenu->addItem("Restore", 0, "Alt+F5", cmdRestore);
    windowMenu->addItem("Move", 0, "Alt+F7", cmdMove);
    windowMenu->addItem("Size", 0, "Alt+F8", cmdSize);
    windowMenu->addItem("Minimize", 2, "Alt+F9", cmdMinimize);
    windowMenu->addItem("Maximize", 2, "Alt+F10", cmdMaximize);
    windowMenu->addItem("Hide", 0, "Alt+F11", cmdHide);
    windowMenu->addItem("Rollup", 4, "Alt+F12", cmdRollup);
    windowMenu->addSeparator();
    windowMenu->addItem("Raise", 4, "Alt+F1", cmdRaise);
    windowMenu->addItem("Lower", 0, "Alt+F3", cmdLower);
    windowMenu->addSubmenu("Layer", 2, layerMenu);
    if (workspaceCount > 1) {
        windowMenu->addSeparator();
        windowMenu->addSubmenu("Move To", 5, moveMenu);
        windowMenu->addItem("Occupy All", 7, "Alt+F2", cmdOccupyAllOrCurrent);
        /*YMenu::YMenuItem *item =
            new YMenu::YMenuItem("Occupy Workspace", 0, 0,
                                 cmdOccupyAllOrCurrent,
                                 occupyMenu, 0);*/
        //windowMenu->add(item);
    }
    windowMenu->addSeparator();
    windowMenu->addItem("Close", 0, "Alt+F4", cmdClose);
#ifdef CONFIG_WINLIST
    windowMenu->addSeparator();
    {
        YMenu::YMenuItem *item =
            new YMenu::YMenuItem("Window list", 0, 0,
                                 cmdWindowList,
                                 windowListMenu, 0);
        windowMenu->add(item);
    }
#endif
    rootMenu = new ObjectMenu();

    YMenu *closeSubmenu = new YMenu();
    assert(closeSubmenu != 0);

    closeSubmenu->addItem("Close", 0, "Delete", cmdClose);
    closeSubmenu->addSeparator();
    closeSubmenu->addItem("Kill Client", 0, "", cmdKill);
    closeSubmenu->addItem("Terminate Process", 0, "", cmdTermProcess)->setEnabled(false);
    closeSubmenu->addItem("Kill Process", 5, "", cmdKillProcess)->setEnabled(false);

    windowListPopup = new YMenu();
    windowListPopup->addItem("Show", 0, "", cmdShow);
    windowListPopup->addItem("Hide", 0, "", cmdHide);
    windowListPopup->addItem("Minimize", 0, "", cmdMinimize);
    windowListPopup->addSubmenu("Move To", 5, moveMenu);
    windowListPopup->addSeparator();
    windowListPopup->addItem("Tile vertically", 5, "", cmdTileVertical)->setEnabled(false);
    windowListPopup->addItem("Tile horizontally", 1, "", cmdTileHorizontal)->setEnabled(false);
    windowListPopup->addItem("Cascade", 1, "", cmdCascade)->setEnabled(false);
    windowListPopup->addSeparator();
    YMenu::YMenuItem *item =
        new YMenu::YMenuItem("Close", 0, 0,
                             cmdClose,
                             closeSubmenu, 0);
    windowListPopup->add(item);
    //windowListPopup->addSubmenu("Close", 0, "", closeSubmenu);;
}

void initWorkspaces() {
    XTextProperty names;

    if (XStringListToTextProperty(workspaceNames, workspaceCount, &names)) {
        XSetTextProperty(app->display(),
                         manager->handle(),
                         &names, _XA_WIN_WORKSPACE_NAMES);
        XSetTextProperty(app->display(),
                         manager->handle(),
                         &names, __XA_WIN_WORKSPACE_NAMES);
        XFree(names.value);
    }

    XChangeProperty(app->display(), manager->handle(),
                    _XA_WIN_WORKSPACE_COUNT, XA_CARDINAL,
                    32, PropModeReplace, (unsigned char *)&workspaceCount, 1);

    Atom r_type;
    int r_format;
    unsigned long count;
    unsigned long bytes_remain;
    unsigned char *prop;
    CARD32 ws = 0;

    if (XGetWindowProperty(app->display(),
                           manager->handle(),
                           _XA_WIN_WORKSPACE,
                           0, 1, False, XA_CARDINAL,
                           &r_type, &r_format,
                           &count, &bytes_remain, &prop) == Success && prop)
    {
        if (r_type == XA_CARDINAL && r_format == 32 && count == 1) {
            CARD32 n = *(CARD32 *)prop;

            if (n < workspaceCount)
                ws = n;
        }
        XFree(prop);
    }
    manager->activateWorkspace(ws);
}

int handler(Display *display, XErrorEvent *xev) {

    if (initializing && 
        xev->request_code == X_ChangeWindowAttributes && 
        xev->error_code == BadAccess) 
    {
        fprintf(stderr, "WM already running, exiting...\n");
        exit(1);
    }

    DBG {
        char msg[80], req[80], number[80];
        
        XGetErrorText(display,
                      xev->error_code,
                      msg, sizeof(msg));
        sprintf(number, "%d", xev->request_code);
        
        XGetErrorDatabaseText(display,
                              "XRequest",
                              number, "",
                              req, sizeof(req));
        if (!req[0])
            sprintf(req, "[request_code=%d]", xev->request_code);
        
        fprintf(stderr, "icewm: %s(0x%lX): %s\n", req, xev->resourceid, msg);
    }
    return 0;
}

#ifdef DEBUG
void dumpZorder(const char *oper, YFrameWindow *w, YFrameWindow *a) {
    YFrameWindow *p = manager->top(w->getLayer());
    msg("---- %s ", oper);
    while (p) {
        if (p && p->client())
            msg(" %c %c 0x%lX: %s", (p == w) ? '*' : ' ',  (p == a) ? '#' : ' ', p->client()->clientWindow(), p->client()->windowTitle());
        else
            msg("?? 0x%lX: %s", p->handle());
        p = p->next();
    } 
}
#endif

void YWMApp::handleCommand(WMCommand command, void *context, unsigned int modifiers) {
    switch (command) {
    case cmdActivateWindow:
        {
            YFrameWindow *f = manager->topLayer();

            while (f) {
                if ((void *)f == context) {
                    if (modifiers & ShiftMask)
                        f->wmOccupyOnlyWorkspace(manager->activeWorkspace());
                    manager->activate(f, true);
                    return ;
                }
                f = f->nextLayer();
            }
            
        }
        break;
//    case cmdTerminal: runProgram("xterm"); break;
    case cmdRefresh:  
        {
            static YWindow *w = 0;
            if (w == 0) w = new YWindow();
            w->setGeometry(0, 0, desktop->width(), desktop->height());
            w->show();
            w->hide();
        }
        break;
//    case cmdKill:     runProgram("xkill"); break;
//    case cmdLock:     runProgram("xlock"); break;
    case cmdExec:     
#ifdef CONFIG_GUIEVENTS
        wmapp->signalGuiEvent(geLaunchApp);
#endif
        runProgram(progCmds[int(context)], progArgs[int(context)]);
        break;
    case cmdCloseSession:
        manager->wmCloseSession();
        break;
    case cmdExit:
        phase = phaseShutdown;
        manager->unmanageClients();
        unregisterProtocols();
        exit(0);
        break;
    case cmdRun:
        runProgram(runDlgCommand, 0);
        break;
    case cmdOpen:
        { 
            char *args[3];
            args[0] = (char *)openCommand;
            args[1] = (char *)context;
            args[2] = 0;
            runProgram(openCommand, args);
        }
        break;
#ifdef GNOME
    case cmdGnome:
        gnome_desktop_entry_launch((GnomeDesktopEntry *)context);
        break;
#endif
    case cmdRestart:
        phase = phaseRestart;
#ifdef CONFIG_GUIEVENTS
        wmapp->signalGuiEvent(geRestart);
#endif
        manager->unmanageClients();
        unregisterProtocols();
        XSync(display(), 0);
        runRestart(progCmds[int(context)], progArgs[int(context)]);
        phase = phaseStartup;
        registerProtocols();
        manager->manageClients();
        phase = phaseRunning;
        break;
    case cmdActivateWorkspace:
        manager->activateWorkspace(CARD32(context));
        break;
#ifdef CONFIG_WINLIST
    case cmdWindowList:
        if (windowList)
            windowList->showFocused();
        break;
#endif
    default:
        return ;
    }
}

char *findProgFile(const char *name) {
    char p[1024];
    char *h;

    h = getenv("HOME");
    if (h) {
        strcpy(p, h);
        strcat(p, "/.icewm/");
        strcat(p, name);

        if (access(p, R_OK) == 0)
            return strdup(p);
    }

    strcpy(p, configDir);
    strcat(p, "/");
    strcat(p, name);

    if (access(p, R_OK) == 0)
        return strdup(p);

    strcpy(p, REDIR_ROOT(libDir));
    strcat(p, "/");
    strcat(p, name);

    if (access(p, R_OK) == 0)
        return strdup(p);

    return 0;
}

YWMApp::YWMApp(int *argc, char ***argv, const char *displayName): YApplication(argc, argv, displayName) {
    XSetErrorHandler(handler);

    delete desktop;
    desktop = 0;
    
    desktop = manager = fWindowManager =
        new YWindowManager(0, RootWindow(display(),
                                         DefaultScreen(display())));
    assert(desktop != 0);

    registerProtocols();

    initContexts();
    initPointers();
    initGCs();
    initIcons();
    initMenus();

    wmapp = this;

    if (DesktopBackgroundPixmap && DesktopBackgroundPixmap[0]) {
        YPixmap *bg = new YPixmap(DesktopBackgroundPixmap);
        XSetWindowBackgroundPixmap(app->display(), desktop->handle(), bg->pixmap());
        XClearWindow(app->display(), desktop->handle());
    } else if (DesktopBackgroundColor && DesktopBackgroundColor[0]) {
        YColor *c = new YColor(DesktopBackgroundColor);
        XSetWindowBackground(app->display(), desktop->handle(), c->pixel());
        XClearWindow(app->display(), desktop->handle());
    }

    statusMoveSize = new MoveSizeStatus(manager);
    switchWindow = new SwitchWindow(manager);
#ifdef CONFIG_TASKBAR
    taskBar = new TaskBar(manager);
    if (showTaskBar)
        taskBar->show();
#endif
#ifdef CONFIG_WINLIST
    windowList = new WindowList(manager);
#endif
    //windowList->show();
    ctrlAltDelete = new CtrlAltDelete(manager);

    manager->updateWorkArea();

    XSetInputFocus(display(), PointerRoot, RevertToPointerRoot, CurrentTime);
    initializing = 0;

}

YWMApp::~YWMApp() {
    delete ctrlAltDelete; ctrlAltDelete = 0;
#ifdef CONFIG_TASKBAR
    delete taskBar; taskBar = 0;
#endif
    //delete windowList; windowList = 0;
    delete switchWindow; switchWindow = 0;
    delete statusMoveSize; statusMoveSize = 0;
    
    delete rootMenu; rootMenu = 0;
    delete windowListPopup; windowListPopup = 0;
    delete windowMenu; windowMenu = 0;

    // shared menus last
    delete moveMenu; moveMenu = 0;
    delete windowListMenu; windowListMenu = 0;
    
    delete titleFont; titleFont = 0;
    delete menuFont; menuFont = 0;
    //delete statusFont; statusFont = 0;
    //delete switchFont; switchFont = 0;
#ifdef CONFIG_TASKBAR
    delete normalTaskBarFont; normalTaskBarFont = 0;
    delete activeTaskBarFont; activeTaskBarFont = 0;
#endif
#ifdef CONFIG_WINLIST
    delete windowListFont; windowListFont = 0;
#endif
#ifdef CONFIG_TOOLTIP
    //delete toolTipFont; toolTipFont = 0;
#endif
#ifdef CONFIG_CLOCK
    //delete clockFont; clockFont = 0;
#endif

    delete closePixmap[0];
    delete minimizePixmap[0];
    delete maximizePixmap[0];
    delete restorePixmap[0];
    delete startPixmap;
    delete windowsPixmap;
#ifdef CONFIG_MAILBOX
    delete mailPixmap;
    delete unreadMailPixmap;
    delete newMailPixmap;
#endif
#ifdef CONFIG_CLOCK
    delete PixSpace;
    delete PixSlash;
    delete PixDot;
    delete PixA;
    delete PixP;
    delete PixM;
    delete PixColon;
    for (int n = 0; n < 10; n++) delete PixNum[n];
#endif
   
    XFreeGC(display(), outlineGC);
    XFreeGC(display(), clipPixmapGC);
    
    //XSync(app->display(), False);
}

void YWMApp::handleSignal(int sig) {
    if (sig == SIGINT)
        handleCommand(cmdExit, 0, 0);
    if (sig == SIGTERM)
        handleCommand(cmdExit, 0, 0);
    if (sig == SIGHUP)
        handleCommand(cmdRestart, 0, 0);
    YApplication::handleSignal(sig);
}

void YWMApp::handleIdle() {
#ifdef CONFIG_TASKBAR
    if (taskBar)
        taskBar->relayoutNow();
#endif
}

#ifdef CONFIG_GUIEVENTS
void YWMApp::signalGuiEvent(GUIEvent ge) {
    static Atom GUIEventAtom = None;
    unsigned char num = (unsigned char)ge;
    
    if (GUIEventAtom == None)
        GUIEventAtom = XInternAtom(app->display(), XA_GUI_EVENT_NAME, False);
    XChangeProperty(app->display(), desktop->handle(),
                    GUIEventAtom, GUIEventAtom, 8, PropModeReplace,
                    &num, 1);
}
#endif

int main(int argc, char *argv[]) {
#ifndef NO_CONFIGURE
    char *configFile = 0;
#endif
    char *overrideTheme = 0;
#ifdef I18N
    setlocale(LC_ALL, "");
#endif

    for (int i = 1; i < argc; i++) {
        if (argv[i][0] == '-') {
#ifdef DEBUG
            if (strcmp(argv[i], "-debug") == 0) {
                debug = true;
            } else if (strcmp(argv[i], "-debug_z") == 0) {
                debug_z = true;
            }
#endif
#ifndef NO_CONFIGURE
            if (strcmp(argv[i], "-c") == 0)
                configFile = argv[++i];
            else if (strcmp(argv[i], "-t") == 0)
                overrideTheme = argv[++i];
            else if (strcmp(argv[i], "-n") == 0)
                configurationLoaded = 1;
#endif
        }
    }
#ifndef NO_CONFIGURE
    if (!configurationLoaded) {
        if (configFile == 0)
            configFile = findProgFile("preferences");
        if (configFile)
            loadConfiguration(configFile);


        if (overrideTheme)
            themeName = strdup(overrideTheme);
        
        if (themeName != 0) {
            char theme[1024];
            
            char *themePath;

            strcpy(theme, "themes/");
            strcat(theme, themeName);

            themePath = findProgFile(theme);
            if (themePath) 
                loadConfiguration(themePath);
        }
    }
#endif

    if (workspaceCount == 0)
        addWorkspace(" 0 ");

#ifndef NO_CONFIGURE_MENUS
    if (menuFile == 0)
        menuFile = findProgFile("menu");
    if (programFile == 0)
        programFile = findProgFile("programs");
    if (toolbarFile == 0)
        toolbarFile = findProgFile("toolbar");
#endif

#ifndef NO_WINDOW_OPTIONS
    if (winOptFile == 0)
        winOptFile = findProgFile("winoptions");
#endif

    phase = phaseStartup;
    YWMApp app(&argc, &argv);

    app.blockSignal(SIGINT);
    app.blockSignal(SIGTERM);
    app.blockSignal(SIGHUP);

    initWorkspaces();

#ifndef NO_WINDOW_OPTIONS
    defOptions = new WindowOptions();
    hintOptions = new WindowOptions();
    if (winOptFile)
        loadWinOptions(winOptFile);
#endif
#ifndef NO_CONFIGURE_MENUS
    if (menuFile) {
        loadMenus(menuFile, rootMenu);
    }
    rootMenu->addSeparator();
#ifdef GNOME
    {
        char* gnomeApps = gnome_datadir_file("apps/");

        YMenu *sub = new GnomeMenu(0, gnomeApps);
	YMenu::YMenuItem *item = new YMenu::YMenuItem("Gnome", 0, 0,
						      cmdSubmenu, sub,
                                                      (void *)0);
        YPixmap *gnomeicon = 0;
#ifdef IMLIB
        char *gnome_logo = gnome_pixmap_file("gnome-logo-icon-transparent.png");
        if (gnome_logo)
            gnomeicon = new YPixmap(gnome_logo, ICON_SMALL, ICON_SMALL);
#endif
        item->setPixmap(gnomeicon);
	rootMenu->add(item);
    }
#endif
    if (programFile) {
        ObjectMenu *programs = new ObjectMenu();

        loadMenus(programFile, programs);

        YMenu::YMenuItem *item =
            new YMenu::YMenuItem("Programs", 0, 0, cmdSubmenu, programs, 0);
        rootMenu->add(item);
    }
#else
#endif

    if (openCommand != 0) {
        char *path[2];
        YMenu *sub;
        YMenu::YMenuItem *item;

        path[0] = (char *)"/";
        path[1] = getenv("HOME");

        for (unsigned int i = 0; i < sizeof(path)/sizeof(path[0]); i++) {
            char *p = path[i];

            sub = new BrowseMenu(p);
            item = new YMenu::YMenuItem(p, 0, 0, cmdOpen, sub, (void *)p);
            rootMenu->add(item);
        }
    }
    //rootMenu->addSubmenu("Navigate", 0, sub;
    //rootMenu->addSubmenu("Bookmarks", 0, 0);
    //rootMenu->addSubmenu("Documents", 0, 0);
#ifdef CONFIG_WINLIST
    rootMenu->addSeparator();
    {
        YMenu::YMenuItem *item =
            new YMenu::YMenuItem("Windows", 0, 0,
                                 cmdWindowList,
                                 windowListMenu, 0);
        rootMenu->add(item);
    }
#endif
    rootMenu->addSeparator();
    //rootMenu->addItem("Find...", 0, "", cmdRun);
    if (runDlgCommand != 0)
        rootMenu->addItem("Run...", 0, "", cmdRun);
    rootMenu->addItem("Refresh", 1, "", cmdRefresh);
    rootMenu->addSeparator();

    YMenu *themes = new YMenu();
    char path[1024];
    sprintf(path, "%s/themes/", libDir);
    findThemes(path, themes);
    sprintf(path, "%s/themes/", configDir);
    findThemes(path, themes);
    const char *homeDir = getenv("HOME");
    sprintf(path, "%s/.icewm/themes/", homeDir);
    findThemes(path, themes);
    rootMenu->addSubmenu("Themes", -1, themes);
                      
    YMenu *close = new YMenu();
    close->addItem("All windows", 0, "", cmdCloseSession);
    close->addSeparator();
    close->addItem("Exit Window Manager", 1, "", cmdExit);
    if (addProgram("icewm"EXEEXT, "icewm"EXEEXT, 0) == 1)
        close->addItem("Restart icewm", 0, "", cmdRestart, (void *)(progCount - 1));
    if (addProgram("xterm", "xterm", 0) == 1)
        close->addItem("Restart xterm", 1, "", cmdRestart, (void *)(progCount - 1));
    rootMenu->addSubmenu("Close", 0, close);

#ifdef CONFIG_GUIEVENTS
    app.signalGuiEvent(geStartup);
#endif
    manager->manageClients();
    phase = phaseRunning;
    int rc = app.mainLoop();
#ifdef CONFIG_GUIEVENTS
    app.signalGuiEvent(geShutdown);
#endif
    phase = phaseShutdown;
    manager->unmanageClients();
    unregisterProtocols();
    freeIcons();
    freeConfig();
    freePrograms();
#ifndef NO_WINDOW_OPTIONS
    delete defOptions; defOptions = 0;
    delete hintOptions; hintOptions = 0;
#endif
    return rc;
}
