/* xkeycaps, Copyright (c) 1994 Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the default keymap of the Sun type 4 Swedish keyboard
 * Generated by Torbj|rn Lindgren <tl@cd.chalmers.se>.
 */

#ifndef  SunXK_F36
# define SunXK_F36     0x1005FF10
#endif
#ifndef  SunXK_F37
# define SunXK_F37     0x1005FF11
#endif
#ifndef  SunXK_Props
# define SunXK_Props   0x1005FF70
#endif
#ifndef  SunXK_Front
# define SunXK_Front   0x1005FF71
#endif
#ifndef  SunXK_Copy
# define SunXK_Copy    0x1005FF72
#endif
#ifndef  SunXK_Open
# define SunXK_Open    0x1005FF73
#endif
#ifndef  SunXK_Paste
# define SunXK_Paste   0x1005FF74
#endif
#ifndef  SunXK_Cut
# define SunXK_Cut    0x1005FF75
#endif

#ifndef  SunXK_FA_Grave
# define SunXK_FA_Grave         0x1005FF00
#endif
#ifndef  SunXK_FA_Acute
# define SunXK_FA_Acute         0x1005FF03
#endif
#ifndef  SunXK_FA_Diaeresis
# define SunXK_FA_Diaeresis     0x1005FF04
#endif
#ifndef  SunXK_FA_Circum
# define SunXK_FA_Circum        0x1005FF01
#endif
#ifndef  SunXK_FA_Tilde
# define SunXK_FA_Tilde         0x1005FF02
#endif

static const struct default_keycode_map sun4sw_map [] = {
  {   8, 0,             { XK_Cancel,      0,
                        XK_F11 }},
  {  10, 0,             { XK_Redo,        0,
                        XK_F12 }},
  {  12, 0,             { XK_F1 }},
  {  13, 0,             { XK_F2 }},
  {  14, 0,             { XK_F10 }},
  {  15, 0,             { XK_F3 }},
  {  16, 0,             { XK_F11, 0,
                        SunXK_F36 }},
  {  17, 0,             { XK_F4 }},
  {  18, 0,             { XK_F12, 0,
                        SunXK_F37 }},
  {  19, 0,             { XK_F5 }},
  {  20, 0,             { XK_Multi_key }},
  {  21, 0,             { XK_F6 }},
  {  22, 0,             { XK_asciitilde,  XK_asciicircum }},
  {  23, 0,             { XK_F7 }},
  {  24, 0,             { XK_F8 }},
  {  25, 0,             { XK_F9 }},
  {  26, Mod3Mask,      { XK_Alt_L }},
  {  28, 0,             { XK_Pause,       0,
                        XK_F21 }},
  {  29, 0,             { XK_Print,       0,
                        XK_F22 }},
  {  30, 0,             { XK_Break,       XK_Scroll_Lock,
                        XK_F23 }},
  {  32, 0,             { SunXK_Props,    0,
                        XK_F13 }},
  {  33, 0,             { XK_Undo,        0,
                        XK_F14 }},
  {  36, 0,             { XK_Escape }},
  {  37, 0,             { XK_1,   XK_exclam }},
  {  38, 0,             { XK_2,   XK_quotedbl,
                        XK_at }},
  {  39, 0,             { XK_3,   XK_numbersign,
                        XK_sterling }},
  {  40, 0,             { XK_4,   XK_currency,
                        XK_dollar }},
  {  41, 0,             { XK_5,   XK_percent }},
  {  42, 0,             { XK_6,   XK_ampersand }},
  {  43, 0,             { XK_7,   XK_slash,
                        XK_braceleft }},
  {  44, 0,             { XK_8,   XK_parenleft,
                        XK_bracketleft }},
  {  45, 0,             { XK_9,   XK_parenright,
                        XK_bracketright }},
  {  46, 0,             { XK_0,   XK_equal,
                        XK_braceright }},
  {  47, 0,             { XK_plus,        XK_question,
                        XK_backslash }},
  {  48, 0,             { SunXK_FA_Acute, SunXK_FA_Grave }},
  {  49, 0,             { XK_apostrophe,  XK_asterisk,
                        XK_grave }},
  {  50, 0,             { XK_BackSpace }},
  {  52, 0,             { XK_KP_Equal,    0,
                        XK_F24 }},
  {  53, 0,             { XK_KP_Divide,   0,
                        XK_F25 }},
  {  54, 0,             { XK_KP_Multiply, 0,
                        XK_F26 }},
  {  56, 0,             { SunXK_Front,    0,
                        XK_F15 }},
  {  57, 0,             { XK_KP_Delete,   XK_KP_Decimal }},
  {  58, 0,             { SunXK_Copy,     0,
                        XK_F16 }},
  {  60, 0,             { XK_Tab }},
  {  61, 0,             { XK_Q }},
  {  62, 0,             { XK_W }},
  {  63, 0,             { XK_E }},
  {  64, 0,             { XK_R }},
  {  65, 0,             { XK_T }},
  {  66, 0,             { XK_Y }},
  {  67, 0,             { XK_U }},
  {  68, 0,             { XK_I }},
  {  69, 0,             { XK_O }},
  {  70, 0,             { XK_P }},
  {  71, 0,             { XK_Aring }},
  {  72, 0,             { SunXK_FA_Diaeresis,     SunXK_FA_Circum,
                        SunXK_FA_Tilde }},
  {  73, 0,             { XK_Delete }},
  {  74, Mod2Mask,      { XK_Mode_switch }},
  {  75, 0,             { XK_KP_Home,     XK_KP_7,
                        XK_F27 }},
  {  76, 0,             { XK_KP_Up,       XK_KP_8,
                        XK_F28 }},
  {  77, 0,             { XK_KP_Prior,    XK_KP_9,
                        XK_F28 }},
  {  78, 0,             { XK_KP_Subtract }},
  {  79, 0,             { SunXK_Open,     0,
                        XK_F17 }},
  {  80, 0,             { SunXK_Paste,    0,
                        XK_F18 }},
  {  83, LockMask,      { XK_Caps_Lock }},
  {  84, 0,             { XK_A }},
  {  85, 0,             { XK_S }},
  {  86, 0,             { XK_D }},
  {  87, 0,             { XK_F }},
  {  88, 0,             { XK_G }},
  {  89, 0,             { XK_H }},
  {  90, 0,             { XK_J }},
  {  91, 0,             { XK_K }},
  {  92, 0,             { XK_L }},
  {  93, 0,             { XK_Odiaeresis }},
  {  94, 0,             { XK_Adiaeresis }},
  {  95, 0,             { XK_section,     XK_onehalf }},
  {  96, 0,             { XK_Return }},
  {  97, 0,             { XK_KP_Enter }},
  {  98, 0,             { XK_KP_Left,     XK_KP_4,
                        XK_F30 }},
  {  99, 0,             { 0,      XK_KP_5,
                        XK_F31 }},
  { 100, 0,             { XK_KP_Right,    XK_KP_6,
                        XK_F32 }},
  { 101, 0,             { XK_KP_Insert,   XK_KP_0 }},
  { 102, 0,             { XK_Find,        0,
                        XK_F19 }},
  { 104, 0,             { SunXK_Cut,      0,
                        XK_F20 }},
  { 105, Mod4Mask,      { XK_Num_Lock }},
  { 106, ShiftMask,     { XK_Shift_L }},
  { 107, 0,             { XK_Z }},
  { 108, 0,             { XK_X }},
  { 109, 0,             { XK_C }},
  { 110, 0,             { XK_V }},
  { 111, 0,             { XK_B }},
  { 112, 0,             { XK_N }},
  { 113, 0,             { XK_M }},
  { 114, 0,             { XK_comma,       XK_semicolon }},
  { 115, 0,             { XK_period,      XK_colon }},
  { 116, 0,             { XK_minus,       XK_underscore }},
  { 117, ShiftMask,     { XK_Shift_R }},
  { 118, 0,             { XK_Linefeed }},
  { 119, 0,             { XK_KP_End,      XK_KP_1,
                        XK_F33 }},
  { 120, 0,             { XK_KP_Down,     XK_KP_2,
                        XK_F34 }},
  { 121, 0,             { XK_KP_Next,     XK_KP_3,
                        XK_F35 }},
  { 125, 0,             { XK_Help }},
  { 126, ControlMask,   { XK_Control_L }},
  { 127, Mod1Mask,      { XK_Meta_L }},
  { 128, 0,             { XK_space }},
  { 129, Mod1Mask,      { XK_Meta_R }},
  { 131, 0,             { XK_less,        XK_greater,
                        XK_bar }},
  { 132, 0,             { XK_KP_Add }}
  };
