// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: pkgctrlinfo.h,v 1.11 1997/08/18 20:49:36 tom Exp $
/* ######################################################################

   Package Control Info - Information from the packages control block

   This is the information that relates to a single package. It is stored
   in a tag/value database.
   
   Methods in pkgPkgCtrlInfo
     Find, [](string) - Find an element by it's value. 
     Add  - Add a new element into the list, if the element already exists
            false is returned.
     Remove - Deletes the specified element from the list. If the element
              was not found false is returned.
     Set - Adds a new element or changes an existing element if the element
           already exists.
   
   ##################################################################### */
									/*}}}*/
// Header section: pkglib
#ifndef PKGLIB_PKGCTRLINFO_H
#define PKGLIB_PKGCTRLINFO_H

#include <pkglib/pkgelement.h>
#include <pkglib/pointer.h>

#include <list.h>

class pkgPkgCtrlInfo
{
   // List of elements
   typedef list<pkgElement *> ElmList;
   ElmList Elements;
   
   // Find and return an iterator
   ElmList::iterator FindI(pkgElementId);
   
   public:

   // Constant iterators
   typedef ElmList::const_iterator const_iterator;
   const_iterator begin() const {return Elements.begin();};
   const_iterator end() const {return Elements.end();};
      
   // List manipulators
   bool Add(pkgElement *Element);
   void Set(pkgElement *Element);
   bool Remove(pkgElementId ID);
   
   // Locators
   const pkgElement *Find(pkgElementId Tag) const;
   const pkgElement *Find(const pkgElement &Element) const;
   const pkgElement &operator [](pkgElementId Tag) const;

   ~pkgPkgCtrlInfo();
};

// Smart pointer to a package control info.
typedef SPtr<pkgPkgCtrlInfo> pkgSPkgCtrlInfo;
typedef CSPtr<pkgPkgCtrlInfo> pkgCSPkgCtrlInfo;

#endif
