// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: anchor.cc,v 1.7 1998/01/24 02:54:54 jgg Exp $
/* ######################################################################

   Anchor - Widget anchoring mechanism
   
   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#include <deity/anchor.h>
#include <deity/widget.h>
									/*}}}*/

// Anchor::Anchor - Constructor						/*{{{*/
// ---------------------------------------------------------------------
/* */
Anchor::Anchor(Widget *Target,unsigned int Flags) :
        Notifyer(Nt_Resize), Target(Target), Flags(Flags)
{
   // Hmm, don't do this.
   if (Target->Parent == 0)
   {
      Target->Add(this);
      this->Target = 0;
      return;
   }
   
   Target->Parent->Add(this);
}
									/*}}}*/
// Anchor::Trigger - Called when the parent changes size		/*{{{*/
// ---------------------------------------------------------------------
/* This performs the anchor operation. */
bool Anchor::Trigger(Widget *From,Tag,void *Data)
{
   if (Target == 0)
      return true;
   
   // Get the sizes
   Rect NewPSize = *(Rect *)Data;
   Rect OldPSize = From->Size();
   Rect OldSize = Target->Size();
   Rect NewSize = OldSize;

   if (NewPSize.w == OldPSize.w && NewPSize.h == OldPSize.h)
      return false;
   
   // Begin mapping
   if ((Flags & LeftToRight) == LeftToRight)
      NewSize.x = NewPSize.w - (OldPSize.w - OldSize.x);

   if ((Flags & RightToLeft) == RightToLeft)
      NewSize.w = NewPSize.w - NewSize.x - (OldPSize.w - (OldSize.x + OldSize.w));

   if ((Flags & TopToBot) == TopToBot)
      NewSize.y = NewPSize.h - (OldPSize.h - OldSize.y);

   if ((Flags & BotToBot) == BotToBot)
      NewSize.h = NewPSize.h - NewSize.y - (OldPSize.h - (OldSize.y + OldSize.h));

   Target->Resize(NewSize);
   return false;
}
									/*}}}*/
