/*
TODO
Done	* Use linked list that can by dynamically added to for uri/file
	  pairs.
Done	* add resuming code
	* write uri-get, to call apt-get methods.
Done	* Add IO error handling
Done	* Redo ../ checking
		Note: The above cmds are generated, but until IO checking
		is complete, it doesn't quite work!
Done	* Use full path on local
Done	* If there is no need to get a file, print resume msg anyways.
	* Culus:  Don't forget to run strace on this!
Done	* Print md5sum if file is in ./, and no transfer took place.


*/
#define _BSD_SOURCE
#include <errno.h>
#include <fcntl.h>
#include <locale.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <utime.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <pkglib/md5.h>
#include "ftplib.h"
#include "ftp.h"
#include "file.h"

struct uri_pair *up_first = NULL, *up_last = NULL, *current = NULL;

/*

uri:(//(user(:pass)*@)*host(:port)*)*(/)*(path/)*file

ftp://[user[:pass]@]host[:port]/remote_file  local_file
file:file
file:path/file
file:/path/file

*/

#define DEFAULT_USER "anonymous"
#define DEFAULT_PASS "apt_get@debian.org"

#define malloc(value) malloc(value + 1)

#define str_null_0(st)	(st ? strlen(st) : 0)
#define strreplace(st, c1, c2)\
	{\
		char *s = st;\
		for(;*s;s++)\
			if(*s == c1)\
				*s = c2;\
	}

void apt_tag(int which, void *data){
	static char tags[] = "FSEIRMLII";
	char * st = (char *)data;
if(ftplib_debug)
	printf("apt_tag1 %i %i %i which=%i\n",APT_METHOD_RESUME,APT_METHOD_DOWNLOAD,APT_METHOD_SIZE,which);

	
	switch(which) {
		case APT_METHOD_RESUME:
			printf("%c Resuming (%i)\n", tags[APT_METHOD_INFO], (int)data);
			break;


		case APT_METHOD_DOWNLOAD:
			printf("%c Downloading\n", tags[APT_METHOD_INFO]);
			break;

		case APT_METHOD_SIZE:
			printf("%c %i\n", tags[which], (int)data);
			break;

		default:
			strreplace(st, '\n', ' ');
			printf("%c %s\n", tags[which], st);
			if(ftplib_debug)
				printf("apt_tag which=%i data='%s'\n",which,(char *)data);
			break;
	}
}


void abort_prog(void){
	if(current->local->info.fd) {
		close(current->local->info.fd);
		if(current->remote->info.mtime) {
			char *local;
			int l;
			if((local = (char *)malloc((l = str_null_0(current->local->file) + str_null_0(current->local->path) + 1) + 1)) == NULL) {
				apt_tag(APT_METHOD_ERROR, "abort_prog: malloc");
				exit(100);
			}
			local[0] = 0;
			if(current->local->path) {
				strcat(local, current->local->path);
			strcat(local, "/");
			}
			if(current->local->file)
				strcat(local, current->local->file);
			local[l] = 0;
			set_mtime_file(local, current->remote->info.mtime);
			free(local);
		}
	}
	exit(100);
}

void print_uri(struct uri_type *uri) {
	if(uri && (ftplib_debug > 1)) {
		printf("uri=%s\n", uri->uri);
		printf("user=%s\n", uri->user);
		printf("pass=%s\n", uri->pass);
		printf("host=%s\n", uri->host);
		printf("path=%s\n", uri->path);
		printf("file=%s\n", uri->file);
		printf("port=%i\n", uri->port);
	}
}

void uri_free(struct uri_type *uri) {
	if(uri) {
		if(uri->uri) free(uri->uri);
		if(uri->user) free(uri->user);
		if(uri->pass) free(uri->pass);
		if(uri->host) free(uri->host);
		if(uri->path) free(uri->path);
		if(uri->file) free(uri->file);
		if(uri->original) free(uri->original);
		free(uri);
	}
}

void file_io_error(const char *tag) {
	char *buf, *st_er = strerror(errno);
	int p = 0;

	if(tag)
		p += strlen(tag) + 1;
	if(st_er)
		p += strlen(st_er);

	if((buf = (char *)malloc(p + 1)) == NULL) {
		apt_tag(APT_METHOD_ERROR, "file_io_error: malloc");
		abort_prog();
	}
	buf[0] = 0;
	if(tag)
		sprintf(buf, "%s ", tag);
	if(st_er)
		strcat(buf, st_er);
	buf[p] = 0;
	apt_tag(APT_METHOD_ERROR, buf);
	free(buf);
}

struct uri_type *uri_split(const char *s) {

	char *s_tmp, *o_s_tmp;
	char *p1, *p2;
	struct uri_type *ret;

	int l;

	if(s == NULL)
		return NULL;

	if((s_tmp = o_s_tmp = (char *)malloc((l = strlen(s)) + 1)) == NULL) {
		apt_tag(APT_METHOD_ERROR, "uri_split: malloc(1)");
		abort_prog();
	}
	strcpy(s_tmp, s);
	s_tmp[l] = 0;

	if((ret = (uri_type *)malloc(sizeof(struct uri_type))) == NULL) {
		apt_tag(APT_METHOD_ERROR, "uri_split: malloc(2)");
		abort_prog();
	}

	/* If first ':' isn't followed by '//', then the URI is bad. */
	if((p1 = strchr(s_tmp, ':')) == NULL) {
		free(ret);
		apt_tag(APT_METHOD_ERROR, "uri_split: bad uri");
		return NULL;
	}
	if((ret->uri = (char *)malloc((l = p1 - s_tmp) + 1)) == NULL) {
		apt_tag(APT_METHOD_ERROR, "uri_split: malloc(3)");
		abort_prog();
	}

	strncpy(ret->uri, s_tmp, l);
	ret->uri[l] = 0;

	/* Step over ':' */
	s_tmp = p1 + 1;
	if(strncmp(s_tmp, "//", 2) == 0) {
		/* We have a host specified */

		s_tmp = s_tmp + 2;
		/* Search for auth. part */
		if((p1 = strchr(s_tmp, '@'))) {
			char *s;

			if((s = (char *)malloc((l = p1 - s_tmp) + 1)) == NULL) {
				apt_tag(APT_METHOD_ERROR, "uri_split: malloc(4)");
				abort_prog();
			}
			strncpy(s, s_tmp, l);
			s[l] = 0;
			/* Search for password */
			if((p2 = strchr(s, ':'))) {
				if((ret->pass = (char *)malloc(strlen(p2 + 1) + 1)) == NULL) {
					apt_tag(APT_METHOD_ERROR, "uri_split: malloc(5)");
					abort_prog();
				}
				strcpy(ret->pass, p2 + 1);
			} else
				ret->pass = NULL;
			p2[0] = 0;
			if((ret->user = (char *)malloc((l = strlen(s)) + 1)) == NULL) {
				apt_tag(APT_METHOD_ERROR, "uri_split: malloc(6)");
				abort_prog();
			}
			strncpy(ret->user, s, l);
//			ret->user[p2 + 1] = 0;
			free(s);
			s_tmp = p1 + 1;
		} else
			ret->user = ret->pass = NULL;
		if((p1 = strchr(s_tmp, '/'))) {
			if((ret->host = (char *)malloc((l = p1 - s_tmp) + 1)) == NULL) {
				apt_tag(APT_METHOD_ERROR, "uri_split: malloc(7)");
				abort_prog();
			}
			strncpy(ret->host, s_tmp, l);
			ret->host[l] = 0;
		} else {
			if((ret->host = (char *)malloc((l = strlen(s_tmp)) + 1)) == NULL) {
				apt_tag(APT_METHOD_ERROR, "uri_split: malloc(8)");
				abort_prog();
			}
			strncpy(ret->host, s_tmp, l);
			ret->host[l] = 0;
		}

		if((p2 = strchr(ret->host, ':'))) {
//			p2[0] = 0;
			p2++;
			ret->port = atoi(p2);
		} else
			ret->port = 0;
		s_tmp = ret->host + l;
		p1[-1] = 0;
		s_tmp = p1;
	}

	if((p2 = strrchr(s_tmp, '/'))) {;
		if((ret->path = (char *)malloc((l = p2 - s_tmp) + 1)) == NULL) {
			apt_tag(APT_METHOD_ERROR, "uri_split: malloc(9)");
			abort_prog();
		}
		strncpy(ret->path, s_tmp, l);
		ret->path[l] = 0;
		s_tmp = p2 + 1;
	} else
		ret->path = NULL;

	if((ret->file = (char *)malloc((l = strlen(s_tmp)) + 1)) == NULL) {
		apt_tag(APT_METHOD_ERROR, "uri_split: malloc(10)");
		abort_prog();
	}
	strncpy(ret->file, s_tmp, l);
	ret->file[l] = 0;
	s_tmp = ret->file + l;
//	s_tmp[0] = 0;
//	free(o_s_tmp);
	return ret;

}

int ftp_connect(const char *host, netbuf **nControl) {
	int ret;
	if(host) {
		char * buf;
		if((buf = (char *)malloc(strlen(host) + strlen(CONNECT_MSG) + 1)) == NULL) { 
			apt_tag(APT_METHOD_ERROR, "ftp_connect: malloc");
			abort_prog();
		}
		sprintf(buf, "%s%s", CONNECT_MSG, host);
		apt_tag(APT_METHOD_INFO, buf);
		if ((ret = FtpConnect(host, nControl)) == 0)
			apt_tag(APT_METHOD_ERROR, "ftp_connect: Could not connect");
	}
	return ret;
}

int ftp_login(const char *user, const char *pass, netbuf *nControl) {
	apt_tag(APT_METHOD_INFO, LOGIN_MSG);
	return FtpLogin(user, pass, nControl);
}

void ftp_quit(netbuf *nControl) {
	apt_tag(APT_METHOD_INFO, DISCONNECT_MSG);
	FtpQuit(nControl);
}

int ftp_chdir(const char *path, netbuf *nControl) {
	apt_tag(APT_METHOD_INFO, CD_MSG);
	return FtpChdir(path, nControl);
}

int ftp_get(const char *output, const char *path, netbuf *nControl) {
	return FtpGet(output, path, 0, nControl);
}

int ftp_size(const char *path, int *size, netbuf *nControl) {
	return FtpSize(path, size, nControl);
}

int ftp_type(const char mode, netbuf *nControl) {
	return FtpType(mode, nControl);
}

int parse_mdtm(const char *o_mdtm, time_t *t) {
/* YYYYMMDDHHMMSS */
	char buf[5];
	struct tm tt;
	char * m_mdtm = (char *)o_mdtm;

#define parse_mdtm_helper(mdtm, buf, var, n) \
	{\
		strncpy(buf, mdtm, n);\
		buf[n] = 0;\
		mdtm += n;\
		var = atoi(buf);\
	}

	if(m_mdtm == NULL)
		return -1;
	if(t == NULL)
		return -1;
	if(strlen(m_mdtm) < 14)
		return -1;
#define helper2 {\
	printf("%.14s",o_mdtm);\
	printf(" %i",tt.tm_year);\
	printf(" %i",tt.tm_mon);\
	printf(" %i",tt.tm_mday);\
	printf(" %i",tt.tm_hour);\
	printf(" %i",tt.tm_min);\
	printf(" %i",tt.tm_sec);\
	printf(" %i",tt.tm_wday);\
	printf(" %i",tt.tm_yday);\
	printf(" %i",tt.tm_isdst);\
	printf(" %i\n",*t);}
//	helper2;
	memset(&tt, 0, sizeof(tt));
//	helper2;
	parse_mdtm_helper(m_mdtm, buf, tt.tm_year, 4);
	parse_mdtm_helper(m_mdtm, buf, tt.tm_mon, 2);
	parse_mdtm_helper(m_mdtm, buf, tt.tm_mday, 2);
	parse_mdtm_helper(m_mdtm, buf, tt.tm_hour, 2);
	parse_mdtm_helper(m_mdtm, buf, tt.tm_min, 2);
	parse_mdtm_helper(m_mdtm, buf, tt.tm_sec, 2);
	tt.tm_year -= 1900;
	tt.tm_mon--;
	*t = timegm(&tt);
//	helper2;
	return 0;
}

int ftp_mtime(const char *path, netbuf *nControl, time_t *t) {
	int ret;
	char buf[15];
	if((ret = FtpModDate(path, buf, sizeof(buf), nControl)) == 0) {
		ret = -1;
		apt_tag(APT_METHOD_LOG, "MDTM not supported!");
	} else
		ret = parse_mdtm(buf, t);
	return ret;
}


int method_get(const char *output, const char *path, char mode, netbuf *nControl) {
	int ret;
//, r_size = 0, l_size;
	netbuf *nData;
	char data_buf[10*1024];
	MD5Summation md5buf;
	int need_full = 0, yes_mdtm = 1, get_file = 1;
	if(output == NULL)
		return 1;

if(ftplib_debug) printf("output='%s' remote='%s'\n",output,path);

	if(!ftp_type(mode, nControl))
		return 1;

if(ftplib_debug) printf("output='%s' remote='%s'\n",output,path);
	if(!ftp_size(path, (int *) &current->remote->info.size, nControl)) {
		apt_tag(APT_METHOD_ERROR, FtpLastResponse(nControl));
		return 1;
	}
if(ftplib_debug) printf("output='%s' remote='%s'\n",output,path);

	if((signed)(current->local->info.size = lof_file(output)) == -1)
		current->local->info.size = 0;

	if((ret = ftp_mtime(path, nControl, (time_t *) &current->remote->info.mtime))) {
if(ftplib_debug) printf("past ftp_mtime\n");
		/* Remote doesn't support mdtm, so get full */
		need_full = 1;
		yes_mdtm = 0;
	} else {
if(ftplib_debug) printf("past ftp_mtime\n");
		if(get_mtime_file(output, (time_t *) &current->local->info.mtime)) {
			/* No file in ./, check ../ */
			char *buf;
			int l;
			l = strlen(output);
if(ftplib_debug) printf("past get_mtime_file %i %s %p\n", l, output, output);

			if((buf = (char *)malloc(l + 5)) == NULL) {
if(ftplib_debug) printf("0.1 ");
				apt_tag(APT_METHOD_ERROR, "method_get: malloc(1)");
				abort_prog();
			}
			strcpy(buf, "../");
			strcat(buf, output);
if(ftplib_debug) printf("buf=%s\n",buf);
			if(get_mtime_file(buf, (time_t *) &current->local->info.mtime))
				/* No file in ../ */
				need_full = 1;
			else {
				/* Remote file is newer than ../ */
				if(current->remote->info.mtime == current->local->info.mtime)
					get_file = 0;
			}
		} else {
			/* File exists in ./ */
			if(current->remote->info.mtime == current->local->info.mtime) {
				/* Remote is same as ./ */
				if(current->remote->info.size < current->local->info.size)
					/* Remote is smaller, it must have shrank! */
					need_full = 1;
				else
					if(current->remote->info.size == current->local->info.size)
						get_file = 0;
			} else {
				get_file = 1;
				need_full = 1;
			}
		}
	}
if(ftplib_debug) printf("get=%i full=%i l_size=%Zi l_mtime=%i r_size=%Zi r_mtime=%i\n",
		get_file,
		need_full,
		current->local->info.size,
		current->local->info.mtime,
		current->remote->info.size,
		current->remote->info.mtime);
				
	
	if(get_file) {
		if((current->local->info.fd = open(output, O_CREAT | O_RDWR, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)) == -1) {
			file_io_error("method_get: local: open(1)");
			return 0;
		}
		if((need_full == 0) && FtpRest(current->local->info.size, nControl)) {
			/* Restarting an aborted transfer, init MD5 buffer with old file data */
			if(current->local->info.size > 0) {
				apt_tag(APT_METHOD_RESUME, (void *)current->local->info.size);
				if (md5buf.AddFD(current->local->info.fd,current->local->info.size) == false) {
					file_io_error("method_get: md5buf.AddFD(1)");
					return 0;
				}
			} else {
				apt_tag(APT_METHOD_DOWNLOAD, NULL);
				ftruncate(current->local->info.fd, 0);
			}
		} else {
			apt_tag(APT_METHOD_DOWNLOAD, NULL);
			ftruncate(current->local->info.fd, 0);
		}

		apt_tag(APT_METHOD_SIZE, (void *)current->remote->info.size);
		if((ret = FtpAccess(path, FTPLIB_FILE_READ, nControl, &nData))) {

			while((ret = FtpRead(data_buf, sizeof(data_buf), nData)) > 0) {
			        md5buf.Add((unsigned char *)data_buf,ret);
				if((ret = write(current->local->info.fd, data_buf, ret))== -1) {
					file_io_error("method_get: local: write");
					return 0;
				}
			}
			FtpClose(nData);
			ret = 1;
		} else {
			apt_tag(APT_METHOD_ERROR, FtpLastResponse(nControl));

		}
		close(current->local->info.fd);
		if(current->remote->info.mtime)
			set_mtime_file(output, current->remote->info.mtime);
		if(ret)
			apt_tag(APT_METHOD_MD5SUM, (void *)md5buf.Result().Value().c_str());

	} else {
		/* Treated like a resume */
		apt_tag(APT_METHOD_RESUME, (void *)current->remote->info.size);
		apt_tag(APT_METHOD_SIZE, (void *)current->remote->info.size);
		if(current->local->info.size) {
			if((current->local->info.fd = open(output, O_CREAT | O_RDWR, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)) == -1) {
				file_io_error("method_get: local: open(2)");
				return 0;
			}
			if (md5buf.AddFD(current->local->info.fd,current->local->info.size) == false) {
				file_io_error("method_get: md5buf.AddFD(2)");
				return 0;
			}
		        apt_tag(APT_METHOD_MD5SUM, (void *)md5buf.Result().Value().c_str());
			close(current->local->info.fd);
		}
	}
	return ret;
}

int add_uri_pair(char *s1, char *s2) {
	struct uri_pair *up_new;
	if((up_new = (struct uri_pair *)malloc(sizeof(struct uri_pair))) == NULL) {
		apt_tag(APT_METHOD_ERROR, "add_uri_pair: malloc");
		abort_prog();
	}
	up_new->next = NULL;

	if((up_new->remote = uri_split(s1)) == NULL) {
		free(up_new);
		return 1;
	}
	if((up_new->local = uri_split(s2)) == NULL) {
		uri_free(up_new->remote);
		free(up_new);
		return 1;
	}
	print_uri(up_new->remote);
	print_uri(up_new->local);
	up_new->remote->original = s1;
	up_new->local->original = s2;
	if(up_last == NULL)
		up_first = up_last = up_new;
	else {
		up_last->next = up_new;
		up_last = up_new;
	}
	return 0;
}	
void process_uri_pair(struct uri_pair *up, netbuf **nControl) {
	int l;
	char *tmp_host;
	int res = 1;
	static struct uri_type *old_uri;

	if(up == NULL)
		return;


	if((up->remote->port == 0))
		up->remote->port = 21;
	if(up->remote->user == NULL) {
		if((up->remote->user = (char *)malloc(strlen(DEFAULT_USER) + 1)) == NULL) {
			apt_tag(APT_METHOD_ERROR, "process_uri_pair: malloc(1)");
			abort_prog();
		}
		strcpy(up->remote->user, DEFAULT_USER);
		if((up->remote->pass = (char *)malloc(strlen(DEFAULT_PASS) + 1)) == NULL) {
			apt_tag(APT_METHOD_ERROR, "process_uri_pair: malloc(2)");
			abort_prog();
		}
		strcpy(up->remote->pass, DEFAULT_PASS);
	}
	if((tmp_host = (char *)malloc((l = strlen(up->remote->host) + 5) + 1)) == NULL) {
		apt_tag(APT_METHOD_ERROR, "process_uri_pair: malloc(3)");
		abort_prog();
	} else {
		if(up->remote->port == 21)
			snprintf(tmp_host, l, "%s", up->remote->host);
		else
			snprintf(tmp_host, l, "%s:%s", up->remote->host, up->remote->port);
		tmp_host[l] = 0;
	}
	if((old_uri) && (*nControl) && (
			(strcmp(old_uri->host, up->remote->host) != 0) || (old_uri->port != up->remote->port) ||
			(strcmp(old_uri->user, up->remote->user) != 0) || (strcmp(old_uri->pass, up->remote->pass) != 0))) {
		ftp_quit(*nControl);
		*nControl = NULL;
	}

	apt_tag(APT_METHOD_CHG_URI, up->remote->original);

	if(ftplib_debug)
		printf("before connect res=%i\n", res);
	if(*nControl == NULL) {
		if(ftplib_debug) {
			printf("not connected ");
			if(old_uri) {
				printf("old_uri\n");
				print_uri(old_uri);
			}
			printf("remote\n");
			print_uri(up->remote);
		}
		if(ftplib_debug)
			printf("attempting to connect\n");
		if((res = ftp_connect(tmp_host, nControl))) {
			if(up->remote->user && up->remote->pass) {
				if(!(res = ftp_login(up->remote->user, up->remote->pass, *nControl))) {
					apt_tag(APT_METHOD_ERROR, "process_uri_pair: couldn't log in");
				}
			} else {
				apt_tag(APT_METHOD_ERROR, "need a password");
			}
		} else {
			apt_tag(APT_METHOD_ERROR, "couldn't connect");
		}
	} else
		if(ftplib_debug)
			printf("connected\n");

	if(ftplib_debug)
		printf("before transfer res=%i\n",res);

	if(ftplib_debug)
		printf("*nControl=%p old_uri%p\n",*nControl,old_uri);

	if(res)
		if(*nControl) {
			int res = 0;
			char *local, *remote;
			if((remote = (char *)malloc((res = str_null_0(up->remote->path) + str_null_0(up->remote->file) + 2))) == NULL) {
				apt_tag(APT_METHOD_ERROR, "process_uri_pair: malloc(4)");
				abort_prog();
			}
			snprintf(remote, res, "%s/%s", up->remote->path, up->remote->file);
			remote[res] = 0;
			if((local = (char *)malloc((res = str_null_0(up->local->file) + str_null_0(up->local->path) + 2))) == NULL) {
				apt_tag(APT_METHOD_ERROR, "process_uri_pair: malloc(5)");
				abort_prog();
			}
			local[0] = 0;
			if(up->local->path) {
				strcat(local, up->local->path);
				strcat(local, "/");
			}
			if(up->local->file)
				strcat(local, up->local->file);
			local[res] = 0;
			method_get(local, remote, FTPLIB_IMAGE, *nControl);
		}

	old_uri = up->remote;
}

void process_all_ups(netbuf **nControl) {
	struct uri_pair *next;
	while(up_first) {
		current = up_first;
		process_uri_pair(up_first, nControl);
//		uri_free(current->local);
//		uri_free(current->remote);
		current = NULL;
		next = up_first->next;
//		free(up_first);
		if(next)
			up_first = next;
		else
			up_first = NULL;
	}
	up_last = up_first;		
}

void handler(int signum) {
	switch(signum) {
		case SIGSEGV:
			apt_tag(APT_METHOD_ERROR, "Caught segfault");
		case SIGTERM:
		case SIGQUIT:
		case SIGINT:
		case SIGABRT:
		case SIGHUP:
			abort_prog();
		default:
			{
				char buf[] = "Unkown signal iiiiiiiiii ";
				sprintf(buf, "Unkown signal %i", signum);
				apt_tag(APT_METHOD_ERROR, buf);
				abort_prog();
			}
	}
}


int main(int argc, char **argv){
	int c = 1;
	char *env_APT_FTP_VERBOSE;
	netbuf *nControl = NULL;

	setlocale(LC_ALL, "");
	if((env_APT_FTP_VERBOSE = getenv("APT_FTP_VERBOSE")))
		ftplib_debug = atoi(env_APT_FTP_VERBOSE);
	FtpInit();
	setvbuf(stdout, NULL, _IONBF, 0); 
//	for(c = 0; c < (2 << sizeof(unsigned int)); c++)
//		signal(c, handler);

if(ftplib_debug) signal(SIGSEGV, handler);

	signal(SIGTERM, handler);
	signal(SIGQUIT, handler);
	signal(SIGINT, handler);
	signal(SIGABRT, handler);
	signal(SIGHUP, handler);
	signal(SIGPIPE, handler);

	if(ftplib_debug)
		for(c = 1; c < argc; c ++)
			printf("argv[%i]='%s'\n", c, argv[c]);

	for(c = 1; c < argc; c += 2) {
		char *tmp_uri1, *tmp_uri2;
		int l;
		if((tmp_uri1 = (char *)malloc((l = strlen(argv[c])) + 1)) == NULL) {
			apt_tag(APT_METHOD_ERROR, "main: malloc(1)");
			abort_prog();
		}
		strncpy(tmp_uri1, argv[c], l);
		tmp_uri1[l] = 0;
		strreplace(tmp_uri1, '\n', ' ');
		if((tmp_uri2 = (char *)malloc((l = strlen(argv[c + 1])) + 5 + 1)) == NULL) {
			apt_tag(APT_METHOD_ERROR, "main: malloc(2)");
			abort_prog();
		}
		strcpy(tmp_uri2, "file:");
		strncat(tmp_uri2, argv[c + 1], l);
		tmp_uri2[l + 5] = 0;
		strreplace(tmp_uri2, '\n', ' ');
		if(add_uri_pair(tmp_uri1, tmp_uri2));
//			printf("F %s\n",argv[c]);
	}
	process_all_ups(&nControl);
	if(nControl)
		ftp_quit(nControl);
	return 0;
}


