;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Coerce/pproto.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 10:45:07 1995                          */
;*    Last change :  Mon Jul  8 16:53:08 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We print prototype                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_pproto
   (import  tools_speek
	    tools_shape
	    type_type
	    type_pptype
	    ast_var)
   (export  (pfunction-proto ::long ::variable)
	    (pvariable-proto ::long ::variable)
	    (reset-ppmarge!)
	    (inc-ppmarge!)
	    (dec-ppmarge!)))

;*---------------------------------------------------------------------*/
;*    reset-ppmarge! ...                                               */
;*---------------------------------------------------------------------*/
(define (reset-ppmarge!)
   (set! *pp-marge* 8))

;*---------------------------------------------------------------------*/
;*    inc-ppmarge! ...                                                 */
;*---------------------------------------------------------------------*/
(define (inc-ppmarge!)
   (set! *pp-marge* (+fx 1 *pp-marge*)))

;*---------------------------------------------------------------------*/
;*    dec-ppmarge! ...                                                 */
;*---------------------------------------------------------------------*/
(define (dec-ppmarge!)
   (set! *pp-marge* (-fx *pp-marge* 1)))

;*---------------------------------------------------------------------*/
;*    *pp-marge* ...                                                   */
;*---------------------------------------------------------------------*/
(define *pp-marge*       8)
(define old-marge        -1)
(define old-marge-string "")

;*---------------------------------------------------------------------*/
;*    pfunction-proto ...                                              */
;*---------------------------------------------------------------------*/
(define (pfunction-proto level variable)
   (let ((marge (if (=fx old-marge *pp-marge*)
		    old-marge-string
		    (let ((marge (make-string *pp-marge* #\space)))
		       (set! old-marge *pp-marge*)
		       (set! old-marge-string marge)
		       marge))))
      (verbose level
	       marge
	       (shape variable) " : "
	       (function-type->string variable)
	       #\Newline)))

;*---------------------------------------------------------------------*/
;*    pvariable-proto ...                                              */
;*---------------------------------------------------------------------*/
(define (pvariable-proto level variable)
   (let ((marge (make-string *pp-marge* #\space)))
      (verbose level
	       marge
	       (shape variable) " : "
	       (variable-type->string variable)
	       #\Newline)))
