;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Heap/restore.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 10:53:23 1994                          */
;*    Last change :  Tue Jun 11 11:58:37 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We restore an heap                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module heap_restore
   (include "Engine/pass.sch")
   (export  (restore-heap))
   (import  engine_param
	    engine_engine
	    init_main
	    tools_file
	    tools_error
	    ast_env
	    type_type
	    type_env
	    ast_var))

;*---------------------------------------------------------------------*/
;*    restore-heap ...                                                 */
;*---------------------------------------------------------------------*/
(define (restore-heap)
   (if (string? *heap-name*)
       (begin
	  (pass-prelude "Heap")
	  (let ((fname (find-file/path *heap-name* (list *lib-dir*))))
	     (if (string? fname)
 		 (let* ((port    (open-input-binary-file fname))
			(handler (lambda (escape proc mes obj)
				    (notify-error proc mes obj)
				    (close-binary-port port)
				    (exit-bigloo -5))))
		    (if (not (binary-port? port))
			(begin
			   (error "restore-heap" "Cannot open heap file" fname)
			   (exit-bigloo -5))
			(try (let* ((Envs (input-obj port))
				    (Genv (car Envs))
				    (Tenv (cdr Envs)))
				(close-binary-port port)
				(set-Genv! Genv)
				(set-Tenv! Tenv)
				(if (not *call/cc?*)
				    (unbind-call/cc!))
				#t)
			     handler)))
		 (begin
		    (error "restore-heap" "Cannot find heap file" *heap-name*)
		    (exit-bigloo -5)))))
       #f))

;*---------------------------------------------------------------------*/
;*    unbind-call/cc! ...                                              */
;*---------------------------------------------------------------------*/
(define (unbind-call/cc!)
   (if (find-global 'call/cc '__r4_control_features_6_9)
       (unbind-global! 'call/cc '__r4_control_features_6_9))
   (if (find-global 'call-with-current-continuation
		    '__r4_control_features_6_9)
       (unbind-global! 'call-with-current-continuation
		       '__r4_control_features_6_9)))
   
