;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/generic.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed May  1 12:05:09 1996                          */
;*    Last change :  Fri Feb  6 13:54:50 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The generic management                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_generic
   (import engine_param
	   tools_args
	   tools_error
	   type_type
	   type_cache
	   ast_var
	   ast_ident
	   object_class
	   object_inline
	   module_module)
   (export (make-generic-body ::symbol ::obj ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    make-generic-body ...                                            */
;*---------------------------------------------------------------------*/
(define (make-generic-body id locals args src)
   (if (method-inlining-enabled?)
       (make-generic-inlined-body id locals args src)
       (make-generic-non-inlined-body id locals args src)))
   
;*---------------------------------------------------------------------*/
;*    make-generic-non-inlined-body ...                                */
;*---------------------------------------------------------------------*/
(define (make-generic-non-inlined-body id locals args src)
   (if (null? args)
       (user-error id
		   "Illegal generic definition (no formal arguments provided)"
		   src
		   '())
       (let* ((pid             (parse-id id))
	      (id              (car pid))
	      (arity           (arity args))
	      (args-id         (map local-id locals))
	      (default-body    (if (>=fx arity 0)
				   `((generic-default
				      (@ ,id ,*module*))
				     ,@args-id)
				   `(apply (generic-default
 					    (@ ,id ,*module*))
					   ((@ cons*
					       __r4_pairs_and_lists_6_3)
					    ,@args-id))))
	      (method-arg      (car locals))
	      (method-arg-id   (local-id method-arg))
	      (method-arg-type (local-type method-arg))
	      (method          (gensym 'method))
	      (default-name    (symbol-append id '-default))
	      (method-name     (gensym 'method))
	      (app-ly-method   `(let ((,method (find-method ,method-arg-id
							    (@ ,id
							       ,*module*))))
				   (if (procedure? ,method)
				       ,(if (>=fx arity 0)
					    `(,method ,@args-id)
					    `(apply ,method (cons* ,@args-id)))
				       (,default-name)))))
	  ;; we emit an error when the dispatching arg type is not a class
	  (if (and (type? method-arg-type)
		   (not (eq? method-arg-type *obj*))
		   (not (eq? method-arg-type (get-default-type)))
		   (not (class? method-arg-type)))
	      (user-error
	       id
	       "generic function has a non-class dispatching type arg"
	       src
	       ''generic-definition-error)
	      ;; we now create the body of the generic
	      `(let ((,default-name (lambda () ,default-body)))
		  ,(if (class? method-arg-type)
		       app-ly-method
		       `(if (object? ,method-arg-id)
			    ,app-ly-method
			    (,default-name))))))))

;*---------------------------------------------------------------------*/
;*    make-generic-inlined-body ...                                    */
;*---------------------------------------------------------------------*/
(define (make-generic-inlined-body id locals args src)
   (let* ((pid     (parse-id id))
	  (id      (car pid))
	  (arity   (arity args))
	  (args-id (map local-id locals))
	  (body    (if (>=fx arity 0)
		       `((generic-default (@ ,id ,*module*)) ,@args-id)
		       `(apply (generic-default	(@ ,id ,*module*))
			       (cons* ,@args-id)))))
      body))
   
