;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/main.scm                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Nov  2 17:24:13 1992                          */
;*    Last change :  Thu Mar 12 07:22:13 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The recette entry point                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module main
   
   (main   recette)

   (import (vital         "vital.scm")
	   (hash          "hash.scm")
	   (bool          "bool.scm")
	   (list          "list.scm")
	   (vector        "vector.scm")
	   (struct        "struct.scm")
	   (print         "print.scm")
	   (char          "char.scm")
	   (string        "string.scm")
	   (kwote         "kwote.scm")
	   (case          "case.scm")
	   (bind-exit     "bexit.scm")
	   (vararity      "vararity.scm")
	   (apply         "apply.scm")
	   (globalisation "globalis.scm")
	   (glo_cell      "cell.scm")
	   (kapture       "kapture.scm")
	   (filtre        "filtre.scm")
	   (match         "match.scm")
	   (rgc-trap      "rgc-trap.scm")
	   (rgc-jm        "rgc-jm.scm")
	   (rgc-eval      "rgc-eval.scm")
	   (rgc           "rgc.scm")
	   (input-port    "port.scm")
	   (read          "read.scm")
	   (callcc        "callcc.scm")
	   (fringe        "fringe.scm")
	   (tail          "tail.scm")
	   (rforeign      "foreign.scm")
	   (big-file      "big-file.scm")
	   (sqic          "sqic.scm")
	   (reval         "eval.scm")
	   (inline        "inline.scm")
	   (letrec        "letrec.scm")
	   (macro         "macro.scm")
	   (flonum        "flonum.scm")
	   (number        "number.scm")
	   (define        "define.scm")
	   (cse           "cse.scm")
	   (error         "error.scm")
	   (include       "include.scm")
	   (0cfa          "0cfa.scm")
	   (alias         "alias.scm")
	   (alias-aux     "alias-aux.scm")
	   (module        "module.scm")
	   (import1       "import1.scm")
	   (import2       "import2.scm")
	   (object        "object.scm")
	   (hygien        "hygien.scm")
	   (wind          "wind.scm")
	   )
   
   (export (do-test name thunk good?)
	   (test-module name file stop)
	   *recette-port*))
   
;*---------------------------------------------------------------------*/
;*    Des variables statiques                                          */
;*---------------------------------------------------------------------*/
(define *test-number*   0)
(define *nb-test*       0)
(define *nb-err*        0)
(define *module-name*   "")
(define *verbose*       #f)
(define *silent*        #t)
(define *recette-port*  #f)
(define *stop-on-error* #f)
(define *tick-number*   -1)

;*---------------------------------------------------------------------*/
;*    tick ...                                                         */
;*---------------------------------------------------------------------*/
(define (tick)
   (set! *tick-number* (+fx 1 *tick-number*))
   (if (=fx *tick-number* 4)
       (set! *tick-number* 0))
   (write-char (integer->char 8))
   (case *tick-number*
      ((0) (write-char #\|))
      ((1) (write-char #\/))
      ((2) (write-char #\-))
      ((3) (write-char #\\))))

;*---------------------------------------------------------------------*/
;*    recette-port ...                                                 */
;*---------------------------------------------------------------------*/
(define recette-port
   (let ((port (open-output-file "recette.log")))
      (if (not (output-port? port))
	  (error "recette-port" "Can't open output-file" "recette.log")
	  (lambda ()
	     port))))

;*---------------------------------------------------------------------*/
;*    do-test ...                                                      */
;*---------------------------------------------------------------------*/
(define (do-test name thunk wanted)
   (set! *test-number* (+ 1 *test-number*))
   (set! *nb-test* (+ 1 *nb-test*))
   (define (correct? result wanted)
      (or (equal? result wanted)
	  (and (flonum? result)
	       (flonum? wanted)
	       (<fl (absfl (-fl result wanted)) 0.00001))))
   (let ((result (thunk)))
      (if (correct? result wanted)
	  (begin
	     (if (not *silent*)
		 (begin
		    (display* *test-number* #\. *module-name* " : "
			      name " --> ")
		    (display "ok.")))
	     (if *verbose*
		 (print " [" result "]")
		 (if (not *silent*)
		     (newline))))
	  (begin
	     (set! *nb-err* (+ 1 *nb-err*))
	     (display* *test-number* #\. *module-name* " : " name )
	     (if *stop-on-error*
		 (error name
			  (list "provided: " result)
			  (list "wanted: " wanted))
		 (begin
		    (notify-error name (list "provided: " result)
				  (list "wanted: " wanted))
		    (if (not *silent*)
			(print "not ok."))))))))

;*---------------------------------------------------------------------*/
;*    test-module ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-module module-name file-name stop?)
   (set! *module-name* module-name)
   (set! *test-number* 0)
   (set! *stop-on-error* stop?)
   (if (not *silent*)
       (newline))
   (print file-name ":"))


;*---------------------------------------------------------------------*/
;*    recette ...                                                      */
;*---------------------------------------------------------------------*/
(define (recette argv)
   (let loop ((argv (cdr argv)))
      (if (null? argv)
	  'done
	  (cond
	     ((string=? (car argv) "-help")
	      (print "usage: recette [-v] [-V]")
	      (exit 0))
	     ((string=? (car argv) "-v")
	      (set! *silent* #f)
	      (set! *verbose* #f)
	      (loop (cdr argv)))
	     ((string=? (car argv) "-V")
	      (set! *silent* #f)
	      (set! *verbose* #t)
	      (loop (cdr argv)))
	     (else
	      (loop (list "-help"))))))
   (set! *recette-port* (open-output-file "recette.log"))
   (if (not (output-port? *recette-port*))
       (error "recette-port" "Can't open output-file" "recette.log"))
   (try (begin
	   (test-vital)
	   (test-cell)
	   (test-modulel)
	   (test-hash)
	   (test-bool)
	   (test-number)
	   (test-flonum)
	   (test-list)
	   (test-vector)
	   (test-struct)
	   (test-print)
	   (test-char)
	   (test-string)
	   (test-kwote)
	   (test-case)
	   (test-bind-exit)
	   (test-vararity)
	   (test-apply)
	   (test-globalisation)
	   (test-kapture)
	   (test-filtre)
	   (test-match)
	   (test-rgc-trap)
	   (test-rgc-jm)
	   (test-rgc-eval)
	   (test-input-port)
	   (test-read)
	   (test-callcc)
	   (test-fringe)
	   (test-wind)
	   (test-tail)
	   (test-foreign)
	   (test-sqic)
	   (test-eval)
	   (test-inline)
	   (test-letrec)
	   (test-macro)
	   (test-define)
	   (test-cse)
	   (test-error)
	   (test-include)
	   (test-0cfa)
	   (test-alias)
	   (test-object)
	   (test-hygien)
	   )
	(lambda (escape proc mes obj)
	   (notify-error proc mes obj)
	   (set! *nb-err* (+ 1 *nb-err*))
	   (exit -1)))
   (close-output-port *recette-port*)
   (print #\Newline "------------------------------")
   (if (> *nb-err* 0)
       (begin
	  (notify-error "recette" *nb-err* "error(s) occur")
	  -1)
       (begin
	  (print "recette done, the " *nb-test* " tests are clear")
	  0)))
 
 
