;; ---------------------------------------------------------------------- ;;
;! @file     preds.scm                                                    !;
;! @created  Fri Jun 20 13:50:10 1997                                     !;
;! @modified Thu Mar  5 15:17:17 1998                                     !;
;; ---------------------------------------------------------------------- ;;
;! @copyright Dominique Boucher                                           !;
;; ---------------------------------------------------------------------- ;;
;; Predicates                                                             ;;
;; ---------------------------------------------------------------------- ;;

(module predicates
	(export
	 
	 (is-program-header? sym)
	 (function-form? expr)
	 (macro-form? expr)
	 (structure-form? expr)
	 (defvar-form? expr)
	 
	 function-comment?
	 param-comment?
	 field-comment?
	 return-comment?
	 descr-comment?
	 ignore-comment?))

;; ---------------------------------------------------------------------- ;;
;; Some predicates                                                        ;;
;; ---------------------------------------------------------------------- ;;

(define (is-program-header? sym)
  (memq sym '(file created modified copyright version include text doc)))
  
(define (function-form? expr)
  (and (list? expr)
       (>= (length expr) 3)
       (memq (car expr) '(define c-define))
       (pair? (cadr expr))))

(define (macro-form? expr)
  (and (list? expr)
       (>= (length expr) 3)
       (memq (car expr) '(define-macro))
       (pair? (cadr expr))))

(define (structure-form? expr)
  (and (list? expr)
       (>= (length expr) 2)
       (memq (car expr) '(define-structure))))

(define (defvar-form? expr)
  (and (list? expr)
       (= (length expr) 3)
       (memq (car expr) '(define))
       (symbol? (cadr expr))))

(define-inline (generic-test type)
  (lambda (doc) (eq? (car doc) type)))

(define function-comment? (generic-test 'function))
(define param-comment?    (generic-test 'param))
(define field-comment?    (generic-test 'field))
(define return-comment?   (generic-test 'return))
(define descr-comment?    (generic-test 'description))
(define ignore-comment?   (generic-test 'ignore))
