package biss;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.Date;

/**
 * lib class providing general static functions for File objects
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class FileLib
{

public static boolean backup ( File f ) {
	String fn = f.getAbsolutePath() + '~';
	File fOld = new File( fn);

	if ( f.exists() ) {
		if ( fOld.exists() )
			fOld.delete();
		return f.renameTo( fOld);
	}
	return false;
}

public static int copyFileData ( File file, byte[] buffer ) {
	int len = (int)file.length();
	if ( len > buffer.length ) return -1;

	try {
		FileInputStream in = new FileInputStream( file);
		in.read( buffer, 0, len);
		in.close();
		return len;
	}
	catch ( Throwable x ) {
		return -1;
	}
}

public static boolean exists ( String pathName ) {
	File f = new File( pathName);
	return f.exists();
}

public static String fileInfoString ( File f, boolean fixed ) {
	Date dtg = new Date( f.lastModified());

	byte [] fill = { ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ' };
	int    n, len = (int)f.length();
	String size = Integer.toString( len);

	ByteArrayOutputStream o = new ByteArrayOutputStream( 24);
	PrintStream      s  = new PrintStream( o, false);

	if ( fixed )
		s.write( fill, 0, 6 - size.length());
	s.print( size);
	s.print( "  ");

	n = dtg.getMonth() + 1;
	if ( n < 10 ) s.print( '0');
	s.print( n);
	s.print( '/');

	n = dtg.getDay() + 1;
	if ( n < 10 ) s.print( '0');
	s.print( n);
	s.print( '/');

	n = dtg.getYear();
	if ( n < 10 ) s.print( '0');
	s.print( n);
	s.print( " ");

	n = dtg.getHours();
	if ( n < 10 ) s.print( '0');
	s.print( n);
	s.print( ':');

	n = dtg.getMinutes();
	if ( n < 10 ) s.print( '0');
	s.print( n);
	s.close();

	return o.toString();
}

public static byte[] getFileData ( File file ) {
	int len = (int)file.length();

	try {
		FileInputStream in = new FileInputStream( file);
		byte buf[] = new byte[len];
		in.read( buf, 0, len);
		in.close();
		return buf;
	}
	catch ( Throwable x ){
		return null;
	}
}

public static String getFileDataAsString ( File file ) {
	byte[] buf = getFileData( file);
	if ( buf != null )
		return new String( buf, 0);
	else
		return null;
}
}
