package biss.awt;

import biss.ObserverSocket;
import java.util.Observable;
import java.util.Vector;

/**
 * generic dialog to choose from a list of objects
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class ListPrompter
  extends DialogWindow
{
	Button CancelBtn = new Button( "~Cancel");
	Button EnterBtn = new Button( "~Enter");
	List ItemPane = new List();
	Object Selection;

public ListPrompter ( String label, TopWindow owner) {
	super( label, owner);

	Lo.add( ItemPane, 0, 0, 1000, 1000, true, 20, 20, -20, -250, 0);
	Lo.add( EnterBtn, 100, 1000, 450, 1000, true, 0, -230, 0, -20, 0);
	Lo.add( CancelBtn,550, 1000, 950, 1000, true, 0, -230, 0, -20, 0); 

	EnterBtn.OsAction.addObserver( this);
	CancelBtn.OsAction.addObserver( this);
	ItemPane.OsSelection.addObserver( this);

	packClient( 300, 300);
	openCentered();
}

public ListPrompter ( String label, Vector list, TopWindow owner) {
	this( label, owner);
	ItemPane.setContents( list);
}

public Vector getContents () {
	return ItemPane.getContents();
}

public List getList () {
	return ItemPane;
}

public Object getSelection () {
	return Selection;
}

public static void main (String[] args) {
	new ListPrompter( "ListPrompter", null);
}

public void setContents ( Vector list) {
	ItemPane.setContents( list);
}

public void setLineHeight ( int height) {
	ItemPane.setLineHeight( height);
}

public void update ( Observable o, Object arg) {
	if ( o == EnterBtn.OsAction ) {
		Selection = ItemPane.getSelection();
		process();
	}
	else if ( o == CancelBtn.OsAction ) {
		Selection = null;
		dispose();
	}
	else if ( o == ItemPane.OsSelection ) {
		Selection = ItemPane.getSelection();
		process();
	}

	super.update( o, arg);
}
}
