/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
# ifndef GLOBALS_H
# define GLOBALS_H

extern /*@owned@*/ fileloc g_currentloc;

/* stream for error messages */
extern FILE *g_msgstream;

/*@-ansireserved@*/
/* This macro is defined by flex. */
/*@constant external int ECHO@*/
/*@=ansireserved@*/

/*@-redecl@*/
/*@-incondefs@*/ 
/*@-namechecks@*/
extern /*@dependent@*/ FILE *yyin;
extern /*@dependent@*/ FILE *yyout;
extern int yyleng;
/*@=incondefs@*/ 

# ifdef WIN32
extern int yywrap (void) /*@*/ ;
# endif

extern int yydebug;
/*@=redecl@*/
/*@=namechecks@*/

extern /*@observer@*/ cstring g_codeFile;
extern int g_codeLine;

extern /*@observer@*/ cstring g_prevCodeFile;
extern int g_prevCodeLine;

extern /*@observer@*/ char *g_localSpecPath;

# ifndef NOLCL
extern /*@only@*/ cstring g_currentSpec;
extern /*@null@*/ /*@only@*/ char *g_currentSpecName;
# endif

extern void setCodePoint (void);
# define setCodePoint() \
  (g_prevCodeFile = g_codeFile, g_prevCodeLine = g_codeLine, \
   g_codeFile = cstring_makeLiteralTemp (__FILE__), g_codeLine = __LINE__)

extern void printCodePoint (void);

extern fileId currentFile (void) /*@globals g_currentloc; @*/ ;
# define currentFile()               (fileloc_fileId (g_currentloc))

extern int currentColumn (void) /*@globals g_currentloc; @*/ ;
# define currentColumn()             (fileloc_column(g_currentloc))

extern void incColumn (void) 
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc@*/ ;
# define incColumn()                  (fileloc_incColumn(g_currentloc)) 

extern void decColumn (void)
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc@*/ ;
# define decColumn()                  (fileloc_addColumn(g_currentloc, -1))

extern void incLine (void)
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc; @*/ ;
# define incLine()                    (fileloc_nextLine(g_currentloc))

extern void decLine (void)
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc; @*/ ;
# define decLine()                    (fileloc_addLine (g_currentloc, -1))

extern void beginLine (void)
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc; @*/ ;
# define beginLine()                  (fileloc_setColumn(g_currentloc, 1))

extern void addColumn (int p_n)
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc; @*/ ;
# define addColumn(n)                 (fileloc_addColumn(g_currentloc, n))

extern void setLine (int p_n)
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc; @*/ ;
# define setLine(n)                   (fileloc_setLineno(g_currentloc, n))

extern void setColumn (int p_n)
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc; @*/ ;
# define setColumn(n)                 (fileloc_setColumn(g_currentloc, n))

# ifndef NOLCL
extern void setSpecFileId (fileId p_s)
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc; @*/ ;
# define setSpecFileId(s) \
  (fileloc_reallyFree (g_currentloc), g_currentloc = fileloc_createSpec (s, 1, 1))
# endif

extern void setFileLine (fileId p_s, int p_line)
   /*@globals fileloc g_currentloc; @*/ 
   /*@modifies g_currentloc; @*/ ;
# define setFileLine(s, line) \
  (context_setFilename(s, line))

# else
# error "Multiple include"
# endif






