/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** typeNameNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

typeNameNodeList typeNameNodeList_new ()
{
  typeNameNodeList s = (typeNameNodeList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = typeNameNodeListBASESIZE;
  s->elements = (typeNameNode *) 
    dmalloc (sizeof (*s->elements) * typeNameNodeListBASESIZE);

  return (s);
}

static void
typeNameNodeList_grow (typeNameNodeList s)
{
  int i;
  typeNameNode *newelements; 

  s->nspace += typeNameNodeListBASESIZE;

  newelements = (typeNameNode *) dmalloc (sizeof (*newelements)
					  * (s->nelements + s->nspace));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] =  s->elements[i]; 
    }

  sfree (s->elements); 
  s->elements = newelements;
}

typeNameNodeList 
typeNameNodeList_add (typeNameNodeList s, typeNameNode el)
{
  if (s->nspace <= 0)
    typeNameNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ cstring
typeNameNodeList_unparse (typeNameNodeList s)
{
  cstring st = cstring_undefined;
  bool first = TRUE;

  typeNameNodeList_elements (s, current)
  {
    if (first)
      {
	st = typeNameNode_unparse (current);
	first = FALSE;
      }
    else
      {
	st = message ("%q, %q", st, typeNameNode_unparse (current));
      }
  } end_typeNameNodeList_elements;
  return (st);
}

void
typeNameNodeList_free (typeNameNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      typeNameNode_free (s->elements[i]); 
    }

  sfree (s->elements);
  sfree (s);
}
