/*
  Optimizer
  Entry header file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#ifndef _ENTRY_H_
#define _ENTRY_H_

typedef class Holder *PHolder;
typedef class Entry *PEntry;


//
//	Class name : Entry
//
//	Description : Entry in Holder
//
class Entry {
  friend Holder;
private:
  unsigned int flag;
  char *label;
  unsigned int opcode;
  unsigned int size;
  char *opcodestr;
  char *src;
  char *dest;
  PEntry next;                        // Next pointer
  void setopcodestr(void);            // Sets the opcodestr
public:
  Entry(YYSTYPE *curEntry);           // Constructor
  ~Entry();                           // Destructor
  unsigned int getFlag(void);         // Returns the flag
  void setFlag(unsigned int f);       // Sets the flag
  unsigned int getopcode(void);       // Returns the opcode
  char *getlabel(void);               // Returns the label string
  unsigned int getsize(void);         // Returns the "size" of the instruction
  char *getopcodestr(void);           // Returns the opcodestr string
  void setsrc(char *s);               // Sets the src string
  void setdest(char *s);              // Sets the dest string
  char *getsrc(void);                 // Returns the src string
  char *getdest(void);                // Returns the dest string
  char *getindirect(PHolder parent, unsigned int where); 
                                      // Get indirect memory reference
  void print(void);                   // Prints the entry
};

#endif
