/*
  Optimizer
  Holder C++ file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#include "Global.h"
#include "Misc.h"
#include "Holder.h"
#include "Entry.h"
#include "IdEntry.h"
#include "GloblEntry.h"
#include "optimizer.tab.h"
#include "Output.h"
#include "GAS.h"
#include "NASM.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <string.h>

//
//	Method name : Holder
//
//	Description : Constructor to Holder
//	Input : ---
//	Output : ---
//
Holder::Holder() {
  firstEntry = (PEntry) NULL;
  lastEntry = (PEntry) NULL;
  Fidlist = (PIdEntry) NULL;
  Lidlist = (PIdEntry) NULL;
  Fstrlist = (PIdEntry) NULL;
  Lstrlist = (PIdEntry) NULL;
  Fextlist = (PIdEntry) NULL;
  Lextlist = (PIdEntry) NULL;
  Fgbllist = (PGloblEntry) NULL;
  Lgbllist = (PGloblEntry) NULL;
  Fvarlist = (PIdEntry) NULL;
  Lvarlist = (PIdEntry) NULL;
  align = 16;
}

//
//	Method name : ~Holder
//
//	Description : Destructor to Holder
//	Input : ---
//	Output : ---
//
Holder::~Holder() {
  PEntry    tmp;
  PIdEntry  idtmp;
  PGloblEntry gtmp;

  while (firstEntry != NULL) {
    tmp = firstEntry;
    firstEntry = tmp->next;
    delete tmp;
  }
  while (Fidlist != NULL) {
    idtmp = Fidlist;
    Fidlist = idtmp->next;
    delete idtmp;
  }
  while (Fextlist != NULL) {
    idtmp = Fextlist;
    Fextlist = idtmp->next;
    delete idtmp;
  }
  while (Fstrlist != NULL) {
    idtmp = Fstrlist;
    Fstrlist = idtmp->next;
    delete idtmp;
  }
  while (Fvarlist != NULL) {
    idtmp = Fvarlist;
    Fvarlist = idtmp->next;
    delete idtmp;
  }
  while (Fgbllist != NULL) {
    gtmp = Fgbllist;
    Fgbllist = gtmp->next;
    delete gtmp;
  }
}

//
//	Method name : insert
//
//	Description : Inserts a entry in Holder
//	Input : The information for the entry
//	Output : ---
//
void Holder::insert(YYSTYPE *entry){
  PEntry newEntry = new Entry(entry);
  
  if (!newEntry) alloc_error();

  if (firstEntry == NULL) {
    firstEntry = newEntry;
    lastEntry = newEntry;
  } else {
    lastEntry->next = newEntry;
    lastEntry = newEntry;
  }
}

//
//	Method name : insertid
//
//	Description : Inserts a global id
//	Input : The name on the id
//	Output : ---
//
void Holder::insertid(char *s1,char *s2,int where){
  PIdEntry tmp,tmp2;
  PIdEntry newEntry;
  PGloblEntry newEntry2;
  char *tmpstr = new char[MaxSize];
  bool wrt,update;

  if (!tmpstr) alloc_error();

  if (where != GBLLIST) {
    if (where == STRLIST) {
      strcpy(tmpstr,s2);
      strdel(&tmpstr,".LC","LC");
      strcpy(s2,tmpstr);
      newEntry  = new IdEntry(s1,s2);
    } else {
      newEntry  = new IdEntry(s1,s2);
    }
    if (!newEntry) alloc_error();
    newEntry2 = (PGloblEntry) NULL;
  } else {
    newEntry2 = new GloblEntry(s1);
    if (!newEntry2) alloc_error();
    newEntry = (PIdEntry) NULL;
  }

  if (where == IDLIST) {
    wrt = true;
    update = false;
    tmp = Fextlist;
    if (tmp != NULL) {
      if (!strcmp(tmp->getname(),s1)) {
	Fextlist = tmp->next;
	delete tmp;
	wrt = false;
	update = true;
      }
    }
    while ((tmp != NULL)&&(wrt == true)) {
      tmp2 = tmp->next;
      if (tmp2 != NULL) {
	if (!strcmp(tmp2->getname(),s1)) {
	  tmp->next = tmp2->next;
	  delete tmp2;
	  wrt = false;
	  update = true;
	}
      }
      tmp = tmp->next;
    }
    if (update == true) {
      tmp = Fextlist;
      while (tmp != NULL) {
	Lextlist = tmp;
	tmp = tmp->next;
      }
    }
    if (Fidlist == NULL) {
      Fidlist = newEntry;
      Lidlist = newEntry;
    } else {
      Lidlist->next = newEntry;
      Lidlist = newEntry;
    }
  } else if (where == STRLIST){
      if (Fstrlist == NULL) {
        Fstrlist = newEntry;
        Lstrlist = newEntry;
      } else {
        Lstrlist->next = newEntry;
        Lstrlist = newEntry;
      }
  } else if (where == EXTLIST){
      wrt = true;
      tmp = Fidlist;
      while ((tmp != NULL)&&(wrt == true)) {
        if (!strcmp(tmp->getname(),s1)){
          wrt = false;
        }
        tmp = tmp->next;
      }
      tmp = Fextlist;
      while ((tmp != NULL)&&(wrt == true)) {
        if (!strcmp(tmp->getname(),s1)){
          wrt = false;
        }
        tmp = tmp->next;
      }
      if (wrt == true) {
	if (strstr(s1,"*%") == NULL) {
	  if (Fextlist == NULL) {
	    Fextlist = newEntry;
	    Lextlist = newEntry;
	  } else {
	    Lextlist->next = newEntry;
	    Lextlist = newEntry;
	  }
	}
      }
  } else if (where == VARLIST){
    if (Fvarlist == NULL) {
      Fvarlist = newEntry;
      Lvarlist = newEntry;
    } else {
      Lvarlist->next = newEntry;
      Lvarlist = newEntry;
    }
  } else if (where == GBLLIST){
    if (Fgbllist == NULL) {
      Fgbllist = newEntry2;
      Lgbllist = newEntry2;
    } else {
      Lgbllist->next = newEntry2;
      Lgbllist = newEntry2;
    }
  }
  delete[] tmpstr;
}

//
//	Method name : insertdata
//
//	Description : Inserts a data-field
//	Input : The information for the data-field
//	Output : ---
//
void Holder::insertdata(char *s1,char *s2){
  PGloblEntry tmp;
  
  tmp = Fgbllist;
  while ((strcmp(s1,tmp->getname()))&&(tmp != NULL)) {
    tmp = tmp->next;
  }
  if (tmp != NULL) {
    tmp->insert(s2);
  } else {
    cout << "ERROR !" << endl;
    exit(1);
  }
}

//
//	Method name : deleteid
//
//	Description : Deletes an id
//	Input : The name of the id
//	Output : ---
//
void Holder::deleteid(char *s) {
  PIdEntry tmp,tmp2;
  PEntry Etmp,Etmp2;
  bool cont,cont2;

  tmp = Fidlist;
  cont = true;
  if (tmp != NULL) {
    if (!strcmp(tmp->getname(),s)) {
      Fidlist = tmp->next;
      delete tmp;
      cont = false;
    }
  }
  while ((tmp != NULL)&&(cont == true)) {
    tmp2 = tmp->next;
    if (tmp2 != NULL) {
      if (!strcmp(tmp2->getname(),s)) {
	tmp->next = tmp2->next;
	delete tmp2;
	cont = false;
      }
    }
    tmp = tmp->next;
  }

  Etmp = firstEntry;
  cont2 = true;
  if (Etmp != NULL) {
    if (!strcmp(Etmp->getlabel(),s)) {
      firstEntry = Etmp->next;
      delete Etmp;
      cont2 = false;
    }
  }
  while ((Etmp != NULL)&&(cont2 == true)) {
    Etmp2 = Etmp->next;
    if (Etmp2 != NULL) {
      if (!strcmp(Etmp2->getlabel(),s)) {
	Etmp->next = Etmp2->next;
	delete Etmp2;
	cont2 = false;
      }
    }
    Etmp = Etmp->next;
  }

}

//
//	Method name : setvarsize
//
//	Description : Sets the variable size
//	Input : The name of the variable, The size, The alignment
//	Output : ---
//
void Holder::setvarsize(char *s1, char *s2, char *s3) {
  PIdEntry tmp;
  bool cont = true;

  tmp = Fvarlist;
  while ((tmp != NULL)&&(cont == true)) {
    if (!strcmp(tmp->getname(),s1)) {
      tmp->setlabel(s2);
      tmp->setalign(s3);
      cont = false;
    }
    tmp = tmp->next;
  }
  if (cont == true) {
    cout << "ERROR !" << endl;
    exit(1);
  }
}

//
//	Method name : setgblsize
//
//	Description : Sets the variable size
//	Input : The name of the variable, The size
//	Output : ---
//
void Holder::setgblsize(char *s1, unsigned int size) {
  PGloblEntry tmp;
  bool cont = true;

  tmp = Fgbllist;
  while ((tmp != NULL)&&(cont == true)) {
    if (!strcmp(tmp->getname(),s1)) {
      tmp->setsize(size);
      cont = false;
    }
    tmp = tmp->next;
  }
  if (cont == true) {
    cout << "ERROR !" << endl;
    exit(1);
  }
}

//
//	Method name : setcodealign
//
//	Description : Sets the alignment for the code
//	Input : The alignment
//	Output : ---
//
void Holder::setcodealign(unsigned int size) {
  this->align = size; 
}

//
//	Method name : switchstr
//
//	Description : Switches the reg-strings
//	Input : ---
//	Output : ---
//
void Holder::switchstr(void){
  PEntry tmp;
  unsigned int tmpint;
  char *tmpstr1 = new char[MaxSize];
  char *tmpstr2 = new char[MaxSize];

  if (!tmpstr1) alloc_error();
  if (!tmpstr2) alloc_error();

  tmp = firstEntry;
  while (tmp != NULL) {
    tmpint = tmp->getFlag();
    if ((tmpint & SRC)&&(tmpint & DEST)) {
      strcpy(tmpstr1,tmp->getsrc());
      strcpy(tmpstr2,tmp->getdest());
      tmp->setsrc(tmpstr2);
      tmp->setdest(tmpstr1);
    }
    tmp = tmp->next;
  }
  delete[] tmpstr1;
  delete[] tmpstr2;
}

//
//	Method name : change
//
//	Description : Changes reg-names
//	Input : ---
//	Output : ---
//
void Holder::change(void){
  PEntry tmp;
  char *tmpstr = new char[MaxSize];
  bool cont = true;

  if (!tmpstr) alloc_error();

  tmp = firstEntry;
  while (tmp != NULL) { 
    while (cont == true) {
      strcpy(tmpstr,"");
      if (tmp->getFlag() & SRC) {
	while (cont == true) {
	  strcpy(tmpstr,"");
	  if (strstr(tmp->getsrc(),"%eax") != NULL) {    // EAX
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%eax","eax");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%ebx") != NULL) {    // EBX
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%ebx","ebx");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%ecx") != NULL) {    // ECX
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%ecx","ecx");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%edx") != NULL) {    // EDX
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%edx","edx");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%edi") != NULL) {    // EDI
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%edi","edi");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%esi") != NULL) {    // ESI
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%esi","esi");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%ebp") != NULL) {    // EBP
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%ebp","ebp");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%esp") != NULL) {    // ESP
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%esp","esp");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%ax") != NULL) {     // AX
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%ax","ax");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%bx") != NULL) {     // BX
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%bx","bx");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%cx") != NULL) {     // CX
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%cx","cx");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%dx") != NULL) {     // DX
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%dx","dx");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%sp") != NULL) {     // SP
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%sp","sp");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%bp") != NULL) {     // BP
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%bp","bp");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%si") != NULL) {     // SI
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%si","si");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%di") != NULL) {     // DI
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%di","di");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%al") != NULL) {     // AL
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%al","al");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%bl") != NULL) {     // BL
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%bl","bl");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%cl") != NULL) {     // CL
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%cl","cl");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%dl") != NULL) {     // DL
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%dl","dl");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%ah") != NULL) {     // AH
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%ah","ah");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%bh") != NULL) {     // BH
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%bh","bh");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%ch") != NULL) {     // CH
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%ch","ch");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%dh") != NULL) {     // DH
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%dh","dh");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%es") != NULL) {     // ES
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%es","es");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%cs") != NULL) {     // CS
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%cs","cs");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%ss") != NULL) {     // SS
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%ss","ss");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%ds") != NULL) {     // DS
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%ds","ds");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%fs") != NULL) {     // FS
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%fs","fs");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%gs") != NULL) {     // GS
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%gs","gs");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%cr") != NULL) {     // CR0->CR4
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%cr","cr");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%db") != NULL) {     // DB0->DB7
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%db","db");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%dr") != NULL) {     // DR0->DR7
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%dr","dr");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%tr") != NULL) {     // TR3->TR7
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%tr","tr");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%st") != NULL) {     // ST0->ST7
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%st","st");
	    tmp->setsrc(tmpstr);
	  } else if (strstr(tmp->getsrc(),"%mm") != NULL) {     // MM0->MM7
	    strcpy(tmpstr,tmp->getsrc());
	    strdel(&tmpstr,"%mm","mm");
	    tmp->setsrc(tmpstr);
	  } else {
	    cont = false;
	  }
	}
      }
      cont = true;
      if (tmp->getFlag() & DEST) {
	while (cont == true) {
	  strcpy(tmpstr,"");
	  if (strstr(tmp->getdest(),"%eax") != NULL) {    // EAX
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%eax","eax");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%ebx") != NULL) {    // EBX
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%ebx","ebx");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%ecx") != NULL) {    // ECX
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%ecx","ecx");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%edx") != NULL) {    // EDX
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%edx","edx");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%edi") != NULL) {    // EDI
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%edi","edi");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%esi") != NULL) {    // ESI
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%esi","esi");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%ebp") != NULL) {    // EBP
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%ebp","ebp");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%esp") != NULL) {    // ESP
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%esp","esp");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%ax") != NULL) {     // AX
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%ax","ax");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%bx") != NULL) {     // BX
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%bx","bx");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%cx") != NULL) {     // CX
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%cx","cx");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%dx") != NULL) {     // DX
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%dx","dx");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%sp") != NULL) {     // SP
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%sp","sp");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%bp") != NULL) {     // BP
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%bp","bp");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%si") != NULL) {     // SI
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%si","si");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%di") != NULL) {     // DI
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%di","di");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%al") != NULL) {     // AL
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%al","al");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%bl") != NULL) {     // BL
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%bl","bl");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%cl") != NULL) {     // CL
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%cl","cl");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%dl") != NULL) {     // DL
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%dl","dl");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%ah") != NULL) {     // AH
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%ah","ah");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%bh") != NULL) {     // BH
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%bh","bh");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%ch") != NULL) {     // CH
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%ch","ch");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%dh") != NULL) {     // DH
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%dh","dh");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%es") != NULL) {     // ES
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%es","es");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%cs") != NULL) {     // CS
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%cs","cs");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%ss") != NULL) {     // SS
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%ss","ss");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%ds") != NULL) {     // DS
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%ds","ds");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%fs") != NULL) {     // FS
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%fs","fs");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%gs") != NULL) {     // GS
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%gs","gs");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%cr") != NULL) {     // CR0->CR4
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%cr","cr");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%db") != NULL) {     // DB0->DB7
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%db","db");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%dr") != NULL) {     // DR0->DR7
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%dr","dr");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%tr") != NULL) {     // TR3->TR7
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%tr","tr");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%st") != NULL) {     // ST0->ST7
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%st","st");
	    tmp->setdest(tmpstr);
	  } else if (strstr(tmp->getdest(),"%mm") != NULL) {     // MM0->MM7
	    strcpy(tmpstr,tmp->getdest());
	    strdel(&tmpstr,"%mm","mm");
	    tmp->setdest(tmpstr);
	  } else {
	    cont = false;
	  }
	}
      } 
      if (!(tmp->getFlag() & (SRC + DEST))) {
	cont = false;
      }
    }
    cont = true;
    tmp = tmp->next;
  }
  delete[] tmpstr;
}

//
//	Method name : notation
//
//	Description : Convert "as" notation to NASM
//	Input : ---
//	Output : ---
//
void Holder::notation(void){   
  PEntry tmp;
  unsigned int num;
  int numindex;
  bool switchstr;
  PIdEntry tmp1,tmp2,tmp3,tmp4;
  PGloblEntry gtmp;

  char *tmpstr1 = new char[MaxSize];
  char *tmpstr2 = new char[MaxSize];
  char *tmpstr3 = new char[MaxSize];

  if (!tmpstr1) alloc_error();
  if (!tmpstr2) alloc_error();
  if (!tmpstr3) alloc_error();

  tmp = firstEntry;
  while (tmp != NULL) {
    num = tmp->getFlag();
    if (num & OPCODE) {
      ///////////////////////////////////////////////////////////////////////////////////////////////////
      ///////////////////////////////////////////////////////////////////////////////////////////////////
      if (num & DEST) {
	strcpy(tmpstr1,tmp->getdest());
	if (((strstr(tmpstr1,"(") != NULL)||(strstr(tmpstr1,":") != NULL))&&(isReg(tmpstr1) == NOREG)) {
	  strcpy(tmpstr1,tmp->getindirect(this,DEST));
	  tmp->setdest(tmpstr1);
	} else if ((isReg(tmpstr1) == FREG)||(isReg(tmpstr1) == MMXREG)||(isReg(tmpstr1) == SREG)) {
	  tmp->setdest(cleanreg(tmpstr1));
	}

	strcpy(tmpstr1,tmp->getdest());
	if (isReg(tmpstr1) == NOREG) {
	  if (tmpstr1[0] == '[') {
	    num = tmp->getsize();
	    if (num == BYTE) {
	      strcpy(tmpstr2,"byte ");
	    } else if (num == WORD) {
	      strcpy(tmpstr2,"word ");
	    } else if (num == LONG) {
	      strcpy(tmpstr2,"dword ");
	    } else if (num == SHORT) {
	      strcpy(tmpstr2,"dword ");
	    } else if (num == QUAD) {
	      strcpy(tmpstr2,"qword ");
	    } else if (num == TERA) {
	      strcpy(tmpstr2,"tword ");
	    } else {
	      strcpy(tmpstr2,"");
	    }
	    strcat(tmpstr2,tmpstr1);
	    tmp->setdest(tmpstr2);
	  } else if (chknum(tmpstr1) == true) {
	    strdel(&tmpstr1,"$","");
	    num = tmp->getsize();
	    if (num == BYTE) {
	      strcpy(tmpstr2,"byte ");
	    } else if (num == WORD) {
	      strcpy(tmpstr2,"word ");
	    } else if (num == LONG) {
	      strcpy(tmpstr2,"dword ");
	    } else if (num == SHORT) {
	      strcpy(tmpstr2,"dword ");
	    } else if (num == QUAD) {
	      strcpy(tmpstr2,"qword ");
	    } else if (num == TERA) {
	      strcpy(tmpstr2,"tword ");
	    } else {
	      cout << "Bug found: No size defined." << endl;
	      tmp->print();
	      exit(1);
	    }
	    strcat(tmpstr2,tmpstr1);
	    tmp->setdest(tmpstr2);
	  } else if (isLocalLabel(tmpstr1) == true) {
	    //cout << tmpstr1 << endl;
	    num = tmp->getopcode();
	    if (num != _JMP) {
	      strcpy(tmpstr2,"near ");
	      strcat(tmpstr2,tmpstr1);
	      tmp->setdest(tmpstr2);
	    } 
	  } else if (tmpstr1[0] == '*') {
	    strdel(&tmpstr1,"*","");
	    tmp->setdest(tmpstr1);
	  } else if (tmpstr1[0] == '$') {
	    if (tmpstr1[1] == '.') {
	      strdel(&tmpstr1,"$.","");
	    } else {
	      strdel(&tmpstr1,"$","");
	    }
	    numindex = findnum(tmpstr1);
	    switchstr = false;
	    if (numindex != -1) {
	      strcpy(tmpstr3,tmpstr1);
	      switchstr = true;
	      strdel(&tmpstr1,numindex);
	    }
	    tmp1 = this->findid(tmpstr1);
	    tmp2 = this->findfunc(tmpstr1);
	    tmp3 = this->findstr(tmpstr1);
	    tmp4 = this->findvar(tmpstr1);
	    gtmp = this->findglobl(tmpstr1);
	    if ((tmp1 == NULL)&&(tmp2 == NULL)&&(tmp3 == NULL)&&(tmp4 == NULL)&&(gtmp == NULL)) {
	      this->insertid(tmpstr1,"",EXTLIST);
	    }
	    if (switchstr == true) {
	      strcpy(tmpstr1,tmpstr3);
	    }
	    num = tmp->getsize();
	    if (num == BYTE) {
	      strcpy(tmpstr2,"byte $");
	    } else if (num == WORD) {
	      strcpy(tmpstr2,"word $");
	    } else if (num == LONG) {
	      strcpy(tmpstr2,"dword $");
	    } else if (num == SHORT) {
	      strcpy(tmpstr2,"dword $");
	    } else if (num == QUAD) {
	      strcpy(tmpstr2,"qword $");
	    } else if (num == TERA) {
	      strcpy(tmpstr2,"tword $");
	    } else {
	      cout << "Bug found: No size defined." << endl;
	      tmp->print();
	      exit(1);
	    }
	    strcat(tmpstr2,tmpstr1);
	    tmp->setdest(tmpstr2);
	  } else {
	    if (tmpstr1[0] == '.') {
	      strdel(&tmpstr1,".","");
	    }
	    numindex = findnum(tmpstr1);
	    switchstr = false;
	    if (numindex != -1) {
	      strcpy(tmpstr3,tmpstr1);
	      switchstr = true;
	      strdel(&tmpstr1,numindex);
	    }
	    tmp1 = this->findid(tmpstr1);
	    tmp2 = this->findfunc(tmpstr1);
	    tmp3 = this->findstr(tmpstr1);
	    tmp4 = this->findvar(tmpstr1);
	    gtmp = this->findglobl(tmpstr1);
	    if ((tmp1 == NULL)&&(tmp2 == NULL)&&(tmp3 == NULL)&&(tmp4 == NULL)&&(gtmp == NULL)) {
	      this->insertid(tmpstr1,"",EXTLIST);
	    }
	    if (switchstr == true) {
	      strcpy(tmpstr1,tmpstr3);
	    }
	    num = tmp->getsize();
	    if (num == BYTE) {
	      strcpy(tmpstr2,"byte [$");
	    } else if (num == WORD) {
	      strcpy(tmpstr2,"word [$");
	    } else if (num == LONG) {
	      strcpy(tmpstr2,"dword [$");
	    } else if (num == SHORT) {
	      strcpy(tmpstr2,"dword [$");
	    } else if (num == QUAD) {
	      strcpy(tmpstr2,"qword [$");
	    } else if (num == TERA) {
	      strcpy(tmpstr2,"tword [$");
	    } else {
	      strcpy(tmpstr2,"$");
	    }
	    strcat(tmpstr2,tmpstr1);
	    if (tmpstr2[0] != '$') {
	      strcat(tmpstr2,"]");
	    }
	    tmp->setdest(tmpstr2);
	  }
	}
      }
      ///////////////////////////////////////////////////////////////////////////////////////////////////
      ///////////////////////////////////////////////////////////////////////////////////////////////////
      num = tmp->getFlag();
      if (num & SRC) {
	strcpy(tmpstr1,tmp->getsrc());
	if (((strstr(tmpstr1,"(") != NULL)||(strstr(tmpstr1,":") != NULL))&&(isReg(tmpstr1) == NOREG)) {
	  strcpy(tmpstr1,tmp->getindirect(this,SRC));
	  tmp->setsrc(tmpstr1);
	} else if ((isReg(tmpstr1) == FREG)||(isReg(tmpstr1) == MMXREG)||(isReg(tmpstr1) == SREG)) {
	  tmp->setsrc(cleanreg(tmpstr1));
	}

	strcpy(tmpstr1,tmp->getsrc());
	if (isReg(tmpstr1) == NOREG) {
	  if (tmpstr1[0] == '[') {
	    num = tmp->getopcode();
	    if ((num == _MOVSX_B)||(num == _MOVZX_B)) { 
	      strcpy(tmpstr2,"byte ");
	      strcat(tmpstr2,tmpstr1);
	      tmp->setsrc(tmpstr2);
	    } else if ((num == _MOVSX_W)||(num == _MOVZX_W)) { 
	      strcpy(tmpstr2,"word ");
	      strcat(tmpstr2,tmpstr1);
	      tmp->setsrc(tmpstr2);
	    }
	  } else if (chknum(tmpstr1) == true) {
	    strdel(&tmpstr1,"$","");
	    tmp->setsrc(tmpstr1);
	  } else if (tmpstr1[0] == '$') {
	    if (tmpstr1[1] == '.') {
	      strdel(&tmpstr1,".","");
	      tmp->setsrc(tmpstr1);
	    }
	    strdel(&tmpstr1,"$","");
	    numindex = findnum(tmpstr1);
	    if (numindex != -1) {
	      strdel(&tmpstr1,numindex);
	    }
	    tmp1 = this->findid(tmpstr1);
	    tmp2 = this->findfunc(tmpstr1);
	    tmp3 = this->findstr(tmpstr1);
	    tmp4 = this->findvar(tmpstr1);
	    gtmp = this->findglobl(tmpstr1);
	    if ((tmp1 == NULL)&&(tmp2 == NULL)&&(tmp3 == NULL)&&(tmp4 == NULL)&&(gtmp == NULL)) {
	      this->insertid(tmpstr1,"",EXTLIST);
	    }
	  } else {
	    if (tmpstr1[0] == '.') {
	      strdel(&tmpstr1,".","");
	    }
	    numindex = findnum(tmpstr1);
	    switchstr = false;
	    if (numindex != -1) {
	      strcpy(tmpstr3,tmpstr1);
	      switchstr = true;
	      strdel(&tmpstr1,numindex);
	    }
	    tmp1 = this->findid(tmpstr1);
	    tmp2 = this->findfunc(tmpstr1);
	    tmp3 = this->findstr(tmpstr1);
	    tmp4 = this->findvar(tmpstr1);
	    gtmp = this->findglobl(tmpstr1);
	    if ((tmp1 == NULL)&&(tmp2 == NULL)&&(tmp3 == NULL)&&(tmp4 == NULL)&&(gtmp == NULL)) {
	      this->insertid(tmpstr1,"",EXTLIST);
	    }
	    if (switchstr == true) {
	      strcpy(tmpstr1,tmpstr3);
	    }
	    num = tmp->getopcode();
	    if ((num == _MOVSX_B)||(num == _MOVZX_B)) { 
	      strcpy(tmpstr2,"byte [$");
	      strcat(tmpstr2,tmpstr1);
	      strcat(tmpstr2,"]");
	      tmp->setsrc(tmpstr2);
	    } else if ((num == _MOVSX_W)||(num == _MOVZX_W)) { 
	      strcpy(tmpstr2,"word [$");
	      strcat(tmpstr2,tmpstr1);
	      strcat(tmpstr2,"]");
	      tmp->setsrc(tmpstr2);
	    } else {
	      strcpy(tmpstr2,"[$");
	      strcat(tmpstr2,tmpstr1);
	      strcat(tmpstr2,"]");
	      tmp->setsrc(tmpstr2);
	    }
	  }
	}
	  
      }
    }
    tmp = tmp->next;
  }
  delete[] tmpstr1;
  delete[] tmpstr2;
  delete[] tmpstr3;
}

//
//	Method name : cleanup
//
//	Description : Clean up unused entries
//	Input : ---
//	Output : ---
//
void Holder::cleanup(void){ 
  PEntry Etmp1,Etmp2;
  PIdEntry tmp1,tmp2;
  PIdEntry idtmp1,idtmp2;
  PGloblEntry gtmp,gtmp2;
  char *s = new char[MaxSize];
  char *t = new char[MaxSize];
  bool cont;

  if (!s) alloc_error();
  if (!t) alloc_error();

  gtmp = Fgbllist;               // delete var-names from Entry-list and IDLIST
  while (gtmp != NULL) {
    strcpy(s,gtmp->getname());
    cont = true;
    tmp1 = Fidlist;
    if (tmp1!= NULL) {
      strcpy(t,tmp1->getname());
      if (!strcmp(s,t)) {
	Fidlist = tmp1->next;
	cont = false;
	delete tmp1;
      }
    }
    while ((tmp1 != NULL)&&(cont == true)) {
      tmp2 = tmp1->next;
      if (tmp2 != NULL) {
	strcpy(t,tmp2->getname());
	if (!strcmp(s,t)) {
	  tmp1->next = tmp2->next;
	  cont = false;
	  delete tmp2;
	}
      }
      tmp1 = tmp1->next;
    }

    cont = true;
    idtmp1 = Fvarlist;
    if (idtmp1!= NULL) {
      strcpy(t,idtmp1->getname());
      if (!strcmp(s,t)) {
	Fvarlist = idtmp1->next;
	cont = false;
	delete idtmp1;
      }
    }
    while ((idtmp1 != NULL)&&(cont == true)) {
      idtmp2 = idtmp1->next;
      if (idtmp2 != NULL) {
	strcpy(t,idtmp2->getname());
	if (!strcmp(s,t)) {
	  idtmp1->next = idtmp2->next;
	  cont = false;
	  delete idtmp2;
	}
      }
      idtmp1 = idtmp1->next;
    }
    gtmp = gtmp->next;
  }

  idtmp1 = Fvarlist;               // delete var-names from Entry-list and IDLIST
  while (idtmp1 != NULL) {
    strcpy(s,idtmp1->getname());
    cont = true;
    tmp1 = Fidlist;
    if (tmp1!= NULL) {
      strcpy(t,tmp1->getname());
      if (!strcmp(s,t)) {
	Fidlist = tmp1->next;
	cont = false;
	delete tmp1;
      }
    }
    while ((tmp1 != NULL)&&(cont == true)) {
      tmp2 = tmp1->next;
      if (tmp2 != NULL) {
	strcpy(t,tmp2->getname());
	if (!strcmp(s,t)) {
	  tmp1->next = tmp2->next;
	  cont = false;
	  delete tmp2;
	}
      }
      tmp1 = tmp1->next;
    }
    idtmp1 = idtmp1->next;
  }

  Etmp1 = firstEntry;
  while (Etmp1 != NULL) {
    Etmp2 = Etmp1->next;
    while ((Etmp2 != NULL)&&(Etmp2->getFlag() == LABEL)) {
      strcpy(s,Etmp2->getlabel());
      if (!strncmp(s,".LC",3)) {
	Etmp1->next = Etmp2->next;
	delete Etmp2;
	Etmp2 = Etmp1->next;
      }
      else if (!strncmp(s,".Lfe",4)) {
	Etmp1->next = Etmp2->next;
	delete Etmp2;       
	Etmp2 = Etmp1->next;
      }
      else break;
    }
    Etmp1 = Etmp1->next;
  }
  Etmp1 = firstEntry;
  if (Etmp1 != NULL) {
    if (Etmp1->getFlag() == LABEL) {
      strcpy(s,Etmp1->getlabel());
      if (!strncmp(s,".LC",3)) {
	firstEntry = Etmp1->next;
	delete Etmp1;
      }
      else if (!strncmp(s,".Lfe",4)) {
	firstEntry = Etmp1->next;
	delete Etmp1;
      }
    }
  }

  gtmp = Fgbllist;    
  while (gtmp != NULL) {
    strcpy(s,gtmp->getname());
    cont = true;
    Etmp1 = firstEntry;
    if (Etmp1!= NULL) {
      strcpy(t,Etmp1->getlabel());
      if (!strcmp(s,t)) {
	firstEntry = Etmp1->next;
	cont = false;
	delete Etmp1;
      }
    }
    while ((Etmp1 != NULL)&&(cont == true)) {
      Etmp2 = Etmp1->next;
      if (Etmp2 != NULL) {
	strcpy(t,Etmp2->getlabel());
	if (!strcmp(s,t)) {
	  Etmp1->next = Etmp2->next;
	  cont = false;
	  delete Etmp2;
	}
      }
      Etmp1 = Etmp1->next;
    }
    gtmp = gtmp->next;
  }

  idtmp1 = Fvarlist;    
  while (idtmp1 != NULL) {
    strcpy(s,idtmp1->getname());
    cont = true;
    Etmp1 = firstEntry;
    if (Etmp1!= NULL) {
      strcpy(t,Etmp1->getlabel());
      if (!strcmp(s,t)) {
	firstEntry = Etmp1->next;
	cont = false;
	delete Etmp1;
      }
    }
    while ((Etmp1 != NULL)&&(cont == true)) {
      Etmp2 = Etmp1->next;
      if (Etmp2 != NULL) {
	strcpy(t,Etmp2->getlabel());
	if (!strcmp(s,t)) {
	  Etmp1->next = Etmp2->next;
	  cont = false;
	  delete Etmp2;
	}
      }
      Etmp1 = Etmp1->next;
    }
    idtmp1 = idtmp1->next;
  }

  idtmp1 = Fstrlist;
  while (idtmp1 != NULL) {
    strcpy(s,idtmp1->getlabel());
    cont = true;
    gtmp = Fgbllist;
    if (gtmp != NULL) {
      strcpy(t,gtmp->getname());
      if (!strcmp(s,t)) {
	Fgbllist = gtmp->next;
	cont = false;
	delete gtmp;
      }
    }
    while ((gtmp != NULL)&&(cont == true)) {
      gtmp2 = gtmp->next;
      if (gtmp2 != NULL) {
	strcpy(t,gtmp2->getname());
	if (!strcmp(s,t)) {
	  gtmp->next = gtmp2->next;
	  cont = false;
	  delete gtmp2;
	}
      }
      gtmp = gtmp->next;
    }
    idtmp1 = idtmp1->next;
  }

  delete[] s;
  delete[] t;
}

//
//	Method name : findvar
//
//	Description : 
//	Input : The search string
//	Output : Pointer to the entry else NULL
//
PIdEntry Holder::findvar(char *s) {
  PIdEntry tmp;
  bool cont;
  unsigned int i,j;
  char *tmpstr1 = new char[MaxSize];
  char *tmpstr2 = new char[MaxSize];
  
  if (!tmpstr1) alloc_error();
  if (!tmpstr2) alloc_error();

  tmp = Fvarlist;
  while (tmp != NULL) {
    strcpy(tmpstr1,"$");
    strcat(tmpstr1,tmp->getname());
    cont = true; i = 0;
    while (cont == true) {
      strcpy(tmpstr2,"");
      if (s[i] != '\0') {
	while ((s[i] == '[')||(s[i] == '+')||(s[i] == '-')||(s[i] == '*')||(s[i] == ']')) {
	  i++;
	}
	j = 0;
	while ((s[i] != '[')&&(s[i] != '+')&&(s[i] != '-')&&(s[i] != '*')&&(s[i] != ']')&&(s[i] != '\0')) {
	  tmpstr2[j] = s[i];
	  i++; j++;
	}
	tmpstr2[j] = '\0';
      } else {
	cont = false;
      }
      if ((!strcmp(tmpstr2,tmp->getname()))&&(strcmp(tmpstr2,tmpstr1))) {
	delete[] tmpstr1;
	delete[] tmpstr2;
	return tmp;
      }
    }
    tmp = tmp->next;
  }
  delete[] tmpstr1;
  delete[] tmpstr2;
  return NULL;
}

//
//	Method name : findglobl
//
//	Description : 
//	Input : The search string
//	Output : Pointer to the entry else NULL
//
PGloblEntry Holder::findglobl(char *s) {
  PGloblEntry tmp;
  bool cont;
  unsigned int i,j;
  char *tmpstr1 = new char[MaxSize];
  char *tmpstr2 = new char[MaxSize];
  
  if (!tmpstr1) alloc_error();
  if (!tmpstr2) alloc_error();

  tmp = Fgbllist;
  while (tmp != NULL) {
    strcpy(tmpstr1,"$");
    strcat(tmpstr1,tmp->getname());
    cont = true; i = 0;
    while (cont == true) {
      strcpy(tmpstr2,"");
      if (s[i] != '\0') {
	while ((s[i] == '[')||(s[i] == '+')||(s[i] == '-')||(s[i] == '*')||(s[i] == ']')) {
	  i++;
	}
	j = 0;
	while ((s[i] != '[')&&(s[i] != '+')&&(s[i] != '-')&&(s[i] != '*')&&(s[i] != ']')&&(s[i] != '\0')) {
	  tmpstr2[j] = s[i];
	  i++; j++;
	}
	tmpstr2[j] = '\0';
      } else {
	cont = false;
      }
      if ((!strcmp(tmpstr2,tmp->getname()))&&(strcmp(tmpstr2,tmpstr1))) {
	delete[] tmpstr1;
	delete[] tmpstr2;
	return tmp;
      }
    }
    tmp = tmp->next;
  }
  delete[] tmpstr1;
  delete[] tmpstr2;
  return NULL;
}


//
//	Method name : findfunc
//
//	Description : 
//	Input : The search string
//	Output : Pointer to the entry else NULL
//
PIdEntry Holder::findfunc(char *s) {
  PIdEntry tmp;
  
  tmp = Fidlist;
  while (tmp != NULL) {
    if (!strcmp(tmp->getname(),s)) {
      return tmp;
    }
    tmp = tmp->next;
  }
  tmp = Fextlist;
  while (tmp != NULL) {
    if (!strcmp(tmp->getname(),s)) {
      return tmp;
    }
    tmp = tmp->next;
  }
  return NULL;
}

//
//	Method name : findstr
//
//	Description : 
//	Input : The search string
//	Output : Pointer to the entry else NULL
//
PIdEntry Holder::findstr(char *s) {
  PIdEntry tmp;
  
  tmp = Fstrlist;
  while (tmp != NULL) {
    if (!strcmp(tmp->getlabel(),s)) {
      return tmp;
    }
    tmp = tmp->next;
  }
  return NULL;
}

//
//	Method name : findid
//
//	Description : Finds a global id
//	Input : The search string
//	Output : Pointer to the entry else NULL
//
PIdEntry Holder::findid(char *s) {
  PIdEntry tmp;
  
  tmp = Fidlist;
  while (tmp != NULL) {
    if (!strcmp(tmp->getlabel(),s)) {
      return tmp;
    }
    tmp = tmp->next;
  }
  return NULL;
}

//
//	Method name : outvars
//
//	Description : 
//	Input : 
//	Output :
//
void Holder::outvars(void) {
  PGloblEntry tmp;

  tmp = Fgbllist;
  while (tmp != NULL) {
    tmp->putvars();
    tmp = tmp->next;
  }
}

//
//	Method name : printAll
//
//	Description : Prints all the entry's
//	Input : Which entry's to print
//	Output : ---
//
void Holder::printAll(unsigned int which){
  PEntry Entrytmp;
  PIdEntry IdEntrytmp;
  PGloblEntry GloblEntrytmp;

  if (which == ALL) {
    Entrytmp = firstEntry;
    cout << "ENTRY:\n\n";
    while (Entrytmp != NULL) {
      Entrytmp->print();
      Entrytmp = Entrytmp->next;
    }
    cout << "\nIDLIST:\n";
    IdEntrytmp = Fidlist;
    while (IdEntrytmp != NULL) {
      IdEntrytmp->print();
      IdEntrytmp = IdEntrytmp->next;
    }
    cout << "\nSTRLIST:\n";
    IdEntrytmp = Fstrlist;
    while (IdEntrytmp != NULL) {
      IdEntrytmp->print();
      IdEntrytmp = IdEntrytmp->next;
    }
    cout << "\nEXTLIST:\n";
    IdEntrytmp = Fextlist;
    while (IdEntrytmp != NULL) {
      IdEntrytmp->print();
      IdEntrytmp = IdEntrytmp->next;
    }
    cout << "\nVARLIST:\n";
    IdEntrytmp = Fvarlist;
    while (IdEntrytmp != NULL) {
      IdEntrytmp->print();
      IdEntrytmp = IdEntrytmp->next;
    }
  } else if (which == IDLIST) {
    cout << "\nIDLIST:\n";
    IdEntrytmp = Fidlist;
    while (IdEntrytmp != NULL) {
      IdEntrytmp->print();
      IdEntrytmp = IdEntrytmp->next;
    }
  } else if (which == STRLIST) {
    cout << "\nSTRLIST:\n";
    IdEntrytmp = Fstrlist;
    while (IdEntrytmp != NULL) {
      IdEntrytmp->print();
      IdEntrytmp = IdEntrytmp->next;
    }
  } else if (which == EXTLIST) {
    cout << "\nEXTLIST:\n";
    IdEntrytmp = Fextlist;
    while (IdEntrytmp != NULL) {
      IdEntrytmp->print();
      IdEntrytmp = IdEntrytmp->next;
    }
  } else if (which == VARLIST) {
    cout << "\nVARLIST:\n";
    IdEntrytmp = Fvarlist;
    while (IdEntrytmp != NULL) {
      IdEntrytmp->print();
      IdEntrytmp = IdEntrytmp->next;
    }
  } else if (which == GBLLIST) {
    cout << "\nGBLLIST:\n";
    GloblEntrytmp = Fgbllist;
    while (GloblEntrytmp != NULL) {
      GloblEntrytmp->print();
      GloblEntrytmp = GloblEntrytmp->next;
    }
  }
}

