%{
/* Optimizer
   Bison file         
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include "Global.h"
#include "Misc.h"
#include "Holder.h"
#include "GloblEntry.h"

//#define DEBUG 1

int linenumber = 1;
int aligncode,result,i;
bool firstStatement = true;
bool textRead = false;
char *currentLabel = new char[MaxSize];
char *tmpcpystr = new char[MaxSize];
PGloblEntry tmp;
PIdEntry idtmp;
Holder H;

void unputstring(char *);
int yylex(void);

int yyerror(char *s) {
  cerr << "Optimizer v" << VERSION << " Line (" << linenumber << ") ERROR : " << s << "\n\n";
  exit(1);
}


%}

%token _EOL                // End of line
%token _RESERVED           // Reserved asm words
%token _ID                 // ID token

// Instructions
%token _AAA
%token _AAD
%token _AAM
%token _AAS
%token _ADC
%token _ADD
%token _AND
%token _ARPL
%token _BOUND
%token _BSF
%token _BSR
%token _BSWAP
%token _BT
%token _BTC
%token _BTR
%token _BTS
%token _CALL
%token _CBW
%token _CDQ
%token _CLC
%token _CLD
%token _CLI
%token _CLTS
%token _CMC
%token _CMP
%token _CMPSB
%token _CMPSD
%token _CMPSW
%token _CMPXCHG
%token _CMPXCHG8B
%token _CPUID
%token _CWD
%token _CWDE
%token _DAA
%token _DAS
%token _DEC
%token _DIV
%token _EMMS
%token _ENTER
%token _ESC
%token _F2XM1	
%token _FABS  
%token _FADD  
%token _FADDP 
%token _FBLD 
%token _FBSTP 
%token _FCHS
%token _FCLEX  
%token _FCMOVB
%token _FCMOVBE
%token _FCMOVE
%token _FCMOVNB
%token _FCMOVNBE
%token _FCMOVNE
%token _FCMOVNU
%token _FCMOVU
%token _FCOM  
%token _FCOMI
%token _FCOMIP
%token _FCOMP  
%token _FCOMPP 
%token _FCOS  
%token _FDECSTP  
%token _FDIV  
%token _FDIVP 
%token _FDIVR  
%token _FDIVRP 
%token _FFREE  
%token _FFREEP  // Not supported
%token _FIADD 
%token _FICOM 
%token _FICOMP 
%token _FIDIV 
%token _FIDIVR 
%token _FILD 
%token _FIMUL 
%token _FINCSTP  
%token _FINIT  
%token _FIST 
%token _FISTP 
%token _FISUB 
%token _FISUBR 
%token _FLD    
%token _FLD1  
%token _FLDCW  
%token _FLDENV 
%token _FLDL2E
%token _FLDL2T
%token _FLDLG2
%token _FLDLN2
%token _FLDPI 
%token _FLDZ  
%token _FMUL  
%token _FMULP 
%token _FNCLEX 
%token _FNINIT 
%token _FNOP   
%token _FNSAVE 
%token _FNSTCW 
%token _FNSTENV
%token _FNSTSW 
%token _FPATAN 
%token _FPREM  
%token _FPREM1  
%token _FPTAN  
%token _FRNDINT 
%token _FRSTOR 
%token _FSAVE  
%token _FSCALE  
%token _FSIN  
%token _FSINCOS 
%token _FSQRT   
%token _FST  
%token _FSTCW  
%token _FSTENV 
%token _FSTP  
%token _FSTSW  
%token _FSUB  
%token _FSUBP 
%token _FSUBR  
%token _FSUBRP 
%token _FTST  
%token _FUCOM  
%token _FUCOMI
%token _FUCOMIP
%token _FUCOMP 
%token _FUCOMPP
%token _FWAIT  
%token _FXAM  
%token _FXCH  
%token _FXTRACT 
%token _FYL2X  
%token _FYL2XP1 
%token _HLT
%token _IDIV
%token _IMUL
%token _IN
%token _INC
%token _INSB
%token _INSD
%token _INSW
%token _INT
%token _INT3
%token _INTO
%token _INVD
%token _INVLPG
%token _IRET
%token _IRETD
%token _JCXZ
%token _JECXZ
%token _JMP
%token _LAHF
%token _LAR
%token _LDS
%token _LEA
%token _LEAVE
%token _LES
%token _LFS
%token _LGDT
%token _LGS
%token _LIDT
%token _LLDT
%token _LMSW
%token _LOCK
%token _LODSB
%token _LODSD
%token _LODSW
%token _LOOP
%token _LOOPE
%token _LOOPNE
%token _LOOPNZ
%token _LOOPZ
%token _LSL
%token _LSS
%token _LTR
%token _MOV
%token _MOVD
%token _MOVQ
%token _MOVS
%token _MOVSX_B
%token _MOVZX_B
%token _MOVSX_W
%token _MOVZX_W
%token _MUL
%token _NEG
%token _NOP
%token _NOT
%token _OR
%token _OUT
%token _OUTSB
%token _OUTSD
%token _OUTSW
%token _PACKSSDW
%token _PACKSSWB
%token _PACKUSWB
%token _PADDB
%token _PADDD
%token _PADDSB
%token _PADDSW
%token _PADDUSB
%token _PADDUSW
%token _PADDW
%token _PAND
%token _PANDN
%token _PCMPEQB
%token _PCMPEQD
%token _PCMPEQW
%token _PCMPGTB
%token _PCMPGTD
%token _PCMPGTW
%token _PMADDWD
%token _PMULHW
%token _PMULLW
%token _POP
%token _POPA
%token _POPAD
%token _POPF
%token _POPFD
%token _POR
%token _PSHIMD
%token _PSHIMQ
%token _PSHIMW
%token _PSLLD
%token _PSLLQ
%token _PSLLW
%token _PSRAD
%token _PSRAW
%token _PSRLD
%token _PSRLQ
%token _PSRLW
%token _PSUBB
%token _PSUBD
%token _PSUBSB
%token _PSUBSW
%token _PSUBUSB
%token _PSUBUSW
%token _PSUBW
%token _PUNPCKHBW
%token _PUNPCKHDQ
%token _PUNPCKHWD
%token _PUNPCKLBW
%token _PUNPCKLDQ
%token _PUNPCKLWD
%token _PUSH
%token _PUSHA
%token _PUSHAD
%token _PUSHF
%token _PUSHFD
%token _PXOR
%token _RCL
%token _RCR
%token _RDMSR
%token _RDPMC
%token _RDTSC
%token _REP
%token _REPE
%token _REPZ
%token _REPNE
%token _REPNZ
%token _RET
%token _RETF
%token _ROL
%token _ROR
%token _RSM
%token _SAHF
%token _SAL
%token _SALC
%token _SAR
%token _SBB
%token _SCASB
%token _SCASD
%token _SCASW
%token _SGDT
%token _SHL
%token _SHLD
%token _SHR
%token _SHRD
%token _SIDT
%token _SLDT
%token _SMSW
%token _STC
%token _STD
%token _STI
%token _STOSB
%token _STOSD
%token _STOSW
%token _STR
%token _SUB
%token _TEST
%token _VERR
%token _VERW
%token _WAIT
%token _WBINVD
%token _WRMSR
%token _XADD
%token _XCHG
%token _XLAT
%token _XOR

//Jcc
%token _JO
%token _JNO
%token _JC
%token _JB
%token _JNAE
%token _JNC
%token _JAE
%token _JNB
%token _JE
%token _JZ
%token _JNE
%token _JNZ
%token _JBE
%token _JNA
%token _JA
%token _JNBE
%token _JS
%token _JNS
%token _JP
%token _JPE
%token _JNP
%token _JPO
%token _JL
%token _JNGE
%token _JGE
%token _JNL
%token _JLE
%token _JNG
%token _JG
%token _JNLE

//SETcc
%token _SETO    
%token _SETNO   
%token _SETB    
%token _SETNAE 
%token _SETAE  
%token _SETNB  
%token _SETE   
%token _SETZ   
%token _SETNE  
%token _SETNZ  
%token _SETBE  
%token _SETNA  
%token _SETA   
%token _SETNBE 
%token _SETS   
%token _SETNS  
%token _SETP   
%token _SETPE  
%token _SETNP  
%token _SETPO  
%token _SETL   
%token _SETNGE 
%token _SETGE  
%token _SETNL  
%token _SETLE  
%token _SETNG  
%token _SETG   
%token _SETNLE 

//CMOVcc
%token _CMOVO
%token _CMOVNO
%token _CMOVC
%token _CMOVB
%token _CMOVNAE
%token _CMOVNC
%token _CMOVAE
%token _CMOVNB
%token _CMOVE
%token _CMOVZ
%token _CMOVNE
%token _CMOVNZ
%token _CMOVBE
%token _CMOVNA
%token _CMOVA
%token _CMOVNBE
%token _CMOVS
%token _CMOVNS
%token _CMOVP
%token _CMOVPE
%token _CMOVNP
%token _CMOVPO
%token _CMOVL
%token _CMOVNGE
%token _CMOVGE
%token _CMOVNL
%token _CMOVLE
%token _CMOVNG
%token _CMOVG
%token _CMOVNLE

//Other FIXME
%token _DB
%token _DD
%token _DQ
%token _DT
%token _DW
%token _EQU
%token _FCHS   
%token _IBTS
%token _ICEBP
%token _INCBIN
%token _INT01
%token _INT1
%token _IRETW
%token _LOADALL
%token _LOADALL286
%token _POPAW
%token _POPFW
%token _PUSHAW
%token _PUSHFW
%token _RESB
%token _RESD
%token _RESQ
%token _RESW
%token _REST
%token _RESW
%token _RETF
%token _RETN
%token _SMI
%token _UMOV
%token _XBTS


%%

program:  stmtlist
            {}
;

stmtlist: stmtlist _EOL stmt
            {if ($3.flag != EMPTY) {
              H.insert(&$3);
	      }
            }
        | stmt
            {if ($1.flag != EMPTY) {
              H.insert(&$1);
             }
            }
;

stmt:     label instr
            {$$.flag = $1.flag + $2.flag;
             strcpy($$.label,$1.label);
             $$.opcode = $2.opcode;
	     $$.size = $2.size;
             strcpy($$.dest,$2.dest);
             strcpy($$.src,$2.src);
            }

        | _RESERVED
            {if (!strcmp($1.label,".data")) {
	      aligncode = 1;
             } else 
	     if (!strcmp($1.label,".text")) {
	       textRead = true;
	     }
	    }

        | _RESERVED _ID
            {if (!strcmp($1.label,".string")) {
               H.insertid($2.label,$0.label,STRLIST);
	       H.deleteid($0.label);
             } else 
	     if (!strcmp($1.label,".local")) {
               H.insertid($2.label,"",VARLIST);
             } else 
	     if (!strcmp($1.label,".zero")) {
	       result = atoi($2.label) / aligncode;
	       for (i=0;i<result;i++) {
		 H.insertdata(currentLabel,"0");
	       }
             } else 
	     if (!strcmp($1.label,".value")) {
	       H.insertdata(currentLabel,$2.label);
             } else 
	     if (!strcmp($1.label,".long")) {                
	       if (isLocalLabel(currentLabel) == false) {
	         if (strstr(currentLabel,"LC") != NULL) {
		   strcpy(tmpcpystr,currentLabel);
		   strdel(&tmpcpystr,".LC","LC");
	         } else {
		   strcpy(tmpcpystr,currentLabel);
	         }
	         tmp = H.findglobl(tmpcpystr);
  	         if (tmp != NULL) {
		   if (chknum($2.label) == true) {
		     H.insertdata(tmpcpystr,$2.label);
		   } else if (strstr($2.label,"LC") != NULL) {
		     strcpy(tmpcpystr,$2.label);
		     strdel(&tmpcpystr,".LC","LC");
		     strcpy($2.label,tmpcpystr);
		     H.insertdata(currentLabel,$2.label);
		   } 
		 } else {
		   if (strstr(currentLabel,"LC") != NULL) {
		     strcpy(tmpcpystr,currentLabel);
		     strdel(&tmpcpystr,".LC","LC");
		     H.insertid(tmpcpystr,"",GBLLIST);
		     H.setgblsize(tmpcpystr,aligncode);
		     H.insertdata(tmpcpystr,$2.label);
		   }
		 }
	       }
             } else 
	     if (!strcmp($1.label,".align")) {
	       aligncode = atoi($2.label);
	       if ((textRead == true)&&(firstStatement == true)) {
		 H.setcodealign(aligncode);
		 firstStatement = false;
	       }
             } else 
	     if (!strcmp($1.label,".globl")) {
	       aligncode = 1;
             } else 
	     if (!strcmp($1.label,".byte")) {
	       tmp = H.findglobl(currentLabel);
	       if (tmp != NULL) {
		 H.insertdata(currentLabel,$2.label);
	       }
             }
            }

        | _RESERVED _ID ',' _ID
            {if (!strcmp($1.label,".comm")) {
	      idtmp = H.findvar($2.label);
	      if (idtmp == NULL) {
		H.insertid($2.label,"",VARLIST);
	      }
	      H.setvarsize($2.label,$4.label,"1");
	     } else
	     if ((!strcmp($1.label,".type"))&&(!strcmp($4.label,"@object"))) {
               H.insertid($2.label,"",GBLLIST);
             } else 
	     if ((!strcmp($1.label,".size"))&&(chknum($4.label) == true)) {
	       H.setgblsize($2.label,aligncode);
	     } else 
	     if (!strcmp($1.label,".long")) {     
	       if (strstr(currentLabel,"LC") != NULL) {
		 strcpy(tmpcpystr,currentLabel);
		 strdel(&tmpcpystr,".LC","LC");
	       } else {
		 strcpy(tmpcpystr,currentLabel);
	       }
	       tmp = H.findglobl(tmpcpystr);
	       if (tmp != NULL) {
		 if (chknum($2.label) == true) {
		   H.insertdata(tmpcpystr,$2.label);
		 }
		 if (chknum($4.label) == true) {
		   H.insertdata(tmpcpystr,$4.label);
		 }
	       } else {
		 if (strstr(currentLabel,"LC") != NULL) {
		   strcpy(tmpcpystr,currentLabel);
		   strdel(&tmpcpystr,".LC","LC");
		   H.insertid(tmpcpystr,"",GBLLIST);
		   H.setgblsize(tmpcpystr,aligncode);
		   H.insertdata(tmpcpystr,$2.label);
		   H.insertdata(tmpcpystr,$4.label);
		 }
	       }
	     }
	    }

        | _RESERVED _ID ',' _ID ',' _ID
            {if (!strcmp($1.label,".comm")) {
	      idtmp = H.findvar($2.label);
	      if (idtmp == NULL) {
		H.insertid($2.label,"",VARLIST);
	      }
	      H.setvarsize($2.label,$4.label,$6.label);
	     }
	    }

        | _RESERVED _ID ',' _ID ',' _ID ',' _ID
            {;}

        | _RESERVED _ID ',' _ID ',' _ID ',' _ID ',' _ID
            {;}

        | _RESERVED _ID ',' _ID ',' _ID ',' _ID ',' _ID ',' _ID 
            {;}

        |
            {$$.flag = EMPTY;}
;

instr:    opcode dest ',' src
            {$$.flag = OPCODE + $2.flag + $4.flag;
             $$.opcode = $1.opcode;
	     $$.size = $1.size;
             strcpy($$.dest,$2.dest);
             strcpy($$.src,$4.src);
            }

        | opcode dest 
            {if (firstStatement == true) {
	      firstStatement = false;
	      H.setcodealign(aligncode);
	     }
	     $$.flag = OPCODE + $2.flag;
             $$.opcode = $1.opcode;
	     $$.size = $1.size;
             strcpy($$.dest,$2.dest);
             if ($1.opcode == _CALL) {
               H.insertid($2.dest,"",EXTLIST);
             }
            }
        |
            {$$.flag = EMPTY;}
;

dest:    _ID
            {$$.flag = DEST;
             strcpy($$.dest,$1.label);
            }
        |
            {$$.flag = EMPTY;}
;

src:     _ID
            {$$.flag = SRC;
             strcpy($$.src,$1.label);
            }
        |
            {$$.flag = EMPTY;}
;


label:   _ID ':'
            {strcpy(currentLabel,$1.label);
             if (strstr($1.label,".Ltext") == NULL) {
	       strcpy($$.label,$1.label);
               $$.flag = LABEL;
             }
             if (strncmp($1.label,".L",2)) {
               H.insertid($1.label,"",IDLIST);
             }
            }
        |
            {$$.flag = EMPTY;}
;


opcode :  _AAA         {$$.size = $1.size; $$.opcode = _AAA;}
        | _AAD         {$$.size = $1.size; $$.opcode = _AAD;}
        | _AAM         {$$.size = $1.size; $$.opcode = _AAM;}
	| _AAS         {$$.size = $1.size; $$.opcode = _AAS;}
	| _ADC         {$$.size = $1.size; $$.opcode = _ADC;}
	| _ADD         {$$.size = $1.size; $$.opcode = _ADD;}
	| _AND         {$$.size = $1.size; $$.opcode = _AND;}
	| _ARPL        {$$.size = $1.size; $$.opcode = _ARPL;}
	| _BOUND       {$$.size = $1.size; $$.opcode = _BOUND;}
	| _BSF         {$$.size = $1.size; $$.opcode = _BSF;}
        | _BSR         {$$.size = $1.size; $$.opcode = _BSR;}
	| _BSWAP       {$$.size = $1.size; $$.opcode = _BSWAP;}
	| _BT          {$$.size = $1.size; $$.opcode = _BT;}
	| _BTC         {$$.size = $1.size; $$.opcode = _BTC;}
	| _BTR         {$$.size = $1.size; $$.opcode = _BTR;}
	| _BTS         {$$.size = $1.size; $$.opcode = _BTS;}
	| _CALL        {$$.size = $1.size; $$.opcode = _CALL;}
	| _CBW         {$$.size = $1.size; $$.opcode = _CBW;}
	| _CDQ         {$$.size = $1.size; $$.opcode = _CDQ;}
	| _CLC         {$$.size = $1.size; $$.opcode = _CLC;}
	| _CLD         {$$.size = $1.size; $$.opcode = _CLD;}
	| _CLI         {$$.size = $1.size; $$.opcode = _CLI;}
	| _CLTS        {$$.size = $1.size; $$.opcode = _CLTS;}
	| _CMC         {$$.size = $1.size; $$.opcode = _CMC;}
	| _CMP         {$$.size = $1.size; $$.opcode = _CMP;}
	| _CMPSB       {$$.size = $1.size; $$.opcode = _CMPSB;}
	| _CMPSD       {$$.size = $1.size; $$.opcode = _CMPSD;}
	| _CMPSW       {$$.size = $1.size; $$.opcode = _CMPSW;}
	| _CMPXCHG     {$$.size = $1.size; $$.opcode = _CMPXCHG;}
	| _CMPXCHG8B   {$$.size = $1.size; $$.opcode = _CMPXCHG8B;}
	| _CPUID       {$$.size = $1.size; $$.opcode = _CPUID;}
	| _CWD         {$$.size = $1.size; $$.opcode = _CWD;}
	| _CWDE        {$$.size = $1.size; $$.opcode = _CWDE;}
	| _DAA         {$$.size = $1.size; $$.opcode = _DAA;}
	| _DAS         {$$.size = $1.size; $$.opcode = _DAS;}
	| _DEC         {$$.size = $1.size; $$.opcode = _DEC;}
	| _DIV         {$$.size = $1.size; $$.opcode = _DIV;}
	| _EMMS        {$$.size = $1.size; $$.opcode = _EMMS;}
	| _ENTER       {$$.size = $1.size; $$.opcode = _ENTER;}
        | _ESC         {$$.size = $1.size; $$.opcode = _ESC;}
        | _F2XM1       {$$.size = $1.size; $$.opcode = _F2XM1;}
        | _FABS        {$$.size = $1.size; $$.opcode = _FABS;}
        | _FADD        {$$.size = $1.size; $$.opcode = _FADD;}
        | _FADDP       {$$.size = $1.size; $$.opcode = _FADDP;}
        | _FBLD        {$$.size = $1.size; $$.opcode = _FBLD;}
        | _FBSTP       {$$.size = $1.size; $$.opcode = _FBSTP;}
        | _FCHS        {$$.size = $1.size; $$.opcode = _FCHS;}
        | _FCLEX       {$$.size = $1.size; $$.opcode = _FCLEX;}
        | _FCMOVB      {$$.size = $1.size; $$.opcode = _FCMOVB;}
        | _FCMOVBE     {$$.size = $1.size; $$.opcode = _FCMOVBE;}
        | _FCMOVE      {$$.size = $1.size; $$.opcode = _FCMOVE;}
        | _FCMOVNB     {$$.size = $1.size; $$.opcode = _FCMOVNB;}
        | _FCMOVNBE    {$$.size = $1.size; $$.opcode = _FCMOVNBE;}
        | _FCMOVNE     {$$.size = $1.size; $$.opcode = _FCMOVNE;}
        | _FCMOVNU     {$$.size = $1.size; $$.opcode = _FCMOVNU;}
        | _FCMOVU      {$$.size = $1.size; $$.opcode = _FCMOVU;}
        | _FCOM        {$$.size = $1.size; $$.opcode = _FCOM;}
        | _FCOMI       {$$.size = $1.size; $$.opcode = _FCOMI;}
        | _FCOMIP      {$$.size = $1.size; $$.opcode = _FCOMIP;}
        | _FCOMP       {$$.size = $1.size; $$.opcode = _FCOMP;}
        | _FCOMPP      {$$.size = $1.size; $$.opcode = _FCOMPP;}
        | _FCOS        {$$.size = $1.size; $$.opcode = _FCOS;} 
        | _FDECSTP     {$$.size = $1.size; $$.opcode = _FDECSTP;}  
        | _FDIV        {$$.size = $1.size; $$.opcode = _FDIV;} 
        | _FDIVP       {$$.size = $1.size; $$.opcode = _FDIVP;}
        | _FDIVR       {$$.size = $1.size; $$.opcode = _FDIVR;}
        | _FDIVRP      {$$.size = $1.size; $$.opcode = _FDIVRP;}
        | _FFREE       {$$.size = $1.size; $$.opcode = _FFREE;}
        | _FFREEP      {$$.size = $1.size; $$.opcode = _FFREEP;}   // Not supported
        | _FIADD       {$$.size = $1.size; $$.opcode = _FIADD;}
        | _FICOM       {$$.size = $1.size; $$.opcode = _FICOM;}
        | _FICOMP      {$$.size = $1.size; $$.opcode = _FICOMP;} 
        | _FIDIV       {$$.size = $1.size; $$.opcode = _FIDIV;} 
        | _FIDIVR      {$$.size = $1.size; $$.opcode = _FIDIVR;}
        | _FILD        {$$.size = $1.size; $$.opcode = _FILD;}  
        | _FIMUL       {$$.size = $1.size; $$.opcode = _FIMUL;}
        | _FINCSTP     {$$.size = $1.size; $$.opcode = _FINCSTP;} 
        | _FINIT       {$$.size = $1.size; $$.opcode = _FINIT;}
        | _FIST        {$$.size = $1.size; $$.opcode = _FIST;} 
        | _FISTP       {$$.size = $1.size; $$.opcode = _FISTP;}
        | _FISUB       {$$.size = $1.size; $$.opcode = _FISUB;}
        | _FISUBR      {$$.size = $1.size; $$.opcode = _FISUBR;}  
        | _FLD         {$$.size = $1.size; $$.opcode = _FLD;} 
        | _FLD1        {$$.size = $1.size; $$.opcode = _FLD1;}
        | _FLDCW       {$$.size = $1.size; $$.opcode = _FLDCW;}
        | _FLDENV      {$$.size = $1.size; $$.opcode = _FLDENV;} 
        | _FLDL2E      {$$.size = $1.size; $$.opcode = _FLDL2E;} 
        | _FLDL2T      {$$.size = $1.size; $$.opcode = _FLDL2T;}
        | _FLDLG2      {$$.size = $1.size; $$.opcode = _FLDLG2;}
        | _FLDLN2      {$$.size = $1.size; $$.opcode = _FLDLN2;}
        | _FLDPI       {$$.size = $1.size; $$.opcode = _FLDPI;} 
        | _FLDZ        {$$.size = $1.size; $$.opcode = _FLDZ;}
        | _FMUL        {$$.size = $1.size; $$.opcode = _FMUL;} 
        | _FMULP       {$$.size = $1.size; $$.opcode = _FMULP;} 
        | _FNCLEX      {$$.size = $1.size; $$.opcode = _FNCLEX;} 
        | _FNINIT      {$$.size = $1.size; $$.opcode = _FNINIT;} 
        | _FNOP        {$$.size = $1.size; $$.opcode = _FNOP;} 
        | _FNSAVE      {$$.size = $1.size; $$.opcode = _FNSAVE;}
        | _FNSTCW      {$$.size = $1.size; $$.opcode = _FNSTCW;}
        | _FNSTENV     {$$.size = $1.size; $$.opcode = _FNSTENV;} 
        | _FNSTSW      {$$.size = $1.size; $$.opcode = _FNSTSW;} 
        | _FPATAN      {$$.size = $1.size; $$.opcode = _FPATAN;}
        | _FPREM       {$$.size = $1.size; $$.opcode = _FPREM;} 
        | _FPREM1      {$$.size = $1.size; $$.opcode = _FPREM1;} 
        | _FPTAN       {$$.size = $1.size; $$.opcode = _FPTAN;}
        | _FRNDINT     {$$.size = $1.size; $$.opcode = _FRNDINT;}
        | _FRSTOR      {$$.size = $1.size; $$.opcode = _FRSTOR;} 
        | _FSAVE       {$$.size = $1.size; $$.opcode = _FSAVE;} 
        | _FSCALE      {$$.size = $1.size; $$.opcode = _FSCALE;} 
        | _FSIN        {$$.size = $1.size; $$.opcode = _FSIN;}
        | _FSINCOS     {$$.size = $1.size; $$.opcode = _FSINCOS;} 
        | _FSQRT       {$$.size = $1.size; $$.opcode = _FSQRT;} 
        | _FST         {$$.size = $1.size; $$.opcode = _FST;}
        | _FSTCW       {$$.size = $1.size; $$.opcode = _FSTCW;} 
        | _FSTENV      {$$.size = $1.size; $$.opcode = _FSTENV;}
        | _FSTP        {$$.size = $1.size; $$.opcode = _FSTP;}
        | _FSTSW       {$$.size = $1.size; $$.opcode = _FSTSW;}
        | _FSUB        {$$.size = $1.size; $$.opcode = _FSUB;} 
        | _FSUBP       {$$.size = $1.size; $$.opcode = _FSUBP;}
        | _FSUBR       {$$.size = $1.size; $$.opcode = _FSUBR;} 
        | _FSUBRP      {$$.size = $1.size; $$.opcode = _FSUBRP;} 
        | _FTST        {$$.size = $1.size; $$.opcode = _FTST;} 
        | _FUCOM       {$$.size = $1.size; $$.opcode = _FUCOM;} 
        | _FUCOMI      {$$.size = $1.size; $$.opcode = _FUCOMI;} 
        | _FUCOMIP     {$$.size = $1.size; $$.opcode = _FUCOMIP;} 
        | _FUCOMP      {$$.size = $1.size; $$.opcode = _FUCOMP;} 
        | _FUCOMPP     {$$.size = $1.size; $$.opcode = _FUCOMPP;}
        | _FWAIT       {$$.size = $1.size; $$.opcode = _FWAIT;} 
        | _FXAM        {$$.size = $1.size; $$.opcode = _FXAM;} 
        | _FXCH        {$$.size = $1.size; $$.opcode = _FXCH;}
        | _FXTRACT     {$$.size = $1.size; $$.opcode = _FXTRACT;} 
        | _FYL2X       {$$.size = $1.size; $$.opcode = _FYL2X;}
        | _FYL2XP1     {$$.size = $1.size; $$.opcode = _FYL2XP1;}  
	| _HLT         {$$.size = $1.size; $$.opcode = _HLT;}
	| _IDIV        {$$.size = $1.size; $$.opcode = _IDIV;}
	| _IMUL        {$$.size = $1.size; $$.opcode = _IMUL;}
	| _IN          {$$.size = $1.size; $$.opcode = _IN;}
	| _INC         {$$.size = $1.size; $$.opcode = _INC;}
	| _INSB        {$$.size = $1.size; $$.opcode = _INSB;}
	| _INSD        {$$.size = $1.size; $$.opcode = _INSD;}
	| _INSW        {$$.size = $1.size; $$.opcode = _INSW;}
	| _INT         {$$.size = $1.size; $$.opcode = _INT;}
	| _INTO        {$$.size = $1.size; $$.opcode = _INTO;}
	| _INVD        {$$.size = $1.size; $$.opcode = _INVD;}
	| _INVLPG      {$$.size = $1.size; $$.opcode = _INVLPG;}
	| _IRET        {$$.size = $1.size; $$.opcode = _IRET;}
	| _IRETD       {$$.size = $1.size; $$.opcode = _IRETD;}
	| _JCXZ        {$$.size = $1.size; $$.opcode = _JCXZ;}
	| _JECXZ       {$$.size = $1.size; $$.opcode = _JECXZ;}
	| _JMP         {$$.size = $1.size; $$.opcode = _JMP;}
	| _LAHF        {$$.size = $1.size; $$.opcode = _LAHF;}
	| _LAR         {$$.size = $1.size; $$.opcode = _LAR;}
	| _LDS         {$$.size = $1.size; $$.opcode = _LDS;}
	| _LEA         {$$.size = $1.size; $$.opcode = _LEA;}
	| _LEAVE       {$$.size = $1.size; $$.opcode = _LEAVE;}
	| _LES         {$$.size = $1.size; $$.opcode = _LES;}
	| _LFS         {$$.size = $1.size; $$.opcode = _LFS;}
	| _LGDT        {$$.size = $1.size; $$.opcode = _LGDT;}
	| _LGS         {$$.size = $1.size; $$.opcode = _LGS;}
	| _LIDT        {$$.size = $1.size; $$.opcode = _LIDT;}
	| _LLDT        {$$.size = $1.size; $$.opcode = _LLDT;}
	| _LMSW        {$$.size = $1.size; $$.opcode = _LMSW;}
        | _LOCK        {$$.size = $1.size; $$.opcode = _LOCK;}
	| _LODSB       {$$.size = $1.size; $$.opcode = _LODSB;}
	| _LODSD       {$$.size = $1.size; $$.opcode = _LODSD;}
	| _LODSW       {$$.size = $1.size; $$.opcode = _LODSW;}
	| _LOOP        {$$.size = $1.size; $$.opcode = _LOOP;}
	| _LOOPE       {$$.size = $1.size; $$.opcode = _LOOPE;}
	| _LOOPNE      {$$.size = $1.size; $$.opcode = _LOOPNE;}
	| _LOOPNZ      {$$.size = $1.size; $$.opcode = _LOOPNZ;}
	| _LOOPZ       {$$.size = $1.size; $$.opcode = _LOOPZ;}
	| _LSL         {$$.size = $1.size; $$.opcode = _LSL;}
	| _LSS         {$$.size = $1.size; $$.opcode = _LSS;}
	| _LTR         {$$.size = $1.size; $$.opcode = _LTR;}
	| _MOV         {$$.size = $1.size; $$.opcode = _MOV;}
	| _MOVD        {$$.size = $1.size; $$.opcode = _MOVD;}
	| _MOVQ        {$$.size = $1.size; $$.opcode = _MOVQ;}
        | _MOVS        {$$.size = $1.size; $$.opcode = _MOVS;}
	| _MOVSX_B     {$$.size = $1.size; $$.opcode = _MOVSX_B;}
	| _MOVZX_B     {$$.size = $1.size; $$.opcode = _MOVZX_B;}
	| _MOVSX_W     {$$.size = $1.size; $$.opcode = _MOVSX_W;}
	| _MOVZX_W     {$$.size = $1.size; $$.opcode = _MOVZX_W;}
	| _MUL         {$$.size = $1.size; $$.opcode = _MUL;}
	| _NEG         {$$.size = $1.size; $$.opcode = _NEG;}
	| _NOP         {$$.size = $1.size; $$.opcode = _NOP;}
	| _NOT         {$$.size = $1.size; $$.opcode = _NOT;}
	| _OR          {$$.size = $1.size; $$.opcode = _OR;}
	| _OUT         {$$.size = $1.size; $$.opcode = _OUT;}
	| _OUTSB       {$$.size = $1.size; $$.opcode = _OUTSB;}
	| _OUTSD       {$$.size = $1.size; $$.opcode = _OUTSD;}
	| _OUTSW       {$$.size = $1.size; $$.opcode = _OUTSW;}
	| _PACKSSDW    {$$.size = $1.size; $$.opcode = _PACKSSDW;}
	| _PACKSSWB    {$$.size = $1.size; $$.opcode = _PACKSSWB;}
	| _PACKUSWB    {$$.size = $1.size; $$.opcode = _PACKUSWB;}
	| _PADDB       {$$.size = $1.size; $$.opcode = _PADDB;}
	| _PADDD       {$$.size = $1.size; $$.opcode = _PADDD;}
	| _PADDSB      {$$.size = $1.size; $$.opcode = _PADDSB;}
	| _PADDSW      {$$.size = $1.size; $$.opcode = _PADDSW;}
	| _PADDUSB     {$$.size = $1.size; $$.opcode = _PADDUSB;}
	| _PADDUSW     {$$.size = $1.size; $$.opcode = _PADDUSW;}
	| _PADDW       {$$.size = $1.size; $$.opcode = _PADDW;}
	| _PAND        {$$.size = $1.size; $$.opcode = _PAND;}
	| _PANDN       {$$.size = $1.size; $$.opcode = _PANDN;}
	| _PCMPEQB     {$$.size = $1.size; $$.opcode = _PCMPEQB;}
	| _PCMPEQD     {$$.size = $1.size; $$.opcode = _PCMPEQD;}
	| _PCMPEQW     {$$.size = $1.size; $$.opcode = _PCMPEQW;}
	| _PCMPGTB     {$$.size = $1.size; $$.opcode = _PCMPGTB;}
	| _PCMPGTD     {$$.size = $1.size; $$.opcode = _PCMPGTD;}
	| _PCMPGTW     {$$.size = $1.size; $$.opcode = _PCMPGTW;}
	| _PMADDWD     {$$.size = $1.size; $$.opcode = _PMADDWD;}
	| _PMULHW      {$$.size = $1.size; $$.opcode = _PMULHW;}
	| _PMULLW      {$$.size = $1.size; $$.opcode = _PMULLW;}
	| _POP         {$$.size = $1.size; $$.opcode = _POP;}
	| _POPA        {$$.size = $1.size; $$.opcode = _POPA;}
	| _POPAD       {$$.size = $1.size; $$.opcode = _POPAD;}
	| _POPF        {$$.size = $1.size; $$.opcode = _POPF;}
	| _POPFD       {$$.size = $1.size; $$.opcode = _POPFD;}
	| _POR         {$$.size = $1.size; $$.opcode = _POR;}
        | _PSHIMW      {$$.size = $1.size; $$.opcode = _PSHIMW;}
        | _PSHIMD      {$$.size = $1.size; $$.opcode = _PSHIMD;}
        | _PSHIMQ      {$$.size = $1.size; $$.opcode = _PSHIMQ;}
	| _PSLLD       {$$.size = $1.size; $$.opcode = _PSLLD;}
	| _PSLLQ       {$$.size = $1.size; $$.opcode = _PSLLQ;}
	| _PSLLW       {$$.size = $1.size; $$.opcode = _PSLLW;}
	| _PSRAD       {$$.size = $1.size; $$.opcode = _PSRAD;}
	| _PSRAW       {$$.size = $1.size; $$.opcode = _PSRAW;}
	| _PSRLD       {$$.size = $1.size; $$.opcode = _PSRLD;}
	| _PSRLQ       {$$.size = $1.size; $$.opcode = _PSRLQ;}
	| _PSRLW       {$$.size = $1.size; $$.opcode = _PSRLW;}
	| _PSUBB       {$$.size = $1.size; $$.opcode = _PSUBB;}
	| _PSUBD       {$$.size = $1.size; $$.opcode = _PSUBD;}
	| _PSUBSB      {$$.size = $1.size; $$.opcode = _PSUBSB;}
	| _PSUBSW      {$$.size = $1.size; $$.opcode = _PSUBSW;}
	| _PSUBUSB     {$$.size = $1.size; $$.opcode = _PSUBUSB;}
	| _PSUBUSW     {$$.size = $1.size; $$.opcode = _PSUBUSW;}
	| _PSUBW       {$$.size = $1.size; $$.opcode = _PSUBW;}
	| _PUNPCKHBW   {$$.size = $1.size; $$.opcode = _PUNPCKHBW;}
	| _PUNPCKHDQ   {$$.size = $1.size; $$.opcode = _PUNPCKHDQ;}
	| _PUNPCKHWD   {$$.size = $1.size; $$.opcode = _PUNPCKHWD;}
	| _PUNPCKLBW   {$$.size = $1.size; $$.opcode = _PUNPCKLBW;}
	| _PUNPCKLDQ   {$$.size = $1.size; $$.opcode = _PUNPCKLDQ;}
	| _PUNPCKLWD   {$$.size = $1.size; $$.opcode = _PUNPCKLWD;}
	| _PUSH        {$$.size = $1.size; $$.opcode = _PUSH;}
	| _PUSHA       {$$.size = $1.size; $$.opcode = _PUSHA;}
	| _PUSHAD      {$$.size = $1.size; $$.opcode = _PUSHAD;}
	| _PUSHF       {$$.size = $1.size; $$.opcode = _PUSHF;}
	| _PUSHFD      {$$.size = $1.size; $$.opcode = _PUSHFD;}
	| _PXOR        {$$.size = $1.size; $$.opcode = _PXOR;}
	| _RCL         {$$.size = $1.size; $$.opcode = _RCL;}
	| _RCR         {$$.size = $1.size; $$.opcode = _RCR;}
	| _RDMSR       {$$.size = $1.size; $$.opcode = _RDMSR;}
	| _RDTSC       {$$.size = $1.size; $$.opcode = _RDTSC;}
        | _REP         {$$.size = $1.size; $$.opcode = _REP;}
        | _REPE        {$$.size = $1.size; $$.opcode = _REPE;}
        | _REPZ        {$$.size = $1.size; $$.opcode = _REPZ;}
        | _REPNE       {$$.size = $1.size; $$.opcode = _REPNE;}
        | _REPNZ       {$$.size = $1.size; $$.opcode = _REPNZ;}
	| _RET         {$$.size = $1.size; $$.opcode = _RET;}
        | _RETF        {$$.size = $1.size; $$.opcode = _RETF;}
	| _ROL         {$$.size = $1.size; $$.opcode = _ROL;}
	| _ROR         {$$.size = $1.size; $$.opcode = _ROR;}
	| _RSM         {$$.size = $1.size; $$.opcode = _RSM;}
	| _SAHF        {$$.size = $1.size; $$.opcode = _SAHF;}
	| _SAL         {$$.size = $1.size; $$.opcode = _SAL;}
	| _SALC        {$$.size = $1.size; $$.opcode = _SALC;}
	| _SAR         {$$.size = $1.size; $$.opcode = _SAR;}
	| _SBB         {$$.size = $1.size; $$.opcode = _SBB;}
	| _SCASB       {$$.size = $1.size; $$.opcode = _SCASB;}
	| _SCASD       {$$.size = $1.size; $$.opcode = _SCASD;}
	| _SCASW       {$$.size = $1.size; $$.opcode = _SCASW;}
	| _SGDT        {$$.size = $1.size; $$.opcode = _SGDT;}
	| _SHL         {$$.size = $1.size; $$.opcode = _SHL;}
	| _SHLD        {$$.size = $1.size; $$.opcode = _SHLD;}
	| _SHR         {$$.size = $1.size; $$.opcode = _SHR;}
	| _SHRD        {$$.size = $1.size; $$.opcode = _SHRD;}
	| _SIDT        {$$.size = $1.size; $$.opcode = _SIDT;}
	| _SLDT        {$$.size = $1.size; $$.opcode = _SLDT;}
	| _SMSW        {$$.size = $1.size; $$.opcode = _SMSW;}
	| _STC         {$$.size = $1.size; $$.opcode = _STC;}
	| _STD         {$$.size = $1.size; $$.opcode = _STD;}
	| _STI         {$$.size = $1.size; $$.opcode = _STI;}
	| _STOSB       {$$.size = $1.size; $$.opcode = _STOSB;}
	| _STOSD       {$$.size = $1.size; $$.opcode = _STOSD;}
	| _STOSW       {$$.size = $1.size; $$.opcode = _STOSW;}
	| _STR         {$$.size = $1.size; $$.opcode = _STR;}
	| _SUB         {$$.size = $1.size; $$.opcode = _SUB;}
	| _TEST        {$$.size = $1.size; $$.opcode = _TEST;}
	| _VERR        {$$.size = $1.size; $$.opcode = _VERR;}
	| _VERW        {$$.size = $1.size; $$.opcode = _VERW;}
	| _WAIT        {$$.size = $1.size; $$.opcode = _WAIT;}
	| _WBINVD      {$$.size = $1.size; $$.opcode = _WBINVD;}
	| _WRMSR       {$$.size = $1.size; $$.opcode = _WRMSR;}
	| _XADD        {$$.size = $1.size; $$.opcode = _XADD;}
	| _XCHG        {$$.size = $1.size; $$.opcode = _XCHG;}
	| _XLAT        {$$.size = $1.size; $$.opcode = _XLAT;}
	| _XOR         {$$.size = $1.size; $$.opcode = _XOR;}

	| _JO          {$$.size = $1.size; $$.opcode = _JO;}
	| _JNO         {$$.size = $1.size; $$.opcode = _JNO;}
	| _JC          {$$.size = $1.size; $$.opcode = _JC;}
	| _JB          {$$.size = $1.size; $$.opcode = _JB;}
	| _JNAE        {$$.size = $1.size; $$.opcode = _JNAE;}
	| _JNC         {$$.size = $1.size; $$.opcode = _JNC;}
	| _JAE         {$$.size = $1.size; $$.opcode = _JAE;}
	| _JNB         {$$.size = $1.size; $$.opcode = _JNB;}
	| _JE          {$$.size = $1.size; $$.opcode = _JE;}
	| _JZ          {$$.size = $1.size; $$.opcode = _JZ;}
	| _JNE         {$$.size = $1.size; $$.opcode = _JNE;}
	| _JNZ         {$$.size = $1.size; $$.opcode = _JNZ;}
	| _JBE         {$$.size = $1.size; $$.opcode = _JBE;}
	| _JNA         {$$.size = $1.size; $$.opcode = _JNA;}
	| _JA          {$$.size = $1.size; $$.opcode = _JA;}
	| _JNBE        {$$.size = $1.size; $$.opcode = _JNBE;}
	| _JS          {$$.size = $1.size; $$.opcode = _JS;}
	| _JNS         {$$.size = $1.size; $$.opcode = _JNS;}
	| _JP          {$$.size = $1.size; $$.opcode = _JP;}
	| _JPE         {$$.size = $1.size; $$.opcode = _JPE;}
	| _JNP         {$$.size = $1.size; $$.opcode = _JNP;}
	| _JPO         {$$.size = $1.size; $$.opcode = _JPO;}
	| _JL          {$$.size = $1.size; $$.opcode = _JL;}
	| _JNGE        {$$.size = $1.size; $$.opcode = _JNGE;}
	| _JGE         {$$.size = $1.size; $$.opcode = _JGE;}
	| _JNL         {$$.size = $1.size; $$.opcode = _JNL;}
	| _JLE         {$$.size = $1.size; $$.opcode = _JLE;}
	| _JNG         {$$.size = $1.size; $$.opcode = _JNG;}
	| _JG          {$$.size = $1.size; $$.opcode = _JG;}
	| _JNLE        {$$.size = $1.size; $$.opcode = _JNLE;}

	| _SETO        {$$.size = $1.size; $$.opcode = _SETO;}
	| _SETNO       {$$.size = $1.size; $$.opcode = _SETNO;}
	| _SETB        {$$.size = $1.size; $$.opcode = _SETB;}
	| _SETNAE      {$$.size = $1.size; $$.opcode = _SETNAE;}
	| _SETAE       {$$.size = $1.size; $$.opcode = _SETAE;}
	| _SETNB       {$$.size = $1.size; $$.opcode = _SETNB;}
	| _SETE        {$$.size = $1.size; $$.opcode = _SETE;}
	| _SETZ        {$$.size = $1.size; $$.opcode = _SETZ;}
	| _SETNE       {$$.size = $1.size; $$.opcode = _SETNE;}
	| _SETNZ       {$$.size = $1.size; $$.opcode = _SETNZ;}
	| _SETBE       {$$.size = $1.size; $$.opcode = _SETBE;}
	| _SETNA       {$$.size = $1.size; $$.opcode = _SETNA;}
	| _SETA        {$$.size = $1.size; $$.opcode = _SETA;}
	| _SETNBE      {$$.size = $1.size; $$.opcode = _SETNBE;}
	| _SETS        {$$.size = $1.size; $$.opcode = _SETS;}
	| _SETNS       {$$.size = $1.size; $$.opcode = _SETNS;}
	| _SETP        {$$.size = $1.size; $$.opcode = _SETP;}
	| _SETPE       {$$.size = $1.size; $$.opcode = _SETPE;}
	| _SETNP       {$$.size = $1.size; $$.opcode = _SETNP;}
	| _SETPO       {$$.size = $1.size; $$.opcode = _SETPO;}
	| _SETL        {$$.size = $1.size; $$.opcode = _SETL;}
	| _SETNGE      {$$.size = $1.size; $$.opcode = _SETNGE;}
	| _SETGE       {$$.size = $1.size; $$.opcode = _SETGE;}
	| _SETNL       {$$.size = $1.size; $$.opcode = _SETNL;}
	| _SETLE       {$$.size = $1.size; $$.opcode = _SETLE;}
	| _SETNG       {$$.size = $1.size; $$.opcode = _SETNG;}
	| _SETG        {$$.size = $1.size; $$.opcode = _SETG;}
	| _SETNLE      {$$.size = $1.size; $$.opcode = _SETNLE;}

	| _CMOVO       {$$.size = $1.size; $$.opcode = _CMOVO;}
	| _CMOVNO      {$$.size = $1.size; $$.opcode = _CMOVNO;}
	| _CMOVC       {$$.size = $1.size; $$.opcode = _CMOVC;}
	| _CMOVB       {$$.size = $1.size; $$.opcode = _CMOVB;}
	| _CMOVNAE     {$$.size = $1.size; $$.opcode = _CMOVNAE;}
	| _CMOVNC      {$$.size = $1.size; $$.opcode = _CMOVNC;}
	| _CMOVAE      {$$.size = $1.size; $$.opcode = _CMOVAE;}
	| _CMOVNB      {$$.size = $1.size; $$.opcode = _CMOVNB;}
	| _CMOVE       {$$.size = $1.size; $$.opcode = _CMOVE;}
	| _CMOVZ       {$$.size = $1.size; $$.opcode = _CMOVZ;}
	| _CMOVNE      {$$.size = $1.size; $$.opcode = _CMOVNE;}
	| _CMOVNZ      {$$.size = $1.size; $$.opcode = _CMOVNZ;}
	| _CMOVBE      {$$.size = $1.size; $$.opcode = _CMOVBE;}
	| _CMOVNA      {$$.size = $1.size; $$.opcode = _CMOVNA;}
	| _CMOVA       {$$.size = $1.size; $$.opcode = _CMOVA;}
	| _CMOVNBE     {$$.size = $1.size; $$.opcode = _CMOVNBE;}
	| _CMOVS       {$$.size = $1.size; $$.opcode = _CMOVS;}
	| _CMOVNS      {$$.size = $1.size; $$.opcode = _CMOVNS;}
	| _CMOVP       {$$.size = $1.size; $$.opcode = _CMOVP;}
	| _CMOVPE      {$$.size = $1.size; $$.opcode = _CMOVPE;}
	| _CMOVNP      {$$.size = $1.size; $$.opcode = _CMOVNP;}
	| _CMOVPO      {$$.size = $1.size; $$.opcode = _CMOVPO;}
	| _CMOVL       {$$.size = $1.size; $$.opcode = _CMOVL;}
	| _CMOVNGE     {$$.size = $1.size; $$.opcode = _CMOVNGE;}
	| _CMOVGE      {$$.size = $1.size; $$.opcode = _CMOVGE;}
	| _CMOVNL      {$$.size = $1.size; $$.opcode = _CMOVNL;}
	| _CMOVLE      {$$.size = $1.size; $$.opcode = _CMOVLE;}
	| _CMOVNG      {$$.size = $1.size; $$.opcode = _CMOVNG;}
	| _CMOVG       {$$.size = $1.size; $$.opcode = _CMOVG;}
	| _CMOVNLE     {$$.size = $1.size; $$.opcode = _CMOVNLE;}

	| _DB          {$$.size = $1.size; $$.opcode = EMPTY;}
	| _DD          {$$.size = $1.size; $$.opcode = EMPTY;}
	| _DQ          {$$.size = $1.size; $$.opcode = EMPTY;}
	| _DT          {$$.size = $1.size; $$.opcode = EMPTY;}
	| _DW          {$$.size = $1.size; $$.opcode = EMPTY;}
	| _EQU         {$$.size = $1.size; $$.opcode = EMPTY;}
	| _RESB        {$$.size = $1.size; $$.opcode = EMPTY;}
	| _RESD        {$$.size = $1.size; $$.opcode = EMPTY;}
	| _RESQ        {$$.size = $1.size; $$.opcode = EMPTY;}
	| _REST        {$$.size = $1.size; $$.opcode = EMPTY;}
	| _RESW        {$$.size = $1.size; $$.opcode = EMPTY;}

	| _IBTS        {$$.size = $1.size; $$.opcode = EMPTY;}
	| _ICEBP       {$$.size = $1.size; $$.opcode = EMPTY;}
	| _INCBIN      {$$.size = $1.size; $$.opcode = EMPTY;}
	| _INT1        {$$.size = $1.size; $$.opcode = EMPTY;}
	| _INT01       {$$.size = $1.size; $$.opcode = EMPTY;}
	| _INT3        {$$.size = $1.size; $$.opcode = EMPTY;}
	| _IRETW       {$$.size = $1.size; $$.opcode = EMPTY;}
	| _LOADALL     {$$.size = $1.size; $$.opcode = EMPTY;}
	| _LOADALL286  {$$.size = $1.size; $$.opcode = EMPTY;}
	| _POPAW       {$$.size = $1.size; $$.opcode = EMPTY;}
	| _POPFW       {$$.size = $1.size; $$.opcode = EMPTY;}
	| _PUSHAW      {$$.size = $1.size; $$.opcode = EMPTY;}
	| _PUSHFW      {$$.size = $1.size; $$.opcode = EMPTY;}
	| _RDPMC       {$$.size = $1.size; $$.opcode = EMPTY;}
	| _RETN        {$$.size = $1.size; $$.opcode = EMPTY;}
	| _SMI         {$$.size = $1.size; $$.opcode = EMPTY;}
	| _UMOV        {$$.size = $1.size; $$.opcode = EMPTY;}
	| _XBTS        {$$.size = $1.size; $$.opcode = EMPTY;}

;

%%

int main(int argc, char *argv[])
{
  char in[80];
  char out[80];
  char *tmpstr = new char[MaxSize];
  int  tmpint;
  extern FILE *yyin, *yyout;
  int  outputformat = GAS;   // Default : GAS format output
  int  option = PENTIUM;     // Default : Optimize to Pentium
                             //         : Without MMX instructions

  if (!tmpstr) alloc_error();

  if ((argc < 2)||(argc > 4)) {
     cout << "Optimizer v" << VERSION << " :\n\n";
     cout << "Usage: optimizer [-g|-n] [-I486|-P5|-P5MMX|-P6|-PII] <inputfile>\n\n";
     cout << "       -g     : GAS format output (Default)\n";
     cout << "       -n     : NASM format output\n\n";
     cout << "       -I486  : No optimization\n";
     cout << "       -P5    : Optimize to Pentium (Default)\n";
     cout << "       -P5MMX : Optimize to Pentium MMX\n";
     cout << "       -P6    : Optimize to Pentium Pro\n";
     cout << "       -PII   : Optimize to Pentium II\n\n";
     cout << "       where <inputfile> is : 'filename' or 'filename.s'\n";
     delete[] tmpstr;
     delete[] currentLabel;
     return 0;
  }
  in[0] = '\0';
  out[0] = '\0';
  
  for (tmpint=1; tmpint<argc; tmpint++) {
    if (strstr(argv[tmpint],"-g") != NULL) {
       outputformat = GAS;
    } else
    if (strstr(argv[tmpint],"-n") != NULL) {
       outputformat = NASM;
    } else
    if (strstr(argv[tmpint],"-I486") != NULL) {
       option = I486;
    } else
    if (strstr(argv[tmpint],"-P5") != NULL) {
       option = PENTIUM;
    } else
    if (strstr(argv[tmpint],"-P5MMX") != NULL) {
       option = PENTIUMMMX;
    } else
    if (strstr(argv[tmpint],"-P6") != NULL) {
       option = PENTIUMPRO;
    } else
    if (strstr(argv[tmpint],"-PII") != NULL) {
       option = PENTIUMII;
    } else {
       strcpy(in,argv[tmpint]);
    }
  }
  if (!strcmp(in,"")) {
    cout << "optimizer v" << VERSION << ": No input file given." << endl;
    delete[] tmpstr;
    delete[] currentLabel;
    delete[] tmpcpystr;
    return 1;
  }

// -----------------------------------------------------  
  if (outputformat == GAS) {       // GNU Assembler part
    if (strstr(in,".s") == NULL) {
       strcat(in,".s");
    };
    strcpy(out,in);  

    yyin = fopen(in,"rb");
    if (yyin == NULL) {
      cout << "optimizer v" << VERSION << ": Can't open " << in << endl;
      delete[] tmpstr;
      delete[] currentLabel;
      delete[] tmpcpystr;
      return 1;
    };

    rewind(yyin);
    strcpy(tmpstr,"");
    fgets(tmpstr,MaxSize-1,yyin);
    if (strstr(tmpstr,"// Optimizer v") != NULL) {
      cout << "optimizer v" << VERSION << ": This file has already been optimized by optimizer." << endl;
      delete[] tmpstr;
      delete[] currentLabel;
      delete[] tmpcpystr;
      return 1;
    }
    rewind(yyin);

    H.loadFile();
    remove(in);

    yyout = fopen(out,"wb");
    if (yyout == NULL) {
      cout << "optimizer v" << VERSION << ": Can't open " << out << endl;
      delete[] tmpstr;
      delete[] currentLabel;
      delete[] tmpcpystr;
      return 1;
    };

    rewind(yyout);

    if (option == I486) {
       // Do nothing
    } else if (option == PENTIUM) {
       H.GASoptP5();
    } else if (option == PENTIUMMMX) {
       H.GASoptP5();
       H.GASoptMMX();
    } else if (option == PENTIUMPRO) {
       H.GASoptP6();
    } else if (option == PENTIUMII){
       H.GASoptP6();
       H.GASoptMMX();
    } else {
       yyerror("Error in parameters");
    };

    H.saveFile();
// ------------------------------------------------------
  } else {                         // NASM Assembler part
    if (strstr(in,".s") == NULL) {
       strcpy(out,in);
       strcat(in,".s");
       strcat(out,".asm");
    } else {
       tmpint = strlen(in);
       strncpy(out,in,tmpint-2);
       out[tmpint-2] = '\0';
       strcpy(in,out);
       strcat(in,".s");
       strcat(out,".asm");
    };

    yyin = fopen(in,"rb");
    yyout = fopen(out,"wb");

    if (yyout == NULL) {
      cout << "optimizer v" << VERSION << ": Can't open " << out << endl;
      delete[] tmpstr;
      delete[] currentLabel;
      delete[] tmpcpystr;
      return 1;
    };

    if (yyin == NULL) {
      cout << "optimizer v" << VERSION << ": Can't open " << in << endl;
      remove(out);
      delete[] tmpstr;
      delete[] currentLabel;
      delete[] tmpcpystr;
      return 1;
    };

    rewind(yyin);
    strcpy(tmpstr,"");
    fgets(tmpstr,MaxSize-1,yyin);
    if (strstr(tmpstr,"// Optimizer v") != NULL) {
      cout << "optimizer v" << VERSION << ": This file has already been optimized by optimizer." << endl;
      delete[] tmpstr;
      delete[] currentLabel;
      delete[] tmpcpystr;
      return 1;
    }
    rewind(yyin);

    rewind(yyout);
#ifdef DEBUG
    yydebug = 1;
#endif
    yyparse();

    H.cleanup();
    H.switchstr();
    H.notation();
    H.change();

    if (option == I486) {
       // Do nothing
    } else if (option == PENTIUM) {
       H.optP5();
    } else if (option == PENTIUMMMX) {
       H.optP5();
       H.optMMX();
    } else if (option == PENTIUMPRO) {
       H.optP6();
    } else if (option == PENTIUMII){
       H.optP6();
       H.optMMX();
    } else {
       yyerror("Error in parameters");
    };

#ifdef DEBUG
    H.printAll(ALL);
#endif
    H.header();
    H.tofile();
    H.footer();
  };

  fclose(yyin);
  fclose(yyout);

  delete[] tmpstr;
  delete[] currentLabel;
  delete[] tmpcpystr;
};
