#include <string.h>
#include <stdio.h>
#include <GL/glut.h>
#include <GL/gl.h>


/* Fensterparameter */
#define WIDTH  600
#define HEIGHT 600
#define TITLE  "GLUT Demo: Using Subwindows"
int winIdMain;
int winIdSub;


/* Animation State Vriables */
#define SMALL_ANGLE  5.0
#define TIME_STEP    0.1
static double time = 0.0;
static double spin = 0.0;

/* Diese Funktion rendert eine Zeichenkette
   an der aktuellen Position
 */
static char label[100];

void 
drawString (char *s)
{
  unsigned int i;
  for (i = 0; i < strlen (s); i++)
    glutBitmapCharacter (GLUT_BITMAP_HELVETICA_10, s[i]);
};

void 
drawStringBig (char *s)
{
  unsigned int i;
  for (i = 0; i < strlen (s); i++)
    glutBitmapCharacter (GLUT_BITMAP_HELVETICA_18, s[i]);
};

/*
  Die Displayfunktion aktualisiert das 
  (haupt) Grafikfenster
 */
void 
mainDisplay (void)
{

  /* Loeschen des Zeichenfensters */
  /* Clean drawing board */
  glutSetWindow (winIdMain);
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity ();

  /* Schreibe Fussnote */
  glColor3f (1.0F, 1.0F, 1.0F);
  sprintf (label, "(c)Miguel Angel Sepulveda 1998");
  glRasterPos2f (-0.80F, -0.80F);
  drawString (label);


  /* Zeichne das rotierende Dreieck */
  glPushMatrix ();
  glRotatef (spin, 0.0, 0.0, 1.0);
  glBegin (GL_POLYGON);
  glColor3f (1.0F, 0.0F, 0.0F);
  glVertex2f (0.0F, 0.5F);
  glColor3f (0.0F, 1.0F, 0.0F);
  glVertex2f (-0.4330F, -0.25F);
  glColor3f (0.0F, 0.0F, 1.0F);
  glVertex2f (0.433F, -0.25F);
  glEnd ();
  glPopMatrix ();

  glutSwapBuffers ();
};


/*
  Eine andere Displayfunktion, die verwendet wird 
  zur Aktualisierung der Grafik Subfenster
*/
void 
subDisplay ()
{

  /* Loesche das Subfenster */
  glutSetWindow (winIdSub);
  glClearColor (0.25, 0.25, 0.25, 0.0);
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  /* Zeichne den Rahmen */
  glColor3f (0.0F, 1.0F, 0.0F);
  glBegin (GL_LINE_LOOP);
  glVertex2f (0.0F, 0.0F);
  glVertex2f (0.0F, 0.99F);
  glVertex2f (0.999F, 0.99F);
  glVertex2f (0.999F, 0.0F);
  glEnd ();

  /* Gebe einige Statusvariablen aus */
  glColor3f (1.0F, 1.0F, 1.0F);
  sprintf (label, "Zeit = %8.3f ", time);
  glRasterPos2f (0.05F, 0.75F);
  drawString (label);

  sprintf (label, "Drehwinkel = %8.3f ", spin);
  glRasterPos2f (0.05F, 0.55F);
  drawString (label);

  sprintf (label, "Drehgeschwindigkeit = %8.3f ", spin / time);
  glRasterPos2f (0.05F, 0.35F);
  drawString (label);

  /* Gebe das Banner and weitere Informationen aus */
  glColor3f (1.0F, 0.0F, 1.0F);
  sprintf (label, " Dieses ist ein Subfenster ");
  glRasterPos2f (0.40F, 0.70F);
  drawStringBig (label);

  sprintf (label, " Es besitzt einen eigenen OpenGL Kontext ");
  glRasterPos2f (0.33F, 0.35F);
  drawStringBig (label);

  glutSwapBuffers ();
};


/* Rueckruf (callback) Funktion fuer das Zeichnen des Hauptfensters */
void 
mainReshape (int w, int h)
{
  glViewport (0, 0, w, h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (-1.0F, 1.0F, -1.0F, 1.0F);
  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();

  glutSetWindow (winIdSub);
  glutReshapeWindow (w - 10, h / 10);
  glutPositionWindow (5, 5);
  glutSetWindow (winIdMain);

};

/* Rueckruf (callback) Funktion fuer das Zeichnen des Subfensters */
void 
subReshape (int w, int h)
{
  glViewport (0, 0, w, h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (0.0F, 1.0F, 0.0F, 1.0F);
};

/* Diese Funktion wertet die Tastendruecke aus */
void 
keyboard (unsigned char key, int x, int y)
{
  static int info_banner = 1;

  switch (key)
    {
    case 'i':
    case 'I':
      if (info_banner)
	{
	  glutSetWindow (winIdSub);
	  glutHideWindow ();
	}
      else
	{
	  glutSetWindow (winIdSub);
	  glutShowWindow ();
	};
      info_banner = !info_banner;
      break;
    case 'q':
    case 'Q':
      exit (0);
      break;
    };
};



/*
  Es kann nur eine idle() Rueckruf (callback) Funktion geben.
  Bei einer Animation muss die idle() Funktion sowohl das 
  Hauptfenster als auch alle untergeordneten Unterfenster aktualisieren.
 */
void 
idle (void)
{

  /* Aktualisiere die Statusvariablen */
  spin += SMALL_ANGLE;
  time += TIME_STEP;

  /* Aktualisiere das Haupt- und Subfenster */
  glutSetWindow (winIdMain);
  glutPostRedisplay ();
  glutSetWindow (winIdSub);
  glutPostRedisplay ();
};




int 
main (int argc, char **argv)
{

  /* Initialisier die Glut-Bibliothek  */
  glutInit (&argc, argv);
  glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH);
  glutInitWindowPosition (5, 5);
  glutInitWindowSize (WIDTH, HEIGHT);

  /* Erzeuge und initialisiere das Hauptfenster */
  winIdMain = glutCreateWindow (TITLE);
  glutDisplayFunc (mainDisplay);
  glutReshapeFunc (mainReshape);
  glutKeyboardFunc (keyboard);
  glutIdleFunc (idle);

  /* Erzeuge und initialisiere das Subfenster */
  winIdSub = glutCreateSubWindow (winIdMain, 5, 5, WIDTH - 10, HEIGHT / 10);
  glutDisplayFunc (subDisplay);
  glutReshapeFunc (subReshape);

  glutMainLoop ();

  return 0;
};
