/* "mainwindow.c"
 *	Has all the widget management routines for the
 *	main-window english/widget widgets.
 */

#include <stdio.h>
#include <stdlib.h>

#include <ctype.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>

#include "defs.h"
#include "game.h"
#include "widgets.h"
#include "externs.h"

/* BackCallback:
 *	go back to last kanji.
 *  Has to be in game.c, to access static vars
 */
void BackCallback(Widget w,XtPointer client_data,XtPointer call_data)
{
	int buffer;

	if(lastpicked == 0) return;

	buffer= values[truevalue];
	values[truevalue] = lastpicked;
	lastpicked = buffer;

	setstatus("Going to previous character");
	printallkanji();
	printallenglish();
	DescribeCurrent(values[truevalue]);
	
}

/* changemode:
 *   change from guessing kanji to guessing english, or vica verse,
 *	by clicking on the appropriate button
 *
 *   Also handles changing from english <->kana display,
 *   calling CountKanji(), because we have to .
 */
void ChangeMode(Widget w,XtPointer data,XtPointer calldata)
{
	/* whichbutton is
	 * EITHER
	 *    [mode 4kanji]<->[mode 4english] button,
	 * OR
	 *   [change  kana<->english]
	 */
	int whichbutton = (int) data;
#ifdef DEBUG
	printf("button mode change: %d\n",whichbutton);
#endif
	switch(whichbutton){
		case GUESSMEANING:
		case GUESSKANJI:
			if(Kanji2English == whichbutton)
				return;
			Kanji2English = whichbutton;
			if(switchKanaEnglish){ /* allow switching in place */
				printallkanji();
				printallenglish();
			} else {
				SetupGuess();
			}
			switch(Kanji2English){
				case GUESSKANJI:
					XtSetSensitive(kanjimode,False);
					XtSetSensitive(englishmode,True);
					break;
				case GUESSMEANING:
					XtSetSensitive(kanjimode,True);
					XtSetSensitive(englishmode,False);
					break;
			}
			break;
		case TOGGLEKANA:
#ifdef DEBUG
			puts("We toggle kana/english now");
#endif
			showEnglish = !showEnglish;
			if(switchKanaEnglish){
				printallenglish();
			} else {
				CountKanji();
				SetupGuess();
			}
			
			break;
	}
}

/* Guessvalue:
 *	accelerator function so we can guess with 1,2,3,4 keys
 *	NOTE:
 *	we get passed the value (key-1)
 */
/* note that "-1" means "default due to time" */
void Guessvalue(Widget w,XEvent *event,String *params,Cardinal *num_parags){
	int value;
	value = atoi(*params);
	if(value >=NUMBEROFCHOICES) return;
	guessvalue(value);
}

/*
 *handles top four kanji buttons at top
 */
void kanjicallback(Widget w,XtPointer data,XtPointer calldata)
{
	if(Kanji2English != GUESSMEANING)
		return;
	guessvalue((int) data);
}

void cheatcallback(Widget w,XtPointer data,XtPointer calldata){
	if(Kanji2English == GUESSKANJI){
		ReverseButton(englishWidget[truevalue]);
	} else {
		ReverseButton(kanjiWidget[truevalue]);
	}
	setstatus("Try Harder!");
}

/* englishcallback:
 *	Handles clicking on "english" widgets.
 *	Only really neccessary if we are guessing the meaning of a
 *	kanji character
 */
void englishcallback(Widget w,XtPointer data,XtPointer calldata)
{
	if(Kanji2English!= GUESSKANJI)
		return;
	guessvalue((int) data);
}

