#include "cthugha.h"
#include "information.h"

#include <stdio.h>


void title() {

    printfv(0,"--------------------------------------------------------------------------------\n");
    printfv(0,"---                         C T H U G H A - L  1.1a                          ---\n");
    printfv(0,"--------------------------------------------------------------------------------\n");
    printfv(0,"Compiled on %s %s\n", __DATE__, __TIME__);
    printfv(0,"--------------------------------------------------------------------------------\n");
    printfv(0," by Harald Deischinger <k3096e5@c210.edvz.uni-linz.ac.at>\n");
    printfv(0,"    Am Edhuegel 45\n");
    printfv(0,"    4115  Kleinzell\n");
    printfv(0,"    AUSTRIA\n");
    printfv(0," www: http://www.geocities.com/CapeCanaveral/Lab/6386\n");
    printfv(0,"--------------------------------------------------------------------------------\n");
    printfv(0,"Original Program (CTHUGHA V5.1 and V5.3)\n");
    printfv(0,"  Coded by - Torps Productions: The Digital Aasvogel Group - 1995\n"); 
    printfv(0,"  Original Idea & Code:          Kevin Burfitt (zaph@torps.apana.org.au)\n"); 
    printfv(0,"--------------------------------------------------------------------------------\n");
    printfv(0,"Cthugha WWW-Page:            http://www.afn.org/~cthugha\n");
    printfv(0,"Cthugha newsgroup:           alt.graphics.cthugha\n");
    printfv(0,"--------------------------------------------------------------------------------\n");
    printfv(0,"\n");
    fflush(stdout);
}


void usage() {
    printfv(0,
	    "Cthugha command line options:\n"
	    "-----------------------------\n"
	    "Sound and CD options:                                                          \n"
	    " -L, --line VOL      Use Line In as input with volume VOL      <current active>\n"
	    " -M, --mic VOL       Use Mic as input with volume VOL          <current active>\n"
	    " -C, --cd VOL        Use CD as input with volume VOL           <current active>\n"
	    " --mixer DEV:VOL     Set mixer device DEV to volume VOL                        \n"
	    " -N, --network HOST[:PORT]  Use cthugha-server running at HOST (using PORT)    \n"
	    " -x, --no-sound      Debug mode (no sound-source)                         <off>\n"
	    " --play FILE         Play FILE for sound input (enables --snd-fork)            \n"
	    " --play-silent FILE  Only use FILE as sound input. Don't play to soundcard     \n"
	    " --exec PROG         Run PROG for sound input (enables --snd-fork)             \n"
	    " --exec-silent PROG  Use output of PROG as sound input. Don't play to soundcard\n"
	    " --mod FILE          Short for \"--exec %s/cth-nspmod FILE\"\n"
	    " --mp3 FILE          Short for \"--exec %s/cth-amp FILE\"\n"
	    " -v, --rate N        Set sample rate to N                               <44000>\n"
	    " -2, --stereo        Default to Stereo (2 Channels)                        <on>\n"
	    " -1, --mono          Default to Mono (1 Channel)                          <off>\n"
	    " -c, --track N       Use CD as input, and start playing track N             <1>\n"
	    " --cd-stop           Stops CD on exit (if selected as input)              <off>\n"
	    " --cd-random         Play tracks in random order                          <off>\n"
	    " --cd-loop           Start again after all tracks are played              <off>\n"
	    " --cd-eject          Eject CD at end                                      <off>\n"
	    " --cd-autoplay       Immediately start CD                                 <off>\n"
	    " --snd-sync          Reset soundcard after reading sound                   <on>\n"
	    " --snd-fork          Start an extra process for reading the sound         <off>\n"
	    " --snd-fragments     Set number of sound fragments                          <0>\n"
	    "                                                                               \n"
	    "Startup options:                                                               \n"
	    " -f, --flame N       Start with flame N (number or name)               <random>\n" 
	    " -w, --wave N        Start with wave N (number or name)                <random>\n" 
	    " -t, --translation N Start with translation N (number or name)         <random>\n"
	    " -p, --palette N     Start with palette N (number or name)             <random>\n" 
	    " -d, --display N     Start with display N (number or name)             <random>\n"
	    " -P, --pcx N         Start with PCX N (number or name)                 <random>\n"
	    " -a, --table N       Start with table N (number)                       <random>\n"
	    " -m, --massage N     Start with massage N (number)                     <random>\n"
	    " -o, --object N      Start with 3D object N (number or name)           <random>\n"
	    " --wave-scale N      Start with wave scale value N                             \n"
	    "                                                                               \n"
	    "Change options: (times are in 1/100th of sec)                                  \n"
	    " -T, --time N        Minimum time before changing                         <500>\n"
	    " -R, --random N      Extra random time before changing                   <1000>\n" 
	    " -Q, --quiet-time N  Time before quiet message are displayes              <500>\n" 
	    " --silence-time N    Time before silence change                           <150>\n"
	    " --fire-level N      Set firelevel for change to N                       <1000>\n" 
	    " -l, --lock          Start in Locked mode                                 <off>\n" 
	    " -q, --quiet-file FILE  Load alternate Quiet messages from FILE          <none>\n" 
	    " --little            Only change one option at a time                     <off>\n"
	    "                                                                               \n"
	    "Disable options:                                                               \n"
	    " -i, --no-ipal       Disable Inbuilt Palettes                                  \n"
	    " -e, --no-epal       Disable External Palettes                                 \n"
	    " -X, --no-use-pcx    Disable PCX image files                                   \n" 
	    " -s, --no-flashlight Diable usage of flashlights (changing palette on beats)   \n"
	    " -F, --no-fft        Diable usage of FFT (drawing off transformed buffer)      \n"
	    " --no-trans          Disable translation tables                                \n"
	    " --no-object         Disable 3-D objects                                       \n"
	    " --no-rgb            Don't allow TrueColor RGB mode                            \n"
	    "                                                                               \n"
	    "Display and Buffer options:                                                    \n"
	    " -D, --disp-mode MODE    Set graphics mode (window size)                    <0>\n"
	    "                     0:320x200  1:320x240  2:320x400  3:360x480  4:640x480     \n" 
	    "                     5:800x600  6:1024x768 7:1280x1024 8:1600x1200             \n"
	    "                     When using X11 you can specify a special resolution in the\n"
	    "                     from: WIDTHxHEIGHT.                                       \n"
	    " --disp-direct       Draw directly to screen (only in 320x200 on console)  <on>\n"
	    " --mit-shm           Use MIT-SHM extension with X11 (2-3 times faster)     <on>\n"
	    " -r, --sync          Enable Video synch refresh waiting                        \n" 
	    " -S, --buff-size SIZE    Set buffer size. Perdefined sizes:                 <1>\n"
	    "                     0:160x100  1:320x200  2:320x300  3:360x480  4:640x480     \n"
	    "                     or specify a special size in the form: WIDTHxHEIGHT.      \n"
	    " --tile              Tile buffer to screen horizontally and vertically     <on>\n"
	    " --tile-x            Tile buffer to screen horizontally                    <on>\n"
	    " --tile-y            Tile buffer to screen vertically                      <on>\n"
            " --mirror            Mirror buffer horizontally and vertically                 \n"
            " --mirror-x          Mirror buffer horizontally                                \n"
            " --mirror-y          Mirror buffer vertically                                  \n"
	    " --text-time N       Time how long text is displayed on the screen        <300>\n"
	    " --on-root           Display on root window (also use --no-private-cmap)  <off>\n"
            " --in-window         Display in window with X11                            <on>\n"
	    " --private-cmap      Use a private colormap (also use --no-fft)            <on>\n"
	    " --dga               enable DGA support                                   <off>\n"
	    " --no-buff           Force double-buffering in system memory (only for DGA)    \n"
	    "                                                                               \n"
	    "General options:                                                               \n"
	    " --stretch           Allow stretching of translation tables to fit         <on>\n"
	    " -E, --path LIBDIR   An extra searchpath for map, pcx and tab-files            \n"
	    "                     cthugha searches in LIBDIR/map, LIBDIR/pcx and LIBDIR/tab \n"
	    " --dbl-load          Allow double loading of palettes, pcx, translations  <off>\n"
	    " --save              Save current wave, flame, .. and display at end           \n"
	    " --prt-file FILE     File used to save screen at PrintScreen or with --save    \n"
	    " --no-esc            Disable quit on ESC                                       \n"
	    " --verbose[=LVL]     Print a some extra information                         <1>\n"
	    "                     --verbose without LVL sets a level of 4                   \n"
	    " --no-verbose        Print no extra information                           <off>\n"
	    " -?, --help          This Text                                                 \n"
	    "                                                                               \n"
	    "Server options:                                                                \n"
	    " --server            Start cthugha, xcthugha in server mode               <off>\n"
	    " -W, --srv-wait      Time (in msec) cthugha-server waits after sending    <100>\n"
	    " --srv-port          Port used by the server                             <5555>\n"
	    " --clt-port          Port used by the client                             <5556>\n"
	    "                                                                               \n"
	    "Most switches can be used in a no-form to disable the feature.                 \n",
	    INST_LIB,
	    INST_LIB);
}

