#include "cthugha.h"
#include "options.h"

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <dirent.h>
#include <string.h>
#include <ctype.h>

#include "sound.h"
#include "display.h"
#include "action.h"
#include "translate.h"
#include "information.h"
#include "display.h"
#include "sound.h"
#include "cd_player.h"
#include "keys.h"
#include "server.h"

char extra_lib_path[256] = "";			/* extra path to search for
						   pcx, tab, map and ini */


FILE * ini_file = NULL;		/* the currently open ini-file */
static int ini_nr = -1;

/*
 * create the name of an ini file
 */
char * ini_file_name(int ini_nr) {
    static char fname[256];
    char * var;

    switch( ini_nr ) {
    case 0:
	return(INST_LIB "/cthugha.ini");
    case -1:
    case 1:
	if( (var = getenv("HOME")) == NULL) 
	    return NULL;
	strncpy(fname, var, 256);
	strncat(fname, "/.cthugha.auto", 256);
	return(fname);
    case 2:
	if( (var = getenv("HOME")) == NULL) 
	    return NULL;
	strncpy(fname, var, 256);
	strncat(fname, "/.cthugha.ini", 256);
	return(fname);
    case 3:
	return("./cthugha.ini");
	break;
    case 4:
	if(extra_lib_path[0] == '\0')
	    return NULL;
	strncpy(fname, extra_lib_path, 256);
	strncat(fname, "cthugha.ini", 256);
	return(fname);
    default:
	return NULL;
    }
}


int open_ini_start() {
    ini_nr = -1;
    return 0;
}
/* 
 * open the next ini file
 *returns: 
 * 0 -> OK, 1 -> error
 */
int open_ini_file() {
    char * fname;

    for(ini_nr ++; ini_nr < 6; ini_nr ++) {
	if(ini_nr == 5) {
	    ini_file = NULL;
    	    return open_ini_sys();
	}

    	fname = ini_file_name(ini_nr);
	if(fname)
	    ini_file = fopen(fname, "r");
	if(ini_file) return 0;
    }
    return 1;
}

/* 
 *  getini_<type>
 *  Read in the currently open ini-file the <entry> in <section>.
 *  <value> is only changed if the entry is found.
 */
int getini_str(const char * entry, char * value) {
    char name[512];
    int line_nr;

    /* build up name and class */
    strcpy(name, "cthugha.");
    strncat(name, cthugha_mode_text(), 512);
    strncat(name, ".", 512);
    strncat(name, entry, 512);

    if( ini_file == NULL) {
	return get_ini_str_sys(name, value);
    }

    rewind(ini_file);

    line_nr = 0;

    while( !feof(ini_file)) {
	char line[256];
	char * linep = line;
	char * namep = name;

	line_nr ++;
	line[0] = '\0';

	fgets(line, 256, ini_file);			/* get one line */

	while(isspace(*linep))				/* skip whitespace */
	    linep ++;

	switch(*linep) {
	case '#': case '!': case '\0':			/* comment or empty */
	    break;
	default:
	    /* compare word by word */
	    while(((toupper(*namep) == toupper(*linep)) || (*linep == '?')) &&
		  (*namep != '\0') ) {
		if(*linep == '?') {	/* wildcard */
		    while( (*namep != '.') && (*namep != '\0') )
			namep ++;
		    linep ++;
		} else {		/* compare word */
		    namep ++, linep ++;
		}
	    }

	    while(isspace(*linep))			/* skip whitespace */
		linep ++;

	    if( (*namep == '\0') && (*linep == ':') ) {	/* found entry */
		linep++;
		while(isspace(*linep))			/* skip whitespace */
		    linep ++;

		if(*linep != '\0') {			/* value is given */
		    while( !isspace(*linep) && (*linep != '\0')) {
			*value = *linep;
			linep ++; value++;
		    }
		    *value = '\0';
		    return 0;
		} else					/* no value */
		    return 1;
	    }
	}
    } 

    return 1;
}
int getini_int(const char * entry, int * value) {
    int tvalue;
    char * pos;
    char str[512];
	
    if ( getini_str(entry, str) )
	return 1;

    /* first try to read as number */
    tvalue = strtol(str, &pos, 0);
    if ( str == pos )
	/* not a number */
	return 1;

    *value = tvalue;

    return 0;				
}
int getini_yesno(const char * entry, int * value) {
    char str[512];
	
    if ( getini_str(entry, str) )
	return 1;

    if ( ! strncasecmp("yes", str,3) )
	*value = 1;
    else if ( ! strncasecmp("on", str,2) )
	*value = 1;
    else if ( ! strncasecmp("1", str,1) )
	*value = 1;
    else if ( ! strncasecmp("no", str,2) )
	*value = 0;
    else if ( ! strncasecmp("off", str,3) )
	*value = 0;
    else if ( ! strncasecmp("0", str,1) )
	*value = 0;
    else {
	printfe("Illegal yes/no-value for %s.\n", entry);
	return 1;
    }

    return 0;				
}
int getini_use(feature * in, int pos) {

    char str[512];
    strncpy(str, in->name, 512);
    strncat(str, ".", 512);
    strncat(str, in->entries[pos].name, 512);
    return getini_yesno(str, &(in->entries[pos].use) );
}
    

/*
 * putinit_<type>
 * write a new value in the ini-file for a given entry in a section
 */
int putini_str(const char * entry, const char * value) {

    fprintf(ini_file, "Cthugha.%s.%s: %s\n", 
	    cthugha_mode_text(), entry, value);

    return 0;	
}
int putini_yesno(const char * entry, int value) {
    return putini_str(entry, value ? "on" : "off");
}

int putini_int(const char * entry, int value) {
    char str[256];
    sprintf(str, "%d", value);
    return putini_str(entry, str);
}

int putini_use(feature * in, int pos) {
    if ( in->entries[pos].use >= 0) {
	char str[512];
	strncpy(str, in->name, 512);
	strncat(str, ".", 512);
	strncat(str, in->entries[pos].name, 512);
	return putini_yesno(str, in->entries[pos].use);
    }
    return 1;
}
	       

/* 
 *  Read settings from ini-file's
 */
int read_ini() {
    int value;
    char str[256];
    struct option * opt;

    open_ini_start();
    while(open_ini_file() == 0) {

	for(opt = long_options; opt->name != NULL; opt++) {
	    if(opt->has_arg == 0) {
		/* no argument -> simply a yes/no value,
		 use the value given in the opion */
		getini_yesno(opt->name, opt->flag);
	    } else {
		/* with argument */
		if(opt->flag != NULL) {
		    getini_int(opt->name, opt->flag);
		} else {
		    if( getini_str(opt->name, str) == 0) {
			value = atoi(str);
			if( do_param(opt->val, value, str) )
			    printfv(0, "Unhandled option: '%s'.\n", opt->name);
		    }
		}
	    }
	} 
	fclose(ini_file);
    }
    return 0;
}





