#include "../cthugha.h"
#include "../keys.h"
#include "../cthugha-X11.h"

#include <string.h>


int x11_key = CK_NONE;

int key_esc = 1;		/* disable/enable ESC-key. When enable it 
				   sometimes happens that when pressing
				   functions keys or cursor keys cthugha
				   only get the leading ESC and quits. */


struct xkeys_t {
    char * name;
    int keycode;
};
static struct xkeys_t xkeys[] = {
    { "F1", CK_FKT(1) },
    { "F2", CK_FKT(2) },
    { "F3", CK_FKT(3) },
    { "F4", CK_FKT(4) },
    { "F5", CK_FKT(5) },
    { "F6", CK_FKT(6) },
    { "F7", CK_FKT(7) },
    { "F8", CK_FKT(8) },
    { "Return", CK_ENTER },
    { "Up", CK_UP },
    { "Down", CK_DOWN },
    { "Left", CK_LEFT },
    { "Right", CK_RIGHT },
    { "Prior", CK_PGUP },
    { "Next", CK_PGDN },
    { "End", CK_END },
    { "Home", CK_HOME },
    { "Print", CK_PRINT },
    { "BackSpace", CK_BACK }
};
static int nxkeys = sizeof(xkeys)/sizeof(struct xkeys_t);
	
/*
 * Handler for key-board
 */
void keys_x11(char *input) {

    if ( input[1] == '\0') 
	switch(input[0]) {
	case 0: case -1:	x11_key = CK_NONE; break;
	case 27:		x11_key = (key_esc ? CK_ESC : CK_NONE); break;
	case 10: case 13:	x11_key = CK_ENTER; break;
	case 8:			x11_key = CK_BACK; break;
	case 'q': case 'Q':	/* 'q' stops screen saver */
	    x11_key = (xcth_saver) ? CK_NONE : input[0]; 
	    break;
	default:		x11_key = input[0];
	}
    else {
	int i;
	for(i=0; i < nxkeys; i++)
	    if( strcasecmp(input, xkeys[i].name) == 0) {
		x11_key = xkeys[i].keycode;
		return;
	    }
	x11_key = CK_NONE;
    }
}


int getkey() {
    int key;
    key = x11_key;
    x11_key = CK_NONE;
    return key;
}
