/* A YACC parser generated from "parser.y" */

# line 17
#ifndef lint
#define lint
#endif
#define defTycon(n,l,lhs,rhs,w)  tyconDefn(intOf(l),lhs,rhs,w); sp-=n
#define sigdecl(l,vs,t)          ap(SIGDECL,triple(l,vs,t))
#define grded(gs)                ap(GUARDED,gs)
#define bang(t)                  ap(BANG,t)
#define only(t)			 ap(ONLY,t)
#define letrec(bs,e)             (nonNull(bs) ? ap(LETREC,pair(bs,e)) : e)
#if IGNORE_MODULES
#define exportSelf()             NIL
#else
#define exportSelf()             singleton(ap(MODULEENT,mkCon(module(currentModule).text)))
#endif
#define yyerror(s)               /* errors handled elsewhere */
#define YYSTYPE                  Cell

static Cell   local gcShadow     Args((Int,Cell));
static Void   local syntaxError  Args((String));
static String local unexpected   Args((Void));
static Cell   local checkPrec    Args((Cell));
static Void   local fixDefn      Args((Syntax,Cell,Cell,List));
static Void   local setSyntax    Args((Int,Syntax,Cell));
static Cell   local buildTuple   Args((List));
static List   local checkContext Args((List));
static Cell   local checkClass   Args((Cell));
static Cell   local checkInst    Args((Cell));
static Pair   local checkDo      Args((List));
static Cell   local checkTyLhs   Args((Cell));
#if !TREX
static Void   local noTREX       Args((String));
#endif
static Cell   local tidyInfix    Args((Cell));

/* For the purposes of reasonably portable garbage collection, it is
 * necessary to simulate the YACC stack on the Hugs stack to keep
 * track of all intermediate constructs.  The lexical analyser
 * pushes a token onto the stack for each token that is found, with
 * these elements being removed as reduce actions are performed,
 * taking account of look-ahead tokens as described by gcShadow()
 * below.
 *
 * Of the non-terminals used below, only start, topDecl, fixDecl & begin
 * do not leave any values on the Hugs stack.  The same is true for the
 * terminals EXPR and SCRIPT.  At the end of a successful parse, there
 * should only be one element left on the stack, containing the result
 * of the parse.
 */

#define gc0(e)                   gcShadow(0,e)
#define gc1(e)                   gcShadow(1,e)
#define gc2(e)                   gcShadow(2,e)
#define gc3(e)                   gcShadow(3,e)
#define gc4(e)                   gcShadow(4,e)
#define gc5(e)                   gcShadow(5,e)
#define gc6(e)                   gcShadow(6,e)
#define gc7(e)                   gcShadow(7,e)

#define EXPR 257
#define SCRIPT 258
#define CASEXP 259
#define OF 260
#define DATA 261
#define TYPE 262
#define IF 263
#define THEN 264
#define ELSE 265
#define WHERE 266
#define LET 267
#define IN 268
#define INFIX 269
#define INFIXL 270
#define INFIXR 271
#define PRIMITIVE 272
#define TNEWTYPE 273
#define DEFAULT 274
#define DERIVING 275
#define DO 276
#define TCLASS 277
#define TINSTANCE 278
#define TRUNST 279
#define REPEAT 280
#define VAROP 281
#define VARID 282
#define NUMLIT 283
#define CHARLIT 284
#define STRINGLIT 285
#define CONOP 286
#define CONID 287
#define QVAROP 288
#define QVARID 289
#define QCONOP 290
#define QCONID 291
#define RECSELID 292
#define COCO 293
#define UPTO 294
#define FROM 295
#define ARROW 296
#define IMPLIES 297
#define MODULETOK 298
#define IMPORT 299
#define HIDING 300
#define QUALIFIED 301
#define ASMOD 302
#define NEEDPRIMS 303
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

#line 727


static Cell local gcShadow(n,e)         /* keep parsed fragments on stack  */
Int  n;
Cell e; {
    /* If a look ahead token is held then the required stack transformation
     * is:
     *   pushed: n               1     0          1     0
     *           x1  |  ...  |  xn  |  la   ===>  e  |  la
     *                                top()            top()
     *
     * Othwerwise, the transformation is:
     *   pushed: n-1             0        0
     *           x1  |  ...  |  xn  ===>  e
     *                         top()     top()
     */
    if (yychar>=0) {
	pushed(n-1) = top();
	pushed(n)   = e;
    }
    else
	pushed(n-1) = e;
    sp -= (n-1);
    return e;
}

static Void local syntaxError(s)       /* report on syntax error           */
String s; {
    ERRMSG(row) "Syntax error in %s (unexpected %s)", s, unexpected()
    EEND;
}

static String local unexpected() {     /* find name for unexpected token   */
    static char buffer[100];
    static char *fmt = "%s \"%s\"";
    static char *kwd = "keyword";

    switch (yychar) {
	case 0         : return "end of input";

#define keyword(kw) sprintf(buffer,fmt,kwd,kw); return buffer;
	case INFIXL    : keyword("infixl");
	case INFIXR    : keyword("infixr");
	case INFIX     : keyword("infix");
	case TINSTANCE : keyword("instance");
	case TCLASS    : keyword("class");
	case PRIMITIVE : keyword("primitive");
	case CASEXP    : keyword("case");
	case OF        : keyword("of");
	case IF        : keyword("if");
	case TRUNST    : keyword("runST");
	case THEN      : keyword("then");
	case ELSE      : keyword("else");
	case WHERE     : keyword("where");
	case TYPE      : keyword("type");
	case DATA      : keyword("data");
	case TNEWTYPE  : keyword("newtype");
	case LET       : keyword("let");
	case IN        : keyword("in");
	case DERIVING  : keyword("deriving");
	case DEFAULT   : keyword("default");
	case IMPORT    : keyword("import");
	case MODULETOK : keyword("module");
#undef keyword

	case ARROW     : return "`->'";
	case '='       : return "`='";
	case COCO      : return "`::'";
	case '-'       : return "`-'";
	case '!'       : return "`!'";
	case ','       : return "comma";
	case '@'       : return "`@'";
	case '('       : return "`('";
	case ')'       : return "`)'";
	case '{'       : return "`{'";
	case '}'       : return "`}'";
	case '_'       : return "`_'";
	case '|'       : return "`|'";
	case ';'       : return "`;'";
	case UPTO      : return "`..'";
	case '['       : return "`['";
	case ']'       : return "`]'";
	case FROM      : return "`<-'";
	case '\\'      : return "backslash (lambda)";
	case '~'       : return "tilde";
	case '`'       : return "backquote";
#if TREX
	case RECSELID  : sprintf(buffer,"selector \"#%s\"",
				 textToStr(extText(snd(yylval))));
			 return buffer;
#endif
	case VAROP     :
	case VARID     :
	case CONOP     :
	case CONID     : sprintf(buffer,"symbol \"%s\"",
				 textToStr(textOf(yylval)));
			 return buffer;
	case QVAROP    :
	case QVARID    :
	case QCONOP    : 
	case QCONID    : sprintf(buffer,"symbol \"%s\"",
				 identToStr(yylval));
			 return buffer;
	case HIDING    : return "symbol \"hiding\"";
	case QUALIFIED : return "symbol \"qualified\"";
	case ASMOD     : return "symbol \"as\"";
	case NUMLIT    : return "numeric literal";
	case CHARLIT   : return "character literal";
	case STRINGLIT : return "string literal";
	case IMPLIES   : return "`=>'";
	default        : return "token";
    }
}

static Cell local checkPrec(p)         /* Check for valid precedence value */
Cell p; {
    if (!isInt(p) || intOf(p)<MIN_PREC || intOf(p)>MAX_PREC) {
	ERRMSG(row) "Precedence value must be an integer in the range [%d..%d]",
		    MIN_PREC, MAX_PREC
	EEND;
    }
    return p;
}

static Void local fixDefn(a,line,p,ops)/* Declare syntax of operators      */
Syntax a;
Cell   line;
Cell   p;
List   ops; {
    Int l = intOf(line);
    a     = mkSyntax(a,intOf(p));
    map2Proc(setSyntax,l,a,ops);
}

static Void local setSyntax(line,sy,op)/* set syntax of individ. operator  */
Int    line;
Syntax sy;
Cell   op; {
    addSyntax(line,textOf(op),sy);
    opDefns = cons(op,opDefns);
}

static Cell local buildTuple(tup)      /* build tuple (x1,...,xn) from list*/
List tup; {                            /* [xn,...,x1]                      */
    Int  n = 0;
    Cell t = tup;
    Cell x;

    do {                               /*     .                    .       */
	x      = fst(t);               /*    / \                  / \      */
	fst(t) = snd(t);               /*   xn  .                .   xn    */
	snd(t) = x;                    /*        .    ===>      .          */
	x      = t;                    /*         .            .           */
	t      = fun(x);               /*          .          .            */
	n++;                           /*         / \        / \           */
    } while (nonNull(t));              /*        x1  NIL   (n)  x1         */
    fst(x) = mkTuple(n);
    return tup;
}

static List local checkContext(con)     /* validate type class context     */
Type con; {
    mapOver(checkClass, con);
    return con;
}

static Cell local checkClass(c)         /* check that type expr is a class */
Cell c; {                               /* constrnt of the form Class var  */
    Cell cn = getHead(c);

#if TREX
    if (isExt(cn) && argCount==1)
	return c;
#endif
    if (!isQCon(cn))
	syntaxError("class expression");
    else if (argCount!=1) {
	ERRMSG(row) "Class \"%s\" must have exactly one argument",
		    identToStr(cn)
	EEND;
    }
    else if (whatIs(arg(c))!=VARIDCELL) {
	ERRMSG(row) "Argument of class \"%s\" must be a variable",
		    /* Ha!  What do you think this is?  Gofer!? :-) */
		    textToStr(textOf(cn))
	EEND;
    }
    return c;
}

static Cell local checkInst(c)          /* check that type expr is a class */
Cell c; {                               /* constr of the form Class simple */
    Cell cn = getHead(c);

    if (!isQCon(cn))
	syntaxError("class expression");
    else if (argCount!=1) {
	ERRMSG(row) "Class \"%s\" must have exactly one argument",
		    identToStr(cn)
	EEND;
    }
    else {
	Cell a  = arg(c);
	Cell tn = getHead(a);
#if TREX
	if (isQCon(tn) || isTycon(tn) || isTuple(tn) || isExt(tn)) {
#else
	if (isQCon(tn) || isTycon(tn) || isTuple(tn)) {
#endif
	    for (; isAp(a); a=fun(a))
		if (whatIs(arg(a))!=VARIDCELL) {
		    ERRMSG(row) "Type variable expected in instance type"
		    EEND;
		}
	}
	else {
	    ERRMSG(row) "Illegal type expression in instance declaration"
	    EEND;
	}
    }
    return c;
}

static Pair local checkDo(dqs)          /* convert reversed list of dquals */
List dqs; {                             /* to an (expr,quals) pair         */
    if (isNull(dqs) || whatIs(hd(dqs))!=DOQUAL) {
	ERRMSG(row) "Last generator in do {...} must be an expression"
	EEND;
    }
    fst(dqs) = snd(fst(dqs));           /* put expression in fst of pair   */
    snd(dqs) = rev(snd(dqs));           /* & reversed list of quals in snd */
    return dqs;
}

static Cell local checkTyLhs(c)         /* check that lhs is of the form   */
Cell c; {                               /* T a1 ... a                      */
    Cell tlhs = c;
    while (isAp(tlhs) && whatIs(arg(tlhs))==VARIDCELL)
	tlhs = fun(tlhs);
    switch (whatIs(tlhs)) {
	case CONIDCELL  : return c;

        default :
	    ERRMSG(row) "Illegal left hand side in datatype definition"
	    EEND;
    }
}

#if !TREX
static Void local noTREX(where)
String where; {
    ERRMSG(row) "Attempt to use Typed Records with Extensions\nwhile parsing %s. This feature is disabled in this build of Hugs.",
                 where
    EEND;
}
#endif

/* Expressions involving infix operators or unary minus are parsed as elements
 * of the following type:
 *
 *     data OpExp = Only Exp | Neg OpExp | Infix OpExp Op Exp
 *
 * (The algorithms here do not assume that negation can be applied only once,
 * i.e., that - - x is a syntax error, as required by the Haskell report.
 * Instead, that restriction is captured by the grammar itself, given above.)
 *
 * There are rules of precedence and grouping, expressed by two functions:
 *
 *     prec :: Op -> Int;   assoc :: Op -> Assoc    (Assoc = {L, N, R})
 *
 * OpExp values are rearranged accordingly when a complete expression has
 * been read using a simple shift-reduce parser whose result may be taken
 * to be a value of the following type:
 *
 *     data Exp = Atom Int | Negate Exp | Apply Op Exp Exp | Error String
 *
 * The machine on which this parser is based can be defined as follows:
 *
 *     tidy                         :: OpExp -> [(Op,Exp)] -> Exp
 *     tidy (Only a)      []         = a
 *     tidy (Only a)      ((o,b):ss) = tidy (Only (Apply o a b)) ss
 *     tidy (Infix a o b) []         = tidy a [(o,b)]
 *     tidy (Infix a o b) ((p,c):ss)
 *                      | shift  o p = tidy a ((o,b):(p,c):ss)
 *                      | red    o p = tidy (Infix a o (Apply p b c)) ss
 *                      | ambig  o p = Error "ambiguous use of operators"
 *     tidy (Neg e)       []         = tidy (tidyNeg e) []
 *     tidy (Neg e)       ((o,b):ss)
 *                      | nshift o   = tidy (Neg (underNeg o b e)) ss
 *                      | nred   o   = tidy (tidyNeg e) ((o,b):ss)
 *                      | nambig o   = Error "illegal use of negation"
 *
 * At each stage, the parser can either shift, reduce, accept, or error.
 * The transitions when dealing with juxtaposed operators o and p are
 * determined by the following rules:
 *
 *     shift o p  = (prec o > prec p)
 *               || (prec o == prec p && assoc o == L && assoc p == L)
 *
 *     red o p    = (prec o < prec p)
 *               || (prec o == prec p && assoc o == R && assoc p == R)
 *
 *     ambig o p  = (prec o == prec p)
 *               && (assoc o == N || assoc p == N || assoc o /= assoc p)
 *
 * The transitions when dealing with juxtaposed unary minus and infix operators
 * are as follows.  The precedence of unary minus (infixl 6) is hardwired in
 * to these definitions, as it is to the definitions of the Haskell grammar
 * in the official report.
 *
 *     nshift o   = (prec o > 6)
 *     nred   o   = (prec o < 6) || (prec o == 6 && assoc o == L)
 *     nambig o   = prec o == 6 && (assoc o == R || assoc o == N)
 *
 * An OpExp of the form (Neg e) means negate the last thing in the OpExp e;
 * we can force this negation using:
 *
 *     tidyNeg              :: OpExp -> OpExp
 *     tidyNeg (Only e)      = Only (Negate e)
 *     tidyNeg (Infix a o b) = Infix a o (Negate b)
 *     tidyNeg (Neg e)       = tidyNeg (tidyNeg e)
 * 
 * On the other hand, if we want to sneak application of an infix operator
 * under a negation, then we use:
 *
 *     underNeg                  :: Op -> Exp -> OpExp -> OpExp
 *     underNeg o b (Only e)      = Only (Apply o e b)
 *     underNeg o b (Neg e)       = Neg (underNeg o b e)
 *     underNeg o b (Infix e p f) = Infix e p (Apply o f b)
 *
 * As a concession to efficiency, we lower the number of calls to syntaxOf
 * by keeping track of the values of sye, sys throughout the process.  The
 * value APPLIC is used to indicate that the syntax value is unknown.
 */

#define UMINUS_PREC  6			/* Change these settings at your   */
#define UMINUS_ASSOC LEFT_ASS		/* own risk; they may not work!	   */

static Cell local tidyInfix(e)		/* convert OpExp to Expr	   */
Cell e; {				/* :: OpExp			   */
    Cell s     = NIL;			/* :: [(Op,Exp)]		   */
    Syntax sye = APPLIC;		/* Syntax of op in e (init unknown)*/
    Syntax sys = APPLIC;		/* Syntax of op in s (init unknown)*/

    for (;;)
	switch (whatIs(e)) {
	    case ONLY : e = snd(e);
                        while (nonNull(s)) {
                            Cell next   = arg(fun(s));
                            arg(fun(s)) = e;
                            e           = s;
                            s           = next;
			}
		        return e;

	    case NEG  : if (nonNull(s)) {

			    if (sys==APPLIC) {	/* calculate sys	   */
				sys = identSyntax(fun(fun(s)));
				if (sys==APPLIC) sys=DEF_OPSYNTAX;
			    }

			    if (precOf(sys)==UMINUS_PREC &&	/* nambig  */
				assocOf(sys)!=UMINUS_ASSOC) {
				ERRMSG(row)
				 "Ambiguous use of unary minus with \"%s\"",
				   textToStr(textOf(fun(fun(s))))
				EEND;
			    }

			    if (precOf(sys)>UMINUS_PREC) {	/* nshift  */
				Cell e1    = snd(e);
				Cell t     = s;
                                s          = arg(fun(s));
				while (whatIs(e1)==NEG)
				    e1 = snd(e1);
				arg(fun(t)) = arg(e1);
                                arg(e1)     = t;
				sys         = APPLIC;
				continue;
			    }
			
			}

			/* Intentional fall-thru for nreduce and isNull(s) */

			{   Cell prev = e;		/* e := tidyNeg e  */
			    Cell temp = arg(prev);
			    Int  nneg = 1;
			    for (; whatIs(temp)==NEG; nneg++) {
				fun(prev) = nameNegate;
				prev	  = temp;
				temp	  = arg(prev);
			    }
			    if (isInt(arg(temp))) {	/* special cases   */
				if (nneg&1)		/* for literals    */
				    arg(temp) = mkInt(-intOf(arg(temp)));
			    }
			    else if (isBignum(arg(temp))) {
				if (nneg&1)
				    arg(temp) = bigNeg(arg(temp));
			    }
			    else if (isFloat(arg(temp))) {
				if (nneg&1)
				    arg(temp) = mkFloat(-floatOf(arg(temp)));
			    }
			    else {
				fun(prev) = nameNegate;
				arg(prev) = arg(temp);
				arg(temp) = e;
			    }
			    e = temp;
			}
			continue;

	    default   : if (isNull(s)) {/* Move operation onto empty stack */
			    Cell next   = arg(fun(e));
                            s           = e;
			    arg(fun(s)) = NIL;
                            e           = next;
                            sys         = sye;
                            sye         = APPLIC;
			}
                        else {		/* deal with pair of operators	   */

			    if (sye==APPLIC) {	/* calculate sys and sye   */
				sye = identSyntax(fun(fun(e)));
				if (sye==APPLIC) sye=DEF_OPSYNTAX;
			    }
			    if (sys==APPLIC) {
				sys = identSyntax(fun(fun(s)));
				if (sys==APPLIC) sys=DEF_OPSYNTAX;
			    }

			    if (precOf(sye)==precOf(sys) &&	/* ambig   */
				(assocOf(sye)!=assocOf(sys) ||
				 assocOf(sye)==NON_ASS)) {
				ERRMSG(row)
				"Ambiguous use of operator \"%s\" with \"%s\"",
				  textToStr(textOf(fun(fun(e)))),
				  textToStr(textOf(fun(fun(s))))
				EEND;
			    }

			    if (precOf(sye)>precOf(sys) ||	/* shift   */
				(precOf(sye)==precOf(sys) &&
				 assocOf(sye)==LEFT_ASS &&
				 assocOf(sys)==LEFT_ASS)) {
				Cell next   = arg(fun(e));
				arg(fun(e)) = s;
				s	    = e;
				e	    = next;
				sys	    = sye;
				sye	    = APPLIC;
                            }
			    else {				/* reduce  */
				Cell next   = arg(fun(s));
				arg(fun(s)) = arg(e);
				arg(e)      = s;
				s	    = next;
				sys	    = APPLIC;
				/* sye unchanged */
			    }
                        }
			continue;
	}
}

/*-------------------------------------------------------------------------*/
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 102,
	297, 143,
	-2, 155,
-1, 127,
	293, 213,
	44, 213,
	-2, 277,
-1, 143,
	61, 227,
	-2, 216,
-1, 192,
	297, 142,
	-2, 169,
-1, 203,
	293, 216,
	-2, 168,
-1, 284,
	297, 143,
	-2, 85,
-1, 299,
	297, 143,
	-2, 133,
-1, 302,
	297, 143,
	-2, 135,
-1, 314,
	297, 144,
	-2, 172,
-1, 316,
	297, 145,
	-2, 174,
-1, 335,
	293, 216,
	-2, 168,
-1, 357,
	61, 226,
	-2, 215,
-1, 359,
	61, 225,
	-2, 218,
-1, 471,
	123, 243,
	-2, 247,
	};
#define YYNPROD 345
# define YYLAST 2211
short yyact[]={

  33, 551,  98, 570,  20, 557, 565, 264, 100, 563,
   5, 497, 478, 224, 469, 463, 454, 374,  23, 442,
 351, 518,  65,  66, 464, 139, 307, 457, 292, 167,
 207, 263,  79, 141, 169, 107, 372, 168,  90,  51,
 382, 173,  54, 281, 202, 385, 276, 106, 278, 385,
 180, 537,  44, 343,  43, 403, 401, 532, 395, 385,
 390, 443, 191,  37,  74, 543, 363,  77,  35, 127,
  34, 143,  36, 241, 143, 140, 591, 280, 140, 279,
 295,  38,  39,  40, 455, 164, 582,  37, 103, 361,
 397, 329,  35, 277,  37, 229,  36, 127,  37, 451,
  46, 481, 203, 210, 554,  38,  39,  40, 210, 451,
 531, 210,  38,  39,  40, 398,  38,  39,  40, 215,
  35, 280,  37, 279,  36, 283, 222, 561, 223,  34,
 290,  95, 273, 334,  52, 204, 237, 412, 214, 520,
  38,  39,  40, 243, 239, 332,  50, 174, 519, 413,
 517, 120, 249, 525,  45, 304, 282, 348,  63, 252,
 128, 253,  96, 254, 247, 165, 175, 129,  93, 269,
 260, 589, 261, 176, 266, 251, 443, 371,   4,   2,
   3, 267, 250, 287, 287, 233, 296, 287, 287, 236,
 201, 244, 210, 441, 210, 308, 377,  53, 334, 259,
 313, 138, 225,  31,  97, 530, 335, 210, 375, 309,
 399, 294, 335, 337, 210, 336, 407,  64, 210, 132,
  86, 235, 338, 339, 510,  70, 258, 509,  88, 106,
 238, 341, 127, 440, 342,  73,  67, 220, 124, 204,
 219, 345, 163, 212, 347, 204, 143, 194, 236, 354,
 140,  71, 588,   6, 356, 434, 162, 114, 246, 378,
 507, 437, 271, 136, 326, 334, 154, 328, 270, 156,
 268, 240,  37, 127, 227, 598, 127, 399,  37, 581,
 476,  70, 388, 477, 344, 210, 580, 287, 542, 210,
  38,  39,  40, 242, 514,  37,  38,  39,  40, 520,
 210, 489,  34, 210, 210, 384, 365, 460,  70, 384,
 366, 383, 406,  38,  39,  40, 106, 449, 106, 384,
 287, 133,  37, 210, 386, 590, 210, 459, 210, 296,
 210, 423, 210, 226, 424, 166, 425, 145, 428, 396,
  38,  39,  40, 379, 228, 362,  37, 327, 480, 155,
 400, 480, 250, 402, 431, 414, 435, 432, 411, 245,
 256, 104, 204, 436,  38,  39,  40, 153, 597, 444,
 295, 446, 127, 426,  35, 201, 579, 255,  36, 450,
 232, 333,  55, 250, 578,  55, 296,  57, 210,  56,
 210,  58,  56, 210, 445, 272, 462, 106, 296, 483,
 248, 340, 448, 564, 415, 447, 418,  56, 422, 479,
 211, 458, 127, 573, 308, 498,   8, 210, 368, 387,
 210, 295, 210, 294, 364, 466, 484, 461, 309, 499,
 452, 210, 393, 210, 473,  32, 492, 490, 369, 482,
 367, 545, 501, 541, 376, 370, 333, 355, 505, 379,
 540, 312, 380, 381, 296, 495, 346, 312, 502, 504,
 353, 110, 513, 197, 500, 111, 210, 210, 210, 210,
 512, 149, 521, 335, 388, 148, 287, 147, 287, 458,
 210, 126, 105, 388, 524, 526, 508, 210, 210, 115,
 210, 503, 408, 511, 133, 409, 488, 214, 538, 529,
 535, 522, 324, 485, 539, 325, 204, 516, 142, 126,
 536, 323, 127, 333, 160, 296, 296, 433, 531, 358,
 210,  47, 558, 210, 210, 210, 360, 210, 210, 210,
 553, 296,  59, 210, 210, 210, 566, 105, 209, 562,
 458, 552, 546, 209, 559, 544, 105, 498, 574, 366,
 575, 577, 479, 214, 576, 466, 572, 555, 567, 568,
 522, 499, 522, 210, 415, 210, 418, 197, 466, 211,
 515, 587, 586, 197, 274, 275, 321, 318, 146, 322,
 319, 296, 594, 106, 109, 596, 558, 595, 359, 217,
 296, 210, 296, 599, 357, 553, 592, 593, 522, 600,
 522, 295, 210, 320, 157, 316, 552, 453, 317, 410,
 604, 161,  37, 152, 160, 572, 153, 602, 105, 105,
 110, 303, 105, 105, 111, 525, 310, 105, 190, 209,
  38,  39,  40, 262,  80, 150, 102, 427, 151, 137,
  37, 105, 105, 131, 126, 439, 438, 105,  49, 105,
  48, 198,  37, 209, 350, 352,  89,  35,  38,  39,
  40,  36,  81,  37, 105,  91,  17, 130, 459, 349,
  38,  39,  40,  84,  61,  83,  85, 417,   9, 420,
 373,  38,  39,  40, 234, 126, 231, 208, 126,  24,
 230, 193, 208,  37, 125, 123, 121, 200,  35,  37,
  34, 199,  36, 195,  35, 493,  34, 405,  36, 404,
 300,  38,  39,  40, 297, 291, 584,  38,  39,  40,
 209, 583, 105, 571, 209, 569, 468, 556, 172, 550,
 412, 548, 456, 496, 494, 209, 306, 170, 209, 105,
  30, 527, 413, 189,  22,  94,  92,  42, 211,  41,
  37, 105,   1, 105,   0, 105,   0,  34, 105,   0,
   0, 105,   0, 105,   0, 105,   0, 209,  38,  39,
  40,   0, 284, 288,   0,  21, 299, 302, 208,   0,
   0,   0,   0,   0, 126,   0,   0,   0,  99,   0,
   0, 601, 417,   0, 420, 331,   0,   0, 211, 110,
   0, 331, 208, 111, 525,   0,   0,   0,   0,   0,
   0,  37,   0,   0,   0, 379,  35, 293, 102,   0,
  36,   0,   0, 105, 126, 105,   0,   0, 209,  38,
  39,  40, 105,   0, 197,   0,   0, 105,   0, 105,
  24,   0,   0,  37,   0, 310,   0,   0,   0, 110,
   0,   0, 209, 111, 352, 209,   0, 209,   0,   0,
 506,  38,  39,  40,   0,   0, 105,   0, 105, 208,
   0,   0,   0, 208,   0,   0, 392,   0,   0,  37,
   0, 334,   0,   0, 208, 312, 491, 208, 205, 330,
   0,  30,  87,   0,   0,  22,   0,  38,  39,  40,
   0, 105, 209, 209, 209, 416,   0, 419, 105, 421,
   0, 105,   0, 105,   0, 209, 208,   0,   0,   0,
   0,   0, 209, 209, 126, 105,  21,   0,   0,  28,
   0,  37,  25,  26,  27,   0,  35,   0,  34, 110,
  36,  29,   0, 111,   0, 118,   0,   0,   0,  38,
  39,  40,   0,   0,   0, 105, 560,   0, 209, 209,
 105,  24, 105, 209, 209,   0,  11,   0, 105, 209,
 209, 285, 289,   0,   0, 298, 301, 208,  55, 467,
 171,   0,   0,  57,   0,  56, 102,  58,   0,   0,
  37, 486,   0, 487, 379,  35,   0, 585, 105,  36,
 105, 208,   0,   0, 208,   0, 208,   0,  38,  39,
  40,   0,  30,  12, 108,   0,  22,   0, 105,   0,
 416,   0, 419,   0,  24,   0, 105,   0,   0,  11,
   0,   0,   0,   0, 603,   0,   0, 105,   0,   0,
  37,   0,   0, 171,   0,  35,   0,  21,   0,  36,
   0, 208, 208, 208,   0, 523,   0,   0,  38,  39,
  40,   0, 331,   0, 208, 533,   0, 534,   0,  24,
   0, 208, 208,   0,  11,  30,  12,   0,   0,  22,
  28,   0,  37,  25,  26,  27,   0,  35,   0,  34,
   0,  36,  29, 554,   0,   0,   0, 549,   0,   0,
  38,  39,  40,   0, 108,   0,   0, 208, 208, 467,
  21,   0, 208, 208, 523,   0, 523,   0, 208, 208,
  30,  12, 467,  24,  22,   0,   0,  37,  11, 333,
  37,   0,  35,   0,  34,  35,  36,   0,   0,  36,
   0,   0,   0, 311, 196,  38,  39,  40,  38,  39,
  40,   0, 523,   0, 523,  21,  75,   0,   0,   0,
   0,   0,   0,  24,  78,   0,   0,  87,  76,   0,
   0,   0, 102,   0,  30,  12,   0,   0,  22,   0,
  15,   0, 182, 181,  14,   0,   0, 211,  13,   0,
 179, 177, 178, 185, 183, 188,   0,  16, 186, 187,
  18,  28,   0,  37,  25,  26,  27,   0,  35,  21,
  34,   0,  36,  29,  30,  12,   0,   0,  22,  53,
 180,  38,  39,  40, 184,   0,   0,   0,   0,   0,
   0,   0, 312, 305,   0,   0,   0,   0, 110,   0,
   0,   0, 111,  15,   0, 182, 181,  14,   0,  21,
   0,  13,   0, 179, 177, 178, 185, 183, 188,   0,
  16, 186, 187,  18,  28,   0,  37,  25,  26,  27,
   0,  35,  24,  34,   0,  36,  29,  11,   0,   0,
   0, 391,   0,   0,  38,  39,  40, 184,  15,   0,
 182, 181,  14,   0,   0,   0,  13,   0,   0,   0,
   0, 185, 183, 188,   0,  16, 186, 187,  18,  28,
   0,  37,  25,  26,  27,   0,  35,   0,  34,   0,
  36,  29,   0,  30,  12,   0,   0,  22,   0,  38,
  39,  40, 184,   0,   0,  37,  24, 257,   0,   7,
 480, 117,  15,   0,   0,   0,  14, 547,   0,   0,
  13,   0,   0,  38,  39,  40,   0,   0,  21,  16,
   0,   0,  18,  28,   0,  37,  25,  26,  27,   0,
  35,   0,  34,   0,  36,  29,  24,   0,   0,   7,
   0,  11,  15,  38,  39,  40,  14,  30,  12,   0,
  13,  22,   0,   0,   0, 122,   0,   0,   0,  16,
   0,   0,  18,  28,  55,  37,  25,  26,  27,  57,
  35,  56,  34,  58,  36,  29,  24,   0,   0,   0,
   0,  11,  21,  38,  39,  40,   0,  30,  12,  37,
   0,  22,   0,   0,  35,   0,   0,   0,  36,   0,
   0,   0,   0, 206,   0,   0,   0,  38,  39,  40,
   0,   0,  24,   0,   0,   0,   0,  11,   0,   0,
   0,   0,  21,   0,   0,   0,   0,  30,  12,   0,
   0,  22,   0,   0,  37,   0,   0,   0,   0,  35,
   0,  34,   0,  36,   0,   0,   0,   0,   7,   0,
 311,  15,  38,  39,  40,  14,  24, 148,   0, 265,
   0,   0,  21,  30,  12,   0,   0,  22,  16,   0,
   0,  18,  28,   0,  37,  25,  26,  27,   0,  35,
   0,  34,  37,  36,  29,   0,   0,  35,   0,   0,
   0,  36,  38,  39,  40,   0,   0,   0,  21,   0,
  38,  39,  40,   0,   0,   0,   0,  30,  12,   0,
   0,  22,   0,   0,   0,  15,  24,   0,   0,  14,
   0, 117,   0,  13,   0,   0,   0,   0,   0,   0,
   0,   0,  16,   0,   0,  18,  28,   0,  37,  25,
  26,  27,  21,  35,   0,  34, 465,  36,  29,   0,
 205, 330,   0, 472,  87,  15,  38,  39,  40,  14,
   0,   0,   0,  13,   0,   0,   0,  30,  12,   0,
   0,  22,  16,   0,   0,  18,  28, 286,  37,  25,
  26,  27,   0,  35,   0,  34,   0,  36,  29, 205,
 330,   0,   0,  87,   0,  15,  38,  39,  40,  14,
   0, 110,  21,  13, 110, 111,   0,   0, 111,   0,
   0,   0,  16,   0,   0,  18,  28,   0,  37,  25,
  26,  27,   0,  35,   0,  34,   0,  36,  29,  24,
   0,  15,   0,   0, 112, 135,  38,  39,  40, 134,
 110,   0,   0,   0, 111,   0,   0,   0,  16,  19,
   0,  18,  28,   0,  37,  25,  26,  27,   0,  35,
   0,  34,  62,  36,  29,   0,   0,  68,  69,   0,
   0,  72,  38,  39,  40,  15,  24,   0,   0,  14,
  30,  12,   0,  13,  22,   0,   0,   0,   0,   0,
   0,   0,  16, 205, 192,  18,  28,  87,  37,  25,
  26,  27,   0,  35,   0,  34,   0,  36,  29,   0,
   0, 119,   0,   0,   0,  21,  38,  39,  40, 211,
 429, 144,   0, 430,   0,   0,   0,  30,  12,   0,
   0,  22,   0, 158, 159,  15, 211, 314,   0,  14,
 315,   0,   0,  13, 110,   0,   0,   0, 111,   0,
   0,   0,  16,   0,   0,  18,  28,   0,  37,  25,
  26,  27,  21,  35,   0,  34, 108,  36,  29, 470,
 110, 211, 474,   0, 111, 475,  38,  39,  40, 211,
   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,
   0, 111,  37,   0,   0,  37, 531,  35,   0,   0,
 471,  36,   0, 211,  36, 108, 196,   0,   0, 101,
  38,  39,  40,  38,  39,  40,   0,   0,   0,  37,
   0,   0, 110,   0,  35,   0, 111,   0,  36,   0,
 110,  37, 216,   0, 111, 528,  35,  38,  39,  40,
  36,   0, 211,   0,   0, 196,   0,   0,  15,  38,
  39,  40,  14,   0, 110,   0,  13,   0, 111, 211,
 110,   0,   0,   0, 111,  16,   0,   0,  18,  28,
   0,  37,  25,  26,  27, 211,  35,   0,  34,   0,
  36,  29,   0,   0,   0,   0,   0,   0,   0,  38,
  39,  40, 211, 110,   0,  15, 394, 111,   0,  14,
   0,   0,   0,  13,   0,   0,   0,   0, 211, 108,
 110,   0,  16, 389, 111,  18,  28,   0,  37,  25,
  26,  27,   0,  35,   0,  34, 110,  36,  29,   0,
 111,   0,   0,   0,   0,  37,  38,  39,  40,   0,
  35,   0,   0, 110,  36,   0,   0, 111,   0, 196,
   0,   0,   0,  38,  39,  40,   0,   0,   0, 110,
  10,  37,   0, 111,   0,   0,  35,   0,   0,   0,
  36,   0,  60,   0,   0, 206,   0,   0,  37,  38,
  39,  40,   0,  35,   0,  82,   0,  36,   0,   0,
   0,   0, 206,   0,   0, 108,  38,  39,  40,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 113,   0,
   0,   0,   0,  37,   0,   0,   0,   0,  35, 108,
 116,  37,  36,   0,   0, 108,  35,   0,   0,   0,
  36,  38,  39,  40,   0,   0,   0,  60,   0,  38,
  39,  40,   0,   0,   0,  37,   0,   0,   0,   0,
  35,  37,   0,   0,  36,   0,  35,   0,   0,   0,
  36,   0,   0,  38,  39,  40,   0,   0,   0,  38,
  39,  40,   0, 218,   0,   0,   0,   0, 221,   0,
   0,   0,   0,   0,  37,   0,   0,   0,   0,  35,
   0,   0,   0,  36,   0,   0,   0,   0,   0,   0,
   0,  37,  38,  39,  40,   0,  35,   0,   0,   0,
  36,   0,   0,   0,   0, 213,   0,  37, 116,  38,
  39,  40,  35,   0,   0,   0,  36,   0,   0,   0,
   0,   0,   0,   0,  37,  38,  39,  40,   0,  35,
   0,   0,   0,  36,   0,   0,   0,   0,   0,   0,
  37,   0,  38,  39,  40,  35,   0,   0,   0,  36,
   0,   0,   0,   0,   0,   0,   0,   0,  38,  39,
  40 };
short yypact[]={

 -78,-1000,1083,-244,-1000,-112,-1000,-1000,-193, 101,
 101,1676, 800,  94,1083,1083, 113, 800, 800, 102,
 187, 800,-1000, 112,1123,-1000,-1000,-1000,-1000,-1000,
1083,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000, -88,-125,-1000,  94,1809,1629,-1000,-1000,
-1000,-1000,-1000,-219,-1000,-1000,-1000,-1000,-1000,1516,
-1000, 649, 102,-117,1336,-104, -93,1412, 102, 102,
 468, 800, 102, 468, 537, 436,1456, 430,-1000, 594,
 572, 225, 101, 800, 800, 570,-1000,-1000, 195, 149,
  41, 323, 921,-1000, 588,-1000,-1000,-1000,-1000,-235,
-1000,1693,1147,-1000,-1000,-1000, 151,1859,-1000,-1000,
1779,-1000,1676,-1000, 144, 141,-1000,1676,1083, 102,
1083,  77,-1000, 215,-1000,  51, 124, 187,1083, 107,
  77, 212,-1000,-222,  94,1083,  66, 315,-1000,-1000,
 197,-1000, 119,-1000, 102,  50,-1000,-1000,-1000,-1000,
-1000,1083,-1000,1083,-1000,1083,-160,1296, 185, 158,
-1000,-1000,1083,-1000,1083,1232,1083,  77,-1000, 211,
 209,-1000, 203,-1000,-1000,-1000,-1000,-151,-151,-151,
-208,-131,1577,1577,-153, 561,1577,1577, 581,-111,
1192,1803,-1000,1736, 564, 536, 562, 535, 470, 461,
 223,-1000,-1000, 151,-202, 848,1803,-1000,-1000,-1000,
-1000,1589,-184,1803,-1000, 130,-1000,1147,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,1376,1809,  13,
-1000,-112,-1000,1083,  65,-1000,1083,-108,1376,-1000,
1412,1083,-117,-104,-1000, 468,1083, 553, 478, 547,
 537,-1000,-1000,-1000, 485,-1000, 195,-1000,-1000,-1000,
-1000,-205, 301,-1000,-229,  94,-1000,-1000, 984,-1000,
-249,1029, 163,-1000, 163, 163,   9,-164,-1000,-1000,
-1000, 358,-1000,-1000,1892,-237,1240, 151,1875,-239,
-1000,  46,-1000,-1000,-170, 165,-1000,-112,-241,1908,
-112,-242,1908,1803,  93,-1000, 451,-1000,-1000,-1000,
 569,-164, 697,-1000,-1000,1803,-1000,1803,-1000,-195,
-1000,-1000,1803,-1000,-1000,1803,-1000,1803, 597,1803,
-1000,1719, 313, 478, 476,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000, 104,-1000,-1000,-1000, 194,1083,  77,
 202,-1000, -63,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,1083,1232,1083,-117,-1000,-1000, 984,-1000,-1000,
-1000, 273,-1000,-1000,-1000,-1000,-1000,-1000,-188,-1000,
 273, 273,-1000,-164, 567,  40,   5,1803,-1000,1553,
-131,-1000,1771, 239,  61,-131,1809, 330,-1000, 462,
-1000,-167,-1000,-167, 455, 257,-1000, 921,-1000, 845,
 411,-1000, 436, 434, 430,-1000,1147,-1000,-1000,1147,
-1000,1908,-1000,-1000,-1000, 423,-1000, 100,-1000,-1000,
1803,-1000,1803,-1000,1083,-1000,-1000,1376,-112,  52,
1083,-1000,-1000,1376,-1000,-1000,-1000,-1000, 201, 163,
 131, 128,  19,  40, 421,-1000, 250,-1000,-1000, 530,
-164,-1000,-118,  24,-1000,1908, 529, 708,1842,  82,
-1000,-1000,1550,  -4,-1000,-195,-1000,-195,-136,1908,
-1000,-176, -10,-1000,-1000,-1000,1908,1908,-1000,1803,
  77,-1000,-1000, 409, 402,-1000, 244,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-231, 984,-1000,-1000,
-1000,-1000, 400,-1000, 381,1053,  19,  13,-1000,1553,
  87,  57,1908,1908, 370,-178, 370,1908,1908,-1000,
 330, 372,1553,1908,1908,-1000,-1000,  61,-1000,-1000,
-1000,-1000, 417,1083,-1000,-1000,-1000, 343, 335,-1000,
 242,-1000,-1000,-1000, 232,-1000, 235,-1000,-207,-1000,
-1000,-167, 370,-1000,1908,-1000,-1000,-1000,-1000, 127,
-1000,  32,-1000,-1000,  24,-136,-1000,-1000,-1000,-1000,
  64,  13,1809, 327, 231,-1000,-1000,-1000,-1000, 330,
 758, 330,-1000,-1000,-1000,-1000,-1000,-1000,-167,-1000,
-1000,1803,-1000,-1000,-1000 };
short yypgo[]={

   0, 752,   7,  52, 749, 747, 746,  29,  13, 745,
 743,  46,  37,  34, 737, 169, 736,  26,   4,  18,
 435, 734, 733,  11, 147,  40,  16, 732,  27,  25,
 731, 729,   1,  14,  41, 395, 177,  36, 728, 166,
 173,  43,   8, 727, 589,  15,  21, 788,  12,   0,
   5,   2,  24,   6,  17,   9,  35, 726, 725,  30,
   3, 723, 721, 716, 715,  28, 714, 710, 709, 707,
 145,  88, 703, 361, 584, 651, 701, 697,  44,  33,
 158, 696, 695, 694, 416, 690, 686, 684, 221, 203,
  39, 680, 521, 650, 648,  42, 253, 678,2000, 674,
 669, 667, 666,1689, 263, 634, 662, 656, 220, 654,
  20, 646, 645,  19, 643, 219, 639, 201, 633,  31 };
short yyr1[]={

   0,   1,   1,   1,   4,   4,   4,   5,   9,  11,
  11,   7,   7,   7,   7,   7,  10,  10,  10,  10,
  16,  16,  17,  17,  17,  17,  17,  21,  21,  21,
  21,  22,  22,  23,  23,  14,  14,  15,  24,  24,
  24,  24,  24,  25,  25,  25,  26,  26,  26,  26,
  27,  27,  28,  28,  28,  28,  30,  30,  30,  30,
  31,  31,  32,  32,  13,  13,  34,  34,  34,  35,
  35,  36,  36,  12,  12,  12,  12,  38,  38,  38,
  38,  39,  39,  39,  39,  39,  39,  39,  39,  39,
  41,  41,  41,  43,  43,  50,  50,  45,  45,  52,
  52,  52,  52,  52,  52,  52,  57,  57,  57,  55,
  55,  58,  58,  60,  60,  48,  46,  46,  46,  62,
  62,  63,  63,  39,  64,  64,  64,  65,  65,  39,
  39,  39,  66,  66,  67,  67,  68,  68,  69,  69,
  51,  51,  47,  47,  47,  47,  47,  47,  71,  72,
  72,  72,  72,  72,  42,  42,  73,  73,  73,  73,
  53,  53,  56,  56,  44,  44,  59,  59,  74,  74,
  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,
  74,  75,  75,  70,  70,  76,  76,  76,  76,  77,
  77,  78,  80,  81,  81,  81,  81,  82,  82,  40,
  40,  85,  85,  86,  86,   3,   3,  87,  87,  88,
  61,  61,  83,  83,  29,  29,  79,  79,  79,  49,
  49,  49,  49,  18,  18,  18,  18,  89,  89,  37,
  37,  37,  92,  92,  92,  91,  91,  91,  93,  93,
  93,  90,  90,  33,  33,  19,  19,  20,  20,  95,
  95,  54,  54,  94,  94,   2,   2,  96,  96,  84,
  84,  97,  97,  97,  97,  97,  98,  98,  98,  98,
  98,  98,  99,  99, 102, 102, 102, 103, 103, 103,
 103, 103, 103, 103, 103, 103, 103, 103, 103, 103,
 103, 103, 103, 103, 103, 103, 103, 103, 103, 105,
 105, 106, 106, 108, 100, 100, 109, 109, 110, 111,
 111, 111, 112, 112, 113, 101, 101, 114, 114, 115,
 115, 115, 115, 104, 104, 116, 116, 117, 117, 107,
 107, 107, 107, 107, 107, 107, 107, 118, 118, 119,
 119, 119,   6,   8,   8 };
short yyr2[]={

   0,   3,   2,   1,   4,   7,   2,   0,   1,   1,
   1,   1,   3,   2,   4,   6,   0,   2,   3,   4,
   3,   1,   1,   1,   4,   4,   2,   0,   1,   1,
   2,   3,   1,   1,   1,   3,   1,   0,   3,   5,
   6,   4,   2,   0,   4,   3,   0,   1,   1,   2,
   3,   1,   1,   1,   4,   4,   0,   1,   1,   2,
   3,   1,   1,   1,   3,   1,   3,   3,   3,   1,
   0,   3,   1,   0,   1,   1,   2,   3,   3,   1,
   1,   4,   6,   5,   7,   2,   4,   5,   7,   2,
   2,   1,   1,   3,   1,   3,   1,   3,   1,   4,
   3,   3,   1,   1,   4,   1,   3,   3,   2,   2,
   1,   3,   1,   3,   4,   2,   0,   2,   4,   0,
   1,   3,   1,   4,   3,   1,   1,   2,   1,   3,
   3,   4,   3,   1,   3,   1,   0,   1,   3,   1,
   3,   1,   2,   1,   3,   3,   1,   3,   3,   3,
   3,   3,   3,   1,   1,   1,   1,   3,   3,   1,
   1,   1,   2,   1,   2,   1,   1,   1,   1,   2,
   3,   3,   3,   3,   3,   3,   3,   5,   3,   2,
   1,   2,   1,   3,   3,   3,   3,   3,   3,   3,
   1,   3,   3,   0,   1,   1,   2,   3,   1,   3,
   2,   2,   1,   2,   1,   2,   0,   2,   1,   4,
   3,   1,   3,   1,   1,   3,   1,   3,   3,   1,
   1,   1,   1,   1,   3,   3,   3,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   3,   1,   1,
   3,   1,   1,   1,   3,   1,   3,   1,   1,   1,
   1,   1,   3,   1,   3,   1,   1,   3,   1,   1,
   1,   4,   3,   2,   3,   4,   4,   4,   6,   6,
   4,   1,   2,   1,   2,   2,   1,   1,   3,   2,
   1,   1,   4,   4,   2,   1,   1,   1,   1,   3,
   3,   3,   5,   1,   3,   4,   4,   4,   3,   3,
   3,   3,   1,   3,   1,   2,   3,   1,   3,   1,
   2,   1,   2,   1,   4,   2,   1,   3,   1,   3,
   2,   2,   1,   0,   1,   3,   1,   1,   3,   0,
   1,   1,   3,   3,   4,   2,   5,   3,   1,   3,
   1,   2,   1,   1,   1 };
short yychk[]={

-1000,  -1, 257, 258, 256,  -2, -96, 256, -84, -97,
 -98,  45,  92, 267, 263, 259, 276,-102, 279,-103,
 -18, 126,  95, -19,  40, 283, 284, 285, 280, 292,
  91, -89, -20, -49, 289, 287, 291, 282, 300, 301,
 302,  -4,  -5, 298,  -3, 266, 293, -92, -93, -94,
  45, -90,  33,  96, -95, 281, 288, 286, 290, -92,
 -98, -99,-103, -80, 123,  -2,  -2, 123,-103,-103,
 123,  64,-103, 123, -90,  33,  45, -95,  41,  -2,
-105,-106, -98, -93, -94, -75,-108,  44, -89,-107,
  -2,-105,  -6, 256,  -9, 256, 287, -80, -51, -47,
 -42,  40, -44, -71, -73, -20, -49, -56, 256, -74,
  91,  95,  45, -98, -89, -20, -98,  45, 296,-103,
 268, -81,  59, -82, -40, -83, -84, -18, 264, 260,
-101,-114,-115, -96, 267, 263,-104,-116,-117, -29,
 -18, -79,  40, -49,-103,-104,  41,  41,  41,  41,
  41,  44,  41,  44,  41, 124,  44, -92,-103,-103,
  44,  41,  61,  93,  44, 124, 294,  -7, -12, -13,
 -14,  59, -38, -34, -24, -39, -40, 270, 271, 269,
 299, 262, 261, 273, 303, 272, 277, 278, 274, -10,
  40, 297,  41, -44, -70, -72, 296, -73, -75, -76,
 -77, -71, -78, -49, -79,  40, 296, -59, -74, -20,
 -49,  40,  92, 296, -59, -42,  93, -44, -98,  96,
  96, -98,  -2,  -2,  -8, 125, 256,  59, 293,  44,
 -85, -86, 256,  61, -87, -88, 124,  -2, 123,  -8,
  59, 295, -80,  -2, 125,  44,  61,  45, 281,  33,
 -90, 125,  -2,  -2,  -2,-108, -89,  41,  41,  41,
  -2,  -2,-118,-119,  -2, 267,  -2,  -8,  59, -15,
  59,  59, -35, 283, -35, -35, -11, 301, 256, 287,
 285, -41, 287, 256, -44, -47,  40, -49, -44, -47,
 283, -64, -65, 256, -29,  40, -49, -66, -47, -44,
 -67, -47, -44,  40, 266,  41, -16, -17, -18, -19,
 -20, 298,  40, -42,  41,  44,  41,  44,  41,  44,
  41,  41,  44,  41,  41,  44,  41, 124,  44, 293,
  41, -44, -70, 281,  33, -49, -42, -49, -42,  93,
 -40, -51, -18,  40,  -3,  -2, -88,  -2, 265,-100,
-109,-110, -84,-115,  -2,-117,  -2,  41,  41,  41,
  41, 294,  44, 295, -80, -12, -34, -15, -24, -39,
 -40, -36, -37, -91, -54,  45, 281,  33,  96, 286,
 -36, -36, -25, 302, 300,  40, -11,  61, -49,  61,
 297,  41, -44, -70,  61, 297, 293,  44, 285,  45,
  -3, 297,  -3, 297, -68, -69, -42, 123,  41,  44,
  40, -11,  33,  45, -95, -71, -44, -73, -71, -44,
 -73, -44, -71, -42, -42, -42, -78,  40, -42,  41,
  44,  41,  44,  41,  61,  -2,  -8,  59,-111,-112,
 296, 256,-113, 124,  -2,-119,  -2, -12, -13,  44,
 -49, 287, -11,  40, -26,  44, -27, -28, -29, 287,
 302, -25, -42, -45, -52,  33, -56, -44, -57, -33,
 256, 287,  40, -41,  41,  44,  41,  44, -48, -33,
 287,  40, -41, -51, -65,  41, -44, -44,  41,  44,
  -7,  41, -17, 294, -21,  44, -22, -23, -18, -19,
  41,  -2,-110,  -3,-113,  -2, -84,  59, -37,  96,
  96, -25, -26,  41,  44,  40, -11, 268, -46, 124,
 275, -53, -56, -44, -54,  96, -54,  33,  33, -59,
 123, 286,  61, -44, -44, -46, -59,  61, -42,  -8,
  41,  41,  44, 296, -12,  41, -28, 294, -30,  44,
 -31, -32, -29, -33,  40, -25, -43, -50, -18, -52,
 -20,  40, -54, -55,  33, -53, -55, -59, -59, -58,
 -60, -61, -29,  41, -45, -48, -23,  -2,  41,  41,
  44,  44, 293, -62, -63, -20, -55, -53, 125,  44,
 293,  44, -46, -46, -32, -50, -51,  41,  44, -60,
 -42,  33, -29, -20, -42 };
short yydef[]={

   0,  -2,   0,   7,   3, 206, 255, 256, 258, 259,
 260,   0,   0,   0,   0,   0,   0, 271,   0, 276,
 277,   0, 280, 281,   0, 285, 286, 287, 288, 293,
 329, 223, 245, 227, 228, 247, 248, 219, 220, 221,
 222,   2,   0,   0,   1,   0,   0,   0, 232, 233,
 234, 238, 239,   0, 253, 241, 242, 249, 250,   0,
 263,   0, 273,   0, 193,   0,   0,   0, 274, 275,
 323,   0, 279, 323, 238, 239,   0, 253, 284,   0,
   0,   0, 260,   0,   0,   0, 302, 182, 223,   0,
 330, 331,  73, 342,  16,   6,   8, 205, 257,   0,
 141,   0,  -2, 146, 154, 165, 168, 156, 159, 163,
   0, 180,   0, 262,   0,   0, 264,   0,   0, 272,
   0,   0, 194, 195, 198,   0,   0,  -2,   0,   0,
   0, 316, 318, 322,   0,   0,   0, 324, 326, 327,
   0, 214,   0,  -2, 278,   0, 224, 225, 226, 246,
 289,   0, 290,   0, 291,   0,   0,   0,   0,   0,
 181, 298,   0, 294,   0,   0, 335,   0,  11,   0,
  37,  74,  75,  65,  36,  79,  80,  70,  70,  70,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,
   0, 153, 190,  -2,   0,   0,   0, 164, 166, 167,
 168,   0,   0,   0, 162,   0, 179, 155, 261, 240,
 254, 265, 266, 267, 192, 343, 344, 196,   0,   0,
 200, 206, 202,   0, 204, 208,   0,   0,   0, 270,
 315,   0, 320, 321, 283,   0,   0,   0,   0,   0,
   0, 282, 300, 299,   0, 301,   0, 295, 296, 297,
 303, 300, 332, 338, 340,   0, 333,   4,  73,  13,
  37,  76,   0,  69,   0,   0,  43,   0,  42,   9,
  10,   0,  91,  92,  -2,   0,   0,   0, 143,   0,
  89,   0, 125, 126, 128,   0, 216, 206,   0,  -2,
 206,   0,  -2, 136,   0,  17,   0,  21,  22,  23,
 245,   0,   0, 140,  -2,   0,  -2,   0, 147,   0,
 170, 171,   0, 173, 175,   0, 176,   0,   0,   0,
 169,   0,   0,   0,   0,  -2, 158, 148, 157, 178,
 197, 199, 212,   0, 201, 203, 207,   0,   0,   0,
 304, 307,   0, 317, 319, 325, 328,  -2, 217,  -2,
 292, 334,   0,   0, 341,  12,  64,  73,  35,  77,
  78,  66,  72, 229, 230, 231, 235, 236,   0, 251,
  67,  68,  38,   0,   0,  46,  43,   0,  90,   0,
   0, 142,   0,   0,   0,   0,   0,   0, 127,   0,
 129,   0, 130,   0,   0, 137, 139,  73,  18,   0,
  27,  26,   0,   0,   0, 152, 184, 186, 149, 183,
 187, 150, 151, 185, 188,   0, 189,   0, 191, 172,
   0, 174,   0, 218,   0, 268, 269, 305, 206, 309,
   0, 311, 313,   0, 336, 337, 339,  14,   0,   0,
   0,   0,  43,  46,   0,  47,  48,  51,  52,  53,
   0,  41,  81, 116,  98,   0,   0, 102, 103,   0,
 105,  -2,   0,  86, 144,   0, 145,   0, 116,   0,
 243,   0,   0, 123, 124, 215, 132, 134, 131,   0,
   0,  19,  20,   0,   0,  28,  29,  32,  33,  34,
 177, 209, 306, 308, 312, 310,   0,  73,  71, 237,
 252,  39,   0,  45,  49,  56,  43,   0,  83,   0,
   0,   0, 160, 161,   0,   0,   0,   0,   0, 108,
   0,   0,   0, 184, 183,  87, 115,   0, 138,   5,
  24,  25,  30,   0,  15,  44,  50,   0,   0,  57,
  58,  61,  62,  63,   0,  40,  82,  94,  96,  97,
 117, 119,   0, 100,   0, 110, 101, 106, 107,   0,
 112,   0, 211, 244, 116, 116,  31, 314,  54,  55,
  59,   0,   0,   0, 120, 122,  99, 109, 104,   0,
   0,   0,  84,  88,  60,  93,  95, 118,   0, 111,
 113,   0, 210, 121, 114 };
#define YYFLAG   -1000
#define YYERROR  goto yyerrlab
#define YYACCEPT return(0)
#define YYABORT  return(1)

/*      parser for yacc output  */

#ifdef YYDEBUG
int yydebug     = 0;     /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar      = -1;    /* current input token number */
int yynerrs     = 0;     /* number of errors */
short yyerrflag = 0;     /* error recovery flag */

int yyparse() {
    short yys[YYMAXDEPTH];
    short yyj, yym;
    register YYSTYPE *yypvt;
    register short yystate, *yyps, yyn;
    register YYSTYPE *yypv;
    register short *yyxi;

    yystate   = 0;
    yychar    = -1;
    yynerrs   = 0;
    yyerrflag = 0;
    yyps      = &yys[-1];
    yypv      = &yyv[-1];

yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
    if (yydebug)
        printf("state %d, char 0%o\n", yystate, yychar);
#endif
    if(++yyps>&yys[YYMAXDEPTH]) {
        yyerror("yacc stack overflow");
        return(1);
    }
    *yyps = yystate;
    ++yypv;
#ifdef UNION
    yyunion(yypv, &yyval);
#else
    *yypv = yyval;
#endif

yynewstate:

    yyn = yypact[yystate];

    if (yyn<=YYFLAG)
        goto yydefault; /* simple state */

    if (yychar<0)
        if ((yychar=yylex())<0)
            yychar=0;
    if ((yyn+=yychar)<0 || yyn>=YYLAST)
        goto yydefault;

    if (yychk[yyn=yyact[yyn]]==yychar) {
        /* valid shift */
        yychar = -1;
#ifdef UNION
        yyunion(&yyval, &yylval);
#else
        yyval = yylval;
#endif
        yystate = yyn;
        if (yyerrflag>0)
            --yyerrflag;
        goto yystack;

    }

yydefault:

    /* default state action */

    if ((yyn=yydef[yystate])== -2) {
        if (yychar<0)
            if ((yychar=yylex())<0)
                yychar = 0;
        /* look through exception table */

        for (yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2)
            ; /* VOID */

        for (yyxi+=2; *yyxi >= 0; yyxi+=2) {
            if (*yyxi==yychar)
                break;
        }
        if ((yyn=yyxi[1])<0)
            return(0);   /* accept */
    }

    if (yyn==0) {
        /* error */
        /* error ... attempt to resume parsing */

        switch (yyerrflag) {
            case 0: /* brand new error */
                    yyerror( "syntax error" );

yyerrlab:           ++yynerrs;

            case 1:
            case 2: /* incompletely recovered error ... try again */

                    yyerrflag = 3;

                    /* find a state where "error" is a legal shift action */

                    while (yyps>=yys) {
                        yyn = yypact[*yyps] + YYERRCODE;
                        if (yyn>=0 && yyn<YYLAST
                                   && yychk[yyact[yyn]]==YYERRCODE) {
                            yystate = yyact[yyn];
                            /* simulate a shift of "error" */
                            goto yystack;
                        }
                        yyn = yypact[*yyps];

                        /* the current yyps has no shift on "error",
                           pop stack */

#ifdef YYDEBUG
                        if (yydebug)
                            printf("error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1]);
#endif

                        --yyps;
                        --yypv;
                    }

                    /* there is no state on the stack with an error shift
                       ... abort */

yyabort:            return(1);


            case 3: /* no shift yet; clobber input char */
#ifdef YYDEBUG
                    if (yydebug)
                        printf("error recovery discards char %d\n", yychar);
#endif

                    if (yychar==0)
                        goto yyabort; /* don't discard EOF, quit */
                    yychar = -1;
                    goto yynewstate;   /* try again in the same state */
        }
    }

    /* reduction by production yyn */

#ifdef YYDEBUG
    if (yydebug)
        printf("reduce %d\n",yyn);
#endif
    yyps -= yyr2[yyn];
    yypvt = yypv;
    yypv -= yyr2[yyn];
#ifdef UNION
    yyunion(&yyval, &yypv[1]);
#else
    yyval = yypv[1];
#endif
    yym=yyn;
    /* consult goto table to find next state */
    yyn = yyr1[yyn];
    yyj = yypgo[yyn] + *yyps + 1;
    if (yyj>=YYLAST || yychk[yystate=yyact[yyj]]!= -yyn)
        yystate = yyact[yypgo[yyn]];
    switch(yym) {
        
case 1:
# line 99
{inputExpr = letrec(yypvt[-0],yypvt[-1]); sp-=2;} break;
case 2:
# line 100
{valDefns  = yypvt[-0];            sp-=1;} break;
case 3:
# line 101
{syntaxError("input");} break;
case 4:
# line 114
{
                                         setExportList(singleton(ap(MODULEENT,mkCon(module(currentModule).text))));
                                         yyval = gc3(yypvt[-1]);
                                        } break;
case 5:
# line 119
{setExportList(yypvt[-4]);   yyval = gc7(yypvt[-1]);} break;
case 6:
# line 120
{syntaxError("module definition");} break;
case 7:
# line 126
{startModule(conMain); 
					 yyval = gc0(NIL);} break;
case 8:
# line 129
{startModule(yypvt[-0]); yyval = gc1(NIL);} break;
case 9:
# line 131
{yyval = yypvt[-0];} break;
case 10:
# line 132
{ static String scriptFile;
                                          String modName = findPathname(scriptFile,textToStr(textOf(yypvt[-0])));
                                          if (modName) { /* fillin pathname if known */
					      yyval = mkStr(findText(modName));
					  } else {
					      yyval = yypvt[-0];
					  }
                                        } break;
case 11:
# line 141
{yyval = yypvt[-0];} break;
case 12:
# line 142
{yyval = gc3(yypvt[-0]);} break;
case 13:
# line 143
{yyval = gc2(NIL);} break;
case 14:
# line 144
{yyval = gc4(yypvt[-0]);} break;
case 15:
# line 146
{yyval = gc6(yypvt[-0]);} break;
case 16:
# line 151
{yyval = gc0(exportSelf());} break;
case 17:
# line 152
{yyval = gc2(NIL);} break;
case 18:
# line 153
{yyval = gc3(yypvt[-1]);} break;
case 19:
# line 154
{yyval = gc4(yypvt[-2]);} break;
case 20:
# line 156
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 21:
# line 157
{yyval = gc1(singleton(yypvt[-0]));} break;
case 22:
# line 162
{yyval = yypvt[-0];} break;
case 23:
# line 163
{yyval = yypvt[-0];} break;
case 24:
# line 164
{yyval = gc4(pair(yypvt[-3],DOTDOT));} break;
case 25:
# line 165
{yyval = gc4(pair(yypvt[-3],yypvt[-1]));} break;
case 26:
# line 166
{yyval = gc2(ap(MODULEENT,yypvt[-0]));} break;
case 27:
# line 168
{yyval = gc0(NIL);} break;
case 28:
# line 169
{yyval = gc1(NIL);} break;
case 29:
# line 170
{yyval = yypvt[-0];} break;
case 30:
# line 171
{yyval = gc2(yypvt[-1]);} break;
case 31:
# line 173
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 32:
# line 174
{yyval = gc1(singleton(yypvt[-0]));} break;
case 33:
# line 176
{yyval = yypvt[-0];} break;
case 34:
# line 177
{yyval = yypvt[-0];} break;
case 35:
# line 182
{imps = cons(yypvt[-0],imps); yyval=gc3(NIL);} break;
case 36:
# line 183
{imps = singleton(yypvt[-0]); yyval=gc1(NIL);} break;
case 37:
# line 185
{if (chase(imps)) {
					     clearStack();
					     onto(imps);
                                             done();
					     closeAnyInput();
					     return 0;
					 }
					 yyval = gc0(NIL);
					} break;
case 38:
# line 196
{addQualImport(yypvt[-1],yypvt[-1]);
					 addUnqualImport(yypvt[-1],yypvt[-0]);
                                         yyval = gc3(yypvt[-1]);} break;
case 39:
# line 200
{addQualImport(yypvt[-3],yypvt[-1]);
					 addUnqualImport(yypvt[-3],yypvt[-0]);
                                         yyval = gc5(yypvt[-3]);} break;
case 40:
# line 204
{addQualImport(yypvt[-3],yypvt[-1]);
                                         yyval = gc6(yypvt[-3]);} break;
case 41:
# line 207
{addQualImport(yypvt[-1],yypvt[-1]);
                                         yyval = gc4(yypvt[-1]);} break;
case 42:
# line 209
{syntaxError("import declaration");} break;
case 43:
# line 211
{yyval = gc0(DOTDOT);} break;
case 44:
# line 212
{yyval = gc4(ap(HIDDEN,yypvt[-1]));} break;
case 45:
# line 213
{yyval = gc3(yypvt[-1]);} break;
case 46:
# line 215
{yyval = gc0(NIL);} break;
case 47:
# line 216
{yyval = gc1(NIL);} break;
case 48:
# line 217
{yyval = yypvt[-0];} break;
case 49:
# line 218
{yyval = gc2(yypvt[-1]);} break;
case 50:
# line 220
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 51:
# line 221
{yyval = gc1(singleton(yypvt[-0]));} break;
case 52:
# line 223
{yyval = yypvt[-0];} break;
case 53:
# line 224
{yyval = yypvt[-0];} break;
case 54:
# line 225
{yyval = gc4(pair(yypvt[-3],DOTDOT));} break;
case 55:
# line 226
{yyval = gc4(pair(yypvt[-3],yypvt[-1]));} break;
case 56:
# line 228
{yyval = gc0(NIL);} break;
case 57:
# line 229
{yyval = gc1(NIL);} break;
case 58:
# line 230
{yyval = yypvt[-0];} break;
case 59:
# line 231
{yyval = gc2(yypvt[-1]);} break;
case 60:
# line 233
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 61:
# line 234
{yyval = gc1(singleton(yypvt[-0]));} break;
case 62:
# line 236
{yyval = yypvt[-0];} break;
case 63:
# line 237
{yyval = yypvt[-0];} break;
case 64:
# line 242
{yyval = gc2(NIL);} break;
case 65:
# line 243
{yyval = gc0(NIL);} break;
case 66:
# line 245
{fixDefn(LEFT_ASS,yypvt[-2],yypvt[-1],yypvt[-0]); sp-=3;} break;
case 67:
# line 246
{fixDefn(RIGHT_ASS,yypvt[-2],yypvt[-1],yypvt[-0]);sp-=3;} break;
case 68:
# line 247
{fixDefn(NON_ASS,yypvt[-2],yypvt[-1],yypvt[-0]);  sp-=3;} break;
case 69:
# line 249
{yyval = gc1(checkPrec(yypvt[-0]));} break;
case 70:
# line 250
{yyval = gc0(mkInt(DEF_PREC));} break;
case 71:
# line 252
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 72:
# line 253
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 73:
# line 258
{yyval = gc0(NIL);} break;
case 74:
# line 259
{yyval = gc1(NIL);} break;
case 75:
# line 260
{yyval = yypvt[-0];} break;
case 76:
# line 261
{yyval = gc2(yypvt[-1]);} break;
case 77:
# line 263
{yyval = gc2(yypvt[-2]);} break;
case 78:
# line 264
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 79:
# line 265
{yyval = gc0(NIL);} break;
case 80:
# line 266
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 81:
# line 271
{defTycon(4,yypvt[-1],yypvt[-2],yypvt[-0],SYNONYM);} break;
case 82:
# line 273
{defTycon(6,yypvt[-3],yypvt[-4],
						    ap(yypvt[-2],yypvt[-0]),RESTRICTSYN);} break;
case 83:
# line 276
{defTycon(5,yypvt[-2],checkTyLhs(yypvt[-3]),
						    ap(rev(yypvt[-1]),yypvt[-0]),DATATYPE);} break;
case 84:
# line 279
{defTycon(7,yypvt[-2],yypvt[-3],
						  ap(ap(QUAL,pair(yypvt[-5],rev(yypvt[-1]))),
						     yypvt[-0]),DATATYPE);} break;
case 85:
# line 282
{defTycon(2,yypvt[-1],checkTyLhs(yypvt[-0]),
						    ap(NIL,NIL),DATATYPE);} break;
case 86:
# line 284
{defTycon(4,yypvt[-3],yypvt[-0],
						  ap(ap(QUAL,pair(yypvt[-2],NIL)),
						     NIL),DATATYPE);} break;
case 87:
# line 288
{defTycon(5,yypvt[-2],checkTyLhs(yypvt[-3]),
						    ap(yypvt[-1],yypvt[-0]),NEWTYPE);} break;
case 88:
# line 291
{defTycon(7,yypvt[-2],yypvt[-3],
						  ap(ap(QUAL,pair(yypvt[-5],yypvt[-1])),
						     yypvt[-0]),NEWTYPE);} break;
case 89:
# line 294
{needPrims(intOf(yypvt[-0])); sp-=2;} break;
case 90:
# line 296
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 91:
# line 297
{yyval = yypvt[-0];} break;
case 92:
# line 298
{syntaxError("type defn lhs");} break;
case 93:
# line 300
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 94:
# line 301
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 95:
# line 303
{yyval = gc3(sigdecl(yypvt[-1],singleton(yypvt[-2]),
							     yypvt[-0]));} break;
case 96:
# line 305
{yyval = yypvt[-0];} break;
case 97:
# line 307
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 98:
# line 308
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 99:
# line 310
{yyval = gc4(ap(ap(yypvt[-1],bang(yypvt[-2])),yypvt[-0]));} break;
case 100:
# line 311
{yyval = gc3(ap(ap(yypvt[-1],yypvt[-2]),yypvt[-0]));} break;
case 101:
# line 312
{yyval = gc3(ap(ap(yypvt[-1],yypvt[-2]),yypvt[-0]));} break;
case 102:
# line 313
{yyval = yypvt[-0];} break;
case 103:
# line 314
{yyval = yypvt[-0];} break;
case 104:
# line 315
{yyval = gc4(ap(LABC,pair(yypvt[-3],rev(yypvt[-1]))));} break;
case 105:
# line 316
{syntaxError("data type definition");} break;
case 106:
# line 318
{yyval = gc3(ap(yypvt[-2],bang(yypvt[-0])));} break;
case 107:
# line 319
{yyval = gc3(ap(yypvt[-2],bang(yypvt[-0])));} break;
case 108:
# line 320
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 109:
# line 322
{yyval = gc2(bang(yypvt[-0]));} break;
case 110:
# line 323
{yyval = yypvt[-0];} break;
case 111:
# line 325
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 112:
# line 326
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 113:
# line 328
{yyval = gc3(pair(rev(yypvt[-2]),yypvt[-0]));} break;
case 114:
# line 329
{yyval = gc4(pair(rev(yypvt[-3]),bang(yypvt[-0])));} break;
case 115:
# line 331
{yyval = gc2(singleton(ap(yypvt[-1],yypvt[-0])));} break;
case 116:
# line 333
{yyval = gc0(NIL);} break;
case 117:
# line 334
{yyval = gc2(singleton(yypvt[-0]));} break;
case 118:
# line 335
{yyval = gc4(yypvt[-1]);} break;
case 119:
# line 337
{yyval = gc0(NIL);} break;
case 120:
# line 338
{yyval = gc1(rev(yypvt[-0]));} break;
case 121:
# line 340
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 122:
# line 341
{yyval = gc1(singleton(yypvt[-0]));} break;
case 123:
# line 346
{primDefn(yypvt[-3],yypvt[-2],yypvt[-0]); sp-=4;} break;
case 124:
# line 348
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 125:
# line 349
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 126:
# line 350
{syntaxError("primitive defn");} break;
case 127:
# line 352
{yyval = gc2(pair(yypvt[-1],yypvt[-0]));} break;
case 128:
# line 353
{yyval = yypvt[-0];} break;
case 129:
# line 358
{classDefn(intOf(yypvt[-2]),yypvt[-1],yypvt[-0]); sp-=3;} break;
case 130:
# line 359
{instDefn(intOf(yypvt[-2]),yypvt[-1],yypvt[-0]);  sp-=3;} break;
case 131:
# line 360
{defaultDefn(intOf(yypvt[-3]),yypvt[-1]);  sp-=4;} break;
case 132:
# line 362
{yyval = gc3(pair(yypvt[-2],checkClass(yypvt[-0])));} break;
case 133:
# line 363
{yyval = gc1(pair(NIL,checkClass(yypvt[-0])));} break;
case 134:
# line 365
{yyval = gc3(pair(yypvt[-2],checkInst(yypvt[-0])));} break;
case 135:
# line 366
{yyval = gc1(pair(NIL,checkInst(yypvt[-0])));} break;
case 136:
# line 368
{yyval = gc0(NIL);} break;
case 137:
# line 369
{yyval = gc1(rev(yypvt[-0]));} break;
case 138:
# line 371
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 139:
# line 372
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 140:
# line 377
{yyval = gc3(ap(QUAL,pair(yypvt[-2],yypvt[-0])));} break;
case 141:
# line 378
{yyval = yypvt[-0];} break;
case 142:
# line 380
{yyval = gc2(NIL);} break;
case 143:
# line 381
{yyval = gc1(singleton(checkClass(yypvt[-0])));} break;
case 144:
# line 382
{yyval = gc3(singleton(checkClass(yypvt[-1])));} break;
case 145:
# line 383
{yyval = gc3(checkContext(yypvt[-1]));} break;
case 146:
# line 385
{yyval = gc1(singleton(yypvt[-0]));} break;
case 147:
# line 386
{yyval = gc3(checkContext(yypvt[-1]));} break;
case 148:
# line 388
{
#if TREX
                                         yyval = gc3(ap(mkExt(textOf(yypvt[-0])),yypvt[-2]));
#else
                                         noTREX("a type context");
#endif
                                        } break;
case 149:
# line 396
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 150:
# line 397
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 151:
# line 398
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 152:
# line 399
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 153:
# line 400
{yyval = gc1(singleton(yypvt[-0]));} break;
case 154:
# line 404
{yyval = yypvt[-0];} break;
case 155:
# line 405
{yyval = yypvt[-0];} break;
case 156:
# line 407
{yyval = yypvt[-0];} break;
case 157:
# line 408
{yyval = gc3(ap(ap(typeArrow,yypvt[-2]),yypvt[-0]));} break;
case 158:
# line 409
{yyval = gc3(ap(ap(typeArrow,yypvt[-2]),yypvt[-0]));} break;
case 159:
# line 410
{syntaxError("type expression");} break;
case 160:
# line 412
{yyval = yypvt[-0];} break;
case 161:
# line 413
{yyval = yypvt[-0];} break;
case 162:
# line 415
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 163:
# line 416
{yyval = yypvt[-0];} break;
case 164:
# line 418
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 165:
# line 419
{yyval = yypvt[-0];} break;
case 166:
# line 421
{yyval = yypvt[-0];} break;
case 167:
# line 422
{yyval = yypvt[-0];} break;
case 168:
# line 424
{yyval = yypvt[-0];} break;
case 169:
# line 425
{yyval = gc2(typeUnit);} break;
case 170:
# line 426
{yyval = gc3(typeArrow);} break;
case 171:
# line 427
{yyval = gc3(yypvt[-1]);} break;
case 172:
# line 428
{yyval = gc3(yypvt[-1]);} break;
case 173:
# line 429
{yyval = gc3(yypvt[-1]);} break;
case 174:
# line 430
{yyval = gc3(buildTuple(yypvt[-1]));} break;
case 175:
# line 431
{yyval = gc3(buildTuple(yypvt[-1]));} break;
case 176:
# line 433
{
#if TREX
                                         yyval = gc3(revOnto(yypvt[-1],typeNoRow));
#else
                                         noTREX("a type");
#endif
                                        } break;
case 177:
# line 440
{yyval = gc5(revOnto(yypvt[-3],yypvt[-1]));} break;
case 178:
# line 442
{yyval = gc3(ap(typeList,yypvt[-1]));} break;
case 179:
# line 443
{yyval = gc2(typeList);} break;
case 180:
# line 444
{yyval = gc1(inventVar());} break;
case 181:
# line 446
{yyval = gc2(mkTuple(tupleOf(yypvt[-1])+1));} break;
case 182:
# line 447
{yyval = gc1(mkTuple(2));} break;
case 183:
# line 449
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 184:
# line 450
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 185:
# line 452
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 186:
# line 453
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 187:
# line 454
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 188:
# line 455
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 189:
# line 458
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 190:
# line 459
{yyval = gc1(singleton(yypvt[-0]));} break;
case 191:
# line 461
{yyval = gc3(ap(mkExt(textOf(yypvt[-2])),yypvt[-0]));} break;
case 192:
# line 467
{yyval = gc3(yypvt[-1]);} break;
case 193:
# line 469
{yyval = gc0(NIL);} break;
case 194:
# line 470
{yyval = gc1(NIL);} break;
case 195:
# line 471
{yyval = yypvt[-0];} break;
case 196:
# line 472
{yyval = gc2(yypvt[-1]);} break;
case 197:
# line 474
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 198:
# line 475
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 199:
# line 478
{yyval = gc3(sigdecl(yypvt[-1],yypvt[-2],yypvt[-0]));} break;
case 200:
# line 479
{yyval = gc2(pair(yypvt[-1],yypvt[-0]));} break;
case 201:
# line 481
{yyval = gc2(letrec(yypvt[-0],yypvt[-1]));} break;
case 202:
# line 482
{syntaxError("declaration");} break;
case 203:
# line 484
{yyval = gc2(pair(yypvt[-1],yypvt[-0]));} break;
case 204:
# line 485
{yyval = gc1(grded(rev(yypvt[-0])));} break;
case 205:
# line 487
{yyval = gc2(yypvt[-0]);} break;
case 206:
# line 488
{yyval = gc0(NIL);} break;
case 207:
# line 490
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 208:
# line 491
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 209:
# line 493
{yyval = gc4(pair(yypvt[-1],pair(yypvt[-2],yypvt[-0])));} break;
case 210:
# line 495
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 211:
# line 496
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 212:
# line 498
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 213:
# line 499
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 214:
# line 504
{yyval = yypvt[-0];} break;
case 215:
# line 505
{yyval = gc3(varMinus);} break;
case 216:
# line 507
{yyval = yypvt[-0];} break;
case 217:
# line 508
{yyval = gc3(yypvt[-1]);} break;
case 218:
# line 509
{yyval = gc3(varBang);} break;
case 219:
# line 511
{yyval = yypvt[-0];} break;
case 220:
# line 512
{yyval = gc1(varHiding);} break;
case 221:
# line 513
{yyval = gc1(varQualified);} break;
case 222:
# line 514
{yyval = gc1(varAsMod);} break;
case 223:
# line 516
{yyval = yypvt[-0];} break;
case 224:
# line 517
{yyval = gc3(yypvt[-1]);} break;
case 225:
# line 518
{yyval = gc3(varBang);} break;
case 226:
# line 519
{yyval = gc3(varMinus);} break;
case 227:
# line 521
{yyval = yypvt[-0];} break;
case 228:
# line 522
{yyval = yypvt[-0];} break;
case 229:
# line 525
{yyval = yypvt[-0];} break;
case 230:
# line 526
{yyval = yypvt[-0];} break;
case 231:
# line 527
{yyval = gc1(varMinus);} break;
case 232:
# line 529
{yyval = yypvt[-0];} break;
case 233:
# line 530
{yyval = yypvt[-0];} break;
case 234:
# line 531
{yyval = gc1(varMinus);} break;
case 235:
# line 534
{yyval = yypvt[-0];} break;
case 236:
# line 535
{yyval = gc1(varBang);} break;
case 237:
# line 536
{yyval = gc3(yypvt[-1]);} break;
case 238:
# line 538
{yyval = yypvt[-0];} break;
case 239:
# line 539
{yyval = gc1(varBang);} break;
case 240:
# line 540
{yyval = gc3(yypvt[-1]);} break;
case 241:
# line 542
{yyval = yypvt[-0];} break;
case 242:
# line 543
{yyval = yypvt[-0];} break;
case 243:
# line 546
{yyval = yypvt[-0];} break;
case 244:
# line 547
{yyval = gc3(yypvt[-1]);} break;
case 245:
# line 549
{yyval = yypvt[-0];} break;
case 246:
# line 550
{yyval = gc3(yypvt[-1]);} break;
case 247:
# line 552
{yyval = yypvt[-0];} break;
case 248:
# line 553
{yyval = yypvt[-0];} break;
case 249:
# line 555
{yyval = yypvt[-0];} break;
case 250:
# line 556
{yyval = yypvt[-0];} break;
case 251:
# line 559
{yyval = yypvt[-0];} break;
case 252:
# line 560
{yyval = gc3(yypvt[-1]);} break;
case 253:
# line 562
{yyval = yypvt[-0];} break;
case 254:
# line 563
{yyval = gc3(yypvt[-1]);} break;
case 255:
# line 568
{yyval = yypvt[-0];} break;
case 256:
# line 569
{syntaxError("expression");} break;
case 257:
# line 571
{yyval = gc3(ap(ESIGN,pair(yypvt[-2],yypvt[-0])));} break;
case 258:
# line 572
{yyval = yypvt[-0];} break;
case 259:
# line 574
{yyval = gc1(tidyInfix(yypvt[-0]));} break;
case 260:
# line 575
{yyval = yypvt[-0];} break;
case 261:
# line 577
{yyval = gc4(ap(NEG,ap(ap(yypvt[-2],yypvt[-3]),yypvt[-0])));} break;
case 262:
# line 578
{yyval = gc3(ap(ap(yypvt[-1],yypvt[-2]),yypvt[-0]));} break;
case 263:
# line 579
{yyval = gc2(ap(NEG,only(yypvt[-0])));} break;
case 264:
# line 580
{yyval = gc3(ap(ap(yypvt[-1],only(yypvt[-2])),yypvt[-0]));} break;
case 265:
# line 581
{yyval = gc4(ap(NEG,
                                                     ap(ap(yypvt[-2],only(yypvt[-3])),yypvt[-0])));} break;
case 266:
# line 584
{yyval = gc4(ap(LAMBDA,      
  						     pair(rev(yypvt[-2]),
  							  pair(yypvt[-1],yypvt[-0]))));} break;
case 267:
# line 587
{yyval = gc4(letrec(yypvt[-2],yypvt[-0]));} break;
case 268:
# line 588
{yyval = gc6(ap(COND,triple(yypvt[-4],yypvt[-2],yypvt[-0])));} break;
case 269:
# line 589
{yyval = gc6(ap(CASE,pair(yypvt[-4],rev(yypvt[-1]))));} break;
case 270:
# line 590
{yyval = gc4(ap(DOCOMP,checkDo(yypvt[-1])));} break;
case 271:
# line 591
{yyval = yypvt[-0];} break;
case 272:
# line 593
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 273:
# line 594
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 274:
# line 596
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 275:
# line 597
{yyval = gc2(ap(RUNST,yypvt[-0]));} break;
case 276:
# line 598
{yyval = yypvt[-0];} break;
case 277:
# line 600
{yyval = yypvt[-0];} break;
case 278:
# line 601
{yyval = gc3(ap(ASPAT,pair(yypvt[-2],yypvt[-0])));} break;
case 279:
# line 602
{yyval = gc2(ap(LAZYPAT,yypvt[-0]));} break;
case 280:
# line 603
{yyval = gc1(WILDCARD);} break;
case 281:
# line 604
{yyval = yypvt[-0];} break;
case 282:
# line 605
{yyval = gc4(ap(CONFLDS,pair(yypvt[-3],yypvt[-1])));} break;
case 283:
# line 606
{yyval = gc4(ap(UPDFLDS,
						     triple(yypvt[-3],NIL,yypvt[-1])));} break;
case 284:
# line 608
{yyval = gc2(nameUnit);} break;
case 285:
# line 609
{yyval = yypvt[-0];} break;
case 286:
# line 610
{yyval = yypvt[-0];} break;
case 287:
# line 611
{yyval = yypvt[-0];} break;
case 288:
# line 612
{yyval = yypvt[-0];} break;
case 289:
# line 613
{yyval = gc3(yypvt[-1]);} break;
case 290:
# line 614
{yyval = gc3(buildTuple(yypvt[-1]));} break;
case 291:
# line 616
{
#if TREX
                                         yyval = gc3(revOnto(yypvt[-1],nameNoRec));
#else
                                         yyval = gc3(NIL);
#endif
                                        } break;
case 292:
# line 623
{yyval = gc5(revOnto(yypvt[-3],yypvt[-1]));} break;
case 293:
# line 624
{yyval = yypvt[-0];} break;
case 294:
# line 626
{yyval = gc3(yypvt[-1]);} break;
case 295:
# line 627
{yyval = gc4(ap(yypvt[-1],yypvt[-2]));} break;
case 296:
# line 628
{yyval = gc4(ap(ap(nameFlip,yypvt[-2]),yypvt[-1]));} break;
case 297:
# line 629
{yyval = gc4(ap(ap(nameFlip,yypvt[-2]),yypvt[-1]));} break;
case 298:
# line 630
{yyval = gc3(yypvt[-1]);} break;
case 299:
# line 632
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 300:
# line 633
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 301:
# line 636
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 302:
# line 637
{yyval = gc1(singleton(yypvt[-0]));} break;
case 303:
# line 639
{
#if TREX
                                         yyval = gc3(ap(mkExt(textOf(yypvt[-2])),yypvt[-0]));
#else
                                         noTREX("an expression");
#endif
                                        } break;
case 304:
# line 648
{yyval = yypvt[-0];} break;
case 305:
# line 649
{yyval = gc2(yypvt[-1]);} break;
case 306:
# line 651
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 307:
# line 652
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 308:
# line 654
{yyval = gc3(pair(yypvt[-2],letrec(yypvt[-0],yypvt[-1])));} break;
case 309:
# line 656
{yyval = gc1(grded(rev(yypvt[-0])));} break;
case 310:
# line 657
{yyval = gc2(pair(yypvt[-1],yypvt[-0]));} break;
case 311:
# line 658
{syntaxError("case expression");} break;
case 312:
# line 660
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 313:
# line 661
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 314:
# line 663
{yyval = gc4(pair(yypvt[-1],pair(yypvt[-2],yypvt[-0])));} break;
case 315:
# line 665
{yyval = gc2(yypvt[-1]);} break;
case 316:
# line 666
{yyval = yypvt[-0];} break;
case 317:
# line 668
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 318:
# line 669
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 319:
# line 671
{yyval = gc3(ap(FROMQUAL,pair(yypvt[-2],yypvt[-0])));} break;
case 320:
# line 672
{yyval = gc2(ap(QWHERE,yypvt[-0]));} break;
case 321:
# line 673
{yyval = gc2(ap(BOOLQUAL,yypvt[-0]));} break;
case 322:
# line 674
{yyval = gc1(ap(DOQUAL,yypvt[-0]));} break;
case 323:
# line 676
{yyval = gc0(NIL);} break;
case 324:
# line 677
{yyval = gc1(rev(yypvt[-0]));} break;
case 325:
# line 679
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 326:
# line 680
{yyval = gc1(singleton(yypvt[-0]));} break;
case 327:
# line 682
{yyval = yypvt[-0];} break;
case 328:
# line 683
{yyval = gc3(pair(yypvt[-2],yypvt[-0]));} break;
case 329:
# line 688
{yyval = gc0(nameNil);} break;
case 330:
# line 689
{yyval = gc1(ap(FINLIST,cons(yypvt[-0],NIL)));} break;
case 331:
# line 690
{yyval = gc1(ap(FINLIST,rev(yypvt[-0])));} break;
case 332:
# line 691
{yyval = gc3(ap(COMP,pair(yypvt[-2],rev(yypvt[-0]))));} break;
case 333:
# line 692
{yyval = gc3(ap(ap(nameFromTo,yypvt[-2]),yypvt[-0]));} break;
case 334:
# line 693
{yyval = gc4(ap(ap(nameFromThen,yypvt[-3]),yypvt[-1]));} break;
case 335:
# line 694
{yyval = gc2(ap(nameFrom,yypvt[-1]));} break;
case 336:
# line 695
{yyval = gc5(ap(ap(ap(nameFromThenTo,
							       yypvt[-4]),yypvt[-2]),yypvt[-0]));} break;
case 337:
# line 698
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 338:
# line 699
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 339:
# line 701
{yyval = gc3(ap(FROMQUAL,pair(yypvt[-2],yypvt[-0])));} break;
case 340:
# line 702
{yyval = gc1(ap(BOOLQUAL,yypvt[-0]));} break;
case 341:
# line 703
{yyval = gc2(ap(QWHERE,yypvt[-0]));} break;
case 342:
# line 708
{yyerrok; goOffside(startColumn);} break;
case 343:
# line 711
{yyval = yypvt[-0];} break;
case 344:
# line 712
{yyerrok; 
					 if (canUnOffside()) {
					     unOffside();
					     /* insert extra token on stack*/
					     push(NIL);
					     pushed(0) = pushed(1);
					     pushed(1) = mkInt(column);
					 }
					 else
					     syntaxError("definition");
					} break;/* End of actions */
    }
    goto yystack;  /* stack new state and value */

}
