#include "substdio.h"
#include "subfd.h"
#include "readwrite.h"
#include "stralloc.h"
#include "commands.h"
#include "strerr.h"
#include "exit.h"
#include "sgetopt.h"
#include "fmt.h"
#include "ip.h"
#include "env.h"

#define FATAL "rblsmtpd: fatal: "
void die_sys() { _exit(111); }

int flagbounce = 0;
int flagrblsafe = 0;
char *rbldomain = "rbl.maps.vix.com";
unsigned int timeout = 60;

struct ip_address ip;
stralloc rbltext = {0};
stralloc message = {0};

char strnum[FMT_ULONG];

char ssinbuf[64];
substdio ssin = SUBSTDIO_FDBUF(read,0,ssinbuf,sizeof ssinbuf);
char ssoutbuf[1];
substdio ssout = SUBSTDIO_FDBUF(write,1,ssoutbuf,sizeof ssoutbuf);

void reject() { substdio_putflush(&ssout,message.s,message.len); }
void accept() { substdio_putsflush(&ssout,"250 rblsmtpd.local\r\n"); }
void greet()  { substdio_putsflush(&ssout,"220 rblsmtpd.local\r\n"); }
void quit()   { substdio_putsflush(&ssout,"221 rblsmtpd.local\r\n"); _exit(0); }

struct commands smtpcommands[] = {
  { "quit", quit, 0 }
, { "helo", accept, 0 }
, { "ehlo", accept, 0 }
, { "mail", accept, 0 }
, { "rset", accept, 0 }
, { "noop", accept, 0 }
, { 0, reject, 0 }
} ;

void check()
{
  int i;
  char *x;

  x = env_get("RBLSMTPD");
  if (x) {
    if (!*x) return;
    if (*x == '-') {
      if (!stralloc_copys(&message,"553 ")) die_sys();
      ++x;
    }
    else
      if (!stralloc_copys(&message,"451 ")) die_sys();
    if (!stralloc_cats(&message,x)) die_sys();
  }
  else {
    x = env_get("TCPREMOTEIP");
    if (!x) return;
    if (!*x) return;
    if (x[ip_scan(x,&ip)]) return;

    switch(txt(&rbltext,&ip,rbldomain)) {
      case 0:
	return;
      case -1:
	if (!flagrblsafe) return;
        if (!stralloc_copys(&message,"451 temporary RBL lookup error")) die_sys();
	break;
      default:
        if (!stralloc_copys(&message,flagbounce ? "553 " : "451 ")) die_sys();
        if (!stralloc_cat(&message,&rbltext)) die_sys();
    }
  }

  if (message.len > 200) message.len = 200;
  for (i = 0;i < message.len;++i)
    if ((message.s[i] < 32) || (message.s[i] > 126))
      message.s[i] = '?';
  substdio_puts(subfderr,"rblsmtpd: pid ");
  substdio_put(subfderr,strnum,fmt_ulong(strnum,(unsigned long) getpid()));
  substdio_puts(subfderr,": ");
  substdio_put(subfderr,message.s,message.len);
  substdio_puts(subfderr,"\n");
  substdio_flush(subfderr);
  if (!stralloc_cats(&message,"\r\n")) die_sys();

  if (!timeout) { reject(); _exit(0); }
  alarm(timeout);

  greet();
  commands(&ssin,smtpcommands);
  die_sys();
}

void usage()
{
  strerr_die1x(100,"rblsmtpd: usage: rblsmtpd [ -b ] [ -R ] [ -r domain ] [ -t timeout ] smtpd [ arg ... ]");
}

void main(argc,argv)
int argc;
char **argv;
{
  int opt;

  while ((opt = getopt(argc,argv,"t:r:Rb")) != opteof)
    switch(opt) {
      case 't': scan_uint(optarg,&timeout); break;
      case 'R': flagrblsafe = 1; break;
      case 'b': flagbounce = 1; break;
      case 'r': rbldomain = optarg; break;
      default: usage();
    }
  argv += optind;
  if (!*argv) usage();

  res_init();
  check();
  execvp(*argv,argv);
  strerr_die4sys(111,FATAL,"unable to run ",*argv,": ");
}
