%{
/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv3.3/kernel/sources/RCS/kr_pat_scan.l,v $
  SHORTNAME      : pattern scanner
  SNNS VERSION   : 3.2

  PURPOSE        : pattern file scanner, lex file
  NOTES          : preliminary

  AUTHOR         : Michael Vogt
  DATE           : 10.9.93

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.2 $
  LAST CHANGE    : $Date: 1994/11/08 13:41:00 $

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#include "y.tab.h"
#include <stdlib.h>
#include <string.h>
#include "glob_typ.h"
#include "kr_typ.h"
#include "kernel.h"
#include "kr_pat_parse.h"
#include "kr_pat_scan.ph"

%}

digit           [0-9]
white           [ \t]
free            [^\n]
exp		[Ee][-+]?{digit}+

%%

\#{free}*				|
{white}*					;

\n						lineno++;

\[						return(L_BRACKET);

\]						return(R_BRACKET);

[Vv]{digit}+"."{digit}+(-{free}*)?      {
					s_dotpos = strchr((char *) yytext, '.');
					*s_dotpos = '\0';
					yylval.version.v = 
						atoi((char *) yytext+1);
					yylval.version.r =
						atoi((char *) s_dotpos+1);
					return(V_NUMBER);
				        }

[-+]?{digit}+				|
[-+]?{digit}+{exp}			|
[-+]?{digit}+"."{digit}*({exp})?	|
[-+]?{digit}*"."{digit}+({exp})?	        {
						    yylval.value=atof((char *) yytext);
						    return(NUMBER);
						}

"SNNS pattern definition file"			return(VERSION_HEADER);

"generated at"{free}*				return(GENERATED_AT);

"No. of patterns"{white}*:			return(NO_OF_PATTERN);

"No. of input units"{white}*:			return(NO_OF_INPUT);

"No. of output units"{white}*:			return(NO_OF_OUTPUT);

"No. of variable input dimensions"{white}*:	return(NO_OF_VAR_IDIM);

"No. of variable output dimensions"{white}*:	return(NO_OF_VAR_ODIM);

"Maximum input dimensions"{white}*:		return(MAXIMUM_IDIM);

"Maximum output dimensions"{white}*:		return(MAXIMUM_ODIM);

[^ \t\n\[\]]+					return(ERROR);

%%

int pplex(void)
{
    if (scanner_pattern_end_flag)
    {
	scanner_pattern_end_flag = 0;
	yylval.value = 0.0;
	return PATTERNEND;
    }
    else
	return yylex();
}

void scanner_await_pattern_end(void)
{
    scanner_pattern_end_flag = 1;
}

void scanner_init_scanner(FILE *in_file)
{
    yyin = in_file;
#ifdef FLEX_SCANNER
    yyrestart(yyin);
#endif
    scanner_pattern_end_flag = 0;
}
