.TH xephem 1X
.SH Name
xephem \- an interactive astronomical ephemeris for X
.SH Syntax
\fBxephem\fP
.SH Description
.na
.nh
.PP
.B XEphem
version 3.1
is an interactive astronomical ephemeris program for X Windows systems with
Motif. It provides many graphical views as well as quantitative heliocentric,
geocentric and topocentric information for Earth satellites, solar system
and celestial objects.
.SH Getting Started
.PP
.B XEphem
contains extensive context-sensitive on-line help. Virtually none of
that help is duplicated here so go ahead and run
.B xephem
to learn more.
When you first run
.B xephem
you may hear a beep.
This means
.B xephem
has added a message to the message box menu.
This menu is not shown by default.
Whether the message box is displayed may be toggled by using the
.I Messages
entry in the
.I File
pulldown menu off the
.I Main menu.
Whether
.B xephem
beeps when it adds a message may be toggled using the
.I Message Bell
option in the
.I Preferences
pulldown menu.
.SH Quick Menu Tour
.PP
The
.I Help
pulldown at the top right of the main menu provides access to several
categories of assistance applicable to the overall operation of
.B xephem.
Those unfamiliar with
.B xephem
might begin by reading the 
.I Introduction
help section first and reading the additional help information in the
order in which it is listed in the pulldown. 
In particular,
.I Examples
leads to several useful practice operations.

The
.I Main menu
of
.B xephem
provides control and display of three basic services: observing circumstances,
looping, and access to additional displays.

Observing circumstances includes location, time and atmospheric conditions
(used for the refraction model). Looping refers to the ability to set up
.B xephem
so that it automatically increments time at a desired step size and rate.

Additional displays provide all of the graphical and quantitative information
available, and always refer to the circumstances defined in the main menu.
These additional displays are activated from the 
.I Views
pulldown.

.B XEphem
has information about the Solar system built in which can be accessed without
the need to access an external database. 
But
.B XEphem
can read files of additional objects into memory as well. Files of objects
are read in using the
.I Load and Delete
button in the
.I Objects
pulldown. The definition of any object in
memory may be inspected and manipulated in detail and assigned to so-called
`user defined objects' X, Y and Z using the
.I Search and ObjXYZ
button in the same pulldown.

All of the data that 
.B xephem
presents in numeric form may be written to a file and later plotted; written
to a file as a tabular listing; or used to formulate an arbitrary
mathematical expression that may be solved for a maximum, minimum or zero.
These facilities are accessed from the
.I Control
pulldown.

Several general computational and display options may be controlled from the
.I Preferences
pulldown.

The
.I Files
pulldown allows one to reset the main menu to the initial
resource settings; toggle whether the general messages box is displayed; and
quit the program.
.SH X Resources
.PP
.B XEphem
has many X resources, some of which you will soon want to tune to your
taste and circumstances; many others may be left unchanged. Look through the
.I XEphem.ad
sample in the distribution for full details. If no resources are available,
.B xephem
contains reasonable internal fallback resources.

Of course, in addition to all the custom resources,
.B xephem
supports
the usual Xt command line arguments such as -display, -xrm, -synchronous, -fg
and -bg.

.B xephem
may install a private colormap when it first starts if it finds few color
cells available.
This can also be
forced from the command line
using the 
.I -install
option. This option should be followed by one of the following keywords:
.I guess,
.I yes
or
.I no.

The application class of
.B xephem
is
.I XEphem.
You may get a list of all the builtin fallback resources by using the
.I -prfb
option.

.SH Time zones
.B xephem
will attempt to
support time zone control information from the host operating system.
If this fails for some reason, time zone offset and name may always
be set manually at any time from the Main menu, or they may be initialized from
the XEphem.TZName and XEphem.TZone resources, respectively.

.SH Author
.PP
Elwood Downey, email ecdowney@ClearSkyInstitute.edu.

.SH References
.PP
The latest information about
.B xephem
is maintained at
.I http://iraf.noao.edu/~ecdowney/xephem.html.
(Although they graciously host the distribution,
.B xephem
is not associated with the National Optical Astronomical Observatory.)
.PP
The online Help entry
.I on Credits
lists many of the references, individuals and organizations which have
contributed to
.B xephem,
to all of which I am most grateful.
