/* Copyright 1993 by Clifford A. Adams */
/* shelp.c
 *
 * Help scan mode.  (Extended help.)
 */

/* trim this list later */
#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "scan.h"
#include "scmd.h"
#include "sdisp.h"
#include "smisc.h"
#include "sorder.h"
#include "spage.h"
#include "shdata.h"
#include "shfile.h"
#include "shmisc.h"
#include "term.h"
#include "util.h"
#include "INTERN.h"
#include "shelp.h"

/* context that the current context was called from */
int sh_context_from = 0;

int
sh_main(from)
int from;			/* where was this called from? */
{
    if (sh_initialized)
	return(sh_continue());
    if (!sh_init())
	return(0);		/* better return value later */
    return(sh_continue());
}


/* called before quitting help scan */
void
sh_quit()
{
    sh_old_context();
    sh_initialized = FALSE;
}

/* returns TRUE on success */
bool
sh_init()
{
    char *top_help;		/* top file for help */

    /* check to see if screen is big enough */
    if (!sh_check_screen()) {
	printf("Sorry--screen too small for extended help.\n") FLUSH;
	return(FALSE);
    }
    sh_init_context();

    sh_init_ents();

    /* initialize top level here */
    top_help = getval("SCANHELP","%X/help/top");
    if (!sh_use_file(top_help,"(type 'h' for help)")) {
	printf("\nCannot find top file for help scan!\n") FLUSH;
	printf("(This is probably a configuration error.\n") FLUSH;
	printf(" Contact your news administrator to fix this.)\n") FLUSH;
	return(FALSE);
    }
/* PROBLEM: this initialization/check is quite late... */
    if (s_initscreen()) {		/* If not able to init screen...*/
	sh_quit();
	return(FALSE);			/* ...most likely dumb terminal */
    }
    sh_initialized = TRUE;
    s_save_context();
    return(TRUE);
}

int
sh_continue()
{
    char sh_oldmode;
    int i;

    s_change_context(sh_contexts[sh_num_contexts-1].cnum);

    /* redraw it *all* */
    s_ref_all = TRUE;
    if ((s_top_ent<1) || (s_top_ent>=sh_num_ents))
	s_top_ent = s_first();
    i = s_fillpage();
    if ((i==-1) || (i == 0)) {
/*	printf("s_fillpage could not get a page\n") FLUSH; */
	printf("Help scan: No eligible files or topics at this level.\n")
		FLUSH;
	if (sh_num_contexts>1) {
	    sh_old_context();
	    s_refill = TRUE;
	    return(sh_continue());
	}
	/* for now just leave if no page could be filled. */
	printf("No extended help available at this time.\n") FLUSH;
	return(0);
    }
    sh_oldmode = mode;			/* save mode */
    mode = 'h';				/* for RN macros */
    i = s_cmdloop();
    mode = sh_oldmode;			/* restore mode */
    /* something else (quit, return, etc...) */
    if (i==SH_QUIT) {
	sh_quit();
	return(0);
    }
    return(i);
}
#endif /* SCAN */
