/* This file is Copyright 1993 by Clifford A. Adams */
/* svonline.h
 *
 * Online commands (entered with Vcommand)
 */

#include "EXTERN.h"
#include "common.h"
#include "intrp.h"
#include "term.h"
#include "util.h"
#include "scan.h"
#include "svirt.h"
#include "svdata.h"
#include "svfile.h"
#ifdef SCAN
#include "INTERN.h"
#include "svonline.h"

/* Yet another local buffer */
char sv_onbuf[LBUFLEN];

/* get alternative subject into sv_onbuf */
void
sv_get_alt()
{
    char *s;
    int i;

    printf("Enter virtual subject (RETURN for none):\n") FLUSH;
    buf[0] = '>';
    buf[1] = FINISHCMD;
    i = finish_command(TRUE);
    if (!i) {
	*sv_onbuf = '\0';
	return;
    }
    safecpy(sv_onbuf,buf,LBUFLEN-4);
    /* no alternates if (somehow) user replaced the prompt or if
     * the user just typed return
     */
    if ((*sv_onbuf != '>') || (!sv_onbuf[1])) {
	*sv_onbuf = '\0';
	return;
    }
    *sv_onbuf = '\"';	/* replace question mark with quote */
    /* replace all but initial and possible final double quotes with single
     * quotes
     */
    for (s=sv_onbuf+1;*s && *(s+1);s++) {
	if (*s == '\"')
	    *s = '\'';
    }
    if (*s != '\"') {	/* user did not provide final quote */
	s++;
	*s = '\"';		/* add final quote */
    }
    s++;
    *s = ' ';		/* add a space separator */
    s++;
    *s = '\0';		/* terminate the string */
}

void
sv_append(line)
char *line;
{
    char *s;
    char filechar;	/* filename character from line */
    char *filename;	/* expanded filename */
    FILE *fp;
    int i;

    if (!line || !*line)
	return;		/* do nothing with empty string */

    filechar = *line;		/* ch is file abbreviation */

    switch (filechar) {
	case '%':
	case '/':
	case '~':
	    safecpy(sv_onbuf,line,LBUFLEN-4);
	    i = 0;
	    for (s=sv_onbuf;*s && (*s != ' ') && (*s != '\t');s++)
		i++;
	    *s = '\0';
	    filename = sv_onbuf;
	    s = line+i;		/* set up for appended text */
	    break;
	default:
	    printf("\nBad file in virtual command: %s\n",line) FLUSH;
	    return;
    }
    /* skip whitespace after filechar */
    while ((*s == ' ') || (*s == '\t'))
	s++;
    makedir(filename,MD_FILE);
    if (!(fp = fopen(filexp(filename),"a"))) {
	printf("\nCould not open (for append) file %s\n",filename);
	return;
    }
    if (s[0] && !s[1]) {	/* only one character */
	/* check for abbreviations */
	switch(*s) {
	    case 'A':		/* Article number */
	    case 'M':		/* Message-id */
	    case 'I':		/* message-Id */
		sv_get_alt();
		printf("group %s\n",filexp("%C")) FLUSH;
		fprintf(fp,"group %s\n",filexp("%C"));
		if (*s == 'A') {
		    printf("%s+%s\n",sv_onbuf,filexp("%a")) FLUSH;
		    fprintf(fp,"%s+%s\n",sv_onbuf,filexp("%a"));
		} else {
		    printf("%s+%s\n",sv_onbuf,filexp("%i")) FLUSH;
		    fprintf(fp,"%s+%s\n",sv_onbuf,filexp("%i"));
		}
		fclose(fp);
		return;
	}
    }
    printf("%s\n",s) FLUSH;
    fprintf(fp,"%s\n",s);
    fclose(fp);
}

void
sv_do_command(cmd)
char *cmd;
{
    char *s;
    char ch;

    /* look familiar?  Look at scorefile.c... */
    if (!strncmp(cmd,"file",4)) {
	s = cmd+4;
	while ((*s == ' ') || (*s == '\t'))
	    s++;			/* skip whitespace */
	ch = *s++;
	while ((*s == ' ') || (*s == '\t'))
	    s++;			/* skip whitespace */
	if (sv_abbr[(int)ch])
	    free(sv_abbr[(int)ch]);
	/* possibly later massage the filename string more */
	sv_abbr[(int)ch] = savestr(filexp(s));
	return;
    }
}

void
sv_do_online(line)
char *line;
{
    char *s;

    if (!line || !*line)
	return;		/* very empty line */
    if (line[strlen(line)-1] == '\n')
	line[strlen(line)-1] = '\0';	/* kill the newline */

    for (s=line;((*s) && ((*s==' ') || (*s=='\t')));s++)
	;	/* EMPTY */	/* skip whitespace */
    if ((!*s) || (*s == '#'))
	return;	/* line was whitespace or comment after whitespace */
    if (isalpha(*s)) {		/* command line */
	sv_do_command(s);
	return;
    }
    /* maybe do something different with punctuation (later)? */
}

void
sv_online_clean()
{
    /* nothing needed yet */
    ;
}

int
sv_online(command,subvirt)
char *command;
bool_int subvirt;		/* if TRUE, allow sub-virtual groups */
{
    char lbuf[LBUFLEN];
    char *s;

    switch(*command) {
	case '+':
	    sv_append(command+1);
	    return(0);
	case '.':
	    if (!subvirt) {
		printf("Virtual scan mode error:\n");
		printf("Strn can only use virtual group files from");
		printf("the article level.\n");
		get_anything();
		eat_typeahead();
		return(-1);
	    }
	    eat_typeahead();
	    if (command[1] == '\0')
		sv_use_article();
	    else {
		strcpy(lbuf,command+1);
		for (s=lbuf;(*s && (*s != ' '));s++)
		    ;	/* EMPTY */
		if (!*s)
		    s = "Virtual scan";		/* generic title */
		else
		    *s++ = '\0';
		sv_close_current();
		sv_main(lbuf,s);
	    }
	    sv_ng_quit_fast = TRUE;	/* get out of the group fast */
	    return(0);
	default:
	    printf("Unknown virtual command received:\n|%s|\n",command) FLUSH;
	    return(-1);
    }
}

void
sv_add_hotlist(subvirt)
bool_int subvirt;
{
    FILE *fp;

    fp = fopen(filexp("%p/hotlist.strn"),"r");
    if (fp)
	fclose(fp);
    else {
	fp = fopen(filexp("%p/hotlist.strn"),"w");
	if (!fp) {
	    printf("\nCould not create hotlist file: %s\n",
		   filexp("%p/hotlist.strn"));
	    return;
	}
	fprintf(fp,"#### Strn hotlist file\n");
	fprintf(fp,"begin virtual\n");
	fprintf(fp,"filter unread+read\n");
	fprintf(fp,"display unread+read\n");
	fclose(fp);
    }
    sv_online("+%p/hotlist.strn I",subvirt);
}

void
sv_online_menu(subvirt)
bool_int subvirt;		/* if TRUE, allow sub-virtual groups */
{
    bool q_done;	/* if TRUE, we are finished with current question */
    char ch;


    q_done = FALSE;
    while (!q_done) {
	printf("\nVirtual scan command menu:\n");
	printf("0) Exit.\n") FLUSH;
/* add some numeric options later? */
	printf("1) Add the current article to the Hotlist.\n");
	if (subvirt) {
	    printf("!) Enter the Hotlist now.\n");
	    printf(".) Use the current article as a virtual group.\n");
	  printf("[The '!' and '.' options will leave the current group.]\n");
	}
	ch = menu_get_char();
	q_done = TRUE;
	switch (ch) {
	    case '0':
		return;
	    case '1':
		sv_add_hotlist(subvirt);
		break;
	    case '!':
		if (!subvirt) {
		    q_done = FALSE;
		    break;
		}
		sv_online(".%p/hotlist.strn Hotlist",subvirt);
		break;
	    case '.':
		if (!subvirt) {
		    q_done = FALSE;
		    break;
		}
		sv_online(".",subvirt);
		break;	
	    default:
		q_done = FALSE;
		break;
	}
    }
}
#endif /* SCAN */
