//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef ERROR_HXX
#define ERROR_HXX

#ifdef WIN32
  #define WIN32_LEAN_AND_MEAN
  #define STRICT
  #include <windows.h>
#endif

#if (defined(MSDOS_OS) || defined(WIN32) || defined(OS_2))
  #include <strstrea.h>
#else
  #include <strstream.h>
#endif

/**
  This class is used to throw exceptions for errors that occur 
  in the "core" code.

  @author  Bradford W. Mott
  @version $Id: Error.hxx,v 1.2 1997/05/17 19:00:05 bwmott Exp $
*/
class Error
{
  public:
    /// Constructor
    Error()
    {}
 
    /// Copy Constructor
    Error(Error& err)
    {
#ifdef WIN32
      int nMsgCount, nDescCount;
      HGLOBAL hgMessage, hgDescription;
      PSTR szMessage, szDescription;
                
      nMsgCount = err.message().pcount() + 1;
      nDescCount = err.description().pcount() + 1;

      hgMessage = GlobalAlloc(GPTR, nMsgCount);
      szMessage = (LPSTR)GlobalLock(hgMessage);
      hgDescription = GlobalAlloc(GPTR, nDescCount);
      szDescription = (LPSTR)GlobalLock(hgDescription);

      // myMessage.write(err.message().str(), nCount);
      lstrcpyn(szMessage, err.message().str(), nMsgCount);
      szMessage[nMsgCount] = '\0';
      err.message().rdbuf()->freeze(0);
      
          
      // myDescription.write(err.description().str(), nCount);
      lstrcpyn(szDescription, err.description().str(), nDescCount);
      szDescription[nDescCount] = '\0';
      err.description().rdbuf()->freeze(0);
      MessageBox(NULL, szDescription, szMessage, MB_OK | MB_ICONERROR);

      GlobalUnlock(hgMessage);
      GlobalFree(hgMessage);
      GlobalUnlock(hgDescription);
      GlobalFree(hgDescription);
#else
      myMessage.write(err.message().str(), err.message().pcount());
      err.message().rdbuf()->freeze(0);

      myDescription.write(err.description().str(), err.description().pcount());
      err.description().rdbuf()->freeze(0);
#endif
    }
 
    /// Destructor
    virtual ~Error()
    {}

  public:
    /// Answer stream which should contain the one line error message
    ostrstream& message() { return myMessage; }

    /// Answer stream which should contain the multiple line description
    ostrstream& description() { return myDescription; }

  public:
    /// Overload the assignment operator
    Error& operator=(Error& err)
    {
#if defined MAC_OS
      // Mac compiler doesn't support seekp() so I'll try flush instead :-)
      myMessage.flush();
#else
      myMessage.seekp(0);
#endif

      myMessage.write(err.message().str(), err.message().pcount());
      err.message().rdbuf()->freeze(0);

#if defined MAC_OS
      // Mac compiler doesn't support seekp() so I'll try flush instead :-)
      myDescription.flush();
#else
      myDescription.seekp(0);
#endif

      myDescription.write(err.description().str(), err.description().pcount());
      err.description().rdbuf()->freeze(0);

      return *this;
    }

    /// Overload the I/O output operator
    friend ostream& operator<<(ostream& out, Error& error)
    {
      out.write(error.message().str(), error.message().pcount());
      error.message().rdbuf()->freeze(0);

      if(error.description().pcount() != 0)
      {
        out << endl << endl;

        out.write(error.description().str(), error.description().pcount());
        error.description().rdbuf()->freeze(0);
      }

      return out;
    }

  private:
    // Contains the one line error code message
    ostrstream myMessage;

    // Contains a multiple line description of the error and ways to 
    // solve the problem
    ostrstream myDescription;
};
#endif


