/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char z80_c[] = "$Id: z80.c,v 4.1 1998/01/06 21:25:43 erik Rel $";
#endif

#include "z80.h"
#include "debug.h"
#include "mem.h"
#include "io.h"
#include "util.h"
#ifdef XBELL_AUDIO
#include "audio.h"
#endif
#ifdef XZX_IF1
#include "if1.h"
#endif
#include "loadsave.h"
#include "monitor.h"
#include "snapshot.h"

#define PARITY(reg)		parityTbl[(reg)]
#define SZ53P(reg)		sz53pTbl[(reg)]
#define SZ53(reg)		sz53Tbl[(reg)]

#ifndef HAVE_ENOUGH_SWAP
static void z80_DecodeCB(uns8);
static void z80_DecodeED(uns8);
static void z80_DecodeDD(uns8);
static void z80_DecodeFD(uns8);
#endif

struct z80 Cpu;
unsigned int Tstates;

static uns32 work32;
static uns16 work16;
static uns8	work8, work8_2;
static unsigned int idx;
static uns8 carry, add, sub;

static uns8 parityTbl[] = {
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	P_FLAG, 0, 0, P_FLAG, 0, P_FLAG, P_FLAG, 0,
	0, P_FLAG, P_FLAG, 0, P_FLAG, 0, 0, P_FLAG
};

static uns8 halfCarryTbl[]    = { 0, 0, H_FLAG, 0, H_FLAG, 0, H_FLAG, H_FLAG };
static uns8 subHalfCarryTbl[] = { 0, H_FLAG, H_FLAG, H_FLAG, 0, 0, 0, H_FLAG };

static uns8 overflowTbl[]     = { 0, V_FLAG, 0, 0, 0, 0, V_FLAG, 0 };
static uns8 subOverflowTbl[]  = { 0, 0, 0, V_FLAG, V_FLAG, 0, 0, 0 };

static uns8 *sz53pTbl, *sz53Tbl;

#define INC(reg) \
	{															\
		++(reg);												\
		F = (F & C_FLAG) |										\
			SZ53((reg)) |										\
			((reg) & 0xf ? 0 : H_FLAG) |						\
			((reg) == 0x80 ? V_FLAG : 0);						\
	}
#undef DEC
#define DEC(reg) \
	{															\
		F = (F & C_FLAG) |										\
			((reg) & 0xf ? 0 : H_FLAG) |						\
			((reg) == 0x80 ? V_FLAG : 0) |						\
			N_FLAG;												\
		--(reg);												\
		F |= SZ53((reg));										\
	}
#define ADD(val) \
	{															\
		work16 = A + (val);										\
		idx = ((A & 0x88) >> 1) |								\
			  (((val) & 0x88) >> 2) |							\
			  ((work16 & 0x88) >> 3);							\
		A = work16;												\
		F = SZ53(A) |											\
			halfCarryTbl[idx & 0x7] |							\
			overflowTbl[idx >> 4] |								\
			(work16 & 0x100 ? C_FLAG : 0);						\
	}
#define ADC(val) \
	{															\
		work16 = A + (val) + (F & C_FLAG);						\
		idx = ((A & 0x88) >> 1) |								\
			  (((val) & 0x88) >> 2) |							\
			  ((work16 & 0x88) >> 3);							\
		A = work16;												\
		F = SZ53(A) |											\
			halfCarryTbl[idx & 0x7] |							\
			overflowTbl[idx >> 4] |								\
			(work16 & 0x100 ? C_FLAG : 0);						\
	}
#define SUB(val) \
	{															\
		work16 = A - (val);										\
		idx = ((A & 0x88) >> 1) |								\
			  (((val) & 0x88) >> 2) |							\
			  ((work16 & 0x88) >> 3);							\
		A = work16;												\
		F = SZ53(A) |											\
			subHalfCarryTbl[idx & 0x7] |						\
			subOverflowTbl[idx >> 4] |							\
			N_FLAG |											\
			(work16 & 0x100 ? C_FLAG : 0);						\
	}
#define SBC(val) \
	{															\
		work16 = A - (val) - (F & C_FLAG);						\
		idx = ((A & 0x88) >> 1) |								\
			  (((val) & 0x88) >> 2) |							\
			  ((work16 & 0x88) >> 3);							\
		A = work16;												\
		F = SZ53(A) |											\
			subHalfCarryTbl[idx & 0x7] |						\
			subOverflowTbl[idx >> 4] |							\
			N_FLAG |											\
			(work16 & 0x100 ? C_FLAG : 0);						\
	}
#define AND(val) \
	{															\
		A &= (val);												\
		F = SZ53P(A) | H_FLAG;									\
	}
#define XOR(val) \
	{															\
		A ^= (val);												\
		F = SZ53P(A);											\
	}
#define OR(val) \
	{															\
		A |= (val);												\
		F = SZ53P(A);											\
	}
#define CMP(val) \
	{															\
		work16 = A - (val);										\
		idx = ((A & 0x88) >> 1) |								\
			  (((val) & 0x88) >> 2) |							\
			  ((work16 & 0x88) >> 3);							\
		F = SZ53(work16 & 0xff) |								\
			subHalfCarryTbl[idx & 0x7] |						\
			subOverflowTbl[idx >> 4] |							\
			N_FLAG |											\
			(work16 & 0x100 ? C_FLAG : 0);						\
	}

#define _CMP_(val) \
	{															\
		work16 = A - (val);										\
		idx = ((A & 0x88) >> 1) |								\
			  (((val) & 0x88) >> 2) |							\
			  ((work16 & 0x88) >> 3);							\
		F = (F & C_FLAG) |										\
			SZ53(work16 & 0xff) |								\
			subHalfCarryTbl[idx & 0x7] |						\
			N_FLAG;												\
	}
#define ADD_HL(reg) \
	{															\
		work32 = HL + (reg);									\
		idx = ((HL & 0x0800) >> 9) |							\
			  (((reg) & 0x0800) >> 10) |						\
			  ((work32 & 0x0800) >> 11);						\
		HL = work32;											\
		F = (F & (S_FLAG | Z_FLAG | V_FLAG)) |					\
			(H & (B5_FLAG | B3_FLAG)) |							\
			halfCarryTbl[idx] |									\
			(work32 & 0x10000 ? C_FLAG : 0);					\
	}
#define ADC_HL(reg) \
	{															\
		work32 = HL + (reg) + (F & C_FLAG);						\
		idx = ((HL & 0x8800) >> 9) |							\
			  (((reg) & 0x8800) >> 10) |						\
			  ((work32 & 0x8800) >> 11);						\
		HL = work32;											\
		F = (H & (S_FLAG | B5_FLAG | B3_FLAG)) |				\
			(HL ? 0 : Z_FLAG) |									\
			halfCarryTbl[idx & 0x7] |							\
			overflowTbl[idx >> 4] |								\
			(work32 & 0x10000 ? C_FLAG : 0);					\
	}
#define SBC_HL(reg) \
	{															\
		work32 = HL - (reg) - (F & C_FLAG);						\
		idx = ((HL & 0x8800) >> 9) |							\
			  (((reg) & 0x8800) >> 10) |						\
			  ((work32 & 0x8800) >> 11);						\
		HL = work32;											\
		F = (H & (S_FLAG | B5_FLAG | B3_FLAG)) |				\
			(HL ? 0 : Z_FLAG) |									\
			subHalfCarryTbl[idx & 0x7] |						\
			subOverflowTbl[idx >> 4] |							\
			N_FLAG |											\
			(work32 & 0x10000 ? C_FLAG : 0);					\
	}
#define ADD_XX(reg) \
	{															\
		work32 = XX + (reg);									\
		idx = ((XX & 0x0800) >> 9) |							\
			  (((reg) & 0x0800) >> 10) |						\
			  ((work32 & 0x0800) >> 11);						\
		XX = work32;											\
		F = (F & (S_FLAG | Z_FLAG | V_FLAG)) |					\
			(HXX & (B5_FLAG | B3_FLAG)) |						\
			halfCarryTbl[idx] |									\
			(work32 & 0x10000 ? C_FLAG : 0);					\
	}
#define RLC(reg) \
	{															\
		(reg) = ((reg) << 1) | ((reg) >> 7);					\
		F = SZ53P((reg)) | ((reg) & C_FLAG);					\
	}
#define RRC(reg) \
	{															\
		F = (reg) & C_FLAG;										\
		(reg) = ((reg) >> 1) | ((reg) << 7);					\
		F |= SZ53P((reg));										\
	}
#define RL(reg) \
	{															\
		work8_2 = (reg) >> 7;									\
		(reg) = ((reg) << 1) | (F & C_FLAG);					\
		F = SZ53P((reg)) | work8_2;								\
	}
#define RR(reg) \
	{															\
		work8_2 = (reg) & C_FLAG;								\
		(reg) = ((reg) >> 1) | (F << 7);						\
		F = SZ53P((reg)) | work8_2;								\
	}
#define SLA(reg) \
	{															\
		F = (reg) >> 7;											\
		(reg) <<= 1;											\
		F |= SZ53P((reg));										\
	}
#define SRA(reg) \
	{															\
		F = (reg) & C_FLAG;										\
		(reg) = ((reg) & 0x80) | ((reg) >> 1);					\
		F |= SZ53P((reg));										\
	}
#define SLI(reg) \
	{															\
		F = (reg) >> 7;											\
		(reg) = ((reg) << 1) | 0x01;							\
		F |= SZ53P((reg));										\
	}
#define SRL(reg) \
	{															\
		F = (reg) & C_FLAG;										\
		(reg) >>= 1;;											\
		F |= SZ53P((reg));										\
	}
#define BIT(bit, reg) \
	{															\
		F = (F & C_FLAG) |										\
			((reg) & (0x01 << (bit)) & S_FLAG) |				\
			((reg) & (B5_FLAG | B3_FLAG)) |						\
			((reg) & (0x01 << (bit)) ?							\
						  H_FLAG : (Z_FLAG | H_FLAG | P_FLAG));	\
	}
#define IN(port, reg) \
	{															\
		(reg) = InByte((port));									\
		F = (F & C_FLAG) | SZ53P((reg));						\
	}
#define JR \
	{															\
		PC += (sgn8)RD_BYTE(PC) + 1;							\
	}
#define JP \
	{															\
		PC = RD_WORD(PC);										\
	}
#define CALL \
	{															\
		PUSH(PC + 2);											\
		PC = RD_WORD(PC);										\
	}
#define RST(addr) \
	{															\
		PUSH(PC);												\
		PC = (addr);											\
	}
#undef RET
#define RET \
	{															\
		POP(PC);												\
	}
#ifdef DEBUG
#define Z80_INTERRUPT \
	{															\
		if (GETCFG(debug) & D_INTERRUPT)						\
		{														\
			Msg(M_DEBUG,										\
				"interrupt: IFF1=%d, IFF2=%d", IFF1, IFF2);		\
		}														\
																\
		if (IFF1)												\
		{														\
									\
			if (RD_BYTE(PC) == 0x76)							\
			{													\
				PC++;											\
			}													\
																\
			IFF1 = 0;											\
			IFF2 = 0;											\
			PUSH(PC);											\
																\
			if (IM == 2)										\
			{													\
				Tstates += 19;									\
				PC = RD_WORD((I << 8) | 0xff);					\
			}													\
			else												\
			{													\
				Tstates += 13;									\
				PC = 0x0038;									\
			}													\
		}														\
	}
#else
#define Z80_INTERRUPT \
	{															\
		if (IFF1)												\
		{														\
									\
			if (RD_BYTE(PC) == 0x76)							\
			{													\
				PC++;											\
			}													\
																\
			IFF1 = 0;											\
			IFF2 = 0;											\
			PUSH(PC);											\
																\
			if (IM == 2)										\
			{													\
				Tstates += 19;									\
				PC = RD_WORD((I << 8) | 0xff);					\
			}													\
			else												\
			{													\
				Tstates += 13;									\
				PC = 0x0038;									\
			}													\
		}														\
	}
#endif
#define Z80_M1(op) \
	{															\
		(op) = RD_BYTE(PC++);									\
																\
			\
																\
		R = (R & 0x80) | (++R & 0x7f);							\
	}

void
Z80_Init(void)
{
	int i;
	Tstates = 0;
	Z80_Reset();

	sz53pTbl = Malloc(2 * 256, "Z80_Init");
	sz53Tbl = &sz53pTbl[256];
	for (i = 0;i < 256; i++)
	{
		sz53Tbl[i] = (uns8)(i & (S_FLAG | B5_FLAG | B3_FLAG));
		sz53pTbl[i] = sz53Tbl[i] | PARITY(i);
	}
	sz53Tbl[0] |= Z_FLAG;
	sz53pTbl[0] |= Z_FLAG;
}

void
Z80_Reset(void)
{
	PC   = 0;
	I    = 0;
	R    = 0;
	IM   = 0;
	IFF1 = 0;
	IFF2 = 0;
	IoReset();
}

void
Z80_NMI(void)
{

	Tstates += 15;
	F = (F & ~P_FLAG) | (IFF2 ? P_FLAG : 0);
	IFF2 = IFF1;
	IFF1 = 0;
	if (RD_BYTE(PC) == 0x76)
	{
		PC++;
	}
	PUSH(PC);
	PC = 0x0066;
#ifdef XZX_MF128

	if (GETCFG(mf128_active))
	{
		(void)InByte(P_MF128IN);
	}
#endif
}

#ifndef HAVE_ENOUGH_SWAP
static void
z80_DecodeCB(uns8 op)
{
	switch(op)
	{
#		include "z80_cbops.c"
	}
}
static void
z80_DecodeED(uns8 op)
{
	switch(op)
	{
#		include "z80_edops.c"
	}
}
static void
z80_DecodeDD(uns8 op)
{
	switch(op)
	{
#		define XX  IX
#		define LXX LIX
#		define HXX HIX
#		include "z80_xxops.c"
#		undef XX
#		undef LXX
#		undef HXX
	}
}
static void
z80_DecodeFD(uns8 op)
{
	switch(op)
	{
#		define NO_RCSID
#		define XX  IY
#		define LXX LIY
#		define HXX HIY
#		include "z80_xxops.c"
#		undef XX
#		undef LXX
#		undef HXX
#		undef NO_RCSID
	}
}
#endif

