/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Des Herriott
 *          Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_Z80_H
#define _XZX_Z80_H
/* $Id: z80.h,v 4.1 1998/01/06 21:25:43 erik Rel $ */


#if 0
typedef unsigned char	uns8;
typedef unsigned short	uns16;
typedef unsigned int	uns32;
typedef signed char		sgn8;
typedef signed short	sgn16;
typedef signed int		sgn32;
#endif
typedef union {
#ifdef LITTLE_ENDIAN
	struct { uns8 l, h; } b;
#else
	struct { uns8 h, l; } b;
#endif
	uns16 w;
} pair;

struct z80 {
	pair af, bc, de, hl;
	pair af_alt,  bc_alt, de_alt, hl_alt;
	pair ix, iy;
	pair sp, pc;
	uns8 r, i;
	uns8 im;
	uns8 iff1, iff2;
};

#define AF				Cpu.af.w
#define BC				Cpu.bc.w
#define DE				Cpu.de.w
#define HL				Cpu.hl.w
#define IX				Cpu.ix.w
#define IY				Cpu.iy.w
#define SP				Cpu.sp.w
#define PC				Cpu.pc.w
#define AF1				Cpu.af_alt.w
#define BC1				Cpu.bc_alt.w
#define DE1				Cpu.de_alt.w
#define HL1				Cpu.hl_alt.w
#define A				Cpu.af.b.h
#define F				Cpu.af.b.l
#define B				Cpu.bc.b.h
#define C				Cpu.bc.b.l
#define D				Cpu.de.b.h
#define E				Cpu.de.b.l
#define H				Cpu.hl.b.h
#define L				Cpu.hl.b.l
#define HIX				Cpu.ix.b.h
#define LIX				Cpu.ix.b.l
#define HIY				Cpu.iy.b.h
#define LIY				Cpu.iy.b.l
#define HSP				Cpu.sp.b.h
#define LSP				Cpu.sp.b.l
#define HPC				Cpu.pc.b.h
#define LPC				Cpu.pc.b.l
#define A1				Cpu.af_alt.b.h
#define F1				Cpu.af_alt.b.l
#define B1				Cpu.bc_alt.b.h
#define C1				Cpu.bc_alt.b.l
#define D1				Cpu.de_alt.b.h
#define E1				Cpu.de_alt.b.l
#define H1				Cpu.hl_alt.b.h
#define L1				Cpu.hl_alt.b.l
#define R				Cpu.r
#define I				Cpu.i
#define IFF1			Cpu.iff1
#define IFF2			Cpu.iff2
#define IM				Cpu.im

#define C_FLAG			0x01
#define N_FLAG			0x02
#define P_FLAG			0x04
#define V_FLAG			P_FLAG
#define B3_FLAG			0x08
#define H_FLAG			0x10
#define B5_FLAG			0x20
#define Z_FLAG			0x40
#define S_FLAG			0x80

#define SET(flag)		(F |= flag)
#define CLR(flag)		(F &= ~flag)
#define TST(flag)		((F & flag) != 0)
#define CPL(flag)		(F ^= flag)

#define LOWBYTE(reg)	((reg) & 0xff)
#define HIGHBYTE(reg)	((((reg) >> 8)) & 0xff)

#define POP(reg)		{ (reg) = RD_WORD(SP); SP += 2; }
#define PUSH(reg)		{ SP -= 2; WR_WORD(SP, (reg)); }
#define RET()  			{ POP(PC); }
#define RETN() 	 		{ POP(PC); IFF1 = IFF2; }
#define SCF()			{ F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | \
						  (A & (B5_FLAG | B3_FLAG)) | C_FLAG; }
#define CCF()			{ F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | \
						  (A & (B5_FLAG | B3_FLAG)) | \
						  (F & C_FLAG ? H_FLAG : C_FLAG); }

extern void Z80_Init(void);
extern void Z80_Reset(void);
extern void Z80_NMI(void);
extern struct z80 Cpu;
extern unsigned int Tstates;
#endif

